/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.AdvancedGroupFormatter;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanHost;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.ds.powersource.OIdEventMapping;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.util.ShutdownLogger;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualizationLoggingUtils {
    private static final Logger logger = LogManager.getLogger(VirtualizationLoggingUtils.class);
    private AdvancedSetupHelper advancedHelper;
    private ApplicationErrorHandler errorHandler;
    private ShutdownLogger shutdownLogger;

    public VirtualizationLoggingUtils(@NonNull AdvancedSetupHelper advancedSetupHelper, @NonNull ApplicationErrorHandler applicationErrorHandler) {
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedHelper is marked non-null but is null");
        }
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("applicationErrorHandler is marked non-null but is null");
        }
        this.advancedHelper = advancedSetupHelper;
        this.errorHandler = applicationErrorHandler;
    }

    /*
     * WARNING - void declaration
     */
    public void logCriticalEvent(Set<String> set, Event event) {
        Vector<String> vector = new Vector<String>();
        String string = OIdEventMapping.getEventName(event);
        if (set != null) {
            for (String object2 : set) {
                if (object2 == null) continue;
                vector.add(object2);
            }
        }
        Object object3 = null;
        if (string == null) {
            if (vector.size() == 0) {
                VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter(48);
            } else if (vector.size() == 1) {
                VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter((Integer)1, vector);
            } else {
                VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter((Integer)2, vector);
            }
        } else if (vector.size() == 0) {
            VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter((Integer)49, string);
        } else if (vector.size() == 1) {
            VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter((Integer)34, string, vector);
        } else {
            VirtualizationFeaturesFormatter virtualizationFeaturesFormatter = new VirtualizationFeaturesFormatter((Integer)35, string, vector);
        }
        if (event instanceof AdvancedGroupEvent) {
            void var6_13;
            AdvancedGroupFormatter advancedGroupFormatter = new AdvancedGroupFormatter((IFormatter)var6_13);
        }
        try {
            void var6_15;
            object3 = var6_15.format((Object)event);
            this.errorHandler.put((String)object3);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logCriticalEvent: unable to log message");
        }
    }

    public void logShutdownPCNSDisabled(int n) {
        String string = this.advancedHelper.getUPSSetupGroupNameFromConfig(n);
        if (!StringUtils.isEmpty((CharSequence)string)) {
            try {
                String string2 = new VirtualizationFeaturesFormatter((Integer)109, string).format(null);
                this.errorHandler.put(string2);
            }
            catch (FormatterException | UnsupportedLocaleException throwable) {
                logger.error((Object)throwable);
            }
        }
    }

    public void logMaintenanceModeFailedEvent(String string) {
        try {
            logger.error("logMaintenanceModeFailedEvent() - enter Maintenance Mode failed for host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)6, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logMaintenanceModeFailedEvent() - error logging event", throwable);
        }
    }

    public void logMaintenanceModeErrorEvent(String string) {
        this.logMaintenanceModeErrorEvent(string, null);
    }

    public void logMaintenanceModeErrorEvent(String string, String string2) {
        try {
            if (string2 != null) {
                logger.error("logMaintenanceModeErrorEvent() - enter Maintenance Mode error for host: {}, error description: {}", (Object)string, (Object)string2);
            } else {
                logger.error("logMaintenanceModeErrorEvent() - enter Maintenance Mode error for host: {}", (Object)string);
            }
            String string3 = new VirtualizationFeaturesFormatter((Integer)61, string).format(null);
            this.errorHandler.put(string3);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logMaintenanceModeErrorEvent() - error logging event", throwable);
        }
    }

    public void logMaintenanceModeInvalidEvent(String string) {
        try {
            logger.info("logMaintenanceModeInvalidEvent() - enter Maintenance Mode invalid for host: {} as there are still powered on VMs", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)70, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logMaintenanceModeInvalidEvent() - error logging event", throwable);
        }
    }

    public void logMaintenanceModeEnterEvent(String string) {
        try {
            logger.info("logMaintenanceModeEnterEvent() - enter Maintenance Mode for host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)5, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logMaintenanceModeEnterEvent() - error logging event", throwable);
        }
    }

    public void logVsanMaintenanceModeEnterEvent(String string, String string2) {
        try {
            logger.info("logVsanMaintenanceModeEnterEvent() - enter Maintenance Mode for Vsan host: {}, type: {}", (Object)string, (Object)string2);
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            vector.add(string2);
            String string3 = new VirtualizationFeaturesFormatter((Integer)68, vector).format(null);
            this.errorHandler.put(string3);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVsanMaintenanceModeEnterEvent() - error logging event", throwable);
        }
    }

    public void logMaintenanceModeEnteredEvent(String string) {
        try {
            logger.info("logMaintenanceModeEnteredEvent() - enter Maintenance Mode succeeded for host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)60, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logMaintenanceModeEnteredEvent() - error logging event", throwable);
        }
    }

    public void logMaintenanceModeExitedEvent(String string) {
        try {
            logger.info("logMaintenanceModeExitedEvent() - exit Maintenance Mode for host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)12, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logMaintenanceModeExitedEvent() - error logging event", throwable);
        }
    }

    public void logMaintenanceModeCancelledEvent(String string) {
        try {
            logger.info("logMaintenanceModeCancelledEvent() - cancelled Maintenance Mode for host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)58, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logMaintenanceModeCancelledEvent() - error logging event", throwable);
        }
    }

    public void logHostShutdownEvent(String string) {
        try {
            logger.info("logHostShutdownEvent() - shutting down host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)8, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logHostShutdownEvent() - error logging event", throwable);
        }
    }

    public void logTargetHostShutdownEvent(String string) {
        try {
            logger.info("logTargetHostShutdownEvent() - shutting down target host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)20, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logTargetHostShutdownEvent() - error logging event", throwable);
        }
    }

    public void logTargetHostShutdownFailEvent(String string) {
        try {
            logger.info("logTargetHostShutdownFailEvent() - target host shutdown failed for host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)96, string).format(null);
            this.errorHandler.put(string2);
            this.shutdownLogger.sendShutdownReasonsToEventLog();
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logTargetHostShutdownFailEvent() - error logging event", throwable);
        }
    }

    public void logVCenterOnlineEvent() {
        try {
            logger.info("logVCenterOnlineEvent() - connection to VCenter Server successfully established");
            String string = new VirtualizationFeaturesFormatter(31).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVCenterOnlineEvent() - error logging event", throwable);
        }
    }

    public void logVCenterOfflineEvent() {
        try {
            logger.info("logVCenterOfflineEvent() - connection to vCenter Server is not available");
            String string = new VirtualizationFeaturesFormatter(16).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVCenterOfflineEvent() - error logging event", throwable);
        }
    }

    public void logVCenterAuthFailureEvent() {
        try {
            logger.info("logVCenterAuthFailureEvent() - vCenter Server authorization failure");
            String string = new VirtualizationFeaturesFormatter(17).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVCenterAuthFailureEvent() - error logging event", throwable);
        }
    }

    public void logEXSihostOnlineEvent() {
        try {
            logger.info("logEXSihostOnlineEvent() - ESXi host online");
            String string = new VirtualizationFeaturesFormatter(47).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logEXSihostOnlineEvent() - error logging event", throwable);
        }
    }

    public void logVCSAVMUngracefulShutdownEvent(String string) {
        try {
            logger.info("logVCSAVMUngracefulShutdownEvent() - ungraceful shutdown of VCSA VM: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)44, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVCSAVMUngracefulShutdownEvent() - error logging event", throwable);
        }
    }

    public void logVCSANotFoundEvent() {
        try {
            logger.info("logVCSANotFoundEvent() - VCSA not found");
            String string = new VirtualizationFeaturesFormatter(99).format(null);
            if (string != null) {
                string = string.replaceAll("\\{0\\}", "");
                this.errorHandler.put(string);
            }
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVCSANotFoundEvent() - error logging event", throwable);
        }
    }

    public void logVCSAVMPoweredOffEvent(String string) {
        try {
            logger.info("logVCSAVMPoweredOffEvent() - VCSA VM: {} powered off", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)100, string).format(null);
            if (string2 != null) {
                string2 = string2.replaceAll("\\{0\\}", "");
                this.errorHandler.put(string2);
            }
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVCSAVMPoweredOffEvent() - error logging event", throwable);
        }
    }

    public void logVCSAVMShutdownEvent(String string) {
        try {
            logger.info("logVCSAVMShutdownEvent() - VCSA VM: {} shutdown", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)45, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVCSAVMShutdownEvent() - error logging event", throwable);
        }
    }

    public void logVCenterServerHostShutdownEvent(String string) {
        try {
            logger.info("logVCenterServerHostShutdownEvent() - vCenter Server host:{} shutdown", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)24, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVCenterServerHostShutdownEvent() - error logging event", throwable);
        }
    }

    public void logVMShutdownEvent(String string) {
        String string2;
        try {
            logger.info("logVMShutdownEvent() - VM Shutdown on host: {}", (Object)string);
            string2 = new VirtualizationFeaturesFormatter((Integer)7, string).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "VMVMShutdown_Log_Event";
            logger.error("logVMShutdownEvent() - error logging event", throwable);
        }
        this.errorHandler.put(string2);
    }

    public void logNutanixAHVVMShutdownEvent() {
        String string;
        try {
            logger.info("logNutanixAHVVMShutdownEvent() - VM Shutdown on the Cluster");
            string = new VirtualizationFeaturesFormatter(173).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "Nutanix_VM_Shutdown_Log_Event";
            logger.error("logNutanixAHVVMShutdownEvent() - error logging event", throwable);
        }
        this.errorHandler.put(string);
    }

    public void logNutanixAHVVMStartupLogEvent(String string) {
        String string2;
        try {
            logger.info("logNutanixAHVVMStartupLogEvent() - VM Startup on the Cluster: {}", (Object)string);
            string2 = new VirtualizationFeaturesFormatter((Integer)178, string).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "Nutanix_VM_Startup_Log_Event";
            logger.error("logNutanixAHVVMStartupLogEvent() - error logging event", throwable);
        }
        this.errorHandler.put(string2);
    }

    public void logNutanixPDReplNoneOngoingEvent() {
        String string;
        try {
            logger.info("logNutanixPDReplNoneOngoingEvent() - No ongoing PD replication detected");
            string = new VirtualizationFeaturesFormatter(157).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "Nutanix_PDRepl_None_Ongoing_Log_Event";
            logger.error("logNutanixPDReplNoneOngoingEvent() - error logging event", throwable);
        }
        this.errorHandler.put(string);
    }

    public void logNutanixPDInProgressEvent() {
        String string;
        try {
            logger.info("logNutanixPDInProgressEvent() - PD replication in progress");
            string = new VirtualizationFeaturesFormatter(158).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "Nutanix_PDRepl_In_Progress_Log_Event";
            logger.error("logNutanixPDInProgressEvent() - error logging event", throwable);
        }
        this.errorHandler.put(string);
    }

    public void logNutanixCVMStartupLogEvent(String string) {
        String string2;
        try {
            logger.info("logNutanixCVMStartupLogEvent() - CVM Startup: {}", (Object)string);
            string2 = new VirtualizationFeaturesFormatter((Integer)179, string).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "Nutanix_CVM_Startup_Log_Event";
            logger.error("logNutanixCVMStartupLogEvent() - error logging event", throwable);
        }
        this.errorHandler.put(string2);
    }

    public void logVAppNotPoweredOnEvent(Vector<String> vector) {
        try {
            logger.info("logVAppNotPoweredOnEvent() - vApp: {} not powered on", vector);
            String string = new VirtualizationFeaturesFormatter((Integer)38, vector).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVAppNotPoweredOnEvent() - error logging event", throwable);
        }
    }

    public void logSkipVAppShutdownVMOnHealthyHostEvent(Vector<String> vector) {
        try {
            logger.info("logSkipVAppShutdownVMOnHealthyHostEvent() - skip vApp: {} shutdown VM on healthy host", vector);
            String string = new VirtualizationFeaturesFormatter((Integer)37, vector).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logSkipVAppShutdownVMOnHealthyHostEvent() - error logging event", throwable);
        }
    }

    public void logVAppShutdownStartingEvent(String string) {
        try {
            logger.info("logVAppShutdownStartingEvent() - vApp shutdown starting on host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)10, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVAppShutdownStartingEvent() - error logging event", throwable);
        }
    }

    public void logVAppShutdownNoneEvent(String string) {
        try {
            logger.info("logVAppShutdownNoneEvent() - no vApp to shutdown on host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)57, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVAppShutdownNoneEvent() - error logging event", throwable);
        }
    }

    public void logVAppWithVCSAEvent(String string) {
        try {
            logger.info("logVAppWithVCSAEvent() - vApp: {} with vCSA", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)43, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVAppWithVCSAEvent() - error logging event", throwable);
        }
    }

    public void logVAppWithPCNSVMAEvent(String string) {
        try {
            logger.info("logVAppWithPCNSVMAEvent() - vApp: {} with PCNS vMA", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)25, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVAppWithPCNSVMAEvent() - error logging event", throwable);
        }
    }

    public void logVAppShutdownEnabledEvent(String string, String string2) {
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            vector.add(string2);
            logger.info("logVAppShutdownEnabledEvent() - vApp: {}, Datacenter: {} shutdown enabled", (Object)string, (Object)string2);
            String string3 = new VirtualizationFeaturesFormatter((Integer)9, vector).format(null);
            this.errorHandler.put(string3);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVAppShutdownEnabledEvent() - error logging event", throwable);
        }
    }

    public void logVAppShutdownFailedVCenterServerOfflineEvent() {
        try {
            logger.info("logVAppShutdownFailedVCenterServerOfflineEvent() - vApp shutdown failed, vCenter offline");
            String string = new VirtualizationFeaturesFormatter(27).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVAppShutdownFailedVCenterServerOfflineEvent() - error logging event", throwable);
        }
    }

    public void logVAppShutdownFailedTimeoutEvent() {
        try {
            logger.info("logVAppShutdownFailedTimeoutEvent() - vApp shutdown failed, timeout");
            String string = new VirtualizationFeaturesFormatter(102).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVAppShutdownFailedTimeoutEvent() - error logging event", throwable);
        }
    }

    public void logHostVMShutdownFailedInsufficientTimeEvent(String string) {
        try {
            logger.info("logHostVMShutdownFailedInsufficientTimeEvent() - VM shutdown failed, insufficient time to shut down VMs on host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)63, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logHostVMShutdownFailedInsufficientTimeEvent() - error logging event", throwable);
        }
    }

    public void logClusterVMShutdownFailedInsufficientTimeEvent(String string) {
        try {
            logger.info("logClusterVMShutdownFailedInsufficientTimeEvent() - VM shutdown failed, insufficient time to shut down VMs on cluster: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)72, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterVMShutdownFailedInsufficientTimeEvent() - error logging event", throwable);
        }
    }

    public void logSimplivityOvcShutdownInsufficientTimeEvent() {
        try {
            logger.info("logSimplivityOvcShutdownInsufficientTimeEvent() - Insufficient time allocated for OVC shutdown");
            String string = new VirtualizationFeaturesFormatter(181).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logSimplivityOvcShutdownInsufficientTimeEvent() - error logging event", throwable);
        }
    }

    public void logVirtualizationStartupInProgressEvent(String string) {
        String string2;
        try {
            logger.info("logVirtualizationStartupInProgressEvent() - virtualization startup in progress");
            string2 = new VirtualizationFeaturesFormatter((Integer)30, string).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "VirtualizationStartupInProgress";
            logger.error("logVirtualizationStartupInProgressEvent() - error logging event", throwable);
        }
        this.errorHandler.put(string2);
    }

    public void logVirtShutdownOfNonCriticalHostInProgressEvent(Event event) {
        try {
            logger.info("logVirtShutdownOnNonCriticalHostInProgressEvent() - Virtualization shutdown of non-critical host in progress");
            Object object = new VirtualizationFeaturesFormatter(67);
            object = new AdvancedGroupFormatter((IFormatter)object);
            String string = object.format(event);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVirtShutdownOfNonCriticalHostInProgressEvent() - error logging event", throwable);
        }
    }

    public void logVirtShutdownOfNonCriticalHostsEvent(Map<Integer, LinkedHashSet<VsanHost>> map, Event event) {
        if (map == null || map.isEmpty()) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        for (Map.Entry<Integer, LinkedHashSet<VsanHost>> object2 : map.entrySet()) {
            object2.getValue().forEach(vsanHost -> vector.add(vsanHost.getName()));
        }
        logger.info("logVirtShutdownOfNonCriticalHostsEvent() - virtualization shutdown of non-critical host(s): {}", vector);
        Object object = vector.size() == 1 ? new VirtualizationFeaturesFormatter((Integer)65, vector) : new VirtualizationFeaturesFormatter((Integer)66, vector);
        try {
            object = new AdvancedGroupFormatter((IFormatter)object);
            String throwable = object.format((Object)event);
            this.errorHandler.put(throwable);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVirtShutdownOfNonCriticalHostsEvent() - error logging event");
        }
    }

    public void logVAppVMShutdownLogEvent(String string) {
        String string2;
        try {
            logger.info("logVAppVMShutdownLogEvent() - vApp VM shutdown");
            string2 = new VirtualizationFeaturesFormatter((Integer)62, string).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "MISSING VApp_VMShutdown_Log_Event";
            logger.error("logVAppVMShutdownLogEvent() - error logging event", throwable);
        }
        this.errorHandler.put(string2);
    }

    public void logVCSAVMStartupLogEvent(String string) {
        try {
            logger.info("logVCSAVMStartupLogEvent() - vCSA VM startup");
            String string2 = new VirtualizationFeaturesFormatter((Integer)46, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVCSAVMStartupLogEvent() - error logging event", throwable);
        }
    }

    public void logVsanWitnessVMStartupLogEvent(String string) {
        try {
            logger.info("logWitnessVMStartupLogEvent() - Witness VM startup");
            String string2 = new VirtualizationFeaturesFormatter((Integer)69, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logWitnessVMStartupLogEvent() - error logging event", throwable);
        }
    }

    public void logGuestVMStartupLogEvent(String string) {
        try {
            logger.info("logGuestVMStartupLogEvent() - guest VM startup on host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)11, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logGuestVMStartupLogEvent() - error logging event", throwable);
        }
    }

    public void logReattemptVMStartupLogEvent(String string) {
        try {
            logger.info("logReattemptVMStartupLogEvent() - reattempt VM startup on host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)22, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logReattemptVMStartupLogEvent() - error logging event", throwable);
        }
    }

    public void logDRSEnabledVMMigrationLogEvent(String string) {
        try {
            logger.info("logDRSEnabledVMMigrationLogEvent() - DRS enabled, VM Migration on cluster: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)3, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logDRSEnabledVMMigrationLogEvent() - error logging event", throwable);
        }
    }

    public void logDRSDisabledVMMigrationLogEvent(String string) {
        try {
            logger.info("logDRSDisabledVMMigrationLogEvent() - DRS disabled, VM Migration on cluster: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)4, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logDRSDisabledVMMigrationLogEvent() - error logging event", throwable);
        }
    }

    public void logHostOutOfClusterLogEvent(String string) {
        try {
            logger.info("logHostOutOfClusterLogEvent() - host: {} out of cluster", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)21, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logHostOutOfClusterLogEvent() - error logging event", throwable);
        }
    }

    public void logMigrationFailedVCenterOfflineLogEvent() {
        try {
            logger.info("logMigrationFailedVCenterOfflineLogEvent() - VM Migration failed, vCenter server offline");
            String string = new VirtualizationFeaturesFormatter(26).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logMigrationFailedVCenterOfflineLogEvent() - error logging event", throwable);
        }
    }

    public void logVAppStartupTimeoutLogEvent(String string) {
        try {
            logger.info("logVAppStartupTimeoutLogEvent() - vApp: {} startup timeout", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)111, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVAppStartupTimeoutLogEvent() - error logging event", throwable);
        }
    }

    public void logVAppStartupEvent(Vector<String> vector) {
        try {
            logger.info("logVAppStartupEvent() - vApp: {} startup", vector);
            String string = new VirtualizationFeaturesFormatter((Integer)13, vector).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVAppStartupEvent() - error logging event", throwable);
        }
    }

    public void logReattemptVAppStartupEvent(Vector<String> vector) {
        try {
            logger.info("logReattemptVAppStartupEvent() - reattempt vApp: {} startup", vector);
            String string = new VirtualizationFeaturesFormatter((Integer)23, vector).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logReattemptVAppStartupEvent() - error logging event", throwable);
        }
    }

    public void logVsanHostSyncDelayEvent(String string) {
        try {
            logger.info("logVsanHostSyncDelayEvent() - vSAN host: {} sync delay", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)64, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVsanHostSyncDelayEvent() - error logging event", throwable);
        }
    }

    public void logVsanHostSyncRetryLimitReachedEvent(String string) {
        try {
            logger.error("logVsanHostSyncRetryLimitReachedEvent() - sync traffic is still active on vSAN host: {} proceeding with Host shutdown", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)64, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVsanHostSyncRetryLimitReachedEvent() - error logging event", throwable);
        }
    }

    public void logNutanixAfsStopEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(151).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logNutanixAfsStopEvent() - error logging event", throwable);
        }
    }

    public void logNutanixAfsStartEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(153).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logNutanixAfsStartEvent() - error logging event", throwable);
        }
    }

    public void logNutanixAfsStartFailedEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(154).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logNutanixAfsStartFailedEvent() - error logging event", throwable);
        }
    }

    public void logMigrationFailedNoSuitableHostEvent(String string) {
        logger.debug("logMigrationFailedNoSuitableHostEvent() - migration from host: {} failed as no suitable host found", (Object)string);
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)53, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logMigrationFailedNoSuitableHostEvent() - error logging event", throwable);
        }
    }

    public void logVMMigrationFailedWithTimeout(String string) {
        logger.debug("logVMMigrationTimeout() - VM migration from host: {} timed out", (Object)string);
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)54, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVMMigrationTimeout() - error logging event", throwable);
        }
    }

    public void logVMMigrationFailedMigrateAll(String string) {
        logger.debug("logVMMigrationFailedMigrateAll() - VM migration failed to migrate all from host: {}", (Object)string);
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)55, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVMMigrationFailedMigrateAll() - error logging event", throwable);
        }
    }

    public void logVMMigrationFailedMigrateAny(String string) {
        logger.debug("logVMMigrationFailedMigrateAny() - VM migration failed to migrate any from host: {}", (Object)string);
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)56, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVMMigrationFailedMigrateAny() - error logging event", throwable);
        }
    }

    public void logVMMigrationSucceeded(String string) {
        logger.debug("logVMMigrationSucceeded() - VM migration succeeded for host: {}", (Object)string);
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)52, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVMMigrationSucceeded() - error logging event", throwable);
        }
    }

    public void logVMMigrationNoVmToMigrate(String string) {
        logger.debug("logVMMigrationNoVmToMigrate() - no VMs to migrate from host: {}", (Object)string);
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)59, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVMMigrationNoVmToMigrate() - error logging event", throwable);
        }
    }

    public void logSimplivityOVCShutdownEvent(String string) {
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)180, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logSimplivityOVCShutdownEvent() - error logging event", throwable);
        }
    }

    public void logSimplivityOVCShutdownFailedEvent(String string) {
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)182, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logSimplivityOVCShutdownFailedEvent() - error logging event", throwable);
        }
    }

    public void logSimplivityOVCAuthFailedEvent(String string) {
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)185, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logSimplivityOVCAuthFailedEvent() - error logging event", throwable);
        }
    }

    public void logSimplivityOVCConnFailedEvent(String string) {
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)186, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logSimplivityOVCConnFailedEvent() - error logging event", throwable);
        }
    }

    public void logSimplivityOVCStartupEvent(String string) {
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)183, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logSimplivityOVCStartupEvent() - error logging event", throwable);
        }
    }

    public void logSimplivityOVCStartupFailed(String string) {
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)184, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logSimplivityOVCStartupFailed() - error logging event", throwable);
        }
    }

    public void logClusterShutdownEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(200).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterShutdownEvent() - error logging event", throwable);
        }
    }

    public void logClusterFailedShutdownEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(201).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterFailedShutdownEvent() - error logging event", throwable);
        }
    }

    public void logClusterShutdownTimeoutEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(199).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterShutdownTimeoutEvent() - error logging event", throwable);
        }
    }

    public void logClusterShutdownSuccessEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(208).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterShutdownSuccessEvent() - error logging event", throwable);
        }
    }

    public void logNMCClusterShutdownNotCompleteEvent(String string, String string2) {
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            vector.add(string2);
            String string3 = new VirtualizationFeaturesFormatter((Integer)212, vector).format(null);
            this.errorHandler.put(string3);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logNMCClusterShutdownNotCompleteEvent() - error logging event", throwable);
        }
    }

    public void logNMCClusterShutdownCommandSentEvent(String string, String string2) {
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            vector.add(string2);
            String string3 = new VirtualizationFeaturesFormatter((Integer)216, vector).format(null);
            this.errorHandler.put(string3);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logNMCClusterShutdownCommandSent() - error logging event", throwable);
        }
    }

    public void logNMCClusterShutdownSuccessEvent(String string, String string2) {
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            vector.add(string2);
            String string3 = new VirtualizationFeaturesFormatter((Integer)213, vector).format(null);
            this.errorHandler.put(string3);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logNMCClusterShutdownSuccessEvent() - error logging event", throwable);
        }
    }

    public void logNmcRestServiceUnavailable(String string, String string2) {
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            vector.add(string2);
            String string3 = new VirtualizationFeaturesFormatter((Integer)214, vector).format(null);
            this.errorHandler.put(string3);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logNmcVxRailRestServiceUnavailable() - error logging event", throwable);
        }
    }

    public void logNMCRestServiceError(String string, String string2) {
        try {
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            vector.add(string2);
            String string3 = new VirtualizationFeaturesFormatter((Integer)215, vector).format(null);
            this.errorHandler.put(string3);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logNMCvxRailRestServiceError() - error logging event", throwable);
        }
    }

    public void logCVMShutdownEvent(String string) {
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)204, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logCVMShutdownEvent() - error logging event", throwable);
        }
    }

    public void logCVMShutdownFailEvent(String string) {
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)211, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logCVMShutdownFailEvent() - error logging event", throwable);
        }
    }

    public void logClusterStartupEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(202).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterStartupEvent() - error logging event", throwable);
        }
    }

    public void logClusterFailedStartupEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(203).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterFailedStartupEvent() - error logging event", throwable);
        }
    }

    public void logClusterStartupTimeoutEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(198).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterStartupTimeoutEvent() - error logging event", throwable);
        }
    }

    public void logClusterStopNotCompleteEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(209).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterStopNotCompleteEvent() - error logging event", throwable);
        }
    }

    public void logClusterStartNotCompleteEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(210).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterStartNotCompleteEvent() - error logging event", throwable);
        }
    }

    public void logClusterAlreadyUpEvent() {
        String string;
        logger.debug("logClusterAlreadyUpEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter(207).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "ClusterAlreadyUp";
            logger.error("logClusterAlreadyUpEvent() - error logging event", throwable);
        }
        this.errorHandler.put(string);
    }

    public void logCVMStartupEvent(String string) {
        try {
            String string2 = new VirtualizationFeaturesFormatter((Integer)205, string).format(null);
            this.errorHandler.put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logCVMStartupEvent() - error logging event", throwable);
        }
    }

    public void logCVMStartupWaitEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(206).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logCVMStartupWaitEvent() - error logging event", throwable);
        }
    }

    public void logLoginFailure(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("user is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("remoteAddress is marked non-null but is null");
        }
        try {
            Object[] objectArray = new Object[]{string, string2};
            String string3 = new VirtualizationFeaturesFormatter(311).format(null);
            string3 = StringEscapeUtils.escapeHtml4((String)MessageFormat.format(string3, objectArray));
            logger.log(Level.forName((String)"ACCESS", (int)310), string3);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logLoginFailure() - error logging event", throwable);
        }
    }

    public void logVsanClusterPrepareEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(220).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVsanClusterPrepareEvent() - error logging event", throwable);
        }
    }

    public void logVsanClusterPrepareFailEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(221).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVsanClusterPrepareFailEvent() - error logging event", throwable);
        }
    }

    public void logVsanClusterRecoverEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(222).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVsanClusterRecoverEvent() - error logging event", throwable);
        }
    }

    public void logVsanClusterRecoverFailEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(223).format(null);
            this.errorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logVsanClusterRecoverFailEvent() - error logging event", throwable);
        }
    }

    @Generated
    public void setShutdownLogger(ShutdownLogger shutdownLogger) {
        this.shutdownLogger = shutdownLogger;
    }
}

