/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.hyperflex;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.webserver.model.MappedHost;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.components.webserver.util.virtualization.VirtualizationLoggingUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.hyperflex.HyperflexConnection;
import com.apcc.pcns.hyperflex.HyperflexDetails;
import com.apcc.pcns.restservice.ConnectionFailException;
import com.apcc.pcns.restservice.RestConnectionStatus;
import com.apcc.pcns.trustmanagement.UnverifiedCertificateManager;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;

public class HyperflexUtils {
    public static final String CVM_FILTER = "stCtlVM-";
    private static Logger logger = LogManager.getLogger(HyperflexUtils.class);
    @NonNull
    private VirtualConfigurationManager virtualConfigurationManager;
    @NonNull
    private AdvancedSetupHelper advancedSetupHelper;
    @NonNull
    private ConfigurationManager config;
    @NonNull
    private AuthHelper authHelper;
    @NonNull
    private VirtualizationLoggingUtils virtualizationLoggingUtils;
    @NonNull
    private HostSystemUtils hostSystemUtils;
    @NonNull
    private VMWareConnection vmwareConnection;
    @NonNull
    private UnverifiedCertificateManager unverifiedCertificateManager;

    public HyperflexUtils() {
    }

    public HyperflexUtils(@NonNull VirtualConfigurationManager virtualConfigurationManager, @NonNull AdvancedSetupHelper advancedSetupHelper, @NonNull ConfigurationManager configurationManager, @NonNull AuthHelper authHelper, @NonNull VirtualizationLoggingUtils virtualizationLoggingUtils, @NonNull HostSystemUtils hostSystemUtils, @NonNull VMWareConnection vMWareConnection, @NonNull UnverifiedCertificateManager unverifiedCertificateManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("configManager is marked non-null but is null");
        }
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("virtualizationLoggingUtils is marked non-null but is null");
        }
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        if (unverifiedCertificateManager == null) {
            throw new IllegalArgumentException("unverifiedCertificateManager is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
        this.advancedSetupHelper = advancedSetupHelper;
        this.config = configurationManager;
        this.authHelper = authHelper;
        this.virtualizationLoggingUtils = virtualizationLoggingUtils;
        this.hostSystemUtils = hostSystemUtils;
        this.vmwareConnection = vMWareConnection;
        this.unverifiedCertificateManager = unverifiedCertificateManager;
    }

    public List<VirtualMachine> filterOutHyperflexSpecialVms(List<VirtualMachine> list) {
        logger.debug("filterOutHyperflexSpecialVms() - start, retrieved vmList of size {}", (Object)list.size());
        return list.stream().filter(virtualMachine -> !StringUtils.startsWithIgnoreCase((CharSequence)virtualMachine.getName(), (CharSequence)CVM_FILTER)).collect(Collectors.toList());
    }

    public List<VirtualMachine> filterHyperflexCVMs(VirtualMachine[] virtualMachineArray) {
        logger.debug("filterHyperflexCVMs() - start, retrieved vmList of size {}", (Object)virtualMachineArray.length);
        return Arrays.stream(virtualMachineArray).filter(virtualMachine -> StringUtils.startsWithIgnoreCase((CharSequence)virtualMachine.getName(), (CharSequence)CVM_FILTER)).collect(Collectors.toList());
    }

    public List<PrioritizedVM> filterOutHyperflexSpecialFromPrioritizedVMs(List<PrioritizedVM> list) {
        logger.debug("filterOutHyperflexSpecialFromPrioritizedVMs() - start");
        if (list == null) {
            logger.debug("filterOutHyperflexSpecialFromPrioritizedVMs() - list is null");
            return list;
        }
        logger.debug("filterOutHyperflexSpecialFromPrioritizedVMs() - retrieved vmList of size {}", (Object)list.size());
        return list.stream().filter(prioritizedVM -> !StringUtils.startsWithIgnoreCase((CharSequence)prioritizedVM.getVMName(), (CharSequence)CVM_FILTER)).collect(Collectors.toList());
    }

    private VirtualMachine getHyperflexCvmForHost(HostSystem hostSystem) {
        logger.debug("getHyperflexCvmForHost() - start");
        try {
            VirtualMachine[] virtualMachineArray = hostSystem.getVms();
            return Arrays.stream(virtualMachineArray).filter(virtualMachine -> StringUtils.startsWithIgnoreCase((CharSequence)virtualMachine.getName(), (CharSequence)CVM_FILTER)).findAny().orElse(null);
        }
        catch (InvalidProperty invalidProperty) {
            logger.error("getHyperflexCvmForHost() - InvalidProperty: ", (Throwable)invalidProperty);
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("getHyperflexCvmForHost() - RuntimeFault: ", (Throwable)runtimeFault);
        }
        catch (RemoteException remoteException) {
            logger.error("getHyperflexCvmForHost() - RemoteException: ", (Throwable)remoteException);
        }
        return null;
    }

    public HyperflexDetails loadHyperflexDetails() {
        logger.debug("loadHyperflexDetails() - start");
        String string = this.config.getString("HyperflexClusterDetails", "username");
        String string2 = this.authHelper.getHyperflexPassword();
        String string3 = this.getHost();
        String string4 = this.getDefaultClientId();
        String string5 = this.getDefaultClientSecret();
        String string6 = this.getDefaultRedirectUri();
        logger.debug("loadHyperflexDetails() - end, creating details for host {}", (Object)string3);
        return new HyperflexDetails(string3, string, string2, string4, string5, string6);
    }

    public String getHost() {
        return this.config.getString("HyperflexClusterDetails", "Cluster_Ip");
    }

    public void saveHyperflexDetails(@NonNull HyperflexDetails hyperflexDetails) {
        if (hyperflexDetails == null) {
            throw new IllegalArgumentException("details is marked non-null but is null");
        }
        logger.debug("saveHyperflexDetails() - start, saving details for host {}", (Object)hyperflexDetails.getHost());
        this.config.setProperty("HyperflexClusterDetails", "Cluster_Ip", hyperflexDetails.getHost());
        this.config.setProperty("HyperflexClusterDetails", "username", hyperflexDetails.getUsername());
        this.authHelper.setHyperflexPassword(hyperflexDetails.getPassword());
        logger.debug("saveHyperflexDetails() - end");
    }

    public int getCvmStartupDuration(boolean bl, int n) {
        return this.virtualConfigurationManager.getCvmStartupDuration(bl, n);
    }

    public int getCvmShutdownDuration(boolean bl, int n) {
        return this.virtualConfigurationManager.getCvmShutdownDuration(bl, n);
    }

    public int getClusterShutdownDuration(boolean bl, int n) {
        return this.virtualConfigurationManager.getClusterShutdownDuration(bl, n);
    }

    public int getClusterStartupDuration(boolean bl, int n) {
        return this.virtualConfigurationManager.getClusterStartupDuration(bl, n);
    }

    public int getJobQueryWait() {
        int n = 30;
        try {
            if (this.config.containsKey("HyperflexClusterDetails", "job_query_wait")) {
                logger.debug("getDurationGlobal() - found key for job query wait value");
                n = this.config.getInt("HyperflexClusterDetails", "job_query_wait", n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error((Object)noSuchElementException);
        }
        logger.debug("getJobQueryWait() - end, returning job query wait value: {}", (Object)n);
        return n;
    }

    public int getClusterStopMaxRetries() {
        int n = 10;
        try {
            if (this.config.containsKey("HyperflexClusterDetails", "cluster_stop_retries")) {
                logger.debug("getDurationGlobal() - found key for job query wait value");
                n = this.config.getInt("HyperflexClusterDetails", "cluster_stop_retries", n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error((Object)noSuchElementException);
        }
        logger.debug("getClusterStopMaxRetries() - end, returning max retries value: {}", (Object)n);
        return n;
    }

    public List<String> getMappedHostsList() {
        return this.virtualConfigurationManager.getMappedHostsList();
    }

    public void logClusterShutdownEvent() {
        this.virtualizationLoggingUtils.logClusterShutdownEvent();
    }

    public void logClusterFailedShutdownEvent() {
        this.virtualizationLoggingUtils.logClusterFailedShutdownEvent();
    }

    public void logClusterShutdownTimeoutEvent() {
        this.virtualizationLoggingUtils.logClusterShutdownTimeoutEvent();
    }

    public void logClusterShutdownSuccessEvent() {
        this.virtualizationLoggingUtils.logClusterShutdownSuccessEvent();
    }

    public void logClusterAlreadyUpEvent() {
        this.virtualizationLoggingUtils.logClusterAlreadyUpEvent();
    }

    public void logClusterStartupEvent() {
        this.virtualizationLoggingUtils.logClusterStartupEvent();
    }

    public void logClusterFailedStartupEvent() {
        this.virtualizationLoggingUtils.logClusterFailedStartupEvent();
    }

    public void logClusterStartupTimeoutEvent() {
        this.virtualizationLoggingUtils.logClusterStartupTimeoutEvent();
    }

    public void logHyperflexRestserviceUnavailable() {
        try {
            String string = new VirtualizationFeaturesFormatter(190).format(null);
            ServiceManager.getInstance().getApplicationErrorHandler().put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("logClusterShutdownEvent() - error logging event", throwable);
        }
    }

    public void logCVMShutdownEvent(String string) {
        this.virtualizationLoggingUtils.logCVMShutdownEvent(string);
    }

    public void logCVMShutdownFailEvent(String string) {
        this.virtualizationLoggingUtils.logCVMShutdownFailEvent(string);
    }

    public void logCVMStartupEvent(String string) {
        this.virtualizationLoggingUtils.logCVMStartupEvent(string);
    }

    public void logCVMStartupWaitEvent() {
        this.virtualizationLoggingUtils.logCVMStartupWaitEvent();
    }

    protected HyperflexConnection getHyperflexConnection(HyperflexDetails hyperflexDetails) {
        return ServiceManager.getInstance().getHyperflexConnectionManager().getConnection(hyperflexDetails);
    }

    public RestConnectionStatus checkConnection(@NonNull HyperflexDetails hyperflexDetails) throws IllegalArgumentException {
        if (hyperflexDetails == null) {
            throw new IllegalArgumentException("hyperflexDetails is marked non-null but is null");
        }
        logger.debug("checkConnection() - start");
        RestConnectionStatus restConnectionStatus = RestConnectionStatus.OK;
        boolean bl = hyperflexDetails.hasValidConnectionDetails();
        if (!bl) {
            throw new IllegalArgumentException("Host, username or password cannot be empty");
        }
        logger.debug("checkConnection() - host: {}", (Object)hyperflexDetails.getHost());
        HyperflexConnection hyperflexConnection = this.getHyperflexConnection(hyperflexDetails);
        this.addDefaultHyperflexDetails(hyperflexDetails);
        String string = null;
        try {
            string = hyperflexConnection.getClusterUuid();
        }
        catch (RemoteException remoteException) {
            Throwable throwable = remoteException.getCause();
            if (throwable instanceof ConnectionFailException) {
                boolean bl2;
                ConnectionFailException connectionFailException = (ConnectionFailException)((Object)throwable);
                if (HttpStatus.UNAUTHORIZED == connectionFailException.getStatusCode()) {
                    logger.error("checkConnection() - credentials invalid, returning {}", (Object)RestConnectionStatus.UNAUTHORIZED);
                    return RestConnectionStatus.UNAUTHORIZED;
                }
                if (HttpStatus.SERVICE_UNAVAILABLE == connectionFailException.getStatusCode() && (bl2 = this.unverifiedCertificateManager.addCertificateChainByException(hyperflexDetails.getHost(), throwable))) {
                    logger.debug("checkConnection() - Untrusted Certificate");
                    return RestConnectionStatus.CERTIFICATE_UNTRUSTED;
                }
            }
            logger.error("checkConnection() - unable to connect to Hyperflex service, returning {}, error: {}", (Object)RestConnectionStatus.UNAVAILABLE, (Object)remoteException);
            return RestConnectionStatus.UNAVAILABLE;
        }
        catch (Exception exception) {
            logger.error("checkConnection() - unable to connect to Hyperflex service, returning {}, error: {}", (Object)RestConnectionStatus.UNAVAILABLE, (Object)exception);
            return RestConnectionStatus.UNAVAILABLE;
        }
        logger.debug("checkConnection() - end, connection established");
        this.saveClusterUuidToConfig(string);
        return restConnectionStatus;
    }

    public boolean isClusterLocked() {
        return this.virtualConfigurationManager.isClusterLocked();
    }

    public boolean isClusterHostUnhealthy() {
        return this.virtualConfigurationManager.isCvmHostUnhealthy(this.getMappedHostsList());
    }

    public boolean hasClusterActiveCriticalEvent(ShutdownState shutdownState) {
        return this.virtualConfigurationManager.hasClusterActiveCriticalEvent(shutdownState);
    }

    public boolean isCvmStartupEnabled(int n) {
        return this.virtualConfigurationManager.isCvmStartupEnabled(n);
    }

    private void addDefaultHyperflexDetails(HyperflexDetails hyperflexDetails) {
        if (StringUtils.isBlank((CharSequence)hyperflexDetails.getClientId())) {
            hyperflexDetails.setClientId(this.getDefaultClientId());
        }
        if (StringUtils.isBlank((CharSequence)hyperflexDetails.getClientSecret())) {
            hyperflexDetails.setClientSecret(this.getDefaultClientSecret());
        }
        if (StringUtils.isBlank((CharSequence)hyperflexDetails.getRedirectUri())) {
            hyperflexDetails.setRedirectUri(this.getDefaultRedirectUri());
        }
    }

    private String getDefaultClientId() {
        String string = "HxGuiClient";
        if (this.config.containsKey("HyperflexClusterDetails", "client_id")) {
            string = this.config.getString("HyperflexClusterDetails", "client_id", "HxGuiClient");
        }
        return string;
    }

    private String getDefaultClientSecret() {
        String string = "Sunnyvale";
        if (this.config.containsKey("HyperflexClusterDetails", "client_secret")) {
            string = this.config.getString("HyperflexClusterDetails", "client_secret", "Sunnyvale");
        }
        return string;
    }

    private String getDefaultRedirectUri() {
        String string = "http://localhost:8080/aaa/redirect";
        if (this.config.containsKey("HyperflexClusterDetails", "redirect_uri")) {
            string = this.config.getString("HyperflexClusterDetails", "redirect_uri", "http://localhost:8080/aaa/redirect");
        }
        return string;
    }

    public VirtualMachine getCvmOnHost(String string) {
        logger.debug("getCvmOnHost() - start, getting CVMs on host {}", (Object)string);
        ServiceInstance serviceInstance = this.vmwareConnection.getServiceInstance(string);
        if (serviceInstance == null) {
            logger.error("getCvmOnHost() - cannot obtain ESXi service instance");
            return null;
        }
        HostSystem hostSystem = this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string);
        if (hostSystem == null) {
            logger.error("getCvmOnHost() - hostSystem is null");
            return null;
        }
        logger.debug("getCvmOnHost() - end");
        return this.getHyperflexCvmForHost(hostSystem);
    }

    public Map<String, String> getCVMsFromConfig() {
        logger.debug("getCVMsFromConfig() - start");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 1; i <= 20; ++i) {
            boolean bl = this.config.containsKey("HyperflexClusterDetails", "cvm_name_" + i);
            boolean bl2 = this.config.containsKey("HyperflexClusterDetails", "cvm_host_" + i);
            if (!bl || !bl2) break;
            String string = this.config.getString("HyperflexClusterDetails", "cvm_name_" + i);
            String string2 = this.config.getString("HyperflexClusterDetails", "cvm_host_" + i);
            logger.debug("getCVMsFromConfig() - got Controller VM {} with index {} for host {}", (Object)string, (Object)i, (Object)string2);
            hashMap.put(string2, string);
        }
        logger.debug("getCVMsFromConfig() - end");
        return hashMap;
    }

    public void saveCvmDetailsToConfig(List<String> list) {
        logger.debug("saveCvmDetailsToConfig() - start");
        int n = 0;
        String string = "HyperflexClusterDetails";
        if (list == null || list.isEmpty()) {
            logger.debug("saveCvmDetailsToConfig() - no hosts provided, cannot locate Controller VMs");
            return;
        }
        for (String string2 : list) {
            logger.debug("saveCvmDetailsToConfig() - retrieving CVMs for host {}", (Object)string2);
            VirtualMachine virtualMachine = this.getCvmOnHost(string2);
            if (virtualMachine != null) {
                String string3 = virtualMachine.getName();
                logger.debug("saveCvmDetailsToConfig() - adding Controller VM {} with index {} for host {}", (Object)string3, (Object)(++n), (Object)string2);
                this.config.setProperty(string, "cvm_name_" + n, string3);
                this.config.setProperty(string, "cvm_host_" + n, string2);
                continue;
            }
            logger.debug("saveCvmDetailsToConfig() - no Controller VM found for host {}", (Object)string2);
        }
        if (!this.config.containsKey(string, "cluster_stop_retries")) {
            logger.debug("saveCvmDetailsToConfig() - setting default for cluster operation retries to {}", (Object)10);
            this.config.setProperty(string, "cluster_stop_retries", 10);
        }
        logger.debug("saveCvmDetailsToConfig() - end");
    }

    public void saveCvmDetailsToConfig(LinkedHashMap<String, MappedHost> linkedHashMap) {
        List<String> list = linkedHashMap.entrySet().stream().map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        this.saveCvmDetailsToConfig(list);
    }

    public void saveClusterUuidToConfig(String string) {
        this.virtualConfigurationManager.saveClusterUuidToConfig("HyperflexClusterDetails", string);
    }

    public String getClusterUuidFromConfig() {
        return this.virtualConfigurationManager.getClusterUuidFromConfig("HyperflexClusterDetails");
    }

    public boolean isClusterHostUp() {
        int n = 443;
        int n2 = 1;
        return this.virtualConfigurationManager.isHostAvailable(this.getHost(), n, n2, TimeUnit.SECONDS);
    }

    @Generated
    public void setVirtualConfigurationManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
    }

    @Generated
    public void setAdvancedSetupHelper(@NonNull AdvancedSetupHelper advancedSetupHelper) {
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        this.advancedSetupHelper = advancedSetupHelper;
    }

    @Generated
    public void setConfig(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Generated
    public void setAuthHelper(@NonNull AuthHelper authHelper) {
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        this.authHelper = authHelper;
    }

    @Generated
    public void setVirtualizationLoggingUtils(@NonNull VirtualizationLoggingUtils virtualizationLoggingUtils) {
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("virtualizationLoggingUtils is marked non-null but is null");
        }
        this.virtualizationLoggingUtils = virtualizationLoggingUtils;
    }

    @Generated
    public void setHostSystemUtils(@NonNull HostSystemUtils hostSystemUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setVmwareConnection(@NonNull VMWareConnection vMWareConnection) {
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        this.vmwareConnection = vMWareConnection;
    }

    @Generated
    public void setUnverifiedCertificateManager(@NonNull UnverifiedCertificateManager unverifiedCertificateManager) {
        if (unverifiedCertificateManager == null) {
            throw new IllegalArgumentException("unverifiedCertificateManager is marked non-null but is null");
        }
        this.unverifiedCertificateManager = unverifiedCertificateManager;
    }
}

