/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.hyperv;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.webserver.model.Host;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.model.VM;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.util.virtualization.VMPrioritizationUtils;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HyperVUtils {
    private static final String POWERSHELL_CMD = "powershell.exe";
    private static final String vmGetHostsScript = ".\\psScripts\\scvmm_gethosts.ps1";
    public static final String vmmGetDetailsScript = ".\\psScripts\\scvmm_getdetails.ps1";
    private static final String vmGetMigrationTargets = ".\\psScripts\\LiveMigrateTargets.ps1";
    private static final String vmMaintenanceScript = ".\\psScripts\\scvmm_maintenance.ps1";
    public static final String vmStopHostScript = ".\\psScripts\\scvmm_stopHost.ps1";
    private static final String vmCheckServerScript = ".\\psScripts\\scvmm_checkserver.ps1";
    public static final String vmListVMScript = ".\\psScripts\\list-vm.ps1";
    public static final int ERROR_SCRIPT_TIMEOUT = 100;
    public static final int ERROR_SUCCESS = 101;
    public static final int ERROR_MIGRATION_FAILED = 102;
    public static final int ERROR_SHUTDOWN_FAILED = 103;
    private static final int ERROR_STARTUP_FAILED = 104;
    private static final int ERROR_NO_VM_TO_SHUTDOWN = 105;
    private static final int ERROR_NO_VM_TO_START = 106;
    private static final int ERROR_HEALTHY_HOST = 107;
    public static final int ERROR_CLUSTER_SERVICE_NOT_RUNNING = 108;
    public static final int ERROR_CLUSTER_SERVICE_ALREADY_UP = 109;
    private static final int ERROR_MAINTENANCE_FAILED = 110;
    private static final int ERROR_HOST_ALREADY_IN_MAINTENANCE_MODE = 111;
    private static final int ERROR_HOST_NOT_IN_MAINTENANCE_MODE = 112;
    private static final int ERROR_SERVER_NOT_AVAILABLE = 113;
    private static final int ERROR_HOST_NOT_IN_VALID_STATE = 114;
    public static final int ERROR_VM_MIGRATION_NOTARGETS = 115;
    public static final int ERROR_MIGRATION_SOME_FAILED = 116;
    public static final int ERROR_MIGRATION_NO_VMS = 117;
    public static final int ERROR_STOP_CLUSTER_FAILED = 118;
    public static final int ERROR_START_CLUSTER_FAILED = 119;
    public static final int ERROR_CLUSTER_SERVICE_NOT_INSTALLED = 120;
    public static final int ERROR_VMM_SERVICE_UNAVAILABLE = 1602;
    public static final int ERROR_SERVER_INACCESSIBLE = 1603;
    public static final int ERROR_VMM_ACCESS_ISSUE = 1604;
    public static final int ERROR_INSUFFICIENT_PRIVILEGES = 1605;
    public static final int ERROR_PERMISSION_DENIED = 20414;
    public static final int DEFAULT_TIMEOUT = -1;
    public static final int START_MAINTENANCE_MODE = 1;
    public static final int STOP_MAINTENANCE_MODE = 0;
    private static Logger logger = LogManager.getLogger(HyperVUtils.class);
    @NonNull
    private VirtualConfigurationManager virtualConfigManager;
    @NonNull
    private ApplicationErrorHandler applicationErrorHandler;
    @NonNull
    private VirtualisationStatusStore virtualisationStatusStore;
    @NonNull
    private VMPrioritizationUtils vmPrioritizationUtils;

    public HyperVUtils() {
    }

    public HyperVUtils(@NonNull VirtualConfigurationManager virtualConfigurationManager, @NonNull VirtualisationStatusStore virtualisationStatusStore) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("configManager is marked non-null but is null");
        }
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtualisationStatusStore is marked non-null but is null");
        }
        this.virtualConfigManager = virtualConfigurationManager;
        this.virtualisationStatusStore = virtualisationStatusStore;
    }

    public boolean hostStartMaintenanceMode(String string, String string2, int n) {
        boolean bl = false;
        logger.debug("hostStartMaintenanceMode: " + string2);
        this.virtualisationStatusStore.lockHostForShutdown(string2);
        int n2 = this.executeScript(vmMaintenanceScript, string + " " + string2 + " 1 " + n, n);
        if (n2 == 101) {
            try {
                String string3 = new VirtualizationFeaturesFormatter((Integer)89, string2).format(null);
                this.applicationErrorHandler.put(string3);
            }
            catch (FormatterException | UnsupportedLocaleException throwable) {
                logger.error("Hyperv_HostStartedMaintenanceMode_Event: Unable to log event");
            }
            logger.debug("Started Maintenace Mode on host: " + string2);
            bl = true;
        } else if (n2 == 111) {
            try {
                String string4 = new VirtualizationFeaturesFormatter((Integer)91, string2).format(null);
                this.applicationErrorHandler.put(string4);
            }
            catch (FormatterException | UnsupportedLocaleException throwable) {
                logger.error("Hyperv_HostAlreadyInMaintenanceMode_Event: Unable to log event");
            }
            logger.debug("Host already in maintenance mode: " + string2);
            bl = true;
        } else if (n2 == 110 || n2 == 100) {
            try {
                String string5 = new VirtualizationFeaturesFormatter((Integer)93, string2).format(null);
                this.applicationErrorHandler.put(string5);
            }
            catch (FormatterException | UnsupportedLocaleException throwable) {
                logger.error("Hyperv_FailHostStartMaintenanceMode_Event: Unable to log event");
            }
            logger.error("Start Maintenance Mode failed for host: " + string2);
        } else if (n2 == 114) {
            try {
                String string6 = new VirtualizationFeaturesFormatter((Integer)93, string2).format(null);
                this.applicationErrorHandler.put(string6);
            }
            catch (FormatterException | UnsupportedLocaleException throwable) {
                logger.error("Hyperv_FailHostStartMaintenanceMode_Event: Unable to log event");
            }
            logger.error("Start Maintenance Mode failed, host not in valid State: " + string2);
        } else if (n2 == 113) {
            logger.error("Start Maintenance Mode failed, server not available for host: " + string2);
        } else {
            logger.error("Start Maintenance Mode failed, Unexpected result: " + n2 + " for host:" + string2);
        }
        return bl;
    }

    public boolean hostStopMaintenanceMode(String string, String string2) {
        boolean bl = false;
        logger.debug("hostStopMaintenanceMode: " + string2);
        int n = this.executeScript(vmMaintenanceScript, string + " " + string2 + " 0 0", -1);
        if (n == 101) {
            try {
                String string3 = new VirtualizationFeaturesFormatter((Integer)90, string2).format(null);
                this.applicationErrorHandler.put(string3);
            }
            catch (FormatterException | UnsupportedLocaleException throwable) {
                logger.error("Hyperv_HostStoppedMaintenanceMode_Event: Unable to log event");
            }
            logger.debug("Stopped Maintenance Mode on host: " + string2);
            bl = true;
        } else if (n == 112) {
            try {
                String string4 = new VirtualizationFeaturesFormatter((Integer)92, string2).format(null);
                this.applicationErrorHandler.put(string4);
            }
            catch (FormatterException | UnsupportedLocaleException throwable) {
                logger.error("HostNotInMaintenanceMode_Event: Unable to log event");
            }
            logger.debug("Host not in maintenance mode: " + string2);
            bl = true;
        } else if (n == 110) {
            logger.error("Stop Maintenance Mode failed for host: " + string2);
        } else if (n == 114) {
            logger.error("Stop Maintenance Mode failed, host not in valid state: " + string2);
        } else if (n == 113) {
            logger.error("Stop Maintenance Mode failed, server not available for host: " + string2);
        }
        return bl;
    }

    public void stopHost(String string, String string2, int n) {
        logger.debug("stopHost- VMMServer:{}  Host:{} duration:{} ", (Object)string, (Object)string2, (Object)n);
        try {
            int n2 = this.executeScript(vmStopHostScript, string + " " + string2, n);
            logger.debug("Script Result:" + n2);
            if (n2 == 101) {
                logger.debug("Host Stopped: " + string2);
                try {
                    String string3 = new VirtualizationFeaturesFormatter((Integer)95, string2).format(null);
                    this.applicationErrorHandler.put(string3);
                }
                catch (FormatterException | UnsupportedLocaleException throwable) {
                    logger.error("Hyperv_HostStopSUCCESS: Unable to log event");
                }
            } else if (n2 == 100) {
                logger.debug("Host Stop Timeout: " + string2);
                try {
                    String string4 = new VirtualizationFeaturesFormatter((Integer)116, string2).format(null);
                    this.applicationErrorHandler.put(string4);
                }
                catch (FormatterException | UnsupportedLocaleException throwable) {
                    logger.error("Hyperv_HostStopTIMEOUT: Unable to log event");
                }
            } else {
                logger.warn("Host didnt stop: " + string2 + " Error:" + n2);
                try {
                    String string5 = new VirtualizationFeaturesFormatter((Integer)96, string2).format(null);
                    this.applicationErrorHandler.put(string5);
                }
                catch (FormatterException | UnsupportedLocaleException throwable) {
                    logger.error("Hyperv_HostStopFAIL: Unable to log event");
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Error running script", (Throwable)exception);
        }
    }

    public Integer isServerAvailable(String string) {
        Integer n = 0;
        logger.debug("isServerAvailable: " + string);
        n = this.executeScript(vmCheckServerScript, string, -1);
        switch (n) {
            case 101: {
                logger.debug("Server is available.");
                n = 1;
                break;
            }
            case 113: {
                logger.debug("Server is not available.");
                n = 0;
                break;
            }
            case 1602: {
                logger.debug("Server is accessible, VMM service is unavailable.");
                n = 0;
                break;
            }
            case 1603: {
                logger.debug("Server is not accessible.");
                n = 0;
                break;
            }
            case 1604: {
                logger.debug("You cannot access the Virtual Machine Manager localhost.");
                n = -1;
                break;
            }
            case 1605: {
                logger.debug("You cannot contact the VMM server. The credentials provided have insufficient privileges.");
                n = -1;
                break;
            }
            case 20414: {
                logger.debug("Server is accessible, permissions problem running VMM commands.");
                n = -1;
                break;
            }
            default: {
                logger.debug("Error ID [" + n.toString() + "], defaulting to 'Server is not available'.");
                n = 0;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeScript(String string, String string2, int n) {
        int n2 = 1;
        logger.debug("executeScript:{}  args:{}  timeout:{}", (Object)string, (Object)string2, (Object)n);
        if (string == null) {
            logger.debug("script name is null");
            string = "";
            n2 = 0;
            return n2;
        }
        File file = new File(string);
        if (!file.exists()) {
            logger.debug("Script file doesn't exist - cancelling the operation");
            n2 = 0;
            return n2;
        }
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            ProcessBuilder processBuilder = string2 != null ? new ProcessBuilder("cmd", "/c", "powershell.exe -ExecutionPolicy RemoteSigned -noprofile -noninteractive ", string, string2) : new ProcessBuilder("cmd", "/c", "powershell.exe -ExecutionPolicy RemoteSigned -noprofile -noninteractive ", string);
            process = processBuilder.start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            process.getOutputStream().close();
            Object object = processBuilder;
            synchronized (object) {
                if (n == -1) {
                    logger.trace("waitFor");
                    process.waitFor();
                } else {
                    logger.debug("wait:" + ++n);
                    processBuilder.wait(n * 1000);
                }
            }
            object = Integer.toString(100);
            if (bufferedReader.ready()) {
                object = bufferedReader.readLine();
            } else {
                logger.debug("No output available from script.  Probably a timeout");
            }
            logger.debug("result:" + (String)object);
            n2 = this.processOutput((String)object, string);
        }
        catch (Exception exception) {
            logger.error("Failed to execute script : " + string, (Throwable)exception);
            n2 = 0;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.error("Error closing stream : ", (Throwable)iOException);
                }
            }
        }
        return n2;
    }

    private int processOutput(String string, String string2) {
        int n = 1;
        logger.debug("processOutput:" + string + " for script:" + string2);
        if (string == null || string.trim().equals("")) {
            logger.debug("Cannot process the error code.  No Code Returned ");
            return n;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Cannot process the error code ", (Throwable)numberFormatException);
            return n;
        }
        switch (n) {
            case 101: {
                logger.debug("Script " + string2 + " executed properly");
                break;
            }
            case 102: {
                logger.debug("Vm Migration task failed");
                break;
            }
            case 103: {
                logger.debug("Vm Shutdown task failed");
                break;
            }
            case 104: {
                logger.debug("Vm Startup task failed");
                break;
            }
            case 105: {
                logger.debug("There are no VMs to shutdown");
                break;
            }
            case 106: {
                logger.debug("There are no VMs to start");
                break;
            }
            case 107: {
                logger.debug("There are healthy hosts in the cluster skipping VM Shutdown");
                logger.debug("Fail over clustering will move the VMs to healthy host ");
                try {
                    String string3 = new VirtualizationFeaturesFormatter(82).format(null);
                    this.applicationErrorHandler.put(string3);
                }
                catch (Exception exception) {
                    logger.error("Cannot log event ", (Throwable)exception);
                }
                break;
            }
            case 120: {
                logger.debug("Cluster service not installed on the host");
                break;
            }
            case 108: {
                logger.debug("Cluster service not running on the host");
                break;
            }
            case 109: {
                logger.debug("Host is already in up state");
                break;
            }
            case 110: {
                logger.debug("Host maintenance task failed");
                break;
            }
            case 113: {
                logger.debug("Server is not available");
                break;
            }
            case 118: {
                logger.warn("Unable to stop cluster");
                break;
            }
            case 119: {
                logger.warn("Unable to start cluster");
                break;
            }
        }
        return n;
    }

    public String executePSScript(String string, String string2) {
        String string3 = null;
        logger.debug("executePSScript:" + string);
        File file = new File(string);
        if (!file.exists()) {
            logger.debug("Script file doesn't exist: " + string);
            return string3;
        }
        String string4 = "cmd /c powershell.exe -ExecutionPolicy RemoteSigned -noprofile -noninteractive -file \"" + string + "\"";
        if (string2 != null && string2.length() > 0) {
            string4 = string4 + " " + string2;
        }
        string3 = this.executeScript(string4);
        return string3;
    }

    private String executeScript(String string) {
        String string2 = null;
        logger.debug("ExecuteScript:" + string);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            String string3;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string);
            process.getOutputStream().close();
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3 + "\n");
            }
            inputStream = process.getErrorStream();
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer2.append(string3 + "\n");
            }
            if (stringBuffer2.length() > 0) {
                logger.debug("Error while executing [" + string + "] : " + stringBuffer2.toString());
                string2 = null;
            } else {
                string2 = stringBuffer.toString();
            }
        }
        catch (IOException iOException) {
            logger.debug("IOException in executeScript: ", (Throwable)iOException);
        }
        return string2;
    }

    public List<Host> getHostsManaged() {
        logger.debug("getHostsManaged");
        String string = this.virtualConfigManager.getServerIP();
        String string2 = this.executePSScript(vmGetHostsScript, string);
        List<Host> list = this.parseVMMHosts(string2);
        return list;
    }

    public String getSCVMMVersion() {
        logger.debug("getSCVMMVersion");
        String string = this.virtualConfigManager.getServerIP();
        String string2 = this.executePSScript(vmmGetDetailsScript, string);
        String string3 = null;
        Map<String, String> map = this.parseResultsArray(string2);
        if (map != null) {
            string3 = map.get("ProductVersion");
        }
        logger.debug("getSCVMMVersion() - returns {}", string3);
        return string3;
    }

    public List<PrioritizedVM> getPrioritizationVMs() {
        String[] stringArray;
        logger.debug("getPrioritizationVMs() - start");
        String string = this.executePSScript(vmListVMScript, null);
        if (null == string) {
            logger.error("Hyper-V Module for Windows PowerShell is not present. PowerChute requires this to manage Hyper-V Virtual Machines. Please install this module, and try again.");
            return null;
        }
        ArrayList<PrioritizedVM> arrayList = new ArrayList<PrioritizedVM>();
        String string2 = this.virtualConfigManager.getLocalHostIP();
        string = StringUtils.trim((String)string);
        string = StringUtils.strip((String)string);
        for (String string3 : stringArray = StringUtils.split((String)string, (String)",")) {
            PrioritizedVM prioritizedVM = new PrioritizedVM();
            prioritizedVM.setVMName(StringUtils.strip((String)string3));
            prioritizedVM.setDataCenter(string2);
            arrayList.add(prioritizedVM);
        }
        return arrayList;
    }

    public List<String> filterVMsByPriority(List<PrioritizedVM> list, VMPriority vMPriority) {
        logger.debug("filterVMs() - filtering VMs for priority: {}", (Object)vMPriority);
        boolean bl = this.vmPrioritizationUtils.isVMPrioritizationEnabled();
        if (!bl) {
            logger.debug("filterVMs() - prioritization is not enabled, returning empty list");
            return new ArrayList<String>();
        }
        if (list.isEmpty()) {
            logger.debug("filterVMs() - VM list is empty, cannot filter by priority group");
            return new ArrayList<String>();
        }
        List<PrioritizedVM> list2 = this.filterOutSpecialVMsFromPrioritizedVMs(list);
        List<String> list3 = list2.stream().map(VM::getVMName).collect(Collectors.toList());
        list3 = this.vmPrioritizationUtils.filterVMsByPriority(list3, vMPriority);
        logger.debug("filterVMs() - filtered VMs for priority group {}: {}", (Object)vMPriority, list3);
        return list3;
    }

    public List<PrioritizedVM> filterOutSpecialVMsFromPrioritizedVMs(List<PrioritizedVM> list) {
        return list;
    }

    public List<Host> getHostsInClusterUnmanaged() {
        logger.debug("getHostsInClusterUnmanaged");
        String string = this.executePSScript(vmGetMigrationTargets, null);
        List<Host> list = this.parseVMMHosts(string);
        return list;
    }

    public List<Host> parseVMMHosts(String string) {
        ArrayList<Host> arrayList = null;
        logger.debug("parsing:" + string);
        if (string != null) {
            Integer n = null;
            try {
                n = Integer.parseInt(string);
                logger.error("Error Code returned from getHosts:" + n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                arrayList = new ArrayList<Host>();
                try {
                    JsonArray jsonArray = (JsonArray)Jsoner.deserialize((String)string);
                    if (jsonArray != null && jsonArray.size() > 0) {
                        for (Object e : jsonArray) {
                            JsonObject jsonObject = (JsonObject)e;
                            String string2 = (String)jsonObject.get((Object)"Name");
                            logger.debug("jsonCluster: {}", (Object)string2);
                            if (string2 != null && (string2 = string2.trim()).isEmpty()) {
                                string2 = null;
                            }
                            ArrayList arrayList2 = new ArrayList();
                            if (jsonObject.get((Object)"Hosts") == null) continue;
                            JsonArray jsonArray2 = (JsonArray)jsonObject.get((Object)"Hosts");
                            JsonArray jsonArray3 = (JsonArray)jsonObject.get((Object)"BMCEnabled");
                            if (jsonArray2 == null || jsonArray2.size() <= 0) continue;
                            for (int i = 0; i < jsonArray2.size(); ++i) {
                                String string3 = (String)jsonArray2.get(i);
                                boolean bl = HyperVUtils.isBMCEnabledForHost(jsonArray3, i);
                                Host host = new Host(string3, null, string2, bl);
                                arrayList.add(host);
                            }
                        }
                    } else {
                        logger.debug("no json clusters found");
                    }
                }
                catch (JsonException jsonException) {
                    logger.debug("Failed to parse result of getHostList [" + string + "]");
                }
            }
        }
        logger.debug("parseVMMHosts() - end [" + String.valueOf(arrayList) + "]");
        return arrayList;
    }

    public Map<String, String> parseResultsArray(String string) {
        HashMap<String, String> hashMap = null;
        logger.debug("parseResultsArray parsing:{}", (Object)string);
        if (string != null) {
            Integer n = null;
            try {
                n = Integer.parseInt(string);
                logger.error("Error Code returned from getDetails:{}", (Object)n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n == null) {
                try {
                    JsonArray jsonArray = (JsonArray)Jsoner.deserialize((String)string);
                    hashMap = new HashMap<String, String>();
                    for (Object e : jsonArray) {
                        if (!(e instanceof JsonObject)) continue;
                        JsonObject jsonObject = (JsonObject)e;
                        Set set = jsonObject.entrySet();
                        for (Map.Entry entry : set) {
                            if (entry.getValue() != null) {
                                hashMap.put((String)entry.getKey(), entry.getValue().toString());
                                continue;
                            }
                            hashMap.put((String)entry.getKey(), null);
                        }
                    }
                }
                catch (JsonException jsonException) {
                    logger.error("Invalid Script result returned from getDetails result:{}", (Object)string, (Object)jsonException);
                }
            }
        }
        logger.debug("parseVMMHosts() - end [{}]", hashMap);
        return hashMap;
    }

    private static boolean isBMCEnabledForHost(JsonArray jsonArray, int n) {
        Object object;
        boolean bl = false;
        if (jsonArray != null && jsonArray.size() > n && (object = jsonArray.get(n)) != null) {
            return Boolean.valueOf(object.toString());
        }
        return bl;
    }

    public List<Host> getHosts() {
        logger.debug("getHosts");
        if (this.virtualConfigManager.isManagedHost()) {
            return this.getHostsManaged();
        }
        return this.getHostsInClusterUnmanaged();
    }

    @Generated
    public void setVirtualConfigManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigManager is marked non-null but is null");
        }
        this.virtualConfigManager = virtualConfigurationManager;
    }

    @Generated
    public void setApplicationErrorHandler(@NonNull ApplicationErrorHandler applicationErrorHandler) {
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("applicationErrorHandler is marked non-null but is null");
        }
        this.applicationErrorHandler = applicationErrorHandler;
    }

    @Generated
    public void setVirtualisationStatusStore(@NonNull VirtualisationStatusStore virtualisationStatusStore) {
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtualisationStatusStore is marked non-null but is null");
        }
        this.virtualisationStatusStore = virtualisationStatusStore;
    }

    @Generated
    public void setVmPrioritizationUtils(@NonNull VMPrioritizationUtils vMPrioritizationUtils) {
        if (vMPrioritizationUtils == null) {
            throw new IllegalArgumentException("vmPrioritizationUtils is marked non-null but is null");
        }
        this.vmPrioritizationUtils = vMPrioritizationUtils;
    }
}

