/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.nutanix;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixDetails;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixService;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NutanixUtils {
    private static Logger logger = LogManager.getLogger(NutanixUtils.class);
    private static final String splitDelimiter = "\\|";
    private static final String appendDelimiter = "|";
    private static final int DEFAULT_PORT = 22;
    @NonNull
    private VirtualConfigurationManager virtualConfigurationManager;
    @NonNull
    private AdvancedSetupHelper advancedSetupHelper;
    @NonNull
    private AuthHelper authHelper;
    @NonNull
    private VirtualisationStatusStore virtualisationStatusStore;

    public NutanixUtils() {
    }

    public NutanixUtils(@NonNull VirtualConfigurationManager virtualConfigurationManager, @NonNull AdvancedSetupHelper advancedSetupHelper, @NonNull AuthHelper authHelper) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("configManager is marked non-null but is null");
        }
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
        this.advancedSetupHelper = advancedSetupHelper;
        this.authHelper = authHelper;
    }

    protected ServiceManager getServiceManager() {
        return ServiceManager.getInstance();
    }

    public String getClusterName(String string, String string2) {
        logger.debug("getClusterName() - start");
        String string3 = string2;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            string3 = string;
        } else {
            try {
                ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
                if (configurationManager.containsKey("NutanixClusterDetails", "Cluster_Ip")) {
                    logger.debug("getClusterName() - key found");
                    string3 = configurationManager.getString("NutanixClusterDetails", "Cluster_Ip");
                }
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        logger.debug("getClusterName() - end, result: {}", (Object)string3);
        return string3;
    }

    public String getClusterIp() {
        String string = "";
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        if (configurationManager.containsKey("NutanixClusterDetails", "Cluster_Ip")) {
            logger.debug("getClusterIp() - key found");
            string = configurationManager.getString("NutanixClusterDetails", "Cluster_Ip", string);
        }
        logger.debug("getClusterIp() - end, result: {}", (Object)string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PrioritizedVM> getPrioritizationVMs(String string) {
        logger.debug("getPrioritizationVMs() - start, cluster: {}", (Object)string);
        ArrayList<PrioritizedVM> arrayList = new ArrayList<PrioritizedVM>();
        NutanixConnection nutanixConnection = null;
        try {
            nutanixConnection = NutanixService.getInstance().getClusterConnection();
            nutanixConnection.connect();
            String string2 = this.getClusterName(nutanixConnection.getClusterName(), string);
            Map<String, String> map = nutanixConnection.getAllUvms();
            for (String string3 : map.keySet()) {
                PrioritizedVM prioritizedVM = new PrioritizedVM();
                prioritizedVM.setUUID(string3);
                prioritizedVM.setVMName(map.get(string3));
                prioritizedVM.setDataCenter(string2);
                arrayList.add(prioritizedVM);
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.error("getPrioritizationVMs() - IllegalArgumentException | IOException: {}", (Object)exception.getMessage());
            arrayList = null;
        }
        finally {
            if (nutanixConnection != null) {
                try {
                    nutanixConnection.disconnect();
                }
                catch (RemoteException remoteException) {
                    logger.error("getPrioritizationVMs() - RemoteException: {}", (Object)remoteException.getMessage());
                }
            }
        }
        logger.debug("getPrioritizationVMs() - end, result: {}", arrayList);
        return arrayList;
    }

    public NutanixDetails loadNutanixDetails() {
        logger.debug("loadNutanixDetails() - start");
        NutanixDetails nutanixDetails = new NutanixDetails();
        String string = "";
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        try {
            if (configurationManager.containsKey("NutanixClusterDetails", "Cluster_Ip")) {
                string = configurationManager.getString("NutanixClusterDetails", "Cluster_Ip");
                nutanixDetails.setClusterIp(string);
            }
            string = "";
            if (configurationManager.containsKey("NutanixClusterDetails", "SSH_Key_Path")) {
                UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
                string = configurationManager.getString("NutanixClusterDetails", "SSH_Key_Path");
                if (userFilePathValidator.isValid(string)) {
                    nutanixDetails.setSshKeyPath(string);
                } else {
                    logger.warn("loadNutanixDetails() - The ssh key path specified in the INI is invalid.");
                }
            }
            string = "";
            if (configurationManager.containsKey("NutanixClusterDetails", "Nutanix_Cluster_Username")) {
                string = configurationManager.getString("NutanixClusterDetails", "Nutanix_Cluster_Username");
                nutanixDetails.setClusterUsername(string);
            }
            string = "";
            if (configurationManager.containsKey("NutanixClusterDetails", "AHV_Username")) {
                string = configurationManager.getString("NutanixClusterDetails", "AHV_Username");
                nutanixDetails.setHostUsername(string);
            }
            nutanixDetails.setClusterPassword(this.authHelper.getNutanixClusterPassword());
            nutanixDetails.setHostPassword(this.authHelper.getNutanixHostPassword());
            nutanixDetails.setSshKeyPassphrase(this.authHelper.getNutanixSshKeyPassphrase());
        }
        catch (ConversionException conversionException) {
            logger.error("loadNutanixDetails() - ConversionException: {}", (Object)conversionException.getMessage());
        }
        return nutanixDetails;
    }

    public void saveNutanixDetails(NutanixDetails nutanixDetails) {
        logger.debug("saveNutanixDetails() - start");
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        String string = "NutanixClusterDetails";
        if (nutanixDetails != null) {
            configurationManager.setProperty(string, "Cluster_Ip", nutanixDetails.getClusterIp());
            if (!StringUtils.isBlank((CharSequence)nutanixDetails.getSshKeyPath()) && StringUtils.isBlank((CharSequence)nutanixDetails.getClusterPassword())) {
                configurationManager.setProperty(string, "SSH_Key_Path", nutanixDetails.getSshKeyPath());
            } else if (configurationManager.containsKey(string, "SSH_Key_Path")) {
                configurationManager.clearProperty(string, "SSH_Key_Path");
            }
            if (!configurationManager.containsKey(string, "Nutanix_Cluster_Username")) {
                configurationManager.setProperty(string, "Nutanix_Cluster_Username", "nutanix");
            }
            if (!configurationManager.containsKey(string, "AHV_Username")) {
                configurationManager.setProperty(string, "AHV_Username", "root");
            }
            this.authHelper.setNutanixAuthDetails(nutanixDetails.getClusterPassword(), nutanixDetails.getHostPassword(), nutanixDetails.getSshKeyPassphrase());
        }
        logger.debug("saveNutanixDetails() - end");
    }

    public String getSshKeyPath() {
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        String string = "";
        if (configurationManager.containsKey("NutanixClusterDetails", "SSH_Key_Path")) {
            logger.debug("getSshKeyPath() - found key");
            try {
                string = configurationManager.getString("NutanixClusterDetails", "SSH_Key_Path");
                UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
                if (!userFilePathValidator.isValid(string)) {
                    logger.warn("getSshKeyPath() - The ssh key path specified by {}.{} is invalid.", (Object)"NutanixClusterDetails", (Object)"SSH_Key_Path");
                    string = "";
                }
            }
            catch (ConversionException conversionException) {
                logger.error("getSshKeyPath() - ConversionException: {}", (Throwable)conversionException);
            }
        }
        logger.debug("getSshKeyPath() - end, result: {}", (Object)string);
        return string;
    }

    public void saveClusterDetailsToConfig() {
        logger.debug("saveClusterDetailsToConfig() - start");
        NutanixConnection nutanixConnection = null;
        List<String> list = null;
        List<String> list2 = null;
        List<String> list3 = null;
        String string = "NutanixClusterDetails";
        try {
            nutanixConnection = NutanixService.getInstance().getClusterConnection();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.debug("saveClusterDetailsToConfig() - illegal argument for the Nutanix cluster credentials: {}", (Object)illegalArgumentException.getMessage());
        }
        catch (IOException iOException) {
            logger.debug("saveClusterDetailsToConfig() - unable to load SSH key: {}", (Object)iOException.getMessage());
        }
        if (nutanixConnection != null) {
            try {
                nutanixConnection.connect();
                list = this.getAfsVmsFromCluster(nutanixConnection);
                list2 = this.getCvmIpsFromCluster(nutanixConnection);
                list3 = this.getCvmNamesFromCluster(nutanixConnection);
                nutanixConnection.disconnect();
            }
            catch (RemoteException remoteException) {
                logger.debug("saveClusterDetailsToConfig() - failed to save Nutanix Cluster details to the INI: {}", (Object)remoteException.getMessage());
            }
        }
        if (list != null && !list.isEmpty()) {
            this.saveListAsStringToConfig(list, string, "AFS_VMs");
        }
        if (list2 != null && !list2.isEmpty()) {
            this.saveListAsStringToConfig(list2, string, "CVM_IPs");
        }
        if (list3 != null && !list3.isEmpty()) {
            this.saveListAsStringToConfig(list3, string, "CVM_Names");
        }
        logger.debug("saveClusterDetailsToConfig() - end");
    }

    private List<String> getCvmNamesFromCluster(NutanixConnection nutanixConnection) {
        logger.debug("getCvmNamesFromCluster() - start");
        List<String> list = null;
        if (nutanixConnection != null) {
            try {
                list = nutanixConnection.getCvmNames();
            }
            catch (RemoteException remoteException) {
                logger.debug("getCvmNamesFromCluster() - failed to retrieve CVM name list from the cluster: {}", (Object)remoteException.getMessage());
            }
        }
        return list;
    }

    private List<String> getAfsVmsFromCluster(NutanixConnection nutanixConnection) {
        logger.debug("getAfsVmsFromCluster() - start");
        List<String> list = null;
        if (nutanixConnection != null) {
            try {
                list = nutanixConnection.getAfsVmNames();
            }
            catch (RemoteException remoteException) {
                logger.debug("getAfsVmsFromCluster() - failed to retrieve AFS VM name list from the cluster: {}", (Object)remoteException.getMessage());
            }
        }
        return list;
    }

    private List<String> getCvmIpsFromCluster(NutanixConnection nutanixConnection) {
        logger.debug("getCvmIpsFromCluster() - start");
        List<String> list = null;
        if (nutanixConnection != null) {
            try {
                list = nutanixConnection.getCvmIps();
            }
            catch (RemoteException remoteException) {
                logger.debug("getCvmIpsFromCluster() - failed to retrieve CVM IP list from the cluster: {}", (Object)remoteException.getMessage());
            }
        }
        return list;
    }

    private void saveListAsStringToConfig(List<String> list, String string, String string2) {
        logger.debug("saveListAsStringToConfig() - start, key: {}, list: {}", (Object)string2, list);
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        if (list != null && !list.isEmpty()) {
            String string3 = list.stream().collect(Collectors.joining(appendDelimiter));
            configurationManager.setProperty(string, string2, string3.toString());
        } else {
            configurationManager.clearProperty(string, string2);
        }
    }

    public List<String> getCvmNamesFromConfig() {
        logger.debug("getCvmNamesFromConfig() - start");
        ArrayList<String> arrayList = new ArrayList();
        arrayList = this.getStringAsListFromConfig("NutanixClusterDetails", "CVM_Names");
        return arrayList;
    }

    public List<String> getNutanixHostIpsFromConfig(boolean bl) {
        logger.debug("getNutanixHostIpsFromConfig() - start");
        List<Object> list = new ArrayList();
        list = bl ? new ArrayList<String>(this.advancedSetupHelper.readMappedHostsFromConfig().keySet()) : this.virtualConfigurationManager.parseHostListParameter("HostConfigSettings");
        return list;
    }

    public List<String> getAfsVmsFromConfig() {
        logger.debug("getAfsVmsFromConfig() - start");
        ArrayList<String> arrayList = new ArrayList();
        arrayList = this.getStringAsListFromConfig("NutanixClusterDetails", "AFS_VMs");
        return arrayList;
    }

    public List<String> getCvmIPsFromConfig() {
        logger.debug("getCvmIPsFromConfig() - start");
        ArrayList<String> arrayList = new ArrayList();
        arrayList = this.getStringAsListFromConfig("NutanixClusterDetails", "CVM_IPs");
        return arrayList;
    }

    private List<String> getStringAsListFromConfig(String string, String string2) {
        logger.debug("getStringAsListFromConfig() - start");
        ArrayList<String> arrayList = new ArrayList();
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        String string3 = "";
        if (configurationManager.containsKey(string, string2)) {
            logger.debug("getStringAsListFromConfig() - found key: {}", (Object)string2);
            try {
                string3 = configurationManager.getString(string, string2);
            }
            catch (ConversionException conversionException) {
                logger.debug("getStringAsListFromConfig() - ConversionException with key: {} from config: ", (Object)string2, (Object)conversionException);
            }
        }
        if (!StringUtils.isBlank((CharSequence)string3)) {
            arrayList = Arrays.asList(string3.split(splitDelimiter));
        }
        logger.debug("getStringAsListFromConfig() - end, result: {}", arrayList);
        return arrayList;
    }

    public boolean isAhvHostShutdownDisabled() {
        return this.virtualConfigurationManager.getBooleanGlobal("ahv_shutdown_disable");
    }

    public Map<String, String> filterOutAfsVms(Map<String, String> map) {
        List<String> list = this.getAfsVmsFromConfig();
        logger.debug("filterOutAfsVms() - AFS VM names to filter: {}", list);
        return map.entrySet().stream().filter(entry -> {
            String string = (String)entry.getValue();
            return !list.contains(string);
        }).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
    }

    public Map<String, String> matchUvmsWithUuids(Map<String, String> map, List<String> list) {
        logger.debug("matchUvmsWithUuids() - start, UUIDS: {}", list);
        return map.entrySet().stream().filter(entry -> {
            logger.debug("matchUvmsWithUuids() - matching UUID {}", entry.getKey());
            return list.contains(entry.getKey());
        }).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
    }

    private Stream<VirtualMachine> getVmsFilter(List<VirtualMachine> list, List<String> list2) {
        logger.debug("getVmsFilter() - start");
        return list.stream().filter(virtualMachine -> !list2.contains(virtualMachine.getName()));
    }

    public List<VirtualMachine> filterOutAfsVms(List<VirtualMachine> list) {
        List<String> list2 = this.getAfsVmsFromConfig();
        logger.debug("filterOutAfsVms() - filtering AFS VMs: {} from VM list", list2);
        list = this.getVmsFilter(list, list2).collect(Collectors.toList());
        return list;
    }

    public List<VirtualMachine> filterOutCvmVms(List<VirtualMachine> list) {
        List<String> list2 = this.getCvmNamesFromConfig();
        logger.debug("filterOutCvmVms() - filtering CVMs: {} from VM list", list2);
        list = this.getVmsFilter(list, list2).collect(Collectors.toList());
        return list;
    }

    public List<VirtualMachine> filterOutNutanixSpecialVms(List<VirtualMachine> list) {
        List<String> list2 = Stream.concat(this.getCvmNamesFromConfig().stream(), this.getAfsVmsFromConfig().stream()).collect(Collectors.toList());
        logger.debug("filterOutNutanixSpecialVms() - filtering VMs: {} from VM list", list2);
        list = this.getVmsFilter(list, list2).collect(Collectors.toList());
        return list;
    }

    public List<PrioritizedVM> filterOutNutanixSpecialFromPrioritizedVMs(List<PrioritizedVM> list) {
        List<String> list2 = Stream.concat(this.getCvmNamesFromConfig().stream(), this.getAfsVmsFromConfig().stream()).collect(Collectors.toList());
        logger.debug("filterOutNutanixSpecialFromPrioritizedVMs() - filtering VMs: {} from VM list", list2);
        list = this.getVmListFilter(list, list2).collect(Collectors.toList());
        return list;
    }

    private Stream<PrioritizedVM> getVmListFilter(List<PrioritizedVM> list, List<String> list2) {
        logger.debug("getVmListFilter() - start");
        return list.stream().filter(prioritizedVM -> !list2.contains(prioritizedVM.getVMName()));
    }

    public int getPort() {
        return 22;
    }

    protected String getNutanixTroubleshootingLink() {
        Integer n = this.virtualConfigurationManager.isNutanixAHV() ? ApcHelp.NUTANIX_TROUBLESHOOTING : (this.virtualConfigurationManager.isNutanixESXi() ? ApcHelp.VMWARE_TROUBLESHOOTING : ApcHelp.INTRODUCTION1);
        return ApcHelp.getOnClick(n);
    }

    public void logCvmStartupInProgressEvent(String string) {
        String string2;
        logger.debug("logCvmStartupInProgressEvent() - start, host: {}", (Object)string);
        try {
            string2 = new VirtualizationFeaturesFormatter((Integer)171, string).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "CvmStartupInProgress";
            logger.error("logCvmStartupInProgressEvent() - error logging event", throwable);
        }
        ServiceManager.getInstance().getApplicationErrorHandler().put(string2);
    }

    public void logCvmStartupWaitEvent(String string) {
        String string2;
        logger.debug("logCvmStartupWaitEvent() - start, host: {}", (Object)string);
        try {
            string2 = new VirtualizationFeaturesFormatter((Integer)174, string).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "CvmStartupWait";
            logger.error("logCvmStartupWaitEvent() - error logging event", throwable);
        }
        ServiceManager.getInstance().getApplicationErrorHandler().put(string2);
    }

    public void logPDReplForceAbortEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logPDReplForceAbortEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)156, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "PDReplForceAbortEvent";
            logger.error("logPDReplForceAbortEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logPDReplAbortSomeFailedEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logPDReplAbortSomeFailedEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)139, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "PDReplAbortSomeFailedEvent";
            logger.error("logPDReplAbortSomeFailedEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logPDMetroDisableFailedEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logPDMetroDisableFailedEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)161, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "PDReplAbortSomeFailedEvent";
            logger.error("logPDMetroDisableFailedEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logPDMetroEnableFailedEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logPDMetroEnableFailedEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)163, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "PDReplAbortSomeFailedEvent";
            logger.error("logPDMetroEnableFailedEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logClusterStartFailedEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logClusterStartFailedEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)168, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "ClusterStartFailedEvent";
            logger.error("logClusterStartFailedEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logClusterStartTimeoutEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logClusterStartTimeoutEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)136, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "ClusterStartFailedEvent";
            logger.error("logClusterStartTimeoutEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logAFSStopTimeoutEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logAFSStopTimeoutEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)137, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "AFSStopTimeoutEvent";
            logger.error("logAFSStopTimeoutEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logAFSCommandFailedEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logAFSCommandFailedEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)138, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "AFSCommandFailedEvent";
            logger.error("logAFSCommandFailedEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logAFSForceStopFailedEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logAFSForceStopFailedEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)152, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "AFSForceStopFailedEvent";
            logger.error("logAFSForceStopFailedEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logCVMAuthFailEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logCVMAuthFailEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)131, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "CVMAuthFailEvent";
            logger.error("logCVMAuthFailEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logCVMConnFailEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logCVMConnFailEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)132, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "CVMConnFailEvent";
            logger.error("logCVMConnFailEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logClusterStillRunningEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logClusterStillRunningEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)130, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "ClusterStillRunningEvent";
            logger.error("logClusterStillRunningEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logClusterStopFailedEvent() {
        String string;
        String string2 = this.getNutanixTroubleshootingLink();
        logger.debug("logClusterStopFailedEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter((Integer)166, string2).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "ClusterStopFailedEvent";
            logger.error("logClusterStopFailedEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string);
    }

    public void logClusterStopOpsFailEvent(String string) {
        String string2;
        String string3 = this.getNutanixTroubleshootingLink();
        logger.debug("logClusterStopOpsFailEvent() - start, host: {}", (Object)string);
        try {
            string2 = new VirtualizationFeaturesFormatter((Integer)175, string3).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "ClusterStopOpsFail";
            logger.error("logClusterStopOpsFailEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string2);
    }

    public void logClusterAuthFailEvent(String string) {
        String string2;
        String string3 = this.getNutanixTroubleshootingLink();
        logger.debug("logClusterAuthFailEvent() - start, host: {}", (Object)string);
        try {
            string2 = new VirtualizationFeaturesFormatter((Integer)133, string3).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "ClusterAuthenticationFailed";
            logger.error("logClusterAuthFailEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string2);
    }

    public void logClusterConnectionFailEvent(String string) {
        String string2;
        String string3 = this.getNutanixTroubleshootingLink();
        logger.debug("logClusterConnectionFailEvent() - start, host: {}", (Object)string);
        try {
            string2 = new VirtualizationFeaturesFormatter((Integer)134, string3).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "ClusterConnectionFailed";
            logger.error("logClusterConnectionFailEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string2);
    }

    public void logClusterNotUpFailEvent(String string) {
        String string2;
        String string3 = this.getNutanixTroubleshootingLink();
        logger.debug("logClusterNotUpFailEvent() - start, host: {}", (Object)string);
        try {
            string2 = new VirtualizationFeaturesFormatter((Integer)135, string3).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "ClusterNotUp";
            logger.error("logClusterNotUpFailEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string2);
    }

    public void logClusterAlreadyUpEvent(String string) {
        String string2;
        logger.debug("logClusterAlreadyUpEvent() - start, host: {}", (Object)string);
        try {
            string2 = new VirtualizationFeaturesFormatter((Integer)177, string).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string2 = "ClusterAlreadyUp";
            logger.error("logClusterAlreadyUpEvent() - error logging event", throwable);
        }
        this.getServiceManager().getApplicationErrorHandler().put(string2);
    }

    public void logUvmShutdownFailEvent() {
        String string;
        logger.debug("logUvmShutdownFailEvent() - start");
        try {
            string = new VirtualizationFeaturesFormatter(176).format(null);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            string = "UvmShutdownFail";
            logger.error("logUvmShutdownFailEvent() - error logging event", throwable);
        }
        ServiceManager.getInstance().getApplicationErrorHandler().put(string);
    }

    public int getDuration(boolean bl, int n, String string) {
        if (bl) {
            return this.virtualConfigurationManager.getDurationAdvanced(n, string);
        }
        return this.virtualConfigurationManager.getDurationGlobal(string);
    }

    public int getCvmStartupDuration(boolean bl, int n) {
        return this.getDuration(bl, n, "cvm_startup_duration");
    }

    public boolean getBoolean(boolean bl, int n, String string) {
        if (bl) {
            return this.virtualConfigurationManager.getBooleanAdvanced(n, string);
        }
        return this.virtualConfigurationManager.getBooleanGlobal(string);
    }

    public boolean isUvmStartupEnabled(boolean bl, int n) {
        return this.getBoolean(bl, n, "uvm_startup_enable");
    }

    public boolean isCvmStartupEnabled(boolean bl, int n) {
        return this.getBoolean(bl, n, "cvm_startup_enable");
    }

    public boolean isAllHostsUp(Collection<String> collection) {
        int n = this.getPort();
        int n2 = 1;
        Predicate<String> predicate = string -> this.virtualConfigurationManager.isHostAvailable((String)string, n, n2, TimeUnit.SECONDS);
        return collection.stream().allMatch(predicate);
    }

    public boolean isHostUp(String string) {
        int n = this.getPort();
        int n2 = 1;
        return this.virtualConfigurationManager.isHostAvailable(string, n, n2, TimeUnit.SECONDS);
    }

    public void addDefaultNutanixUsernamesToConfig() {
        logger.debug("addDefaultNutanixUsernamesToConfig() - start");
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        String string = "NutanixClusterDetails";
        if (!configurationManager.containsKey(string, "Nutanix_Cluster_Username")) {
            configurationManager.setProperty(string, "Nutanix_Cluster_Username", "nutanix");
        }
        if (!configurationManager.containsKey(string, "AHV_Username")) {
            configurationManager.setProperty(string, "AHV_Username", "root");
        }
    }

    public String getClusterUsernameFromConfig() {
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        return configurationManager.getString("NutanixClusterDetails", "Nutanix_Cluster_Username", "nutanix");
    }

    public String getHostUsernameFromConfig() {
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        return configurationManager.getString("NutanixClusterDetails", "AHV_Username", "root");
    }

    public boolean isClusterLocked(boolean bl) {
        logger.debug("isClusterLocked() - start");
        List<String> list = this.getNutanixHostIpsFromConfig(bl);
        Optional<String> optional = list.stream().filter(string -> this.virtualisationStatusStore.isHostLockedForShutdown((String)string)).findFirst();
        if (optional.isPresent()) {
            logger.debug("isClusterLocked() - host: {} locked for shutdown", (Object)optional.get());
            return true;
        }
        return false;
    }

    public boolean hasClusterActiveCriticalEvent(boolean bl, ShutdownState shutdownState) {
        logger.debug("hasClusterActiveCriticalEvent() - start");
        List<String> list = this.getNutanixHostIpsFromConfig(bl);
        list.add(this.getClusterIp());
        Optional<String> optional = list.stream().filter(string -> shutdownState.checkIfCriticalEventActive((String)string)).findFirst();
        if (optional.isPresent()) {
            logger.debug("hasClusterActiveCriticalEvent() - critical event active for host: {}", (Object)optional.get());
            return true;
        }
        return false;
    }

    @Generated
    public void setVirtualConfigurationManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
    }

    @Generated
    public void setAdvancedSetupHelper(@NonNull AdvancedSetupHelper advancedSetupHelper) {
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        this.advancedSetupHelper = advancedSetupHelper;
    }

    @Generated
    public void setAuthHelper(@NonNull AuthHelper authHelper) {
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        this.authHelper = authHelper;
    }

    @Generated
    public void setVirtualisationStatusStore(@NonNull VirtualisationStatusStore virtualisationStatusStore) {
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtualisationStatusStore is marked non-null but is null");
        }
        this.virtualisationStatusStore = virtualisationStatusStore;
    }
}

