/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.simplivity;

import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.VirtualizationLoggingUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VirtualMachineUtils;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerOnOvcCallable
implements Callable<Boolean> {
    private static final Logger logger = LogManager.getLogger(PowerOnOvcCallable.class);
    private String host;
    private VirtualMachine vm;
    private VirtualizationLoggingUtils virtualizationLoggingUtils;
    private HostSystemUtils hostSystemUtils;
    private VirtualMachineUtils vmUtils;
    private VirtualisationStatusStore virtualisationStatusStore;
    private VMWareConnection vmwareConnection;

    public PowerOnOvcCallable(@NonNull VirtualMachineUtils virtualMachineUtils, @NonNull HostSystemUtils hostSystemUtils, @NonNull VirtualizationLoggingUtils virtualizationLoggingUtils, @NonNull String string, @NonNull VirtualMachine virtualMachine, @NonNull VirtualisationStatusStore virtualisationStatusStore, @NonNull VMWareConnection vMWareConnection) {
        if (virtualMachineUtils == null) {
            throw new IllegalArgumentException("vmUtils is marked non-null but is null");
        }
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("virtualizationLoggingUtils is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        if (virtualMachine == null) {
            throw new IllegalArgumentException("vm is marked non-null but is null");
        }
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtStore is marked non-null but is null");
        }
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("A blank host won't get you anywhere!");
        }
        this.virtualizationLoggingUtils = virtualizationLoggingUtils;
        this.host = string;
        this.vm = virtualMachine;
        this.hostSystemUtils = hostSystemUtils;
        this.vmUtils = virtualMachineUtils;
        this.virtualisationStatusStore = virtualisationStatusStore;
        this.vmwareConnection = vMWareConnection;
    }

    @Override
    public Boolean call() throws Exception {
        logger.debug("call() - Starting VM: {}", (Object)this.vm.getName());
        boolean bl = true;
        try {
            String string;
            if (this.virtualisationStatusStore.isHostLockedForShutdown(this.host)) {
                logger.debug("Host: {} is locked for shutdown.  OVC startup is not appropriate.", (Object)this.host);
                return false;
            }
            ServiceInstance serviceInstance = this.vmwareConnection.getESXiHostInstance(this.hostSystemUtils.getESXIConnStr(null, this.host));
            if (serviceInstance == null) {
                logger.warn("Failed to contact remote host.  Can't proceed with OVC startup.");
                return false;
            }
            HostSystem hostSystem = this.hostSystemUtils.getHostOfVirtualMachine(this.vm, serviceInstance);
            if (!this.hostSystemUtils.isHostHealthy(hostSystem, this.host, true)) {
                logger.debug("Host: {} is not healthy.  OVC startup is not appropriate.", (Object)this.host);
                return false;
            }
            if (this.vmUtils.isPoweredOff(this.vm)) {
                this.virtualizationLoggingUtils.logSimplivityOVCStartupEvent(this.vm.getName());
                logger.debug("VM is powered off.  Requesting power on for {}.", (Object)this.vm.getName());
                Task task = this.vm.powerOnVM_Task(hostSystem);
                string = task.waitForTask();
                logger.debug("VM power on result: {}", (Object)string);
            } else {
                string = "success";
            }
            if ("success".equals(string)) {
                logger.debug("Removing {} from virtualisation status store.", (Object)this.vm.getName());
                this.virtualisationStatusStore.removeVM(this.host, this.vm.getName());
            } else {
                logger.debug("Power on request failed for {}.", (Object)this.vm.getName());
                this.virtualizationLoggingUtils.logSimplivityOVCStartupFailed(this.vm.getName());
                bl = false;
            }
        }
        catch (RemoteException remoteException) {
            logger.debug("Power on OVC: {}, was not successful: {}", (Object)this.vm.getName(), (Object)remoteException);
            this.virtualizationLoggingUtils.logSimplivityOVCStartupFailed(this.vm.getName());
            bl = false;
        }
        return bl;
    }
}

