/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.simplivity;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.Host;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.servlets.ConnectionStatus;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.VirtualizationLoggingUtils;
import com.apcc.m11.components.webserver.util.virtualization.simplivity.OvcStartupResults;
import com.apcc.m11.components.webserver.util.virtualization.simplivity.PowerOnOvcCallable;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VirtualMachineUtils;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.serviceaware.InitializationAdapter;
import com.apcc.pcns.simplivity.OvcShutdownQueueConsumer;
import com.apcc.pcns.simplivity.SimplivityConnection;
import com.apcc.pcns.simplivity.SimplivityConnectionManager;
import com.apcc.pcns.simplivity.SimplivityDetails;
import com.apcc.pcns.threadpool.ThreadService;
import com.apcc.pcns.util.CountdownTimer;
import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimplivityUtils
extends InitializationAdapter {
    private static final int POLL_DELAY = 5;
    private static final int PORT_CHECK_TIMEOUT = 1;
    private static final int INTERACTIVE_SHELL_TIMEOUT = 5;
    private static final int SSH_PORT = 22;
    public static final String JSON_STATUS = "status";
    public static final String OMNI_STACK_VC_FILTER = "OmniStackVC-";
    private static Logger logger = LogManager.getLogger(SimplivityUtils.class);
    @NonNull
    private SimplivityConnectionManager simplivityConnectionManager;
    @NonNull
    private VirtualConfigurationManager virtualConfigurationManager;
    @NonNull
    private AdvancedSetupHelper advancedSetupHelper;
    @NonNull
    private VirtualMachineUtils virtualMachineUtils;
    @NonNull
    private HostSystemUtils hostSystemUtils;
    @NonNull
    private ConfigurationManager config;
    @NonNull
    private AuthHelper authHelper;
    @NonNull
    private VirtualizationLoggingUtils virtualizationLoggingUtils;
    @NonNull
    private VirtualisationStatusStore virtualisationStatusStore;
    @NonNull
    private VMWareConnection vmwareConnection;
    @NonNull
    private ThreadService threadService;
    private BlockingQueue<SimplivityDetails> shutdownQueue = new LinkedBlockingQueue<SimplivityDetails>();
    private Runnable queueConsumer;
    private boolean firstStartupIteration = true;

    public SimplivityUtils() {
    }

    public SimplivityUtils(@NonNull VirtualConfigurationManager virtualConfigurationManager, @NonNull AdvancedSetupHelper advancedSetupHelper, @NonNull ConfigurationManager configurationManager, @NonNull AuthHelper authHelper, @NonNull VirtualMachineUtils virtualMachineUtils, @NonNull VirtualisationStatusStore virtualisationStatusStore) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("configManager is marked non-null but is null");
        }
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        if (virtualMachineUtils == null) {
            throw new IllegalArgumentException("vmUtils is marked non-null but is null");
        }
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtualisationStatusStore is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
        this.advancedSetupHelper = advancedSetupHelper;
        this.config = configurationManager;
        this.authHelper = authHelper;
        this.virtualMachineUtils = virtualMachineUtils;
        this.virtualisationStatusStore = virtualisationStatusStore;
    }

    @Override
    public void start() {
        logger.debug("start() - Start processing.");
        this.startQueueConsumer();
    }

    private void startQueueConsumer() {
        if (this.queueConsumer == null) {
            logger.debug("startQueueConsumer() - Start OVC Shutdown Queue Processor");
            this.queueConsumer = new OvcShutdownQueueConsumer(this, this.shutdownQueue);
            this.threadService.scheduleWithFixedDelay(this.queueConsumer, 0, 1, TimeUnit.SECONDS);
        }
    }

    public String getSimplivityUser() {
        return this.config.getString("SimplivityClusterDetails", "ovc_username");
    }

    public void setSimplivityUser(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("user is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Blank user names are not accepted.");
        }
        this.config.setProperty("SimplivityClusterDetails", "ovc_username", string);
    }

    public String getSimplivityPassword() {
        return this.authHelper.getSimplivityPassword();
    }

    public void setSimplivityPassword(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("pass is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Blank passwords are not accepted.");
        }
        this.authHelper.setSimplivityPassword(string);
    }

    public List<SimplivityDetails> loadSimplivityDetails() {
        ArrayList<SimplivityDetails> arrayList = new ArrayList<SimplivityDetails>();
        String string2 = this.config.getString("SimplivityClusterDetails", "ovc_username");
        String string3 = this.authHelper.getSimplivityPassword();
        Set<String> set = this.config.getSectionKeys("SimplivityClusterDetails");
        logger.debug("loadSimplivityDetails() - Section Keys: {}", set);
        Set set2 = set.stream().filter(string -> StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"ovc_name_")).collect(Collectors.toSet());
        logger.debug("loadSimplivityDetails() - Name Keys: {}", set2);
        for (String string4 : set2) {
            String string5;
            SimplivityDetails simplivityDetails = new SimplivityDetails();
            simplivityDetails.setOvcUser(string2);
            simplivityDetails.setOvcPassword(string3);
            Integer n = Integer.valueOf(StringUtils.difference((String)"ovc_name_", (String)string4));
            if (this.config.containsKey("SimplivityClusterDetails", ConfigurationKeys.getOvcNameKey(n))) {
                string5 = this.config.getString("SimplivityClusterDetails", ConfigurationKeys.getOvcNameKey(n));
                logger.debug("loadSimplivityDetails() - Found OVC Name {}: {}", (Object)n, (Object)string5);
                simplivityDetails.setOvcName(string5);
            }
            if (this.config.containsKey("SimplivityClusterDetails", ConfigurationKeys.getOvcIPKey(n))) {
                string5 = this.config.getString("SimplivityClusterDetails", ConfigurationKeys.getOvcIPKey(n));
                logger.debug("loadSimplivityDetails() - Found OVC IP {}: {}", (Object)n, (Object)string5);
                simplivityDetails.setOvcIP(string5);
            }
            if (this.config.containsKey("SimplivityClusterDetails", ConfigurationKeys.getOvcHostKey(n))) {
                string5 = this.config.getString("SimplivityClusterDetails", ConfigurationKeys.getOvcHostKey(n));
                logger.debug("loadSimplivityDetails() - Found OVC Host {}: {}", (Object)n, (Object)string5);
                simplivityDetails.setHost(string5);
            }
            arrayList.add(simplivityDetails);
        }
        return arrayList;
    }

    public void clearSimplivityDetails() {
        Set<String> set = this.config.getSectionKeys("SimplivityClusterDetails");
        Set set2 = set.stream().filter(string -> StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"ovc_name_")).collect(Collectors.toSet());
        for (String string2 : set2) {
            Integer n = Integer.valueOf(StringUtils.difference((String)"ovc_name_", (String)string2));
            this.config.clearProperty("SimplivityClusterDetails", ConfigurationKeys.getOvcNameKey(n));
            this.config.clearProperty("SimplivityClusterDetails", ConfigurationKeys.getOvcIPKey(n));
            this.config.clearProperty("SimplivityClusterDetails", ConfigurationKeys.getOvcHostKey(n));
        }
    }

    public void saveSimplivityDetails(@NonNull List<SimplivityDetails> list) {
        if (list == null) {
            throw new IllegalArgumentException("details is marked non-null but is null");
        }
        if (list.isEmpty()) {
            return;
        }
        this.clearSimplivityDetails();
        this.saveSimplivityCredentials(list.get(0));
        this.config.setProperty("SimplivityClusterDetails", "ovc_force_shutdown_delay", list.get(0).getOvcShutdownDelay());
        this.saveSimplivityHostDetails(list);
    }

    public void saveSimplivityHostDetails(List<SimplivityDetails> list) {
        if (list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            logger.debug("saveSimplivityDetails() - saving {}", (Object)list.get(i).getOvcName());
            this.config.setProperty("SimplivityClusterDetails", ConfigurationKeys.getOvcNameKey(i), list.get(i).getOvcName());
            this.config.setProperty("SimplivityClusterDetails", ConfigurationKeys.getOvcIPKey(i), list.get(i).getOvcIP());
            this.config.setProperty("SimplivityClusterDetails", ConfigurationKeys.getOvcHostKey(i), list.get(i).getHost());
        }
    }

    public void saveSimplivityCredentials(@NonNull SimplivityDetails simplivityDetails) {
        if (simplivityDetails == null) {
            throw new IllegalArgumentException("ovc is marked non-null but is null");
        }
        this.config.setProperty("SimplivityClusterDetails", "ovc_username", simplivityDetails.getOvcUser());
        this.authHelper.setSimplivityPassword(simplivityDetails.getOvcPassword());
    }

    private JsonObject getOVCConnectionDetails(@NonNull String string, @NonNull VirtualMachine virtualMachine, @NonNull String string2, @NonNull String string3) {
        if (string == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        if (virtualMachine == null) {
            throw new IllegalArgumentException("ovc is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        logger.debug("getOVCConnectionDetails() - start: {}", (Object)virtualMachine.getName());
        JsonObject jsonObject = new JsonObject();
        HashMap<String, ConnectionStatus> hashMap = new HashMap<String, ConnectionStatus>();
        try {
            Set<String> set = this.virtualMachineUtils.getIPAddressesForVM(virtualMachine);
            boolean bl = false;
            for (String string4 : set) {
                JsonObject jsonObject2 = new JsonObject();
                SimplivityDetails simplivityDetails = new SimplivityDetails(string, string4, virtualMachine.getName(), string2, string3);
                ConnectionStatus connectionStatus = this.checkSimplivityClusterConnection(simplivityDetails);
                int n = connectionStatus.getStatus();
                hashMap.put(string4, connectionStatus);
                jsonObject.put((Object)JSON_STATUS, (Object)n);
                jsonObject2.put((Object)"ovcName", (Object)virtualMachine.getName());
                jsonObject2.put((Object)"ovcIP", (Object)string4);
                jsonObject2.put((Object)"ovcHost", (Object)string);
                if (ConnectionStatus.CONNECTION_SUCCESS == connectionStatus) {
                    logger.debug("Connection Success for OVC: {} on IP:{}", (Object)virtualMachine.getName(), (Object)string4);
                    bl = true;
                    jsonObject.put((Object)"ovc", (Object)jsonObject2);
                    break;
                }
                logger.debug("Connection failure for OVC: {} on IP: {}, reason: {}", (Object)virtualMachine.getName(), (Object)string4, (Object)n);
            }
            if (!bl) {
                if (hashMap.containsValue((Object)ConnectionStatus.INVALID_CREDENTIALS)) {
                    jsonObject.put((Object)JSON_STATUS, (Object)ConnectionStatus.INVALID_CREDENTIALS.getStatus());
                } else if (hashMap.containsValue((Object)ConnectionStatus.OVC_DOWN)) {
                    jsonObject.put((Object)JSON_STATUS, (Object)ConnectionStatus.OVC_DOWN.getStatus());
                } else {
                    jsonObject.put((Object)JSON_STATUS, (Object)ConnectionStatus.NETWORK_ERROR.getStatus());
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            jsonObject.put((Object)JSON_STATUS, (Object)ConnectionStatus.OVC_DOWN.getStatus());
        }
        logger.debug("getOVCConnectionDetails() - end: {}", (Object)jsonObject);
        return jsonObject;
    }

    public Set<VirtualMachine> getAllOvcs() {
        Set<String> set;
        logger.debug("getAllOvcs() - start");
        List<Host> list = this.hostSystemUtils.getConfiguredHosts();
        if (list != null) {
            logger.debug("getAllOvcs() - get hostnames from vcenter");
            set = list.stream().map(Host::getIPAddress).collect(Collectors.toSet());
        } else {
            logger.debug("getAllOvcs() - get hostnames from config");
            set = this.virtualConfigurationManager.getConfiguredHosts();
        }
        logger.debug("getAllOvcs() - getting OVCs from hosts{}", set);
        Set<Object> set2 = new HashSet();
        try {
            Set set3 = set.stream().map(string -> this.hostSystemUtils.getVirtualMachinesForHost((String)string)).flatMap(Collection::stream).collect(Collectors.toSet());
            set2 = set3.stream().filter(virtualMachine -> StringUtils.startsWithIgnoreCase((CharSequence)virtualMachine.getName(), (CharSequence)OMNI_STACK_VC_FILTER)).peek(virtualMachine -> logger.debug("got OVC {}", (Object)virtualMachine.getName())).collect(Collectors.toSet());
        }
        catch (Exception exception) {
            logger.error("getAllOvcs() - getting OVCs for hosts {} from VM list failed, trying by IP, error: {}", set, (Object)exception);
            set2 = this.getAllOvcsByIP(set);
        }
        logger.debug("getAllOvcs() - end");
        return set2;
    }

    private Set<VirtualMachine> getAllOvcsByIP(Set<String> set) {
        logger.debug("getAllOvcsByIP() - start");
        HashSet<VirtualMachine> hashSet = new HashSet<VirtualMachine>();
        List<SimplivityDetails> list = this.loadSimplivityDetails();
        list = list.stream().filter(simplivityDetails -> set.contains(simplivityDetails.getHost())).collect(Collectors.toList());
        list.forEach(simplivityDetails -> {
            logger.debug("getAllOvcsByIP() - retrieving VM for OVC {} on host {}", (Object)simplivityDetails.getOvcName(), (Object)simplivityDetails.getHost());
            ServiceInstance serviceInstance = this.vmwareConnection.getESXiHostInstance(simplivityDetails.getHost());
            if (serviceInstance == null) {
                logger.error("getAllOvcsByIP() - failed to retrieve host connection for host {}", (Object)simplivityDetails.getHost());
                return;
            }
            logger.debug("getAllOvcsByIP() - retrieving VM for OVC with IP {}", (Object)simplivityDetails.getOvcIP());
            VirtualMachine virtualMachine = this.hostSystemUtils.getVirtualMachineByIp(serviceInstance, simplivityDetails.getOvcIP());
            if (virtualMachine == null) {
                logger.error("getAllOvcsByIP() - failed to retrieve VM for OVC IP {}", (Object)simplivityDetails.getOvcIP());
                return;
            }
            hashSet.add(virtualMachine);
        });
        logger.debug("getAllOvcsByIP() - end");
        return hashSet;
    }

    public Map<String, VirtualMachine> getVirtualControllerVMs(Set<String> set) {
        HashMap<String, VirtualMachine> hashMap = new HashMap<String, VirtualMachine>();
        for (String string : set) {
            Set<VirtualMachine> set2 = this.hostSystemUtils.getVirtualMachinesForHost(string);
            Optional<VirtualMachine> optional = set2.stream().filter(virtualMachine -> StringUtils.startsWithIgnoreCase((CharSequence)virtualMachine.getName(), (CharSequence)OMNI_STACK_VC_FILTER)).findFirst();
            if (!optional.isPresent()) continue;
            VirtualMachine virtualMachine2 = optional.get();
            logger.debug("Found OVC: {} for Host: {}", (Object)virtualMachine2.getName(), (Object)string);
            hashMap.put(string, virtualMachine2);
        }
        return hashMap;
    }

    public Map<String, VirtualMachine> getPoweredOnVirtualControllerVMs(Set<String> set) {
        Map<String, VirtualMachine> map = this.getVirtualControllerVMs(set);
        logger.debug("getPoweredOnVirtualControllerVMs() - number of OVCs found: {}", (Object)map.size());
        Map<String, VirtualMachine> map2 = map.entrySet().stream().filter(entry -> this.virtualMachineUtils.isPoweredOn((VirtualMachine)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        logger.debug("getPoweredOnVirtualControllerVMs() - number of OVCs powered on: {}", (Object)map2.size());
        return map2;
    }

    public boolean getOvcStartupEnabled(int n) {
        logger.debug("getOvcStartupEnabled() - group {}", (Object)n);
        boolean bl = this.advancedSetupHelper.isAdvancedNonPhysical(n) ? this.virtualConfigurationManager.getBooleanAdvanced(n, "ovc_startup_enable") : this.config.getBoolean("HostConfigSettings", "ovc_startup_enable").booleanValue();
        logger.debug("getOvcStartupEnabled() - result: {}", (Object)bl);
        return bl;
    }

    public int getOvcStartupDuration(int n) {
        logger.debug("getOvcStartupDuration() - group {}", (Object)n);
        int n2 = this.advancedSetupHelper.isAdvancedNonPhysical(n) ? this.virtualConfigurationManager.getDurationAdvanced(n, "ovc_startup_duration") : this.config.getInt("HostConfigSettings", "ovc_startup_duration").intValue();
        logger.debug("getOvcStartupDuration() - result: {}", (Object)n2);
        return n2;
    }

    public Map<String, VirtualMachine> getStartupOVCs() {
        logger.debug("getStartupOVCs() - start");
        HashMap<String, VirtualMachine> hashMap = new HashMap<String, VirtualMachine>();
        LinkedHashSet<String> linkedHashSet = this.virtualConfigurationManager.getConfiguredHosts();
        for (String string2 : linkedHashSet) {
            List<String> list = this.virtualisationStatusStore.getStartupVMList(string2);
            Optional<String> optional = list.stream().filter(string -> StringUtils.startsWith((CharSequence)string, (CharSequence)OMNI_STACK_VC_FILTER)).findFirst();
            if (!optional.isPresent()) continue;
            logger.debug("getStartupOVCs() - Found startup OVC: {} for host: {}", (Object)optional.get(), (Object)string2);
            ServiceInstance serviceInstance = this.vmwareConnection.getESXiHostInstance(this.hostSystemUtils.getESXIConnStr(null, string2));
            if (serviceInstance != null) {
                try {
                    VirtualMachine virtualMachine = this.virtualMachineUtils.getVirtualMachineFromVMName(serviceInstance, optional.get());
                    hashMap.put(string2, virtualMachine);
                }
                catch (RemoteException remoteException) {
                    logger.warn("getStartupOVCs() - Failed to look up VM for: {}", (Object)optional.get());
                }
                continue;
            }
            logger.error("getStartupOVCs() - Failed to connect to host: {}.  Please verify host credentials.", (Object)string2);
        }
        logger.debug("getStartupOVCs() - end");
        return hashMap;
    }

    public boolean startOVCs(Set<String> set, int n) {
        logger.debug("startOVCs - start");
        Map<String, VirtualMachine> map = this.getStartupOVCs();
        boolean bl = this.getOvcStartupEnabled(n);
        int n2 = this.getOvcStartupDuration(n);
        boolean bl2 = true;
        CountdownTimer countdownTimer = new CountdownTimer(n2, TimeUnit.SECONDS);
        OvcStartupResults ovcStartupResults = new OvcStartupResults();
        if (bl) {
            ovcStartupResults = this.runStartupOnHosts(set, map);
        }
        if (ovcStartupResults.hasStartupAttempts()) {
            bl2 = !ovcStartupResults.hasFailures();
            logger.debug("startOVCs: wait for startup duration due to OVC startup attempts.");
            countdownTimer.sleep();
        } else if (this.isFirstStartupIteration()) {
            logger.debug("startOVCs: wait for startup duration due to first startup iteration.");
            countdownTimer.sleep();
        }
        this.setFirstStartupIteration(false);
        logger.debug("startOVCs - end: {}", (Object)bl2);
        return bl2;
    }

    private OvcStartupResults runStartupOnHosts(Set<String> set, Map<String, VirtualMachine> map) {
        logger.debug("runStartupOnHosts() - start, Hosts: {}, VMs: {}", set, map.values());
        OvcStartupResults ovcStartupResults = new OvcStartupResults();
        ExecutorService executorService = Executors.newFixedThreadPool(set.size());
        HashSet<Future<Boolean>> hashSet = new HashSet<Future<Boolean>>();
        for (String object : set) {
            if (StringUtils.isBlank((CharSequence)object)) continue;
            if (this.hostSystemUtils.isHostHealthy(object)) {
                VirtualMachine executionException = map.get(object);
                if (executionException == null || !this.virtualMachineUtils.isPoweredOff(executionException)) continue;
                logger.debug("runStartupOnHosts() - scheduling startup task for {}", (Object)executionException.getName());
                PowerOnOvcCallable powerOnOvcCallable = new PowerOnOvcCallable(this.virtualMachineUtils, this.hostSystemUtils, this.virtualizationLoggingUtils, object, executionException, this.virtualisationStatusStore, this.vmwareConnection);
                hashSet.add(executorService.submit(powerOnOvcCallable));
                continue;
            }
            logger.debug("runStartupOnHosts() - Skip OVC startup for host {} as it is not healthy", (Object)object);
        }
        executorService.shutdown();
        for (Future future : hashSet) {
            try {
                ovcStartupResults.setSuccess((Boolean)future.get());
            }
            catch (InterruptedException interruptedException) {
                logger.debug("runStartupOnHosts() - Unexpected result when starting OVC: {}", (Throwable)interruptedException);
                ovcStartupResults.setSuccess(false);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                logger.debug("runStartupOnHosts() - Unexpected result when starting OVC: {}", (Throwable)executionException);
                ovcStartupResults.setSuccess(false);
            }
        }
        logger.debug("runStartupOnHosts() - end, successes: {}, failures: {}", (Object)ovcStartupResults.getSuccesses(), (Object)ovcStartupResults.getFailures());
        return ovcStartupResults;
    }

    private boolean hasPoweredOffOVCs() {
        logger.debug("hasPoweredOffOVCs() - start");
        boolean bl = false;
        Set<VirtualMachine> set = this.getAllOvcs();
        bl = set.stream().anyMatch(virtualMachine -> this.virtualMachineUtils.isPoweredOff((VirtualMachine)virtualMachine));
        logger.debug("hasPoweredOffOVCs() - result: {}", (Object)bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownOVC(@NonNull SimplivityDetails simplivityDetails) {
        if (simplivityDetails == null) {
            throw new IllegalArgumentException("ovc is marked non-null but is null");
        }
        boolean bl = this.hasPoweredOffOVCs();
        int n = this.getOvcForceShutdownDelay();
        logger.debug("shutdownOVC() - forcing shutdown: {}, delay: {}", (Object)bl, (Object)n);
        this.virtualizationLoggingUtils.logSimplivityOVCShutdownEvent(simplivityDetails.getOvcName());
        try {
            SimplivityConnection simplivityConnection = this.simplivityConnectionManager.createConnection(simplivityDetails);
            simplivityConnection.connect();
            boolean bl2 = simplivityConnection.shutdownVirtualController(bl, n, simplivityDetails.getTimer(), simplivityDetails.getOvcPassword());
            bl = true;
            this.virtualisationStatusStore.saveVMToPropertyFile(simplivityDetails.getHost(), simplivityDetails.getOvcName());
            boolean bl3 = bl2;
            if (bl2) {
                while (this.virtualConfigurationManager.isHostAvailable(simplivityDetails.getOvcIP(), 22, 1L, TimeUnit.SECONDS)) {
                    if (simplivityDetails.getTimer().hasElapsed()) {
                        logger.error("shutdownOVC() - OVC {} accepted shutdown commands, but did not shut down gracefully within allocated time.", (Object)simplivityDetails.getOvcName());
                        bl3 = false;
                        break;
                    }
                    logger.debug("shutdownOVC() - OVC {} still up.  Waiting...", (Object)simplivityDetails.getOvcName());
                    new CountdownTimer(5L, TimeUnit.SECONDS).sleep();
                }
                logger.debug("shutdownOVC() - OVC {} has stopped.", (Object)simplivityDetails.getOvcName());
            }
            if (!bl3) {
                logger.error("shutdownOVC() - OVC {} did not shut down gracefully.", (Object)simplivityDetails.getOvcName());
                this.virtualizationLoggingUtils.logSimplivityOVCShutdownFailedEvent(simplivityDetails.getOvcName());
            }
        }
        catch (RemoteException remoteException) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)remoteException);
            if (throwable instanceof AuthenticationException) {
                logger.error("shutdownOVC() - Authentication failed for OVC: {}", (Object)simplivityDetails.getOvcName());
                this.virtualizationLoggingUtils.logSimplivityOVCAuthFailedEvent(simplivityDetails.getOvcName());
            } else {
                logger.error("shutdownOVC() - Connection issue to OVC: {}, {}", (Object)simplivityDetails.getOvcName(), (Object)remoteException);
                this.virtualizationLoggingUtils.logSimplivityOVCConnFailedEvent(simplivityDetails.getOvcName());
            }
        }
        catch (IOException iOException) {
            logger.error("shutdownOVC() - Connection issue to OVC: {}, {}", (Object)simplivityDetails.getOvcName(), (Object)iOException);
            this.virtualizationLoggingUtils.logSimplivityOVCConnFailedEvent(simplivityDetails.getOvcName());
        }
        finally {
            simplivityDetails.getShutdownLatch().countDown();
        }
    }

    public Set<CountDownLatch> queueOvcShutdownTasks(@NonNull Set<String> set, @NonNull CountdownTimer countdownTimer) {
        if (set == null) {
            throw new IllegalArgumentException("protectedHosts is marked non-null but is null");
        }
        if (countdownTimer == null) {
            throw new IllegalArgumentException("timer is marked non-null but is null");
        }
        logger.debug("queueOvcShutdownTasks() - start with {} hosts", (Object)set.size());
        HashSet<CountDownLatch> hashSet = new HashSet<CountDownLatch>();
        List<SimplivityDetails> list = this.loadSimplivityDetails();
        list = list.stream().filter(simplivityDetails -> set.contains(simplivityDetails.getHost())).collect(Collectors.toList());
        if (list.isEmpty()) {
            logger.warn("queueOvcShutdownTasks() - Configuration does not list any OVCs for shutdown.");
            return hashSet;
        }
        for (SimplivityDetails simplivityDetails2 : list) {
            if (this.virtualConfigurationManager.isHostAvailable(simplivityDetails2.getOvcIP(), 22, 1L, TimeUnit.SECONDS)) {
                simplivityDetails2.setTimer(countdownTimer);
                if (this.shutdownQueue.offer(simplivityDetails2)) {
                    logger.debug("queueOvcShutdownTasks() - Queued OVC {} for shut down", (Object)simplivityDetails2.getOvcName());
                    hashSet.add(simplivityDetails2.getShutdownLatch());
                    continue;
                }
                logger.error("queueOvcShutdownTasks() - Failed to queue OVC {} for shut down.", (Object)simplivityDetails2.getOvcName());
                continue;
            }
            logger.debug("queueOvcShutdownTasks() - OVC {} is already down.", (Object)simplivityDetails2.getOvcName());
        }
        logger.debug("queueOvcShutdownTasks() - end");
        return hashSet;
    }

    public List<PrioritizedVM> filterOVCsFromPrioritizedVMList(@NonNull List<PrioritizedVM> list) {
        if (list == null) {
            throw new IllegalArgumentException("vmList is marked non-null but is null");
        }
        return list.stream().filter(prioritizedVM -> !StringUtils.startsWithIgnoreCase((CharSequence)prioritizedVM.getVMName(), (CharSequence)OMNI_STACK_VC_FILTER)).collect(Collectors.toList());
    }

    public List<VirtualMachine> filterOutSimplivitySpecialVMs(@NonNull List<VirtualMachine> list) {
        if (list == null) {
            throw new IllegalArgumentException("vmList is marked non-null but is null");
        }
        return list.stream().filter(virtualMachine -> !StringUtils.startsWithIgnoreCase((CharSequence)virtualMachine.getName(), (CharSequence)OMNI_STACK_VC_FILTER)).collect(Collectors.toList());
    }

    public JsonObject checkOvcConnections(@NonNull Set<String> set) {
        if (set == null) {
            throw new IllegalArgumentException("hosts is marked non-null but is null");
        }
        return this.checkOvcConnections(this.getSimplivityUser(), this.getSimplivityPassword(), true, set);
    }

    public JsonObject checkOvcConnections(@NonNull String string, @NonNull String string2, boolean bl, @NonNull Set<String> set) {
        if (string == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        if (set == null) {
            throw new IllegalArgumentException("targetHosts is marked non-null but is null");
        }
        logger.debug("checkOvcConnections() - start");
        JsonObject jsonObject2 = new JsonObject();
        if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2)) {
            logger.warn("checkOvcConnections() - Can't connect to OVCs with blank credentials.");
            jsonObject2.put((Object)JSON_STATUS, (Object)ConnectionStatus.INVALID_CREDENTIALS.getStatus());
            return jsonObject2;
        }
        Map<String, VirtualMachine> map = this.getVirtualControllerVMs(set);
        if (map.isEmpty()) {
            logger.warn("checkOvcConnections() - Failed to find OVCs for target hosts.");
            jsonObject2.put((Object)JSON_STATUS, (Object)ConnectionStatus.NO_OVC_FOUND.getStatus());
            return jsonObject2;
        }
        Map<String, VirtualMachine> map2 = this.getPoweredOnVirtualControllerVMs(set);
        if (map2.isEmpty()) {
            logger.warn("checkOvcConnections() - Failed to find powered on OVCs for target hosts.");
            jsonObject2.put((Object)JSON_STATUS, (Object)ConnectionStatus.NO_OVC_FOUND.getStatus());
            return jsonObject2;
        }
        JsonArray jsonArray = new JsonArray();
        int n = ConnectionStatus.CONNECTION_SUCCESS.getStatus();
        if (bl && map2.size() < map.size()) {
            logger.warn("checkOvcConnections() - Not all OVCs are powered on. OVCs found: {} - OVCs powered on: {}", (Object)map.size(), (Object)map2.size());
            n = ConnectionStatus.OVC_DOWN.getStatus();
        }
        List<Object> list = new ArrayList();
        if (bl) {
            logger.debug("checkOvcConnections() - Conection check to all hosts...");
            list = map2.entrySet().stream().map(entry -> this.getOVCConnectionDetails((String)entry.getKey(), (VirtualMachine)entry.getValue(), string, string2)).collect(Collectors.toList());
        } else {
            logger.debug("checkOvcConnections() - Connection check to any host...");
            Optional<JsonObject> optional = map2.entrySet().stream().map(entry -> this.getOVCConnectionDetails((String)entry.getKey(), (VirtualMachine)entry.getValue(), string, string2)).filter(jsonObject -> ConnectionStatus.CONNECTION_SUCCESS.getStatus() == ((Integer)jsonObject.get((Object)JSON_STATUS)).intValue()).findFirst();
            if (optional.isPresent()) {
                list.add((JsonObject)optional.get());
            } else {
                n = ConnectionStatus.INVALID_CREDENTIALS.getStatus();
            }
        }
        for (JsonObject jsonObject3 : list) {
            n = Math.min(n, (Integer)jsonObject3.get((Object)JSON_STATUS));
            jsonArray.add((Object)jsonObject3);
        }
        jsonObject2.put((Object)JSON_STATUS, (Object)n);
        jsonObject2.put((Object)"ovcs", (Object)jsonArray);
        logger.debug("checkOvcConnections() - end: {}", (Object)jsonObject2);
        return jsonObject2;
    }

    public boolean isSimplivityUp(Set<String> set, Map<String, VirtualMachine> map) {
        logger.debug("isSimplivityUp() - start");
        boolean bl = false;
        List<SimplivityDetails> list = this.loadSimplivityDetails();
        if (set != null && !set.isEmpty()) {
            list = list.stream().filter(simplivityDetails -> set.contains(simplivityDetails.getHost())).collect(Collectors.toList());
        }
        if (map != null && !map.isEmpty()) {
            list = list.stream().filter(simplivityDetails -> map.keySet().contains(simplivityDetails.getHost())).collect(Collectors.toList());
        }
        List list2 = list.stream().filter(simplivityDetails -> this.virtualConfigurationManager.isHostAvailable(simplivityDetails.getOvcIP(), 22, 1L, TimeUnit.SECONDS)).collect(Collectors.toList());
        bl = list.size() == list2.size();
        logger.debug("isSimplivityUp() - result: {}", (Object)bl);
        return bl;
    }

    public ConnectionStatus checkSimplivityClusterConnection(SimplivityDetails simplivityDetails) {
        logger.debug("checkSimplivityClusterConnection() - start");
        ConnectionStatus connectionStatus = ConnectionStatus.NETWORK_ERROR;
        try {
            if (this.virtualConfigurationManager.isHostAvailable(simplivityDetails.getOvcIP(), 22, 1L, TimeUnit.SECONDS)) {
                simplivityDetails.setTimeout(5L, TimeUnit.SECONDS);
                SimplivityConnection simplivityConnection = this.simplivityConnectionManager.createConnection(simplivityDetails);
                simplivityConnection.connect();
                if (simplivityConnection.isVirtualController()) {
                    connectionStatus = ConnectionStatus.CONNECTION_SUCCESS;
                }
                simplivityConnection.disconnect();
            } else {
                connectionStatus = ConnectionStatus.OVC_DOWN;
            }
        }
        catch (RemoteException remoteException) {
            connectionStatus = ConnectionStatus.INVALID_CREDENTIALS;
        }
        catch (IOException iOException) {
            connectionStatus = ConnectionStatus.NETWORK_ERROR;
        }
        logger.debug("checkSimplivityClusterConnection() - Host: {}, Result: {}", (Object)simplivityDetails.getOvcIP(), (Object)connectionStatus);
        return connectionStatus;
    }

    public String getVersion() {
        logger.debug("getVersion() - start");
        List<SimplivityDetails> list = this.loadSimplivityDetails();
        String string = null;
        for (SimplivityDetails simplivityDetails : list) {
            try {
                simplivityDetails.setTimeout(5L, TimeUnit.SECONDS);
                SimplivityConnection simplivityConnection = this.simplivityConnectionManager.createConnection(simplivityDetails);
                simplivityConnection.connect();
                string = simplivityConnection.getVersion();
                simplivityConnection.disconnect();
                if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                logger.info("getVersion() - Result: {}", (Object)string);
                break;
            }
            catch (IOException iOException) {
                logger.debug("getVersion() - Exception", (Throwable)iOException);
            }
        }
        logger.debug("getVersion() - Result: {}", string);
        return string;
    }

    public int getOvcForceShutdownDelay() {
        return this.config.getInt("SimplivityClusterDetails", "ovc_force_shutdown_delay", 60);
    }

    public int getOvcShutdownDuration(int n) {
        int n2;
        logger.debug("getOvcShutdownDuration() - start");
        if (this.advancedSetupHelper.isAdvancedNonPhysical(n)) {
            logger.debug("getOvcShutdownDuration() - get setting from advanced group: {}", (Object)n);
            n2 = this.config.getInt("advanced_ups_setup_" + n, "ovc_shutdown_duration", 300);
        } else {
            logger.debug("getOvcShutdownDuration() - get setting from {}", (Object)"HostConfigSettings");
            n2 = this.config.getInt("HostConfigSettings", "ovc_shutdown_duration", 300);
        }
        logger.debug("getOvcShutdownDuration() - result: {}", (Object)n2);
        return n2;
    }

    public List<SimplivityDetails> parseSimplivityDetails(PageContext pageContext) {
        logger.debug("parseSimplivityDetails() - start");
        String string = StringUtils.trim((String)pageContext.getPostQueryValue("simplivity_ovc_user"));
        String string2 = pageContext.getPostQueryValue("simplivity_ovc_password");
        String string3 = pageContext.getPostQueryValue("ovcNames");
        String string4 = pageContext.getPostQueryValue("ovcIPs");
        String string5 = pageContext.getPostQueryValue("ovcHosts");
        logger.debug("parseSimplivityDetails() - Simplivity Details from Page: User: {}, OVCs: {}, IPs: {}, Hosts: {}", (Object)string, (Object)string3, (Object)string4, (Object)string5);
        ArrayList<SimplivityDetails> arrayList = new ArrayList<SimplivityDetails>();
        if (StringUtils.isNotBlank((CharSequence)string3) && StringUtils.isNotBlank((CharSequence)string4) && StringUtils.isNotBlank((CharSequence)string5)) {
            String[] stringArray = StringUtils.split((String)string3, (String)",");
            String[] stringArray2 = StringUtils.split((String)string4, (String)",");
            String[] stringArray3 = StringUtils.split((String)string5, (String)",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string6 = StringUtils.trim((String)stringArray[i]);
                String string7 = StringUtils.trim((String)stringArray2[i]);
                String string8 = StringUtils.trim((String)stringArray3[i]);
                if (!StringUtils.isNotEmpty((CharSequence)string6) || !StringUtils.isNotEmpty((CharSequence)string7) || !StringUtils.isNotEmpty((CharSequence)string8)) continue;
                SimplivityDetails simplivityDetails = new SimplivityDetails(string8, string7, string6, string, string2);
                arrayList.add(simplivityDetails);
            }
        } else {
            SimplivityDetails simplivityDetails = new SimplivityDetails(null, null, null, "svtcli", null);
            arrayList.add(simplivityDetails);
        }
        return arrayList;
    }

    public List<SimplivityDetails> parseSimplivityDetails(HTTPServletParameterMap hTTPServletParameterMap) {
        logger.debug("parseSimplivityDetails() - start");
        String string = StringUtils.trim((String)hTTPServletParameterMap.getString("simplivity_ovc_user"));
        String string2 = hTTPServletParameterMap.getString("simplivity_ovc_password");
        String string3 = hTTPServletParameterMap.getString("ovcNames");
        String string4 = hTTPServletParameterMap.getString("ovcIPs");
        String string5 = hTTPServletParameterMap.getString("ovcHosts");
        logger.debug("parseSimplivityDetails() - Simplivity Details from Page: User: {}, OVCs: {}, IPs: {}, Hosts: {}", (Object)string, (Object)string3, (Object)string4, (Object)string5);
        ArrayList<SimplivityDetails> arrayList = new ArrayList<SimplivityDetails>();
        if (StringUtils.isNotBlank((CharSequence)string3) && StringUtils.isNotBlank((CharSequence)string4) && StringUtils.isNotBlank((CharSequence)string5)) {
            String[] stringArray = StringUtils.split((String)string3, (String)",");
            String[] stringArray2 = StringUtils.split((String)string4, (String)",");
            String[] stringArray3 = StringUtils.split((String)string5, (String)",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string6 = StringUtils.trim((String)stringArray[i]);
                String string7 = StringUtils.trim((String)stringArray2[i]);
                String string8 = StringUtils.trim((String)stringArray3[i]);
                if (!StringUtils.isNotEmpty((CharSequence)string6) || !StringUtils.isNotEmpty((CharSequence)string7) || !StringUtils.isNotEmpty((CharSequence)string8)) continue;
                SimplivityDetails simplivityDetails = new SimplivityDetails(string8, string7, string6, string, string2);
                arrayList.add(simplivityDetails);
            }
        } else {
            SimplivityDetails simplivityDetails = new SimplivityDetails(null, null, null, "svtcli", null);
            arrayList.add(simplivityDetails);
        }
        return arrayList;
    }

    public List<String> getOvcHostnames() {
        List<SimplivityDetails> list = this.loadSimplivityDetails();
        List<String> list2 = list.stream().map(SimplivityDetails::getHost).collect(Collectors.toList());
        logger.debug("getOvcHostnames() - returning {}", list2);
        return list2;
    }

    @Generated
    public void setSimplivityConnectionManager(@NonNull SimplivityConnectionManager simplivityConnectionManager) {
        if (simplivityConnectionManager == null) {
            throw new IllegalArgumentException("simplivityConnectionManager is marked non-null but is null");
        }
        this.simplivityConnectionManager = simplivityConnectionManager;
    }

    @Generated
    public void setVirtualConfigurationManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
    }

    @Generated
    public void setAdvancedSetupHelper(@NonNull AdvancedSetupHelper advancedSetupHelper) {
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        this.advancedSetupHelper = advancedSetupHelper;
    }

    @Generated
    public void setVirtualMachineUtils(@NonNull VirtualMachineUtils virtualMachineUtils) {
        if (virtualMachineUtils == null) {
            throw new IllegalArgumentException("virtualMachineUtils is marked non-null but is null");
        }
        this.virtualMachineUtils = virtualMachineUtils;
    }

    @Generated
    public void setHostSystemUtils(@NonNull HostSystemUtils hostSystemUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setConfig(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Generated
    public void setAuthHelper(@NonNull AuthHelper authHelper) {
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        this.authHelper = authHelper;
    }

    @Generated
    public void setVirtualizationLoggingUtils(@NonNull VirtualizationLoggingUtils virtualizationLoggingUtils) {
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("virtualizationLoggingUtils is marked non-null but is null");
        }
        this.virtualizationLoggingUtils = virtualizationLoggingUtils;
    }

    @Generated
    public void setVirtualisationStatusStore(@NonNull VirtualisationStatusStore virtualisationStatusStore) {
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtualisationStatusStore is marked non-null but is null");
        }
        this.virtualisationStatusStore = virtualisationStatusStore;
    }

    @Generated
    public void setVmwareConnection(@NonNull VMWareConnection vMWareConnection) {
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        this.vmwareConnection = vMWareConnection;
    }

    @Generated
    public void setThreadService(@NonNull ThreadService threadService) {
        if (threadService == null) {
            throw new IllegalArgumentException("threadService is marked non-null but is null");
        }
        this.threadService = threadService;
    }

    @Generated
    public void setFirstStartupIteration(boolean bl) {
        this.firstStartupIteration = bl;
    }

    @Generated
    public boolean isFirstStartupIteration() {
        return this.firstStartupIteration;
    }
}

