/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.vmware;

import com.apcc.m11.components.webserver.model.Host;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VirtualMachineUtils;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.vmware.vim25.ClusterConfigInfoEx;
import com.vmware.vim25.ClusterDasConfigInfo;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualApp;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterUtils {
    private static final Logger logger = LogManager.getLogger(ClusterUtils.class);
    public static final String VCLS_RETREAT_MODE_STRING = "config.vcls.clusters.%s.enabled";
    @NonNull
    private VirtualConfigurationManager virtualConfigurationManager;
    @NonNull
    private VMWareConnection vmwareConnection;
    @NonNull
    private HostSystemUtils hostSystemUtils;
    @NonNull
    private VirtualMachineUtils virtualMachineUtils;

    public ClusterComputeResource getCluster(ServiceInstance serviceInstance, String string) {
        ClusterComputeResource clusterComputeResource = null;
        logger.debug("getCluster() - start, searching for cluster {}", (Object)string);
        try {
            ManagedEntity[] managedEntityArray;
            Folder folder = serviceInstance.getRootFolder();
            block2: for (ManagedEntity managedEntity : managedEntityArray = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("Datacenter")) {
                ManagedEntity[] managedEntityArray2;
                if (!(managedEntity instanceof Datacenter)) continue;
                for (ManagedEntity managedEntity2 : managedEntityArray2 = new InventoryNavigator((ManagedEntity)((Datacenter)managedEntity).getHostFolder()).searchManagedEntities("ClusterComputeResource")) {
                    if (!(managedEntity2 instanceof ClusterComputeResource)) continue;
                    logger.debug("getCluster() - checking cluster: {}", (Object)managedEntity2.getName());
                    if (!managedEntity2.getName().equals(string)) continue;
                    clusterComputeResource = (ClusterComputeResource)managedEntity2;
                    logger.info("getCluster() - found cluster: {}", (Object)managedEntity2.getName());
                    continue block2;
                }
            }
        }
        catch (RemoteException remoteException) {
            logger.warn("getCluster() - RemoteException: {}", (Object)remoteException.getLocalizedMessage());
        }
        logger.debug("getCluster() - end");
        return clusterComputeResource;
    }

    public ClusterComputeResource getClusterEntity(HostSystem hostSystem) {
        if (hostSystem != null) {
            ManagedEntity managedEntity = null;
            try {
                managedEntity = hostSystem.getParent();
            }
            catch (Exception exception) {
                logger.error("getClusterEntity() - unable to retrieve cluster entity, error: {}", (Throwable)exception);
            }
            if (managedEntity != null && managedEntity instanceof ClusterComputeResource) {
                return (ClusterComputeResource)managedEntity;
            }
        }
        return null;
    }

    public ClusterComputeResource getClusterForHost(HostSystem hostSystem) {
        logger.debug("getClusterForHost() - start");
        ClusterComputeResource clusterComputeResource = null;
        if (hostSystem != null) {
            ManagedEntity managedEntity = hostSystem.getParent();
            while (managedEntity instanceof Folder) {
                managedEntity = managedEntity.getParent();
            }
            if (managedEntity instanceof ClusterComputeResource) {
                clusterComputeResource = (ClusterComputeResource)managedEntity;
                logger.debug("getClusterForHost() - cluster found: {}", (Object)clusterComputeResource.getName());
            }
        }
        logger.debug("getClusterForHost() - end");
        return clusterComputeResource;
    }

    public Set<HostSystem> getClusterHostSystemList(ClusterComputeResource clusterComputeResource, HostSystemUtils hostSystemUtils) {
        HashSet<HostSystem> hashSet = new HashSet<HostSystem>();
        logger.info("getClusterHostSystemList() - start");
        try {
            ManagedEntity[] managedEntityArray = new InventoryNavigator((ManagedEntity)clusterComputeResource).searchManagedEntities("HostSystem");
            if (managedEntityArray != null) {
                for (ManagedEntity managedEntity : managedEntityArray) {
                    if (!(managedEntity instanceof HostSystem)) continue;
                    HostSystem hostSystem = (HostSystem)managedEntity;
                    logger.info("getClusterHostSystemList() - checking host: {}", (Object)hostSystem.getName());
                    if (!hostSystem.getRuntime().isInMaintenanceMode()) {
                        if (!hostSystemUtils.checkIfHostIsPoweredOn(hostSystem)) continue;
                        hashSet.add(hostSystem);
                        continue;
                    }
                    logger.warn("getClusterHostSystemList() - not adding host: {}, in Maintenance Mode", (Object)hostSystem.getName());
                }
            }
        }
        catch (Exception exception) {
            logger.error("getClusterHostSystemList() - Exception: ", (Throwable)exception);
        }
        logger.info("getClusterHostSystemList() - end");
        return hashSet;
    }

    public Integer getAdmissionControlFailoverLevel() {
        ClusterConfigInfoEx clusterConfigInfoEx;
        ClusterDasConfigInfo clusterDasConfigInfo;
        Integer n = null;
        logger.debug("getAdmissionControlFailoverLevel() - start");
        ClusterComputeResource clusterComputeResource = this.findCluster();
        if (clusterComputeResource != null && (clusterDasConfigInfo = (clusterConfigInfoEx = (ClusterConfigInfoEx)clusterComputeResource.getConfigurationEx()).getDasConfig()).getAdmissionControlEnabled().booleanValue()) {
            n = clusterDasConfigInfo.getFailoverLevel();
            logger.debug("getAdmissionControlFailoverLevel() - cluster: {}, failover level: {}", (Object)clusterComputeResource.getName(), (Object)n);
        }
        logger.info("getAdmissionControlFailoverLevel() - end, result: {}", n);
        return n;
    }

    public ClusterComputeResource findCluster() {
        ClusterComputeResource clusterComputeResource = null;
        logger.debug("findCluster() - start");
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance == null) {
            logger.warn("findCluster() - no vCenter server connection");
            return null;
        }
        List<String> list = this.virtualConfigurationManager.getMappedHostsList();
        if (list == null || list.isEmpty()) {
            logger.warn("findCluster() - no PCNS protected hosts found");
            return null;
        }
        try {
            ManagedEntity[] managedEntityArray;
            Folder folder = serviceInstance.getRootFolder();
            for (ManagedEntity managedEntity : managedEntityArray = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("Datacenter")) {
                ManagedEntity[] managedEntityArray2;
                if (!(managedEntity instanceof Datacenter)) continue;
                block3: for (ManagedEntity managedEntity2 : managedEntityArray2 = new InventoryNavigator((ManagedEntity)((Datacenter)managedEntity).getHostFolder()).searchManagedEntities("ClusterComputeResource")) {
                    HostSystem[] hostSystemArray;
                    if (!(managedEntity2 instanceof ClusterComputeResource)) continue;
                    for (HostSystem hostSystem : hostSystemArray = ((ClusterComputeResource)managedEntity2).getHosts()) {
                        if (!list.contains(hostSystem.getName())) continue;
                        clusterComputeResource = (ClusterComputeResource)managedEntity2;
                        logger.info("findCluster() - found PCNS protected host in cluster");
                        continue block3;
                    }
                }
            }
        }
        catch (RemoteException remoteException) {
            logger.debug((Object)remoteException);
        }
        logger.debug("findCluster() - end");
        return clusterComputeResource;
    }

    public List<Host> getHostsWithinDatacenter(Datacenter datacenter) {
        ArrayList<Host> arrayList = new ArrayList<Host>();
        logger.debug("getHostsWithinDatacenter() - start");
        try {
            ManagedEntity[] managedEntityArray;
            ManagedEntity[] managedEntityArray2 = new InventoryNavigator((ManagedEntity)datacenter.getHostFolder()).searchManagedEntities("ClusterComputeResource");
            for (ManagedEntity managedEntity : managedEntityArray = new InventoryNavigator((ManagedEntity)datacenter).searchManagedEntities("HostSystem")) {
                if (!(managedEntity instanceof HostSystem)) continue;
                arrayList.add(new Host(managedEntity.getName(), datacenter.getName(), this.findClusterName(managedEntityArray2, managedEntity.getName()), false));
            }
        }
        catch (RemoteException remoteException) {
            logger.error("getHostsWithinDatacenter() - RemoteException: " + String.valueOf(remoteException));
            arrayList = null;
        }
        catch (Exception exception) {
            logger.error("getHostsWithinDatacenter() - Exception: " + String.valueOf(exception));
            arrayList = null;
        }
        logger.debug("getHostsWithinDatacenter() - end");
        return arrayList;
    }

    private String findClusterName(ManagedEntity[] managedEntityArray, String string) {
        logger.debug("findClusterName() - start");
        for (ManagedEntity managedEntity : managedEntityArray) {
            HostSystem[] hostSystemArray;
            if (!(managedEntity instanceof ClusterComputeResource)) continue;
            ClusterComputeResource clusterComputeResource = (ClusterComputeResource)managedEntity;
            for (HostSystem hostSystem : hostSystemArray = clusterComputeResource.getHosts()) {
                if (!hostSystem.getName().equalsIgnoreCase(string)) continue;
                logger.debug("findClusterName() - found cluster: {}", (Object)clusterComputeResource.getName());
                return clusterComputeResource.getName();
            }
        }
        logger.debug("findClusterName() - end");
        return null;
    }

    public List<String> getHostWithinDatacenter(ServiceInstance serviceInstance, Datacenter datacenter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        logger.debug("getHostWithinDatacenter() - start");
        try {
            ManagedEntity[] managedEntityArray;
            for (ManagedEntity managedEntity : managedEntityArray = new InventoryNavigator((ManagedEntity)datacenter).searchManagedEntities("HostSystem")) {
                if (!(managedEntity instanceof HostSystem)) continue;
                arrayList.add(managedEntity.getName());
            }
        }
        catch (RemoteException remoteException) {
            logger.error("getHostWithinDatacenter() - RemoteException: ", (Throwable)remoteException);
        }
        catch (Exception exception) {
            logger.error("getHostWithinDatacenter() - Exception: ", (Throwable)exception);
        }
        logger.debug("getHostWithinDatacenter() - end");
        return arrayList;
    }

    public String getClusterDomainID(ClusterComputeResource clusterComputeResource) {
        return clusterComputeResource.getMOR().val;
    }

    public boolean hasVCLSBeenDetectedOnTheCluster() {
        boolean bl = false;
        logger.debug("hasVCLSBeenDetectedOnTheCluster() - start");
        if (this.virtualConfigurationManager.hasVCLSBeenDetectedOnCluster()) {
            bl = true;
        } else if (this.isVCLSvMCurrentlyRunning()) {
            bl = true;
            this.virtualConfigurationManager.setVCLSDetectedInCluster();
        }
        logger.debug("hasVCLSBeenDetectedOnTheCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isVCLSvMCurrentlyRunning() {
        HostSystem[] hostSystemArray;
        logger.debug("isVCLSvMCurrentlyRunning() - start");
        List<Host> list = this.hostSystemUtils.getConfiguredHosts();
        if (list == null || list.isEmpty()) {
            logger.debug("isVCLSvMCurrentlyRunning() - Host List is null or empty: {}", list);
            return false;
        }
        String string = this.getClusterFromHostsList(list);
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.debug("isVCLSvMCurrentlyRunning() - no host found having a cluster set");
            return false;
        }
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance == null) {
            logger.debug("isVCLSvMCurrentlyRunning() - ServiceInstance is null");
            return false;
        }
        ClusterComputeResource clusterComputeResource = this.getCluster(serviceInstance, string);
        if (clusterComputeResource == null) {
            logger.debug("isVCLSvMCurrentlyRunning() - cluster is null");
            return false;
        }
        for (HostSystem hostSystem : hostSystemArray = clusterComputeResource.getHosts()) {
            try {
                VirtualMachine[] virtualMachineArray;
                for (VirtualMachine virtualMachine : virtualMachineArray = hostSystem.getVms()) {
                    if (!this.virtualMachineUtils.isVClsVm(virtualMachine)) continue;
                    logger.debug("isVCLSvMCurrentlyRunning() - VCLS VM Found");
                    if (!this.virtualConfigurationManager.hasVCLSBeenDetectedOnCluster()) {
                        logger.debug("isVCLSvMCurrentlyRunning() - setting VCLS detected");
                        this.virtualConfigurationManager.setVCLSDetectedInCluster();
                    }
                    return true;
                }
            }
            catch (InvalidProperty invalidProperty) {
                logger.debug("isVCLSvMCurrentlyRunning() - InvalidProperty Exception", (Throwable)invalidProperty);
            }
            catch (RuntimeFault runtimeFault) {
                logger.debug("isVCLSvMCurrentlyRunning() - RuntimeFault Exception", (Throwable)runtimeFault);
            }
            catch (RemoteException remoteException) {
                logger.debug("isVCLSvMCurrentlyRunning() - RemoteException Exception", (Throwable)remoteException);
            }
        }
        logger.debug("isVCLSvMCurrentlyRunning() - end no VCLS VM Found");
        return false;
    }

    private String getClusterFromHostsList(@NonNull List<Host> list) {
        if (list == null) {
            throw new IllegalArgumentException("hostsList is marked non-null but is null");
        }
        logger.debug("getClusterFromHostsList() - start");
        Host host2 = list.stream().filter(host -> StringUtils.isNotBlank((CharSequence)host.getCluster())).findAny().orElse(null);
        if (host2 == null) {
            logger.debug("getClusterFromHostsList() - no host found having a cluster set");
            return null;
        }
        logger.debug("getClusterFromHostsList() - end, returning {}", (Object)host2.getCluster());
        return host2.getCluster();
    }

    public Optional<Datacenter> getDatacenter(@NonNull ManagedEntity managedEntity) {
        ManagedEntity managedEntity2;
        if (managedEntity == null) {
            throw new IllegalArgumentException("entity is marked non-null but is null");
        }
        logger.debug("getDatacenter() - Entity: {}", (Object)managedEntity.getName());
        for (managedEntity2 = managedEntity; managedEntity2 != null && !(managedEntity2 instanceof Datacenter); managedEntity2 = managedEntity2.getParent()) {
            logger.trace("getDatacenter() - Processing entity: {}", (Object)managedEntity2);
        }
        Optional<Datacenter> optional = Optional.ofNullable((Datacenter)managedEntity2);
        logger.debug("getDatacenter() - Found DataCenter for entity: {}: {}", (Object)managedEntity, (Object)optional.isPresent());
        return optional;
    }

    public Optional<ClusterComputeResource> getClusterForVirtualApp(@NonNull VirtualApp virtualApp) {
        if (virtualApp == null) {
            throw new IllegalArgumentException("vapp is marked non-null but is null");
        }
        logger.debug("getClusterForVirtualApp() - Seeking cluster for VApp: {}", (Object)virtualApp.getName());
        Optional<Object> optional = Optional.ofNullable(null);
        try {
            ComputeResource computeResource;
            for (computeResource = virtualApp.getOwner(); computeResource != null && !(computeResource instanceof ClusterComputeResource); computeResource = computeResource.getParent()) {
                logger.trace("getClusterForVirtualApp() - Processing entity: {}", (Object)computeResource);
            }
            optional = Optional.ofNullable((ClusterComputeResource)computeResource);
            logger.debug("getClusterForVirtualApp() - Found cluster for vapp: {}, {}", (Object)virtualApp, (Object)optional.isPresent());
        }
        catch (RemoteException remoteException) {
            logger.debug("getClusterForVirtualApp() - Failed to find cluster for vapp: {}", (Object)virtualApp, (Object)remoteException);
        }
        return optional;
    }

    public Optional<ComputeResource> getComputeResource(@NonNull ManagedEntity managedEntity) {
        ManagedEntity managedEntity2;
        if (managedEntity == null) {
            throw new IllegalArgumentException("entity is marked non-null but is null");
        }
        logger.debug("getComputeResource() - Seeking ComputeResource for ManagedEntity: {}", (Object)managedEntity);
        for (managedEntity2 = managedEntity; managedEntity2 != null && !(managedEntity2 instanceof ComputeResource); managedEntity2 = managedEntity2.getParent()) {
            logger.trace("getComputeResource() - Processing entity: {}", (Object)managedEntity2);
        }
        Optional<ComputeResource> optional = Optional.ofNullable((ComputeResource)managedEntity2);
        logger.debug("getComputeResource() - Found ComputeResource for entity: {}: {}", (Object)managedEntity, (Object)optional.isPresent());
        return optional;
    }

    public boolean hasParent(@NonNull ManagedEntity managedEntity, @NonNull Set<? extends ManagedEntity> set) {
        if (managedEntity == null) {
            throw new IllegalArgumentException("child is marked non-null but is null");
        }
        if (set == null) {
            throw new IllegalArgumentException("parents is marked non-null but is null");
        }
        logger.debug("hasParent() - Checking if child: {}, has a parent in the set: {}", (Object)managedEntity, set);
        for (ManagedEntity managedEntity2 = managedEntity; managedEntity2 != null; managedEntity2 = managedEntity2.getParent()) {
            logger.trace("hasParent() - Processing entity: {}", (Object)managedEntity2);
            for (ManagedEntity managedEntity3 : set) {
                if (!managedEntity3.getMOR().equals((Object)managedEntity2.getMOR())) continue;
                logger.debug("hasParent() - Found parent for child: {}", (Object)managedEntity);
                return true;
            }
        }
        logger.debug("hasParent() - A parent for child: {} was not found.", (Object)managedEntity);
        return false;
    }

    @Generated
    public void setVirtualConfigurationManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
    }

    @Generated
    public void setVmwareConnection(@NonNull VMWareConnection vMWareConnection) {
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        this.vmwareConnection = vMWareConnection;
    }

    @Generated
    public void setHostSystemUtils(@NonNull HostSystemUtils hostSystemUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setVirtualMachineUtils(@NonNull VirtualMachineUtils virtualMachineUtils) {
        if (virtualMachineUtils == null) {
            throw new IllegalArgumentException("virtualMachineUtils is marked non-null but is null");
        }
        this.virtualMachineUtils = virtualMachineUtils;
    }
}

