/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.vmware;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import com.vmware.vim25.AlarmExpression;
import com.vmware.vim25.AlarmSetting;
import com.vmware.vim25.AlarmSpec;
import com.vmware.vim25.Description;
import com.vmware.vim25.Event;
import com.vmware.vim25.EventAlarmExpression;
import com.vmware.vim25.EventEventSeverity;
import com.vmware.vim25.EventEx;
import com.vmware.vim25.Extension;
import com.vmware.vim25.ExtensionEventTypeInfo;
import com.vmware.vim25.ExtensionResourceInfo;
import com.vmware.vim25.HostEventArgument;
import com.vmware.vim25.InvalidEvent;
import com.vmware.vim25.KeyValue;
import com.vmware.vim25.ManagedEntityStatus;
import com.vmware.vim25.NotAuthenticated;
import com.vmware.vim25.OrAlarmExpression;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.Alarm;
import com.vmware.vim25.mo.AlarmManager;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreateVCenterAlarm {
    private static final Logger logger = LogManager.getLogger(CreateVCenterAlarm.class);
    private static final String kWebServerProperties = "com.apcc.m11.components.webserver.i18n.VCenterPlugin";
    public static final String alarmPrefix = "CreateVCenterAlarm";
    public static final String pluginPrefix = "CreateVCenterPlugin";
    public static final String NORMALEVENT = "normal";
    public static final String ALERTEVENT = "alert";
    public static final String WARNINGEVENT = "warning";
    public static final String kAlarmName = ".AlarmName";
    private static final String kAlarmDescription = ".AlarmDescription";
    private static final String kVersion = ".PluginVersion";
    private static final String kCompanyName = ".PluginVendor";
    private static final String kAlarmUPSFailureAlertMessage = ".AlarmUPSFailureAlertMessage";
    private static final String kAlarmUPSFailureWarningMessage = ".AlarmUPSFailureWarningMessage";
    private static final String kAlarmUPSFailureClearMessage = ".AlarmUPSFailureClearMessage";
    private static final String ALARM_EXPRESSION_EVENT_TYPE = "EventEx";
    private static final String ALARM_CATEGORY = ".category";
    private static final String ALARM_CATEGORY_TYPE = "info";
    private static final String ALARM_FORMAT_ON_HOST = ".formatOnHost";
    private static final String ALARM_FULL_FORMAT = ".fullFormat";
    private static final String ALARM_FORMAT_ON_DATACENTER = ".formatOnDatacenter";
    private static final String ALARM_MODULE = "event";
    private static final String UPS_CRITICAL_EVENT_KEY = "UPSCriticalEventKey";
    private static final String UPS_EVENT_ALERT_ID = "UPS_CRITICAL_EVENT_OCCURRED";
    private static final String UPS_EVENT_WARNING_ID = "UPS_CRITICAL_EVENT_INITIATED";
    private static final String UPS_EVENT_CLEAR_ID = "UPS_CRITICAL_EVENT_CLEARED";
    private static CreateVCenterAlarm theInstance = null;
    private String theAlarmName;
    private String theAlarmDescription;
    private String theAlarmLocale;
    private String theVersion;
    private String theCompanyName;
    private String theAlarmUPSFailureAlertMessage;
    private String theAlarmUPSFailureWarningMessage;
    private String theAlarmUPSFailureClearMessage;
    protected HostSystemUtils hostSystemUtils;
    protected VirtualConfigurationManager vmwareConfigUtils;

    protected CreateVCenterAlarm() {
        this.initialize();
    }

    public static synchronized CreateVCenterAlarm getInstance() {
        if (theInstance == null) {
            theInstance = new CreateVCenterAlarm();
        }
        return theInstance;
    }

    public static synchronized void setInstance(CreateVCenterAlarm createVCenterAlarm) {
        theInstance = createVCenterAlarm;
    }

    public synchronized void createAlarm(ServiceInstance serviceInstance) {
        boolean bl = false;
        Folder folder = serviceInstance.getRootFolder();
        AlarmSpec alarmSpec = new AlarmSpec();
        AlarmSetting alarmSetting = new AlarmSetting();
        AlarmManager alarmManager = serviceInstance.getAlarmManager();
        OrAlarmExpression orAlarmExpression = this.createEventAlarmExpression();
        alarmSpec.setExpression((AlarmExpression)orAlarmExpression);
        alarmSpec.setName(this.theAlarmName);
        alarmSpec.setDescription(this.theAlarmDescription);
        alarmSpec.setEnabled(true);
        alarmSetting.setReportingFrequency(0);
        alarmSetting.setToleranceRange(0);
        alarmSpec.setSetting(alarmSetting);
        try {
            Alarm[] alarmArray;
            for (Alarm alarm : alarmArray = alarmManager.getAlarm((ManagedEntity)folder)) {
                if (!alarm.getAlarmInfo().getName().equalsIgnoreCase(this.theAlarmName)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                alarmManager.createAlarm((ManagedEntity)folder, alarmSpec);
            }
            this.registerExtensionForUPSCriticalEvent(serviceInstance);
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("createAlarm", (Throwable)runtimeFault);
        }
        catch (RemoteException remoteException) {
            logger.error("createAlarm", (Throwable)remoteException);
        }
    }

    public void createUPSCriticalEvent(String string, String string2) {
        HostSystem hostSystem;
        ServiceInstance serviceInstance;
        logger.debug("createUPSCriticalEvent start");
        if (this.vmwareConfigUtils.isPluginEnabled() && (serviceInstance = ServiceManager.getInstance().getVmWareConnection().getVCenterConnection()) != null && (hostSystem = this.hostSystemUtils.getHostUsingIPOrDNSName(serviceInstance, string)) != null) {
            String string3 = serviceInstance.getSessionManager().getCurrentSession().getUserName();
            logger.debug("create Event - VMware");
            EventEx eventEx = new EventEx();
            eventEx.setUserName(string3);
            logger.debug("create event username" + string3);
            logger.debug("create event hostSystem " + hostSystem.getName());
            HostEventArgument hostEventArgument = new HostEventArgument();
            hostEventArgument.setHost(hostSystem.getMOR());
            hostEventArgument.setName("HostSystem");
            eventEx.setHost(hostEventArgument);
            eventEx.setChainId(0);
            eventEx.setKey(0);
            eventEx.setCreatedTime(Calendar.getInstance());
            if (string2.equalsIgnoreCase(ALERTEVENT)) {
                eventEx.setEventTypeId(UPS_EVENT_ALERT_ID);
                eventEx.setMessage(this.theAlarmUPSFailureAlertMessage);
                eventEx.setFullFormattedMessage(this.theAlarmUPSFailureAlertMessage);
                eventEx.setSeverity(EventEventSeverity.error.name());
            } else if (string2.equalsIgnoreCase(WARNINGEVENT)) {
                eventEx.setEventTypeId(UPS_EVENT_WARNING_ID);
                eventEx.setMessage(this.theAlarmUPSFailureWarningMessage);
                eventEx.setFullFormattedMessage(this.theAlarmUPSFailureWarningMessage);
                eventEx.setSeverity(EventEventSeverity.warning.name());
            } else if (string2.equalsIgnoreCase(NORMALEVENT)) {
                eventEx.setEventTypeId(UPS_EVENT_CLEAR_ID);
                eventEx.setMessage(this.theAlarmUPSFailureClearMessage);
                eventEx.setFullFormattedMessage(this.theAlarmUPSFailureClearMessage);
                eventEx.setSeverity(EventEventSeverity.info.name());
            }
            try {
                logger.debug("createUPSCriticalEvent - calling postEvent for eventType " + string2);
                serviceInstance.getEventManager().postEvent((Event)eventEx, null);
            }
            catch (InvalidEvent invalidEvent) {
                logger.error("InvalidEvent - createEvent", (Throwable)invalidEvent);
            }
            catch (NotAuthenticated notAuthenticated) {
                logger.error("NotAuthenticated - createEvent", (Throwable)notAuthenticated);
            }
            catch (RuntimeFault runtimeFault) {
                logger.error("RuntimeFault - createEvent", (Throwable)runtimeFault);
            }
            catch (RemoteException remoteException) {
                logger.error("RemoteException - createEvent", (Throwable)remoteException);
            }
            catch (Exception exception) {
                logger.error("Exception - createEvent", (Throwable)exception);
            }
        }
        logger.debug("createUPSCriticalEvent end");
    }

    private void registerExtensionForUPSCriticalEvent(ServiceInstance serviceInstance) {
        logger.debug("registerExtensionForUPSCriticalEvent - start");
        try {
            if (serviceInstance.getExtensionManager().findExtension(UPS_CRITICAL_EVENT_KEY) == null) {
                Extension extension = new Extension();
                extension.setKey(UPS_CRITICAL_EVENT_KEY);
                extension.setVersion(this.theVersion);
                extension.setLastHeartbeatTime(Calendar.getInstance());
                extension.setCompany(this.theCompanyName);
                Description description = new Description();
                description.setLabel(this.theAlarmName);
                description.setSummary(this.theAlarmDescription);
                extension.setDescription(description);
                KeyValue keyValue = new KeyValue();
                keyValue.setKey("UPS_CRITICAL_EVENT_OCCURRED.category");
                keyValue.setValue(ALARM_CATEGORY_TYPE);
                KeyValue keyValue2 = new KeyValue();
                keyValue2.setKey("UPS_CRITICAL_EVENT_OCCURRED.formatOnHost");
                keyValue2.setValue(this.theAlarmUPSFailureAlertMessage);
                KeyValue keyValue3 = new KeyValue();
                keyValue3.setKey("UPS_CRITICAL_EVENT_OCCURRED.fullFormat");
                keyValue3.setValue(this.theAlarmUPSFailureAlertMessage);
                KeyValue keyValue4 = new KeyValue();
                keyValue4.setKey("UPS_CRITICAL_EVENT_OCCURRED.formatOnDatacenter");
                keyValue4.setValue(this.theAlarmUPSFailureAlertMessage);
                KeyValue keyValue5 = new KeyValue();
                keyValue5.setKey("UPS_CRITICAL_EVENT_INITIATED.category");
                keyValue5.setValue(ALARM_CATEGORY_TYPE);
                KeyValue keyValue6 = new KeyValue();
                keyValue6.setKey("UPS_CRITICAL_EVENT_INITIATED.formatOnHost");
                keyValue6.setValue(this.theAlarmUPSFailureWarningMessage);
                KeyValue keyValue7 = new KeyValue();
                keyValue7.setKey("UPS_CRITICAL_EVENT_INITIATED.fullFormat");
                keyValue7.setValue(this.theAlarmUPSFailureWarningMessage);
                KeyValue keyValue8 = new KeyValue();
                keyValue8.setKey("UPS_CRITICAL_EVENT_INITIATED.formatOnDatacenter");
                keyValue8.setValue(this.theAlarmUPSFailureWarningMessage);
                KeyValue keyValue9 = new KeyValue();
                keyValue9.setKey("UPS_CRITICAL_EVENT_CLEARED.category");
                keyValue9.setValue(ALARM_CATEGORY_TYPE);
                KeyValue keyValue10 = new KeyValue();
                keyValue10.setKey("UPS_CRITICAL_EVENT_CLEARED.formatOnHost");
                keyValue10.setValue(this.theAlarmUPSFailureClearMessage);
                KeyValue keyValue11 = new KeyValue();
                keyValue11.setKey("UPS_CRITICAL_EVENT_CLEARED.fullFormat");
                keyValue11.setValue(this.theAlarmUPSFailureClearMessage);
                KeyValue keyValue12 = new KeyValue();
                keyValue12.setKey("UPS_CRITICAL_EVENT_CLEARED.formatOnDatacenter");
                keyValue12.setValue(this.theAlarmUPSFailureClearMessage);
                ExtensionResourceInfo extensionResourceInfo = new ExtensionResourceInfo();
                extensionResourceInfo.setLocale(this.theAlarmLocale);
                extensionResourceInfo.setModule(ALARM_MODULE);
                extensionResourceInfo.setData(new KeyValue[]{keyValue, keyValue2, keyValue3, keyValue4, keyValue5, keyValue6, keyValue7, keyValue8, keyValue9, keyValue10, keyValue11, keyValue12});
                extension.setResourceList(new ExtensionResourceInfo[]{extensionResourceInfo});
                ExtensionEventTypeInfo extensionEventTypeInfo = new ExtensionEventTypeInfo();
                extensionEventTypeInfo.setEventID(UPS_EVENT_ALERT_ID);
                ExtensionEventTypeInfo extensionEventTypeInfo2 = new ExtensionEventTypeInfo();
                extensionEventTypeInfo2.setEventID(UPS_EVENT_WARNING_ID);
                ExtensionEventTypeInfo extensionEventTypeInfo3 = new ExtensionEventTypeInfo();
                extensionEventTypeInfo3.setEventID(UPS_EVENT_CLEAR_ID);
                extension.setEventList(new ExtensionEventTypeInfo[]{extensionEventTypeInfo, extensionEventTypeInfo2, extensionEventTypeInfo3});
                logger.debug("registerExtensionForUPSCriticalEvent - calling registerExtension");
                serviceInstance.getExtensionManager().registerExtension(extension);
            } else {
                logger.debug("registerExtensionForUPSCriticalEvent - extension already registered");
            }
        }
        catch (RemoteException remoteException) {
            logger.error("registerExtensionForUPSCriticalEvent - register alarm event extension failed", (Throwable)remoteException);
        }
        logger.debug("registerExtensionForUPSCriticalEvent - end");
    }

    public synchronized void unregisterExtensionForUPSCriticalEvent(ServiceInstance serviceInstance) {
        logger.debug("unregisterExtensionForUPSCriticalEvent - start");
        try {
            if (serviceInstance.getExtensionManager().findExtension(UPS_CRITICAL_EVENT_KEY) != null) {
                serviceInstance.getExtensionManager().unregisterExtension(UPS_CRITICAL_EVENT_KEY);
            } else {
                logger.warn("unregisterExtensionForUPSCriticalEvent - alarm event extension not found");
            }
        }
        catch (RemoteException remoteException) {
            logger.error("unregisterExtensionForUPSCriticalEvent - unregister alarm event extension failed", (Throwable)remoteException);
        }
        logger.debug("unregisterExtensionForUPSCriticalEvent - end");
    }

    private OrAlarmExpression createEventAlarmExpression() {
        OrAlarmExpression orAlarmExpression = new OrAlarmExpression();
        AlarmExpression[] alarmExpressionArray = new AlarmExpression[3];
        EventAlarmExpression eventAlarmExpression = new EventAlarmExpression();
        eventAlarmExpression.setEventType(ALARM_EXPRESSION_EVENT_TYPE);
        eventAlarmExpression.setEventTypeId(UPS_EVENT_ALERT_ID);
        eventAlarmExpression.setObjectType("HostSystem");
        eventAlarmExpression.setStatus(ManagedEntityStatus.red);
        alarmExpressionArray[0] = eventAlarmExpression;
        EventAlarmExpression eventAlarmExpression2 = new EventAlarmExpression();
        eventAlarmExpression2.setEventType(ALARM_EXPRESSION_EVENT_TYPE);
        eventAlarmExpression2.setEventTypeId(UPS_EVENT_WARNING_ID);
        eventAlarmExpression2.setObjectType("HostSystem");
        eventAlarmExpression2.setStatus(ManagedEntityStatus.yellow);
        alarmExpressionArray[1] = eventAlarmExpression2;
        EventAlarmExpression eventAlarmExpression3 = new EventAlarmExpression();
        eventAlarmExpression3.setEventType(ALARM_EXPRESSION_EVENT_TYPE);
        eventAlarmExpression3.setEventTypeId(UPS_EVENT_CLEAR_ID);
        eventAlarmExpression3.setObjectType("HostSystem");
        eventAlarmExpression3.setStatus(ManagedEntityStatus.green);
        alarmExpressionArray[2] = eventAlarmExpression3;
        orAlarmExpression.setExpression(alarmExpressionArray);
        return orAlarmExpression;
    }

    private void initialize() {
        this.hostSystemUtils = ServiceManager.getInstance().getHostSystemUtils();
        this.vmwareConfigUtils = ServiceManager.getInstance().getVirtualConfigurationManager();
        String string = kWebServerProperties;
        Locale locale = Locale.getDefault();
        ResourceBundleWrapper resourceBundleWrapper = Utils.getUTF8ResourceBundle(string, locale);
        this.theAlarmLocale = Locale.ENGLISH.getLanguage();
        if (Utils.isSupportedLocale(locale)) {
            this.theAlarmLocale = locale.getLanguage();
        }
        this.theAlarmName = Utils.getResourceString(resourceBundleWrapper, "CreateVCenterAlarm.AlarmName");
        this.theAlarmDescription = Utils.getResourceString(resourceBundleWrapper, "CreateVCenterAlarm.AlarmDescription");
        this.theAlarmUPSFailureWarningMessage = Utils.getResourceString(resourceBundleWrapper, "CreateVCenterAlarm.AlarmUPSFailureWarningMessage");
        this.theAlarmUPSFailureAlertMessage = Utils.getResourceString(resourceBundleWrapper, "CreateVCenterAlarm.AlarmUPSFailureAlertMessage");
        this.theAlarmUPSFailureClearMessage = Utils.getResourceString(resourceBundleWrapper, "CreateVCenterAlarm.AlarmUPSFailureClearMessage");
        this.theVersion = Utils.getResourceString(resourceBundleWrapper, "CreateVCenterPlugin.PluginVersion");
        this.theCompanyName = Utils.getResourceString(resourceBundleWrapper, "CreateVCenterPlugin.PluginVendor");
    }
}

