/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.vmware;

import com.apcc.m11.components.webserver.util.virtualization.vmware.ServiceInstanceConnectionResult;
import com.apcc.m11.components.webserver.util.virtualization.vmware.ServiceInstanceResult;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.trustmanagement.SavingTrustManager;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.NoPermission;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.ws.CustomSSLTrustContextCreator;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ESXiConnectionCallable
implements Callable<ServiceInstanceResult> {
    private static final Logger logger = LogManager.getLogger(ESXiConnectionCallable.class);
    String url = null;
    String hostIp = null;
    String username = null;
    String password = null;
    boolean skipCertCheck = false;

    public ESXiConnectionCallable(String string, String string2, String string3, String string4, boolean bl) {
        this.url = string;
        this.hostIp = string2;
        this.username = string3;
        this.password = string4;
        this.skipCertCheck = bl;
    }

    @Override
    public ServiceInstanceResult call() {
        logger.debug("call() - start, host: {}", (Object)this.hostIp);
        ServiceInstanceResult serviceInstanceResult = new ServiceInstanceResult();
        serviceInstanceResult.setServiceInstanceConnectionResult(ServiceInstanceConnectionResult.SUCCESS);
        try {
            ServiceInstance serviceInstance = this.makeServiceInstance(new URL(this.url), this.username, this.password, this.skipCertCheck);
            serviceInstanceResult.setServiceInstance(serviceInstance);
        }
        catch (NoPermission noPermission) {
            logger.error("call() - failed connecting to: {}, NoPermission: {} Steps for creating shared accounts are included in PCNS documentation", (Object)this.hostIp, (Object)noPermission.getMessage());
            serviceInstanceResult.setServiceInstanceConnectionResult(ServiceInstanceConnectionResult.NO_PERMISSION);
            serviceInstanceResult.setException((Exception)((Object)noPermission));
        }
        catch (InvalidLogin invalidLogin) {
            logger.error("call() - failed connecting to: {}, InvalidLogin: {}. Steps for creating shared accounts are included in PCNS documentation", (Object)this.hostIp, (Object)invalidLogin.getMessage());
            serviceInstanceResult.setServiceInstanceConnectionResult(ServiceInstanceConnectionResult.INVALID_LOGIN);
            serviceInstanceResult.setException((Exception)((Object)invalidLogin));
        }
        catch (RemoteException remoteException) {
            String string;
            logger.error("call() - failed connecting to: {}, RemoteException: {}", (Object)this.hostIp, (Object)remoteException);
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)remoteException);
            if (throwable instanceof UnknownHostException) {
                ServiceManager.getInstance().getShutdownLogger().logShutdownReason(this.hostIp, 228);
            }
            if ((string = remoteException.getMessage()).contains("InvalidLogin")) {
                ServiceManager.getInstance().getShutdownLogger().logShutdownReason(this.hostIp, 224);
            }
            if (string.contains("NoPermission") || string.contains("Permission denied")) {
                ServiceManager.getInstance().getShutdownLogger().logShutdownReason(this.hostIp, 226);
            }
            serviceInstanceResult.setServiceInstanceConnectionResult(ServiceInstanceConnectionResult.REMOTE_EXCEPTION);
            serviceInstanceResult.setException(remoteException);
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("call() - failed connecting to: {}, MalformedURLException: {}", (Object)this.hostIp, (Object)malformedURLException);
            serviceInstanceResult.setServiceInstanceConnectionResult(ServiceInstanceConnectionResult.MALFORMED_URL_EXCEPTION);
            serviceInstanceResult.setException(malformedURLException);
        }
        catch (Exception exception) {
            logger.error("call() - failed connecting to: {}, Exception: {}", (Object)this.hostIp, (Object)exception);
            serviceInstanceResult.setServiceInstanceConnectionResult(ServiceInstanceConnectionResult.EXCEPTION);
            serviceInstanceResult.setException(exception);
        }
        logger.debug("call() - end, result: {}", (Object)serviceInstanceResult.getServiceInstanceConnectionResult());
        return serviceInstanceResult;
    }

    private ServiceInstance makeServiceInstance(URL uRL, String string, String string2, boolean bl) throws RemoteException, MalformedURLException {
        ServiceInstance serviceInstance;
        if (bl) {
            serviceInstance = new ServiceInstance(uRL, string, string2, bl);
        } else {
            SavingTrustManager savingTrustManager = null;
            CustomSSLTrustContextCreator.setContextAlreadyCreated((boolean)false);
            try {
                savingTrustManager = ServiceManager.getInstance().getTrustStoreManager().makeSavingTrustManager();
                serviceInstance = new ServiceInstance(uRL, string, string2, (TrustManager)savingTrustManager);
            }
            catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
                logger.error("makeServiceInstance() Error getting Saving Trust Manager, just using certCheck instead", (Throwable)generalSecurityException);
                serviceInstance = new ServiceInstance(uRL, string, string2, bl);
            }
        }
        return serviceInstance;
    }
}

