/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.vmware;

import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.vmware.ApiTaskCallable;
import com.apcc.m11.components.shutdowner.vmware.HostMaintenanceMode;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.webserver.model.Host;
import com.apcc.m11.components.webserver.model.MappedHost;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.VMPrioritizationUtils;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.VirtualizationLoggingUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.AutoStartPolicyAction;
import com.apcc.m11.components.webserver.util.virtualization.vmware.ClusterUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.CreateVCenterAlarm;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostLoginException;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VirtualMachineUtils;
import com.apcc.m11.components.webserver.util.virtualization.vxrail.VxRailUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixService;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.util.IPUtils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import com.vmware.vim25.Action;
import com.vmware.vim25.AfterStartupTaskScheduler;
import com.vmware.vim25.AutoStartDefaults;
import com.vmware.vim25.AutoStartPowerInfo;
import com.vmware.vim25.AutoStartWaitHeartbeatSetting;
import com.vmware.vim25.ClusterDasFdmAvailabilityState;
import com.vmware.vim25.ClusterDasFdmHostState;
import com.vmware.vim25.DatastoreSummary;
import com.vmware.vim25.DrsBehavior;
import com.vmware.vim25.GuestInfo;
import com.vmware.vim25.HostAutoStartManagerConfig;
import com.vmware.vim25.HostConfigFault;
import com.vmware.vim25.HostConnectSpec;
import com.vmware.vim25.HostIpConfigIpV6Address;
import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostSystemConnectionState;
import com.vmware.vim25.HostSystemPowerState;
import com.vmware.vim25.HostVirtualNicConfig;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.MethodAction;
import com.vmware.vim25.MethodActionArgument;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.ScheduledTaskSpec;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TaskScheduler;
import com.vmware.vim25.Timedout;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostAutoStartManager;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ScheduledTask;
import com.vmware.vim25.mo.ScheduledTaskManager;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.TaskManager;
import com.vmware.vim25.mo.VirtualApp;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HostSystemUtils {
    private static final String POWER_ON_VM_TASK_METHOD_NAME = "PowerOnVM_Task";
    private static final String PCNS_STARTUP_TASK_NAME = "VxRail.StartupTaskName";
    private static final String PCNS_STARTUP_TASK_DESCRIPTION = "VxRail.StartupTaskDescription";
    private static final int RETRIES = 3;
    private static final Logger logger = LogManager.getLogger(HostSystemUtils.class);
    public static final int DELAY_AFTER_EXIT_MAINTENANCE_MODE = 30;
    public static final String VSAN_DATASTORE_TYPE = "vsan";
    @NonNull
    private ClusterUtils clusterUtils;
    @NonNull
    private VirtualizationLoggingUtils virtualLoggingUtils;
    @NonNull
    private VirtualConfigurationManager virtualConfigurationManager;
    @NonNull
    private ConfigurationManager configurationManager;
    @NonNull
    private VsanUtils vsanUtils;
    @NonNull
    private VMPrioritizationUtils vmPrioritizationUtils;
    @NonNull
    private VirtualMachineUtils virtualMachineUtils;
    @NonNull
    private VirtualisationStatusStore virtualisationStatusStore;
    @NonNull
    private VMWareConnection vmwareConnection;
    @NonNull
    private VxRailUtils vxRailUtils;
    @NonNull
    private Utils utils;
    private AdvancedSetupHelper advancedSetupHelper;
    private Map<String, Lock> hostsComingOutOfMaintenanceMode = new HashMap<String, Lock>();

    public HostSystemUtils() {
    }

    public HostSystemUtils(@NonNull ClusterUtils clusterUtils, @NonNull VirtualizationLoggingUtils virtualizationLoggingUtils, @NonNull VirtualConfigurationManager virtualConfigurationManager, @NonNull VsanUtils vsanUtils, @NonNull AdvancedSetupHelper advancedSetupHelper, @NonNull ConfigurationManager configurationManager) {
        if (clusterUtils == null) {
            throw new IllegalArgumentException("clusterUtils is marked non-null but is null");
        }
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("loggingUtils is marked non-null but is null");
        }
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfig is marked non-null but is null");
        }
        if (vsanUtils == null) {
            throw new IllegalArgumentException("vsanUtils is marked non-null but is null");
        }
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        if (configurationManager == null) {
            throw new IllegalArgumentException("configurationManager is marked non-null but is null");
        }
        this.clusterUtils = clusterUtils;
        this.virtualLoggingUtils = virtualizationLoggingUtils;
        this.virtualConfigurationManager = virtualConfigurationManager;
        this.vsanUtils = vsanUtils;
        this.advancedSetupHelper = advancedSetupHelper;
        this.configurationManager = configurationManager;
    }

    public HostSystemUtils setAdvancedSetupHelper(AdvancedSetupHelper advancedSetupHelper) {
        this.advancedSetupHelper = advancedSetupHelper;
        return this;
    }

    public boolean isHostSystemValid(HostSystem hostSystem, String string) {
        boolean bl = true;
        try {
            hostSystem.getName();
            logger.debug("isHostSystemValid() - hostSystem for host: {} is valid", (Object)string);
        }
        catch (Exception exception) {
            logger.info("isHostSystemValid() - hostSystem for host: {} is invalid", (Object)string);
            bl = false;
        }
        return bl;
    }

    public boolean checkIfHostIsPoweredOff(HostSystem hostSystem) {
        boolean bl = false;
        try {
            if (hostSystem != null && hostSystem.getRuntime() != null) {
                logger.debug("checkIfHostIsPoweredOff() - host: {}", (Object)hostSystem.getName());
                if (hostSystem.getRuntime().getPowerState() == HostSystemPowerState.poweredOff) {
                    if (hostSystem.getRuntime().getConnectionState() == HostSystemConnectionState.connected) {
                        bl = true;
                        logger.info("checkIfHostIsPoweredOff() - powered off {}", (Object)hostSystem.getName());
                    } else {
                        logger.debug("checkIfHostIsPoweredOff() - not connected");
                    }
                } else {
                    logger.debug("checkIfHostIsPoweredOff() - not powered off");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            logger.error("checkIfHostIsPoweredOff() - RuntimeException: " + String.valueOf(runtimeException));
        }
        catch (Exception exception) {
            logger.error("checkIfHostIsPoweredOff() - Exception: " + String.valueOf(exception));
        }
        logger.debug("checkIfHostIsPoweredOff() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean checkIfHostIsPoweredOn(HostSystem hostSystem) {
        boolean bl = false;
        try {
            if (hostSystem != null && hostSystem.getRuntime() != null) {
                logger.debug("checkIfHostIsPoweredOn() - host: {}", (Object)hostSystem.getName());
                if (hostSystem.getRuntime().getPowerState() == HostSystemPowerState.poweredOn) {
                    if (hostSystem.getRuntime().getConnectionState() == HostSystemConnectionState.connected) {
                        logger.debug("checkIfHostIsPoweredOn() - host is powered on");
                        bl = true;
                    } else {
                        logger.warn("checkIfHostIsPoweredOn() - not connected, ConnectionState: {}", (Object)hostSystem.getRuntime().getConnectionState());
                    }
                } else {
                    logger.warn("checkIfHostIsPoweredOn() - not powered on, PowerState: {}", (Object)hostSystem.getRuntime().getPowerState());
                }
            } else {
                logger.debug("checkIfHostIsPoweredOn() - hostSystem or hostSystem.getRuntime() is null");
            }
        }
        catch (RuntimeException runtimeException) {
            logger.error("checkIfHostIsPoweredOn() - RuntimeException: " + String.valueOf(runtimeException));
        }
        catch (Exception exception) {
            logger.error("checkIfHostIsPoweredOn() - Exception: " + String.valueOf(exception));
        }
        logger.debug("checkIfHostIsPoweredOn() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean checkIfHostIsResponding(HostSystem hostSystem) {
        boolean bl = true;
        try {
            if (hostSystem != null && hostSystem.getRuntime() != null) {
                logger.debug("checkIfHostIsResponding() - host: {}", (Object)hostSystem.getName());
                if (hostSystem.getRuntime().getPowerState() == HostSystemPowerState.unknown) {
                    if (hostSystem.getRuntime().getConnectionState() == HostSystemConnectionState.notResponding) {
                        bl = false;
                        logger.info("checkIfHostIsResponding() - host is not responding");
                    } else {
                        logger.info("checkIfHostIsResponding() - host power state is not unknown");
                    }
                } else {
                    logger.debug("checkIfHostIsResponding() - host is responding");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            logger.error("checkIfHostIsResponding() - RuntimeException: " + String.valueOf(runtimeException));
        }
        catch (Exception exception) {
            logger.error("checkIfHostIsResponding() - Exception: " + String.valueOf(exception));
        }
        logger.debug("checkIfHostIsResponding() - result: {}", (Object)bl);
        return bl;
    }

    public boolean checkIfHostIsInInvalidState(HostSystem hostSystem) {
        boolean bl = false;
        try {
            logger.debug("checkIfHostIsInInvalidState() - start");
            if (hostSystem != null && hostSystem.getRuntime() != null && hostSystem.getRuntime().getConnectionState().toString().equalsIgnoreCase(HostSystemConnectionState.connected.toString()) && hostSystem.getRuntime().getPowerState().toString().equalsIgnoreCase(HostSystemPowerState.poweredOff.toString())) {
                logger.info("checkIfHostIsInInvalidState() - possibly invalid state, reconnecting host: {}", (Object)hostSystem.getName());
                bl = true;
                Task task = hostSystem.disconnectHost();
                if (task.waitForTask().equals("success")) {
                    logger.debug("checkIfHostIsInInvalidState() - successfully disconnected host");
                    task = hostSystem.reconnectHost_Task(new HostConnectSpec());
                    if (task.waitForTask().equals("success")) {
                        logger.info("checkIfHostIsInInvalidState() - successfully reconnected host");
                        bl = false;
                    } else {
                        logger.info("checkIfHostIsInInvalidState() - failed to reconnect host");
                    }
                } else {
                    logger.info("checkIfHostIsInInvalidState() - failed to disconnect host");
                }
            }
        }
        catch (Exception exception) {
            logger.error("checkIfHostIsInInvalidState() - Exception: ", (Throwable)exception);
        }
        return bl;
    }

    public HashSet<HostSystem> computeTargetHostList(Set<HostSystem> set) {
        HashSet<HostSystem> hashSet = new HashSet<HostSystem>();
        logger.debug("computeTargetHostList() - start");
        for (HostSystem hostSystem : set) {
            if (!this.virtualisationStatusStore.isHostLockedForShutdown(hostSystem.getName())) {
                hashSet.add(hostSystem);
                logger.debug("computeTargetHostList() - possible target host: {}", (Object)hostSystem.getName());
                continue;
            }
            logger.info("computeTargetHostList() - unsuitable critical target host: {}", (Object)hostSystem.getName());
        }
        logger.debug("computeTargetHostList() - end");
        return hashSet;
    }

    public boolean checkIfHostIsInMaintenanceMode(HostSystem hostSystem) {
        return hostSystem.getRuntime().isInMaintenanceMode();
    }

    public HostMaintenanceMode getHostMaintenanceModeInstance(String string, boolean bl, ShutdownState shutdownState, int n, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        HostMaintenanceMode hostMaintenanceMode = new HostMaintenanceMode(string, bl, shutdownState, n, serviceManager);
        return hostMaintenanceMode;
    }

    public String executeHostMaintenanceModeWithWait(HostSystem hostSystem, int n) throws Timedout, InvalidState, RuntimeFault, RemoteException, InterruptedException {
        String string = null;
        Task task = hostSystem.enterMaintenanceMode(n, false);
        logger.debug("verifyHostInMaintenanceMode() - wait for Maintenance Mode task");
        if (!task.waitForTask().equals("success")) {
            string = "Unknown";
            if (task.getTaskInfo() != null) {
                logger.debug("verifyHostInMaintenanceMode() - Maintenance Mode task state: {}", (Object)task.getTaskInfo().getState());
                if (task.getTaskInfo().getState() == TaskInfoState.error && task.getTaskInfo().getError() != null) {
                    string = task.getTaskInfo().getError().getLocalizedMessage();
                }
            }
        }
        return string;
    }

    public Task executeHostMaintenanceMode(HostSystem hostSystem, int n) throws Timedout, InvalidState, RuntimeFault, RemoteException {
        Task task = null;
        if (hostSystem.getRuntime().isInMaintenanceMode()) {
            logger.debug("putHostIntoMaintenanceMode() - host already in maintenance mode");
        } else if (hostSystem.getRuntime().getPowerState() != HostSystemPowerState.poweredOn) {
            logger.debug("putHostIntoMaintenanceMode() - host is not powered on");
        } else {
            task = hostSystem.enterMaintenanceMode(n, false);
        }
        return task;
    }

    public boolean executeHostShutdown(HostSystem hostSystem, String string, String string2) {
        Task task;
        boolean bl = false;
        logger.info("executeHostShutdown() - start, host: {}", (Object)string);
        CreateVCenterAlarm.getInstance().createUPSCriticalEvent(hostSystem.getName(), "alert");
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            logger.debug("executeHostShutdown() - checking if host is PCNS host");
            task = hostSystem.getServerConnection().getServiceInstance();
            if (this.isPCNSHost((ServiceInstance)task, string2, string, null)) {
                logger.info("executeHostShutdown() - PCNS Host Shutdown {} - Wait for logging", (Object)string);
                try {
                    int n = this.configurationManager.getInt("Shutdown", "shutdownCommandDuration", 30);
                    logger.info("executeHostShutdown() - PCNS Host Shutdown - shutdownCommandDuration: {}", (Object)n);
                    TimeUnit.SECONDS.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    logger.info("executeHostShutdown() - Wait was interrupted", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
                logger.info("executeHostShutdown() - PCNS Host Shutdown  - Wait for logging done");
            } else {
                logger.info("executeHostShutdown() - PCNS Host Shutdown - Not PCNS Host {}", (Object)string);
            }
        }
        try {
            task = hostSystem.shutdownHost_Task(true);
            bl = this.waitForApiTask(task);
        }
        catch (RemoteException remoteException) {
            logger.error("executeHostShutdown() - InterruptedException: {}, host: {}", (Object)remoteException.getLocalizedMessage(), (Object)string);
            String string3 = remoteException.getMessage();
            if (string3.contains("NoPermission") || string3.contains("Permission denied")) {
                ServiceManager.getInstance().getShutdownLogger().logShutdownReason(string, 226);
            }
            if (string3.contains("InvalidLogin")) {
                ServiceManager.getInstance().getShutdownLogger().logShutdownReason(string, 224);
            }
        }
        catch (Exception exception) {
            logger.error("executeHostShutdown() - Exception: {}, host: {}", (Object)exception.getLocalizedMessage(), (Object)string);
        }
        logger.info("executeHostShutdown() - end, result: {}", (Object)bl);
        return bl;
    }

    private boolean waitForApiTask(Task task) {
        boolean bl;
        block7: {
            bl = false;
            logger.debug("waitForApiTask() - start");
            try {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                Future<Boolean> future = executorService.submit(new ApiTaskCallable(task));
                executorService.shutdown();
                if (!executorService.awaitTermination(this.virtualConfigurationManager.getApiTaskWaitTimeout(), TimeUnit.SECONDS)) {
                    logger.error("waitForApiTask() - task timed out");
                    executorService.shutdownNow();
                    break block7;
                }
                logger.debug("waitForApiTask() - task completed");
                try {
                    Boolean bl2 = future.get();
                    if (bl2 != null && bl2.booleanValue()) {
                        bl = true;
                    }
                }
                catch (ExecutionException executionException) {
                    logger.error("waitForApiTask() - ExecutionException: {}", (Object)executionException.getLocalizedMessage());
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error("waitForApiTask() - InterruptedException: {}", (Object)interruptedException.getLocalizedMessage());
            }
            catch (Exception exception) {
                logger.error("waitForApiTask() - Exception: {}", (Object)exception.getLocalizedMessage());
            }
        }
        return bl;
    }

    public HostSystem getHostOfVirtualMachine(VirtualMachine virtualMachine, ServiceInstance serviceInstance) {
        HostSystem hostSystem = null;
        logger.debug("getHostOfVirtualMachine() - start");
        if (serviceInstance != null && virtualMachine != null && virtualMachine.getRuntime() != null) {
            hostSystem = new HostSystem(serviceInstance.getServerConnection(), virtualMachine.getRuntime().getHost());
        }
        logger.debug("getHostOfVirtualMachine() - end, result: {}", hostSystem);
        return hostSystem;
    }

    public boolean isVCSAShuttingDown(ServiceInstance serviceInstance) {
        boolean bl = false;
        logger.debug("isVCSAShuttingDown() - start");
        if (serviceInstance == null) {
            logger.info("isVCSAShuttingDown() - serviceInstance is null");
            return true;
        }
        if (this.vmwareConnection.isVCenterOffline()) {
            try {
                if ("VirtualCenter".equalsIgnoreCase(serviceInstance.getAboutInfo().getApiType())) {
                    logger.info("isVCSAShuttingDown() - VCSA is shutting down");
                    bl = true;
                }
            }
            catch (Exception exception) {
                logger.error("isVCSAShuttingDown() - Exception: {}" + exception.getLocalizedMessage());
            }
        }
        logger.debug("isVCSAShuttingDown() - end, result: {}", (Object)bl);
        return bl;
    }

    public VirtualMachine getVirtualMachineUsingUUID(ServiceInstance serviceInstance, String string) {
        VirtualMachine virtualMachine = null;
        logger.debug("getVirtualMachineUsingUUID() - start");
        try {
            ManagedEntity managedEntity;
            if (this.isVCSAShuttingDown(serviceInstance)) {
                return null;
            }
            if (string != null && (managedEntity = serviceInstance.getSearchIndex().findByUuid(null, string, true)) instanceof VirtualMachine) {
                virtualMachine = (VirtualMachine)managedEntity;
            }
        }
        catch (Exception exception) {
            logger.error("getVirtualMachineUsingUUID() - Exception: ", (Throwable)exception);
        }
        logger.debug("getVirtualMachineUsingUUID() - end");
        return virtualMachine;
    }

    public HostSystem getHostSystemUsingVMUUID(ServiceInstance serviceInstance, String string) {
        HostSystem hostSystem = null;
        logger.debug("getHostSystemUsingVMUUID() - start");
        try {
            VirtualMachine virtualMachine;
            if (string != null && (virtualMachine = this.getVirtualMachineUsingUUID(serviceInstance, string)) != null) {
                hostSystem = this.getHostOfVirtualMachine(virtualMachine, serviceInstance);
            }
        }
        catch (Exception exception) {
            logger.error("getHostSystemUsingVMUUID() - Exception: ", (Throwable)exception);
        }
        logger.debug("getHostSystemUsingVMUUID() - end");
        return hostSystem;
    }

    public VirtualMachine[] getVirtualMachines(HostSystem hostSystem) throws InvalidProperty, RuntimeFault, RemoteException {
        return hostSystem.getVms();
    }

    public VirtualMachine getVCenterServerVM() {
        logger.debug("getVCSAVM() - start");
        ServiceInstance serviceInstance = null;
        if (this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
            serviceInstance = this.vmwareConnection.getVCenterConnection();
        }
        return this.getVCenterServerVM(serviceInstance);
    }

    public VirtualMachine getVCenterServerVM(ServiceInstance serviceInstance) {
        logger.debug("getVCenterServerVM() - start");
        VirtualMachine virtualMachine = null;
        String string = null;
        if (serviceInstance == null || this.isVCSAShuttingDown(serviceInstance)) {
            return null;
        }
        try {
            string = this.virtualConfigurationManager.getServerIP();
            if (string != null && this.virtualConfigurationManager.isManagedHost()) {
                logger.debug("getVCenterServerVM() - vCenterServerIP ({}) != null and isManagedHost", (Object)string);
                ManagedEntity managedEntity = null;
                managedEntity = serviceInstance.getSearchIndex().findByIp(null, string, true);
                if (managedEntity == null) {
                    logger.debug("getVCenterServerVM() - checking for vCSA using findByDnsName");
                    managedEntity = serviceInstance.getSearchIndex().findByDnsName(null, string, true);
                }
                if (managedEntity == null) {
                    logger.debug("getVCenterServerVM() - convert vCSA host name to IP");
                    InetAddress inetAddress = InetAddress.getByName(string);
                    managedEntity = serviceInstance.getSearchIndex().findByIp(null, inetAddress.getHostAddress(), true);
                }
                if (managedEntity != null && managedEntity instanceof VirtualMachine) {
                    virtualMachine = (VirtualMachine)managedEntity;
                    logger.debug("getVCenterServerVM() - found vCSA: {}", (Object)virtualMachine.getName());
                }
            }
        }
        catch (Exception exception) {
            logger.warn("getVCenterServerVM() - Exception: ", (Throwable)exception);
        }
        logger.debug("getVCenterServerVM() - end");
        return virtualMachine;
    }

    public HostSystem getHostSystemWithVCSAInstalled() {
        HostSystem hostSystem = null;
        logger.debug("getHostSystemWithVCSAInstalled() - start");
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        VirtualMachine virtualMachine = this.getVCenterServerVM(serviceInstance);
        if (virtualMachine != null) {
            hostSystem = this.getHostOfVirtualMachine(virtualMachine, serviceInstance);
        }
        logger.debug("getHostSystemWithVCSAInstalled() - end, result: {}", hostSystem);
        return hostSystem;
    }

    public boolean isVCenterServerInstalledOnTargetHost() {
        HostSystem hostSystem;
        if (!this.virtualConfigurationManager.isManagedHost()) {
            return false;
        }
        logger.trace("isVCenterServerInstalledOnTargetHost() - start");
        if (this.vmwareConnection.isVCenterOffline()) {
            logger.info("isVCenterServerInstalledOnTargetHost() - VCSA is shutting down, returning true");
            return true;
        }
        boolean bl = false;
        ServiceInstance serviceInstance = null;
        if (this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
            serviceInstance = this.vmwareConnection.getVCenterConnection();
        }
        VirtualMachine virtualMachine = this.getVCenterServerVM(serviceInstance);
        String string = this.getVirtualCentreServerApplianceVirtualMachineName();
        if (virtualMachine == null) {
            logger.debug("isVCenterServerInstalledOnTargetHost() - get VCSA via VCSA Name from property file");
            if (string != null) {
                logger.info("isVCenterServerInstalledOnTargetHost() - VCSA Name: {}", (Object)string);
                try {
                    if (serviceInstance != null && (hostSystem = new InventoryNavigator((ManagedEntity)serviceInstance.getRootFolder()).searchManagedEntity("VirtualMachine", string)) instanceof VirtualMachine) {
                        virtualMachine = (VirtualMachine)hostSystem;
                        logger.info("isVCenterServerInstalledOnTargetHost() - VCSA VM Name: {}", (Object)virtualMachine.getName());
                    }
                }
                catch (RemoteException remoteException) {
                    logger.error("isVCenterServerInstalledOnTargetHost() - RemoteException: " + String.valueOf(remoteException));
                }
            } else {
                logger.debug("isVCenterServerInstalledOnTargetHost() - VCSA Name not found in properties file");
            }
        }
        if (virtualMachine != null) {
            hostSystem = this.getHostOfVirtualMachine(virtualMachine, serviceInstance);
            if (hostSystem != null) {
                List<String> list = null;
                if (this.isVCenterManagedAdvancedMode()) {
                    Map<String, MappedHost> map = this.advancedSetupHelper.readMappedHostsFromConfig();
                    if (map != null && map.size() > 0) {
                        list = new ArrayList<String>(map.keySet());
                    }
                } else {
                    list = this.virtualConfigurationManager.parseHostListParameter("HostConfigSettings");
                }
                logger.info("isVCenterServerInstalledOnTargetHost() - targetHosts: {}", list);
                if (list != null && !list.isEmpty()) {
                    for (String string2 : list) {
                        if (!string2.equalsIgnoreCase(hostSystem.getName())) continue;
                        bl = true;
                        logger.info("isVCenterServerInstalledOnTargetHost() - VCenterServer is installed on targetHost: {}", (Object)string2);
                        break;
                    }
                }
            } else {
                logger.debug("isVCenterServerInstalledOnTargetHost() - vCSAHostSystem is null");
            }
        } else {
            logger.debug("isVCenterServerInstalledOnTargetHost() - VCSA not found");
        }
        logger.debug("isVCenterServerInstalledOnTargetHost() - end, result: {}", (Object)bl);
        return bl;
    }

    public String getVirtualCentreServerApplianceVirtualMachineName() {
        String string = this.virtualisationStatusStore.getProperty("VCSA_VM");
        logger.debug("getVirtualCentreServerApplianceVirtualMachineName() - VCSA VM Name: {0}", (Object)string);
        return string;
    }

    public boolean isVCenterServerInstalledOnTargetHost(LinkedHashSet<String> linkedHashSet) {
        boolean bl = false;
        logger.debug("isVCenterServerInstalledOnTargetHost() - start");
        if (linkedHashSet == null) {
            bl = this.isVCenterServerInstalledOnTargetHost();
        } else if (this.isVCenterManagedAdvancedMode()) {
            HostSystem hostSystem;
            VirtualMachine virtualMachine;
            ServiceInstance serviceInstance = null;
            if (this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
                serviceInstance = this.vmwareConnection.getVCenterConnection();
            }
            if ((virtualMachine = this.getVCenterServerVM(serviceInstance)) != null && (hostSystem = this.getHostOfVirtualMachine(virtualMachine, serviceInstance)) != null) {
                String string = this.getESXiHostIPAddress(hostSystem);
                for (String string2 : linkedHashSet) {
                    if (!string2.equals(hostSystem.getName()) && !string2.equalsIgnoreCase(string)) continue;
                    bl = true;
                    break;
                }
            }
        }
        logger.info("isVCenterServerInstalledOnTargetHost() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isVCenterManagedAdvancedMode() {
        return this.virtualConfigurationManager.isESXi() && this.virtualConfigurationManager.isManagedHost() && this.advancedSetupHelper.isAdvancedShutdownMode();
    }

    public boolean isVCenterServerInstalledOnCriticalHost(Set<String> set, ServiceInstance serviceInstance) {
        HostSystem hostSystem;
        logger.debug("isVCenterServerInstalledOnCriticalHost() - start");
        boolean bl = false;
        VirtualMachine virtualMachine = this.getVCenterServerVM(serviceInstance);
        if (virtualMachine != null && (hostSystem = this.getHostOfVirtualMachine(virtualMachine, serviceInstance)) != null) {
            for (String string : set) {
                if (!string.equalsIgnoreCase(hostSystem.getName()) && (!this.virtualConfigurationManager.isCheckVcsaIpAddressEnabled() || !this.isESXiHostIPAddress(string, hostSystem))) continue;
                bl = true;
                logger.info("isVCenterServerInstalledOnCriticalHost() - Installed on Critical Host");
                break;
            }
        }
        logger.debug("isVCenterServerInstalledOnCriticalHost() - end, result: {}", (Object)bl);
        return bl;
    }

    public String getVCSAHost() {
        String string = null;
        logger.debug("getVCSAHost() - start");
        HostSystem hostSystem = this.getHostSystemWithVCSAInstalled();
        if (hostSystem != null) {
            string = hostSystem.getName();
        }
        logger.debug("getVCSAHost() - end: result: {}", (Object)string);
        return string;
    }

    public boolean isVCenterServerInstalledOnVM(VirtualMachine virtualMachine, ServiceInstance serviceInstance) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        VirtualMachine virtualMachine2 = null;
        logger.debug("isVCenterServerInstalledOnVM() - start");
        try {
            virtualMachine2 = this.getVCenterServerVM(serviceInstance);
            if (virtualMachine2 != null) {
                string = virtualMachine2.getGuest().getIpAddress();
                string2 = virtualMachine2.getGuest().getHostName();
            } else {
                string = this.virtualConfigurationManager.getServerIP();
            }
            string3 = virtualMachine.getGuest().getIpAddress();
            string4 = virtualMachine.getGuest().getHostName();
            if (string != null && string3 != null && string.equalsIgnoreCase(string3) || string2 != null && string4 != null && string2.equalsIgnoreCase(string4)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            logger.error("isVCenterServerInstalledOnVM() - Exception: " + String.valueOf(exception));
        }
        logger.debug("isVCenterServerInstalledOnVM() - end, result: {}", (Object)bl);
        return bl;
    }

    public Set<VirtualMachine> getVirtualMachinesForHost(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        logger.debug("getVirtualMachinesForHost() - {}", (Object)string);
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("getVirtualMachinesForHost() - Can't find VMs for a blank host");
        }
        HashSet<VirtualMachine> hashSet = new HashSet<VirtualMachine>();
        try {
            HostSystem hostSystem = this.getHostSystem(string);
            if (hostSystem != null) {
                VirtualMachine[] virtualMachineArray;
                for (VirtualMachine virtualMachine : virtualMachineArray = hostSystem.getVms()) {
                    hashSet.add(virtualMachine);
                }
            } else {
                logger.warn("getVirtualMachinesForHost() - Host requested was not found among cluster hosts: {}", (Object)string);
            }
        }
        catch (RemoteException remoteException) {
            logger.warn("getVirtualMachinesForHost() - Failed to pull list of VMs from host: {}", (Object)string);
        }
        logger.debug("getVirtualMachinesForHost() - Result: {}", hashSet);
        return hashSet;
    }

    public List<PrioritizedVM> getPrioritizationVMs() {
        logger.debug("getPrioritizationVMs() - start");
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnectionWithRetries();
        if (serviceInstance == null) {
            logger.info("no vCenter Server connection");
            return null;
        }
        ArrayList<PrioritizedVM> arrayList = new ArrayList<PrioritizedVM>();
        List<String> list = this.virtualConfigurationManager.getMappedHostsList();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        String string = "";
        VirtualMachine virtualMachine = this.getVirtualMachineOnWhichPCNSInstalled(serviceInstance);
        if (virtualMachine != null) {
            string = virtualMachine.getName();
        }
        String string2 = "";
        VirtualMachine virtualMachine2 = this.getVCenterServerVM(serviceInstance);
        if (virtualMachine2 != null) {
            string2 = virtualMachine2.getName();
        }
        String string3 = this.getWitnessHostIp();
        try {
            Optional<ComputeResource> optional;
            HashSet<ComputeResource> hashSet = new HashSet<ComputeResource>();
            for (String string4 : list) {
                HostSystem hostSystem = this.getHostSystem(string4);
                optional = this.clusterUtils.getComputeResource((ManagedEntity)hostSystem);
                if (!optional.isPresent() || hashSet.stream().anyMatch(computeResource -> StringUtils.equalsIgnoreCase((CharSequence)computeResource.getName(), (CharSequence)((ComputeResource)optional.get()).getName()))) continue;
                hashSet.add(optional.get());
            }
            for (ComputeResource computeResource2 : hashSet) {
                Object object;
                String string5 = computeResource2.getName();
                optional = this.clusterUtils.getDatacenter((ManagedEntity)computeResource2);
                String string6 = optional.isPresent() ? ((Datacenter)optional.get()).getName() : "";
                for (VirtualMachine virtualMachine3 : object = computeResource2.getResourcePool().getVMs()) {
                    String string7 = virtualMachine3.getName();
                    if (!this.isValidPriorityVM(virtualMachine3) || StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)string7)) continue;
                    PrioritizedVM prioritizedVM = new PrioritizedVM();
                    prioritizedVM.setCluster(string5);
                    prioritizedVM.setDataCenter(string6);
                    prioritizedVM.setVMName(string7);
                    prioritizedVM.setVirtualMachine(virtualMachine3);
                    prioritizedVM.setVCSA(StringUtils.equalsIgnoreCase((CharSequence)string2, (CharSequence)string7));
                    if (StringUtils.isNotBlank((CharSequence)string3) && this.isVMIpAddressMatch(virtualMachine3, string3)) {
                        prioritizedVM.setvSanWitness(true);
                    }
                    logger.info("getPrioritizationVMs() - added VM: {}", (Object)string7);
                    arrayList.add(prioritizedVM);
                }
            }
            Iterator<String> iterator = new InventoryNavigator((ManagedEntity)serviceInstance.getRootFolder()).searchManagedEntities("VirtualApp");
            ArrayList<VirtualApp> arrayList2 = new ArrayList<VirtualApp>();
            for (Object object : iterator) {
                if (!(object instanceof VirtualApp)) continue;
                arrayList2.add((VirtualApp)object);
            }
            List list2 = arrayList2.stream().filter(virtualApp -> this.clusterUtils.hasParent((ManagedEntity)virtualApp, hashSet)).map(virtualApp -> {
                String string = virtualApp.getName();
                PrioritizedVM prioritizedVM = new PrioritizedVM();
                Optional<ClusterComputeResource> optional = this.clusterUtils.getClusterForVirtualApp((VirtualApp)virtualApp);
                Optional<Datacenter> optional2 = this.clusterUtils.getDatacenter((ManagedEntity)virtualApp);
                prioritizedVM.setCluster(optional.isPresent() ? optional.get().getName() : "");
                prioritizedVM.setDataCenter(optional2.isPresent() ? optional2.get().getName() : "");
                prioritizedVM.setVMName(string);
                prioritizedVM.setVirtualApp(true);
                logger.info("getPrioritizationVMs() - added vApp: {}", (Object)string);
                return prioritizedVM;
            }).collect(Collectors.toList());
            arrayList.addAll(list2);
        }
        catch (RemoteException remoteException) {
            logger.error("getPrioritizationVMs() - RemoteException: ", (Throwable)remoteException);
            arrayList = null;
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            throw exception;
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            Collections.sort(arrayList);
        }
        logger.debug("getPrioritizationVMs() - end");
        return arrayList;
    }

    public VirtualMachine getVirtualMachineOnWhichPCNSInstalled() {
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        return this.getVirtualMachineOnWhichPCNSInstalled(serviceInstance);
    }

    public VirtualMachine getVirtualMachineOnWhichPCNSInstalled(ServiceInstance serviceInstance) {
        VirtualMachine virtualMachine = null;
        String string = null;
        Boolean bl = false;
        logger.debug("getVirtualMachineOnWhichPCNSInstalled() - start");
        if (this.isVCSAShuttingDown(serviceInstance)) {
            return null;
        }
        try {
            string = this.configurationManager.getString("Networking", "localHostAddress");
            if (this.configurationManager.getString("Networking", "NetworkConfig").equalsIgnoreCase("IPV6")) {
                logger.debug("getVirtualMachineOnWhichPCNSInstalled() - IPV6 is true, vMA IP: {}", (Object)string);
                bl = true;
                if (StringUtils.contains((CharSequence)string, (CharSequence)"%")) {
                    string = StringUtils.substringBefore((String)string, (String)"%");
                }
                string = this.virtualConfigurationManager.getCompressedAddress(string);
            }
        }
        catch (ConversionException conversionException) {
            logger.error("getVirtualMachineOnWhichPCNSInstalled() - ConversionException: ", (Throwable)conversionException);
        }
        catch (Exception exception) {
            logger.error("getVirtualMachineOnWhichPCNSInstalled() - Exception: ", (Throwable)exception);
        }
        try {
            VirtualMachine virtualMachine2;
            if (StringUtils.isBlank((CharSequence)string)) {
                string = IPUtils.getCurrentAddress(bl);
            }
            if ((virtualMachine2 = this.getVirtualMachineByIp(serviceInstance, string)) == null) {
                virtualMachine2 = this.getVirtualMachineByDnsName(serviceInstance, string);
            }
            if (virtualMachine2 == null) {
                virtualMachine2 = this.getVirtualMachineByHostname(serviceInstance, string);
            }
            if (virtualMachine2 == null) {
                String string2 = this.virtualConfigurationManager.getPCNSVmName();
                if (StringUtils.isNotBlank((CharSequence)string2)) {
                    virtualMachine = this.virtualMachineUtils.getVirtualMachineFromVMName(serviceInstance, string2);
                }
            } else {
                virtualMachine = virtualMachine2;
                this.virtualConfigurationManager.setPCNSVmName(virtualMachine.getName());
            }
        }
        catch (Exception exception) {
            logger.error("getVirtualMachineOnWhichPCNSInstalled() - Exception: " + String.valueOf(exception));
        }
        logger.debug("getVirtualMachineOnWhichPCNSInstalled() - end");
        return virtualMachine;
    }

    public VirtualMachine getVirtualMachineByHostname(@NonNull ServiceInstance serviceInstance, @NonNull String string) {
        if (serviceInstance == null) {
            throw new IllegalArgumentException("serviceInstance is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("ip is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.warn("getVirtualMachineByHostname() - Can't look up a blank hostname...");
            return null;
        }
        VirtualMachine virtualMachine = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            logger.debug("getVirtualMachineByHostname() - Find VM by hostname: {}", (Object)inetAddress);
            virtualMachine = (VirtualMachine)serviceInstance.getSearchIndex().findByIp(null, inetAddress.getHostAddress(), true);
            logger.debug("getVirtualMachineByHostname() - Found VM by hostname: {}", (Object)(virtualMachine != null ? 1 : 0));
        }
        catch (UnknownHostException | RemoteException iOException) {
            logger.error("getVirtualMachineByHostname() - Exception: {}", (Throwable)iOException);
        }
        return virtualMachine;
    }

    public VirtualMachine getVirtualMachineByDnsName(@NonNull ServiceInstance serviceInstance, @NonNull String string) {
        if (serviceInstance == null) {
            throw new IllegalArgumentException("serviceInstance is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("dnsName is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.warn("getVirtualMachineByDnsName() - Can't look up a blank DNS name...");
            return null;
        }
        VirtualMachine virtualMachine = null;
        try {
            logger.debug("getVirtualMachineByDnsName() - Find VM by DNS Name: {}", (Object)string);
            virtualMachine = (VirtualMachine)serviceInstance.getSearchIndex().findByDnsName(null, string, true);
            logger.debug("getVirtualMachineByDnsName() - Found VM by DNS Name: {}", (Object)(virtualMachine != null ? 1 : 0));
        }
        catch (RemoteException remoteException) {
            logger.error("getVirtualMachineByDnsName() - Exception: {}", (Throwable)remoteException);
        }
        return virtualMachine;
    }

    public VirtualMachine getVirtualMachineByDnsName(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("dnsName is marked non-null but is null");
        }
        return this.getVirtualMachineByDnsName(this.vmwareConnection.getVCenterConnection(), string);
    }

    public VirtualMachine getVirtualMachineByIp(@NonNull ServiceInstance serviceInstance, @NonNull String string) {
        if (serviceInstance == null) {
            throw new IllegalArgumentException("serviceInstance is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("ip is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.warn("getVirtualMachineByIp() - Can't look up a blank IP...");
            return null;
        }
        VirtualMachine virtualMachine = null;
        try {
            logger.debug("getVirtualMachineByIp() - Find VM for IP: {}", (Object)string);
            virtualMachine = (VirtualMachine)serviceInstance.getSearchIndex().findByIp(null, string, true);
            logger.debug("getVirtualMachineByIp() - Found VM by IP: {}", (Object)(virtualMachine != null ? 1 : 0));
        }
        catch (RemoteException remoteException) {
            logger.error("getVirtualMachineByIp() - Exception: {}", (Throwable)remoteException);
        }
        return virtualMachine;
    }

    public VirtualMachine getVirtualMachineByIp(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("ip is marked non-null but is null");
        }
        return this.getVirtualMachineByIp(this.vmwareConnection.getVCenterConnection(), string);
    }

    private String getWitnessHostIp() {
        logger.debug("getWitnessHostIp() - start");
        return this.getWitnessHostIp(this.vsanUtils.getWitnessHost(this.advancedSetupHelper.isAdvancedShutdownMode()));
    }

    public String getWitnessHostIp(String string) {
        logger.debug("getWitnessHostIp() - start, vSAN Witness host: {}", (Object)string);
        if (string != null && !IPUtils.isValidIPAddress(string)) {
            String string2;
            logger.debug("getWitnessHostIp() - start, vSAN Witness host: {}", (Object)string);
            HostSystem hostSystem = this.getHostSystem(string);
            if (hostSystem != null && StringUtils.isNotEmpty((CharSequence)(string2 = this.getESXiHostIPAddress(hostSystem)))) {
                logger.info("getWitnessHostIp() - vSAN Witness host IP: {}", (Object)string2);
                string = string2;
            }
        }
        logger.debug("getWitnessHostIp() - end, result: {}", (Object)string);
        return string;
    }

    private boolean isValidPriorityVM(VirtualMachine virtualMachine) {
        logger.debug("isValidPriorityVM() - start");
        if (virtualMachine == null) {
            logger.info("isValidPriorityVM() - invalid VM");
            return false;
        }
        VirtualMachineConfigInfo virtualMachineConfigInfo = virtualMachine.getConfig();
        ManagedEntity managedEntity = virtualMachine.getParentVApp();
        if (virtualMachineConfigInfo == null || managedEntity == null) {
            logger.info("isValidPriorityVM() - invalid Config or parent");
            return false;
        }
        boolean bl = !virtualMachineConfigInfo.isTemplate() && managedEntity.getMOR() == null;
        logger.info("isValidPriorityVM({}) - end, result: {}", (Object)virtualMachine, (Object)bl);
        return bl;
    }

    private boolean isVMIpAddressMatch(VirtualMachine virtualMachine, String string) {
        if (string == null || virtualMachine == null) {
            logger.debug("isVMIpAddressMatch() - at least one parameter is null, VM: {}, VM IP: {}", (Object)virtualMachine, (Object)string);
            return false;
        }
        boolean bl = false;
        GuestInfo guestInfo = virtualMachine.getGuest();
        if (guestInfo != null) {
            String string2 = guestInfo.getIpAddress();
            String string3 = guestInfo.getHostName();
            logger.debug("isVMIpAddressMatch() - VM guest retrieved, IP: {}, hostname: {}, comparing with given IP address {}", (Object)string2, (Object)string3, (Object)string);
            if (string2 != null && string2.equals(string) || string3 != null && string3.equals(string)) {
                logger.debug("isVMIpAddressMatch() - found VM: {}", (Object)string);
                bl = true;
            }
        }
        return bl;
    }

    public VirtualMachine getVCSAVM() {
        logger.debug("getVCSAVM() - start");
        ServiceInstance serviceInstance = null;
        if (this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
            serviceInstance = this.vmwareConnection.getVCenterConnection();
        }
        return this.getVCenterServerVM(serviceInstance);
    }

    public void saveDefaultVCSAShutdownDuration(List<String> list) {
        logger.debug("saveDefaultVCSAShutdownDuration() - start");
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        if (list == null) {
            configurationManager.clearProperty("HostConfigSettings", "VCSA_shutdown_duration");
            logger.info("saveDefaultVCSAShutdownDuration() - mappedHosts is null, clearing VCSA_SHUTDOWN_DURATION");
            return;
        }
        String string = this.getVCSAHost();
        if (string == null) {
            configurationManager.clearProperty("HostConfigSettings", "VCSA_shutdown_duration");
            logger.info("saveDefaultVCSAShutdownDuration() - VCSAHost is null, clearing VCSA_SHUTDOWN_DURATION");
            return;
        }
        boolean bl = false;
        bl = list.contains(string) ? true : VsanUtils.isVsanHostFoundInList(list, string);
        if (bl) {
            logger.info("saveDefaultVCSAShutdownDuration() - found vCSA host");
            if (!configurationManager.containsKey("HostConfigSettings", "VCSA_shutdown_duration")) {
                configurationManager.setProperty("HostConfigSettings", "VCSA_shutdown_duration", 240);
            }
        } else {
            configurationManager.clearProperty("HostConfigSettings", "VCSA_shutdown_duration");
        }
        logger.debug("saveDefaultVCSAShutdownDuration() - end");
    }

    public boolean isVCSAVMInPrioritizationGroup() {
        logger.trace("isVCSAVMInPrioritizationGroup() - start");
        if (!this.vmPrioritizationUtils.isVMPrioritizationEnabled()) {
            return false;
        }
        VirtualMachine virtualMachine = this.getVCenterServerVM();
        if (virtualMachine != null && this.vmPrioritizationUtils.checkIfVMExistsInPrioritizedVMList(virtualMachine.getName()) != null) {
            return true;
        }
        logger.trace("isVCSAVMInPrioritizationGroup() - end, result: false");
        return false;
    }

    public HostSystem getHostSystemOnWhichPCNSInstalled(ServiceInstance serviceInstance) {
        HostSystem hostSystem = null;
        logger.debug("getHostSystemOnWhichPCNSInstalled() - start");
        if (serviceInstance != null) {
            VirtualMachine virtualMachine = this.getVirtualMachineOnWhichPCNSInstalled(serviceInstance);
            if (virtualMachine == null) {
                logger.debug("getHostSystemOnWhichPCNSInstalled() - Unable to find PCNS on host/cluster...");
                String string = this.virtualConfigurationManager.getPCNSHostIp();
                if (StringUtils.isNotBlank((CharSequence)string)) {
                    logger.debug("getHostSystemOnWhichPCNSInstalled() - Using cached PCNS host details from INI: {}", (Object)string);
                    hostSystem = this.getHostSystem(string);
                } else {
                    logger.debug("getHostSystemOnWhichPCNSInstalled() - Cached PCNS Host details not available.");
                }
            } else {
                HostSystem hostSystem2 = this.getHostOfVirtualMachine(virtualMachine, serviceInstance);
                if (hostSystem2 != null) {
                    String string = hostSystem2.getName();
                    logger.debug("getHostSystemOnWhichPCNSInstalled() - Setting cached value for PCNS Host: {}", (Object)string);
                    this.virtualConfigurationManager.setPCNSHostIp(string);
                }
                hostSystem = new HostSystem(serviceInstance.getServerConnection(), virtualMachine.getRuntime().getHost());
            }
        }
        logger.debug("getHostSystemOnWhichPCNSInstalled() - end, PCNS host system found: {}", (Object)(hostSystem != null ? 1 : 0));
        return hostSystem;
    }

    public String getPCNSHost() {
        HostSystem hostSystem;
        String string = null;
        logger.debug("getPCNSHost() - start");
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance != null && (hostSystem = this.getHostSystemOnWhichPCNSInstalled(serviceInstance)) != null) {
            string = hostSystem.getName();
        }
        logger.info("getPCNSHost() - end, result: {}", string);
        return string;
    }

    public List<String> getPCNSClusterHosts() {
        HostSystem hostSystem;
        logger.debug("getPCNSClusterHosts() - start");
        ArrayList<String> arrayList = new ArrayList<String>();
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance != null && (hostSystem = this.getHostSystemOnWhichPCNSInstalled(serviceInstance)) != null) {
            ManagedEntity managedEntity = hostSystem.getParent();
            while (managedEntity instanceof Folder) {
                managedEntity = managedEntity.getParent();
            }
            if (managedEntity instanceof ClusterComputeResource) {
                try {
                    ManagedEntity[] managedEntityArray;
                    for (ManagedEntity managedEntity2 : managedEntityArray = new InventoryNavigator(managedEntity).searchManagedEntities("HostSystem")) {
                        if (!(managedEntity2 instanceof HostSystem) || managedEntity2.getName().equals(hostSystem.getName())) continue;
                        arrayList.add(managedEntity2.getName());
                    }
                    arrayList.add(hostSystem.getName());
                }
                catch (RemoteException remoteException) {
                    logger.error("getPCNSClusterHosts() - RemoteException: " + String.valueOf(remoteException));
                }
                catch (Exception exception) {
                    logger.error("getPCNSClusterHosts() - Exception: " + String.valueOf(exception));
                }
            }
        }
        logger.debug("getPCNSClusterHosts() - end");
        return arrayList;
    }

    public String getIPAddressFromHostname(ServiceInstance serviceInstance, String string) {
        String string2 = null;
        logger.debug("getIPAddressFromHostname() - start, host: {}", (Object)string);
        try {
            ManagedEntity managedEntity;
            if (this.isVCSAShuttingDown(serviceInstance)) {
                return null;
            }
            if (serviceInstance != null && (managedEntity = serviceInstance.getSearchIndex().findByDnsName(null, string, false)) != null && managedEntity instanceof HostSystem) {
                HostSystem hostSystem = (HostSystem)managedEntity;
                string2 = this.getESXiHostIPAddress(hostSystem);
            }
        }
        catch (RemoteException remoteException) {
            logger.error("getIPAddressFromHostname() - RemoteException: {}", (Throwable)remoteException);
        }
        logger.debug("getIPAddressFromHostname() - end: Host: {}, IP: {}", (Object)string, string2);
        return string2;
    }

    public String getESXiHostIPAddress(HostSystem hostSystem) {
        String string = null;
        logger.debug("getESXiHostIPAddress() - start");
        if (hostSystem != null) {
            String string2 = hostSystem.getName();
            logger.debug("getESXiHostIPAddress() - for host {}", (Object)string2);
            String string3 = this.virtualConfigurationManager.getIPFromHostName(string2);
            ServiceInstance serviceInstance = null;
            boolean bl = false;
            try {
                serviceInstance = this.vmwareConnection.getESXiHostInstance(string3, false, true);
            }
            catch (HostLoginException hostLoginException) {
                bl = true;
            }
            if (serviceInstance != null) {
                logger.debug("getESXiHostIPAddress() - connected to IP Address: {}, associated with HostSystem.name: {}", (Object)string3, (Object)string2);
                string = string3;
            } else if (bl) {
                logger.debug("getESXiHostIPAddress() - Host Connection returned a login failed.  This means {} it is the correct IP Address, associated with HostSystem.name: {}", (Object)string3, (Object)string2);
                string = string3;
            } else {
                logger.info("getESXiHostIPAddress() - unable to connect to IP Address: {}, associated with HostSystem.name: {}, checking all NICs associated with host in parallel", (Object)string3, (Object)string2);
                List<String> list = this.getESXiHostIPAddressess(hostSystem);
                string = this.findAccessableESXIp(list);
                logger.debug("getESXiHostIPAddress() - found accessable ESX at {}", (Object)string);
            }
        } else {
            logger.debug("getESXiHostIPAddress() - hostSystem is null");
        }
        logger.debug("getESXiHostIPAddress() - end, result: {}", string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findAccessableESXIp(List<String> list) {
        String string = null;
        ForkJoinPool forkJoinPool = new ForkJoinPool(10);
        try {
            Optional optional = (Optional)((ForkJoinTask)forkJoinPool.submit(() -> ((Stream)list.stream().parallel()).filter(string -> {
                ServiceInstance serviceInstance;
                logger.debug("findAccessableESXIp() - attempting to connect to: {}", string);
                try {
                    serviceInstance = this.vmwareConnection.getESXiHostInstance((String)string, false, true);
                }
                catch (HostLoginException hostLoginException) {
                    logger.debug("findAccessableESXIp() - Host Connection returned a login failed. IP {} is accessable", string);
                    return true;
                }
                return serviceInstance != null;
            }).findAny())).get();
            if (optional.isPresent()) {
                logger.debug("findAccessableESXIp() - found IP: {}", (Object)optional);
                string = (String)optional.get();
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            logger.debug("findAccessableESXIp () Exception", (Throwable)exception);
            Thread.currentThread().interrupt();
        }
        finally {
            forkJoinPool.shutdown();
        }
        return string;
    }

    public List<String> getESXiHostIPAddressess(HostSystem hostSystem) {
        ArrayList<String> arrayList = new ArrayList<String>();
        logger.debug("getESXiHostIPAddressess() - start");
        try {
            HostVirtualNicConfig[] hostVirtualNicConfigArray;
            if (hostSystem != null && hostSystem.getHostNetworkSystem() != null && hostSystem.getHostNetworkSystem().getNetworkConfig() != null && hostSystem.getHostNetworkSystem().getNetworkConfig().getVnic() != null && (hostVirtualNicConfigArray = hostSystem.getHostNetworkSystem().getNetworkConfig().getVnic()) != null) {
                logger.debug("getESXiHostIPAddressess() - hvcs not null");
                for (HostVirtualNicConfig hostVirtualNicConfig : hostVirtualNicConfigArray) {
                    HostIpConfigIpV6Address[] hostIpConfigIpV6AddressArray;
                    if (hostVirtualNicConfig == null || hostVirtualNicConfig.getSpec() == null || hostVirtualNicConfig.getSpec().getIp() == null) continue;
                    arrayList.add(hostVirtualNicConfig.getSpec().getIp().getIpAddress());
                    logger.info("getESXiHostIPAddressess() - added IP address: {}", (Object)hostVirtualNicConfig.getSpec().getIp().getIpAddress());
                    if (hostVirtualNicConfig.getSpec().getIp().getIpV6Config() == null || (hostIpConfigIpV6AddressArray = hostVirtualNicConfig.getSpec().getIp().getIpV6Config().getIpV6Address()) == null || hostIpConfigIpV6AddressArray.length <= 0) continue;
                    for (HostIpConfigIpV6Address hostIpConfigIpV6Address : hostIpConfigIpV6AddressArray) {
                        arrayList.add(hostIpConfigIpV6Address.getIpAddress());
                        logger.info("getESXiHostIPAddressess() - added IPV6 address: {}", (Object)hostIpConfigIpV6Address.getIpAddress());
                    }
                }
                if (hostVirtualNicConfigArray.length > 1) {
                    logger.info("getESXiHostIPAddressess() - multiple NICs: {} detected in host: {}", arrayList, (Object)hostSystem.getName());
                }
            }
        }
        catch (Exception exception) {
            logger.error("getESXiHostIPAddressess() - Exception: {}", (Object)exception.getLocalizedMessage());
        }
        logger.debug("getESXiHostIPAddressess() - end, result: {}", arrayList);
        return arrayList;
    }

    public boolean isESXiHostIPAddress(String string, HostSystem hostSystem) {
        logger.debug("isESXiHostIPAddress() - start, IP: {}", (Object)string);
        if (IPUtils.isValidIPAddress(string)) {
            return string.equalsIgnoreCase(this.getESXiHostIPAddress(hostSystem));
        }
        return false;
    }

    public String getESXIConnStr(ServiceInstance serviceInstance, String string) {
        String string2 = null;
        logger.debug("getESXIConnStr() - start");
        if (serviceInstance != null && !IPUtils.isValidIPAddress(string) && !this.virtualConfigurationManager.isHostnameResolvable(string)) {
            string2 = this.getIPAddressFromHostname(serviceInstance, string);
        }
        if (StringUtils.isBlank(string2)) {
            string2 = string;
        }
        logger.debug("getESXIConnStr() - end, result: {}", (Object)string2);
        return string2;
    }

    public HostSystem getHostUsingIPOrDNSName(ServiceInstance serviceInstance, String string) {
        HostSystem hostSystem = null;
        logger.debug("getHostUsingIPOrDNSName() - start");
        try {
            String string2;
            if (this.isVCSAShuttingDown(serviceInstance)) {
                return null;
            }
            if (serviceInstance == null) {
                logger.info("getHostUsingIPOrDNSName() - serviceInstance is null");
                return null;
            }
            logger.debug("getHostUsingIPOrDNSName() - host IP: {}", (Object)string);
            ManagedEntity managedEntity = serviceInstance.getSearchIndex().findByIp(null, string, false);
            if (managedEntity != null) {
                logger.debug("getHostUsingIPOrDNSName() - managedEntity with IP: {}", (Object)managedEntity.getName());
            }
            if (managedEntity == null && StringUtils.countMatches((CharSequence)string, (CharSequence)":") > 1 && "HostAgent".equalsIgnoreCase(string2 = serviceInstance.getAboutInfo().getApiType()) && (managedEntity = this.getHostSystemFromESXiConnection(serviceInstance, string)) != null) {
                logger.debug("getHostUsingIPOrDNSName() - managedEntity with ESXi connection (for IPv6 host): {}", (Object)managedEntity.getName());
            }
            if (managedEntity == null && (managedEntity = serviceInstance.getSearchIndex().findByDnsName(null, string, false)) != null) {
                logger.debug("getHostUsingIPOrDNSName() - managedEntity with DNS Name: {}", (Object)managedEntity.getName());
            }
            if (managedEntity == null && "HostAgent".equalsIgnoreCase(string2 = serviceInstance.getAboutInfo().getApiType()) && (managedEntity = this.getHostSystemFromESXiConnection(serviceInstance, string)) != null) {
                logger.debug("getHostUsingIPOrDNSName() - managedEntity with ESXi connection: {}", (Object)managedEntity.getName());
            }
            if (managedEntity != null && managedEntity instanceof HostSystem) {
                hostSystem = (HostSystem)managedEntity;
            }
            if (hostSystem != null) {
                logger.debug("getHostUsingIPOrDNSName() - hostSystem received: {}", (Object)hostSystem.getName());
            }
        }
        catch (Exception exception) {
            logger.error("getHostUsingIPOrDNSName() - Exception: " + String.valueOf(exception));
        }
        logger.debug("getHostUsingIPOrDNSName() - end");
        return hostSystem;
    }

    private ManagedEntity getHostSystemFromESXiConnection(@NonNull ServiceInstance serviceInstance, @NonNull String string) {
        if (serviceInstance == null) {
            throw new IllegalArgumentException("serviceInstance is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("hostName is marked non-null but is null");
        }
        Optional<Object> optional = Optional.ofNullable(null);
        Object[] objectArray = null;
        logger.debug("getHostSystemFromESXiConnection() - start");
        try {
            objectArray = this.getInventoryNavigator(serviceInstance).searchManagedEntities("HostSystem");
            if (ArrayUtils.isEmpty((Object[])objectArray)) {
                logger.debug("getHostSystemFromESXiConnection() - failed to find any host system entries for host: {}", (Object)string);
            } else {
                optional = Stream.of(objectArray).filter(managedEntity -> managedEntity instanceof HostSystem).filter(managedEntity -> this.virtualConfigurationManager.isHyperflex() || StringUtils.equalsIgnoreCase((CharSequence)managedEntity.getName(), (CharSequence)string)).findAny();
            }
        }
        catch (RemoteException remoteException) {
            logger.error("getHostSystemFromESXiConnection() - RemoteException: ", (Throwable)remoteException);
        }
        logger.debug("getHostSystemFromESXiConnection() - end, hostsystem found: {}", (Object)(optional != null ? 1 : 0));
        return optional.orElse(null);
    }

    public InventoryNavigator getInventoryNavigator(ServiceInstance serviceInstance) {
        InventoryNavigator inventoryNavigator = new InventoryNavigator((ManagedEntity)serviceInstance.getRootFolder());
        return inventoryNavigator;
    }

    public boolean checkHostHAStateAvailable(String string) {
        logger.debug("checkHostHAStateAvailable() - start, host: {}", (Object)string);
        boolean bl = false;
        HostSystem hostSystem = null;
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance != null) {
            hostSystem = this.getHostUsingIPOrDNSName(serviceInstance, string);
        } else {
            hostSystem = this.getHostSystem(string);
            logger.debug("checkHostHAStateAvailable() - retrieving hostSystem from ESXi host instance");
        }
        try {
            if (hostSystem != null && hostSystem.getRuntime() != null) {
                HostRuntimeInfo hostRuntimeInfo = hostSystem.getRuntime();
                logger.debug("checkHostHAStateAvailable() - hostSystem & runtime not null");
                if (hostRuntimeInfo.getPowerState() == HostSystemPowerState.poweredOn) {
                    if (hostRuntimeInfo.getConnectionState() == HostSystemConnectionState.connected) {
                        ClusterDasFdmHostState clusterDasFdmHostState = hostRuntimeInfo.getDasHostState();
                        if (!this.isHostPartOfCluster(hostSystem)) {
                            logger.info("checkHostHAStateAvailable() - standalone host detected (ESXi Host connection): {}", (Object)hostSystem.getName());
                            if (clusterDasFdmHostState == null) {
                                logger.info("checkHostHAStateAvailable() - hostSystem.getRuntime().geDasHostState() returns null; cannot determine HA State");
                            }
                            bl = true;
                        } else if (clusterDasFdmHostState != null) {
                            logger.debug("checkHostHAStateAvailable() - ClusterDasFdmHostState.getState(): {} for host: {}", (Object)clusterDasFdmHostState.getState(), (Object)hostSystem.getName());
                            switch (ClusterDasFdmAvailabilityState.valueOf((String)clusterDasFdmHostState.getState())) {
                                case master: 
                                case connectedToMaster: {
                                    bl = true;
                                    break;
                                }
                                case fdmUnreachable: 
                                case uninitialized: 
                                case initializationError: 
                                case uninitializationError: {
                                    ExecutorService executorService = Executors.newFixedThreadPool(1);
                                    final HostSystem hostSystem2 = hostSystem;
                                    logger.debug("checkHostHAStateAvailable() - reConfigureHostForDAS task starting in separate thread");
                                    executorService.execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            String string = null;
                                            try {
                                                logger.debug("checkHostHAStateAvailable() - reConfigureHostForDAS task starting with waitForTask");
                                                string = hostSystem2.reconfigureHostForDAS().waitForTask();
                                            }
                                            catch (RemoteException remoteException) {
                                                logger.error("checkHostHAStateAvailable() - reConfigureHostForDAS RemoteException: " + String.valueOf(remoteException));
                                            }
                                            catch (InterruptedException interruptedException) {
                                                logger.debug("checkHostHAStateAvailable() - reConfigureHostForDAS task interrupted");
                                            }
                                            if ("success".equals(string)) {
                                                logger.debug("checkHostHAStateAvailable() - reConfigureHostForDAS task succeeded");
                                            } else {
                                                logger.info("checkHostHAStateAvailable() - reConfigureHostForDAS task failed; taskResult: {}", (Object)string);
                                            }
                                        }
                                    });
                                    break;
                                }
                            }
                        } else {
                            logger.info("checkHostHAStateAvailable() - hostSystem.getRuntime().geDasHostState() returns null; cannot determine HA State");
                            bl = true;
                        }
                    } else {
                        logger.info("checkHostHAStateAvailable() - host not connected");
                    }
                } else {
                    logger.info("checkHostHAStateAvailable() - host not powered on");
                }
            } else {
                logger.info("checkHostHAStateAvailable() - hostSystem or runTime is null");
            }
        }
        catch (RuntimeException runtimeException) {
            logger.error("checkHostHAStateAvailable() - RuntimeException: " + String.valueOf(runtimeException));
        }
        catch (Exception exception) {
            logger.error("checkHostHAStateAvailable() - Exception: " + String.valueOf(exception));
        }
        logger.debug("checkHostHAStateAvailable() - end, return: {}", (Object)bl);
        return bl;
    }

    public boolean isHostPartOfCluster(ServiceInstance serviceInstance, String string) {
        logger.debug("isHostPartOfCluster() - start, host: {}", (Object)string);
        boolean bl = false;
        if (serviceInstance != null) {
            HostSystem hostSystem = this.getHostUsingIPOrDNSName(serviceInstance, string);
            bl = this.isHostPartOfCluster(hostSystem);
        }
        logger.debug("isHostPartOfCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isHostPartOfCluster(HostSystem hostSystem) {
        logger.debug("isHostPartOfCluster() - start: {}", (Object)hostSystem);
        boolean bl = false;
        if (hostSystem != null) {
            try {
                ManagedEntity managedEntity = hostSystem.getParent();
                while (managedEntity instanceof Folder) {
                    managedEntity = managedEntity.getParent();
                }
                if (managedEntity instanceof ClusterComputeResource) {
                    bl = true;
                }
                logger.debug("isHostPartOfCluster() - HostSystem parent type is: {}", (Object)managedEntity.getClass().getCanonicalName());
            }
            catch (Exception exception) {
                logger.debug("isHostPartOfCluster() - Can't determine if HostSystem is part of cluster. Assuming false.  Exception: {}", (Throwable)exception);
            }
        }
        logger.debug("isHostPartOfCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isVAppDetectedInCluster(ServiceInstance serviceInstance, String string) {
        boolean bl;
        block4: {
            bl = false;
            logger.debug("isVAppDetectedInCluster() - start, host: {}", (Object)string);
            try {
                ManagedEntity[] managedEntityArray;
                ManagedEntity managedEntity;
                HostSystem hostSystem = this.getHostUsingIPOrDNSName(serviceInstance, string);
                if (hostSystem == null || !((managedEntity = hostSystem.getParent()) instanceof ClusterComputeResource)) break block4;
                ClusterComputeResource clusterComputeResource = (ClusterComputeResource)managedEntity;
                for (ManagedEntity managedEntity2 : managedEntityArray = new InventoryNavigator((ManagedEntity)clusterComputeResource).searchManagedEntities("VirtualApp")) {
                    if (!(managedEntity2 instanceof VirtualApp)) continue;
                    bl = true;
                    break;
                }
            }
            catch (InvalidProperty | RuntimeFault throwable) {
                logger.error("isVAppDetectedInCluster() - InvalidProperty | RuntimeFault: " + String.valueOf(throwable));
            }
            catch (RemoteException remoteException) {
                logger.error("isVAppDetectedInCluster() - RemoteException: " + String.valueOf(remoteException));
            }
        }
        logger.debug("isAnyVAppDetectedInCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public void triggerNormalVCenterAlarmEvent(LinkedHashSet<String> linkedHashSet) {
        logger.info("triggerNormalVCenterAlarmEvent() - start");
        if (linkedHashSet != null && !linkedHashSet.isEmpty()) {
            ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
            for (String string : linkedHashSet) {
                HostSystem hostSystem = this.getHostUsingIPOrDNSName(serviceInstance, string);
                if (hostSystem == null) continue;
                CreateVCenterAlarm.getInstance().createUPSCriticalEvent(hostSystem.getName(), "normal");
            }
        }
        logger.info("triggerNormalVCenterAlarmEvent() - end");
    }

    public Set<HostSystem> getCustomTargetHostSystemList(List<String> list, ServiceInstance serviceInstance) {
        logger.debug("getCustomTargetHostSystemList() - start");
        HashSet<HostSystem> hashSet = new HashSet<HostSystem>();
        if (list != null && list.size() > 0) {
            for (String string : list) {
                if (!this.vmwareConnection.validateServiceInstance()) {
                    serviceInstance = this.vmwareConnection.getESXiHostInstance(string);
                }
                if (serviceInstance != null) {
                    HostSystem hostSystem = this.getHostUsingIPOrDNSName(serviceInstance, string);
                    if (hostSystem != null) {
                        if (hostSystem.getRuntime().isInMaintenanceMode() || !this.checkIfHostIsPoweredOn(hostSystem)) continue;
                        hashSet.add(hostSystem);
                        continue;
                    }
                    logger.debug("getCustomTargetHostSystemList() - hostSystem is null for host: {}", (Object)string);
                    continue;
                }
                logger.debug("getCustomTargetHostSystemList() - unable to establish connection to host: {}", (Object)string);
            }
        } else {
            hashSet = null;
        }
        logger.info("getCustomTargetHostSystemList() - end {}", hashSet);
        return hashSet;
    }

    public Boolean isDRSFullyAuto(Integer n) {
        logger.debug("isDRSFullyAuto() - start, setup: {}", (Object)n);
        ClusterComputeResource clusterComputeResource = null;
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        LinkedHashSet<String> linkedHashSet = this.virtualConfigurationManager.getConfiguredHosts(n);
        for (String string : linkedHashSet) {
            logger.debug("isDRSFullyAuto() - host: {}", (Object)string);
            HostSystem hostSystem = this.getHostUsingIPOrDNSName(serviceInstance, string);
            if (hostSystem != null) {
                ManagedEntity managedEntity = hostSystem.getParent();
                while (managedEntity instanceof Folder) {
                    managedEntity = managedEntity.getParent();
                }
                while (managedEntity != null && !(managedEntity instanceof ClusterComputeResource)) {
                    logger.debug("isDRSFullyAuto() - parent is a: {}", (Object)managedEntity.getClass().getCanonicalName());
                    managedEntity = managedEntity.getParent();
                }
                if (managedEntity instanceof ClusterComputeResource) {
                    clusterComputeResource = (ClusterComputeResource)managedEntity;
                    Boolean bl = clusterComputeResource.getConfiguration().getDrsConfig().getEnabled();
                    if (bl.booleanValue()) {
                        String string2 = clusterComputeResource.getConfiguration().getDrsConfig().getDefaultVmBehavior().toString();
                        if (DrsBehavior.fullyAutomated.toString().equalsIgnoreCase(string2)) {
                            logger.info("isDRSFullyAuto() - DRS is fullyAutomated for:{}", (Object)n);
                            return true;
                        }
                        logger.debug("isDRSFullyAuto() - DRS is not fullyAutomated, its: {}", (Object)string2);
                        continue;
                    }
                    logger.debug("isDRSFullyAuto() - DRS is not enabled");
                    continue;
                }
                if (managedEntity == null) {
                    logger.info("isDRSFullyAuto() - parent is null");
                    continue;
                }
                logger.info("isDRSFullyAuto() - parent is a: {}", (Object)managedEntity.getClass().getCanonicalName());
                continue;
            }
            logger.info("isDRSFullyAuto() - no hostSystem found");
        }
        logger.debug("isDRSFullyAuto() - end, result: false");
        return false;
    }

    public boolean isAnyHostPartOfCluster(Collection<String> collection) {
        logger.debug("isAnyHostPartOfCluster() - start");
        boolean bl = false;
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance != null) {
            for (String string : collection) {
                if (!this.isHostPartOfCluster(serviceInstance, string)) continue;
                bl = true;
                break;
            }
        }
        logger.info("isAnyHostPartOfCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public Set<String> getHostsPartOfCluster(Collection<String> collection) {
        logger.debug("getHostsPartOfCluster() - start");
        Set<String> set = new LinkedHashSet<String>();
        if (collection == null || collection.isEmpty()) {
            logger.debug("getHostsPartOfCluster() - hosts to filter null or empty");
            return set;
        }
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance != null) {
            set = collection.stream().filter(string -> this.isHostPartOfCluster(serviceInstance, (String)string)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        logger.info("getHostsPartOfCluster() - end, result: {}", set);
        return set;
    }

    public boolean isAnyVAppDetectedInCluster(Collection<String> collection) {
        boolean bl = false;
        logger.debug("isAnyVAppDetectedInCluster() - start");
        ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
        if (serviceInstance != null) {
            for (String string : collection) {
                if (!this.isVAppDetectedInCluster(serviceInstance, string)) continue;
                bl = true;
                break;
            }
        }
        logger.info("isAnyVAppDetectedInCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public VirtualMachine isVMPresentOnHost(HostSystem hostSystem, String string) {
        VirtualMachine virtualMachine = null;
        logger.debug("isVMPresentOnHost() - start, VM: {}", (Object)string);
        if (hostSystem == null) {
            logger.info("isVMPresentOnHost() - hostSystem is null");
            return null;
        }
        if (!StringUtils.isNotBlank((CharSequence)string)) {
            logger.info("isVMPresentOnHost() - VM IP: {} is invalid", (Object)string);
            return null;
        }
        try {
            VirtualMachine[] virtualMachineArray;
            for (VirtualMachine virtualMachine2 : virtualMachineArray = hostSystem.getVms()) {
                if (!this.isVMIpAddressMatch(virtualMachine2, string)) continue;
                virtualMachine = virtualMachine2;
                logger.info("isVMPresentOnHost() - found VM: {} on host", (Object)string);
                break;
            }
        }
        catch (RemoteException remoteException) {
            logger.error("isVMPresentOnHost() - RemoteException: ", (Throwable)remoteException);
        }
        logger.debug("isVMPresentOnHost() - end");
        return virtualMachine;
    }

    public List<Host> getHosts() {
        logger.debug("getHosts() - start");
        ArrayList<Host> arrayList = null;
        ManagedEntity[] managedEntityArray = this.getDataCenters();
        if (managedEntityArray == null) {
            logger.info("getHosts() - cannot retrieve hosts with no datacenters retrieved");
            return null;
        }
        arrayList = new ArrayList<Host>();
        for (ManagedEntity managedEntity : managedEntityArray) {
            if (!(managedEntity instanceof Datacenter)) continue;
            Datacenter datacenter = (Datacenter)managedEntity;
            List<Host> list = this.getHostsWithinDatacenterWithRetry(datacenter, 3);
            if (list != null) {
                arrayList.addAll(list);
                continue;
            }
            arrayList = null;
            break;
        }
        logger.debug("getHosts() - end {}", arrayList);
        return arrayList;
    }

    public List<Host> getConfiguredHosts() {
        logger.debug("getConfiguredHosts() - start");
        ArrayList<Host> arrayList = null;
        ArrayList<Host> arrayList2 = null;
        LinkedHashSet<String> linkedHashSet = ServiceManager.getInstance().getVirtualConfigurationManager().getConfiguredHosts();
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            logger.debug("getConfiguredHosts() - no configured hosts found, returning null");
            return null;
        }
        ManagedEntity[] managedEntityArray = this.getDataCenters();
        if (managedEntityArray == null) {
            logger.info("getHosts() - cannot retrieve hosts with no datacenters retrieved");
            return null;
        }
        arrayList2 = new ArrayList<Host>();
        arrayList = new ArrayList();
        for (ManagedEntity managedEntity : managedEntityArray) {
            if (!(managedEntity instanceof Datacenter)) continue;
            Datacenter datacenter = (Datacenter)managedEntity;
            arrayList2.addAll(this.getHostsWithinDatacenterWithRetry(datacenter, 3));
        }
        arrayList = arrayList2.stream().filter(host -> StringUtils.isNotBlank((CharSequence)host.getIPAddress()) && linkedHashSet.contains(host.getIPAddress())).collect(Collectors.toList());
        logger.debug("getConfiguredHosts() - end {}", arrayList);
        return arrayList;
    }

    private ManagedEntity[] getDataCenters() {
        logger.debug("getDataCenters() - start");
        ManagedEntity[] managedEntityArray = null;
        try {
            ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnectionWithRetries();
            if (serviceInstance == null) {
                logger.info("getDataCenters() - serviceInstance is null, unable to retrieve datacenters");
                return null;
            }
            Folder folder = serviceInstance.getRootFolder();
            managedEntityArray = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("Datacenter");
        }
        catch (RemoteException remoteException) {
            logger.error("getDataCenters() - RemoteException: {}", (Throwable)remoteException);
        }
        catch (Exception exception) {
            logger.error("getDataCenters() - Exception: {}", (Throwable)exception);
        }
        if (managedEntityArray != null) {
            logger.debug("getDataCenters() - end, nnumber of managedEntities found:{}", (Object)managedEntityArray.length);
        } else {
            logger.error("getDataCenters() - retrieved NULL");
        }
        return managedEntityArray;
    }

    private List<Host> getHostsWithinDatacenterWithRetry(Datacenter datacenter, int n) {
        if (this.clusterUtils == null) {
            logger.error("getHostsWithinDatacenterWithRetry() - clusterUtils not available, aborting");
            return null;
        }
        if (datacenter == null) {
            logger.error("getHostsWithinDatacenterWithRetry() - datacenter is null, unable to retrieve hosts");
            return null;
        }
        n = Math.max(1, n);
        List<Host> list = null;
        for (int i = 0; i < n && (list = this.clusterUtils.getHostsWithinDatacenter(datacenter)) == null; ++i) {
        }
        return list;
    }

    public List<Host> getAhvHosts() {
        logger.debug("getAhvHosts() - start");
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        List<String> list = null;
        ArrayList<Host> arrayList = new ArrayList<Host>();
        String string = null;
        try {
            NutanixConnection nutanixConnection = NutanixService.getInstance().getClusterConnection();
            nutanixConnection.connect();
            list = nutanixConnection.getAhvIps();
            string = nutanixConnection.getClusterName();
            nutanixConnection.disconnect();
            String string2 = null;
            if (configurationManager.containsKey("NutanixClusterDetails", "Cluster_Ip")) {
                string2 = configurationManager.getString("NutanixClusterDetails", "Cluster_Ip");
            }
            if (string == null) {
                string = string2;
            }
            if (list != null) {
                for (String string3 : list) {
                    arrayList.add(new Host(string3, null, string, false));
                }
            }
        }
        catch (RemoteException remoteException) {
            logger.error("getAhvHosts() - failed to retrieve AHV ip list: {}", (Object)remoteException.getMessage());
        }
        catch (ConversionException conversionException) {
            logger.error("getAhvHosts() - failed to retrieve cluster ip from ini: {}", (Object)conversionException.getMessage());
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.debug("getAhvHosts() - failed to get the cluster connection: {}", (Object)exception.getMessage());
        }
        logger.debug("getAhvHosts() - end, result: {}", arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getOnlineHostOutOfMaintenanceMode(String string, boolean bl) {
        boolean bl2;
        block17: {
            bl2 = false;
            try {
                logger.info("getOnlineHostOutOfMaintenanceMode() - host: {}", (Object)string);
                if (this.virtualisationStatusStore.isHostLockedForShutdown(string)) {
                    logger.info("getOnlineHostOutOfMaintenanceMode() - host locked");
                    return bl2;
                }
                HostSystem hostSystem = null;
                hostSystem = bl ? this.getHostSystem(string) : this.getHostSystemDirectConnOrVCenter(string);
                if (hostSystem == null) {
                    logger.info("getOnlineHostOutOfMaintenanceMode() - host not found, checking if it exists in current setup");
                    LinkedHashSet<String> linkedHashSet = this.virtualConfigurationManager.getConfiguredHosts();
                    if (!this.virtualConfigurationManager.isHostInCurrentSetup(linkedHashSet, string)) {
                        this.virtualisationStatusStore.clearHostForShutdown(string);
                    }
                    return bl2;
                }
                this.checkIfHostIsInInvalidState(hostSystem);
                if (this.checkIfHostIsPoweredOn(hostSystem)) {
                    Lock lock = this.getHostMaintenanceModeLock(string);
                    try {
                        lock.lock();
                        if (hostSystem.getRuntime().isInMaintenanceMode()) {
                            logger.info("getOnlineHostOutOfMaintenanceMode() - powered on and in Maintenance Mode");
                            CreateVCenterAlarm.getInstance().createUPSCriticalEvent(string, "normal");
                            this.virtualLoggingUtils.logMaintenanceModeExitedEvent(string);
                            int n = this.virtualConfigurationManager.getMaintenanceModeTimeoutDuration();
                            Task task = hostSystem.exitMaintenanceMode(n);
                            String string2 = task.waitForTask();
                            logger.trace("getOnlineHostOutOfMaintenanceMode() - task result: {}", (Object)string2);
                            if (StringUtils.equalsIgnoreCase((CharSequence)string2, (CharSequence)"success")) {
                                int n2 = 30;
                                try {
                                    n2 = ServiceManager.getInstance().getConfigurationManager().getInt("HostConfigSettings", "delay_after_exit_maintenance_mode");
                                }
                                catch (NoSuchElementException | ConversionException throwable) {
                                    logger.debug((Object)throwable);
                                }
                                logger.info("getOnlineHostOutOfMaintenanceMode() - sleeping: {} seconds waiting for HA initialization to complete", (Object)n2);
                                new CountdownTimer(n2, TimeUnit.SECONDS).sleep();
                                if (!hostSystem.getRuntime().isInMaintenanceMode()) {
                                    bl2 = true;
                                    logger.info("getOnlineHostOutOfMaintenanceMode() - successfully exited Maintenance Mode");
                                    this.virtualisationStatusStore.clearHostForShutdown(string);
                                } else {
                                    logger.error("getOnlineHostOutOfMaintenanceMode() - failed to exit Maintenance Mode, task result: {}, host is still in Maintenance Mode", (Object)string2);
                                }
                                break block17;
                            }
                            logger.info("getOnlineHostOutOfMaintenanceMode() - failed to exit Maintenance Mode");
                            break block17;
                        }
                        logger.info("getOnlineHostOutOfMaintenanceMode() - host powered on but not in Maintenance Mode");
                        bl2 = true;
                        CreateVCenterAlarm.getInstance().createUPSCriticalEvent(string, "normal");
                        this.virtualisationStatusStore.clearHostForShutdown(string);
                        break block17;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                logger.info("getOnlineHostOutOfMaintenanceMode() - host not powered on");
            }
            catch (RemoteException remoteException) {
                logger.error("getOnlineHostOutOfMaintenanceMode() - RemoteException: " + String.valueOf(remoteException));
            }
            catch (InterruptedException interruptedException) {
                logger.error("getOnlineHostOutOfMaintenanceMode() - InterruptedException: " + String.valueOf(interruptedException));
            }
            catch (Exception exception) {
                logger.error("getOnlineHostOutOfMaintenanceMode() - Exception: " + String.valueOf(exception));
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock getHostMaintenanceModeLock(@NonNull String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        Map<String, Lock> map = this.hostsComingOutOfMaintenanceMode;
        synchronized (map) {
            return this.hostsComingOutOfMaintenanceMode.computeIfAbsent(string2, string -> new ReentrantLock());
        }
    }

    public HostsStarted haveHostsStarted(Set<String> set) {
        logger.debug("haveHostsStarted() - start");
        HostsStarted hostsStarted = HostsStarted.NONE;
        int n = 0;
        for (String string : set) {
            if (string == null) continue;
            logger.info("haveHostsStarted() - checking host: {}", (Object)string);
            if (this.virtualisationStatusStore.isHostLockedForShutdown(string)) {
                logger.info("haveHostsStarted() - skipping locked host: {}", (Object)string);
                continue;
            }
            HostSystem hostSystem = this.getHostSystemDirectConnOrVCenter(string);
            this.checkIfHostIsInInvalidState(hostSystem);
            if (this.checkIfHostIsPoweredOn(hostSystem)) {
                if (hostSystem.getRuntime().isInMaintenanceMode()) {
                    logger.info("haveHostsStarted() - host: {} in Maintenance Mode, skipping", (Object)string);
                    continue;
                }
                logger.info("haveHostsStarted() - host: {} powered on", (Object)string);
                ++n;
                continue;
            }
            logger.info("haveHostsStarted() - host: {} not powered on", (Object)string);
        }
        if (n > 0) {
            hostsStarted = n < set.size() ? HostsStarted.SOME : HostsStarted.ALL;
        }
        logger.debug("haveHostsStarted() - end, result: {}", (Object)hostsStarted);
        return hostsStarted;
    }

    public boolean isHostShutdownTriggered(ServiceInstance serviceInstance, HostSystem hostSystem) {
        boolean bl = false;
        logger.info("isHostShutdownTriggered() - start");
        TaskManager taskManager = serviceInstance.getTaskManager();
        Task[] taskArray = taskManager.getRecentTasks();
        try {
            for (Task task : taskArray) {
                TaskInfo taskInfo;
                if (task.getAssociatedManagedEntity() == null || !(task.getAssociatedManagedEntity() instanceof HostSystem) || task.getAssociatedManagedEntity().getName() == null || !task.getAssociatedManagedEntity().getName().equalsIgnoreCase(hostSystem.getName()) || (taskInfo = task.getTaskInfo()) == null || taskInfo.getName() == null || !taskInfo.getName().equalsIgnoreCase("shutdownHost_Task") || taskInfo.getState() == null || !taskInfo.getState().toString().equalsIgnoreCase(TaskInfoState.success.toString())) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            logger.error("isHostShutdownTriggered() - Exception: " + String.valueOf(exception));
        }
        logger.info("isHostShutdownTriggered() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean areAllVMsPoweredOff(HostSystem hostSystem, boolean bl) {
        boolean bl2;
        block11: {
            bl2 = false;
            logger.info("areAllVMsPoweredOff() - start");
            if (hostSystem != null) {
                try {
                    List<VirtualMachine> list = Arrays.asList(hostSystem.getVms());
                    if (bl) {
                        logger.debug("areAllVMsPoweredOff() - filtering out vCLS VMs");
                        list = this.virtualMachineUtils.filterOutVCLSVms(list);
                    }
                    if (this.virtualConfigurationManager.isVxRail()) {
                        logger.debug("areAllVMsPoweredOff() - filtering out VxRail Special VMs");
                        list = this.vxRailUtils.filterOutVxRailSpecialVms(list);
                    }
                    if (list.isEmpty()) {
                        logger.debug("areAllVMsPoweredOff() - no VMs retrieved, returning true");
                        return true;
                    }
                    Optional<VirtualMachine> optional = list.stream().filter(virtualMachine -> !StringUtils.equalsIgnoreCase((CharSequence)virtualMachine.getRuntime().getPowerState().toString(), (CharSequence)VirtualMachinePowerState.poweredOff.toString())).findAny();
                    if (optional.isPresent()) {
                        String string = null;
                        try {
                            string = optional.get().getName();
                            logger.info("areAllVMsPoweredOff() -  VM: {} is still powered on, returning false", (Object)string);
                            return false;
                        }
                        catch (Exception exception) {
                            logger.debug("areAllVMsPoweredOff() -  getting VM name failed with error: {}", (Throwable)exception);
                            break block11;
                        }
                    }
                    logger.info("areAllVMsPoweredOff() -  all VMs are powered off");
                    bl2 = true;
                }
                catch (RemoteException remoteException) {
                    logger.error("areAllVMsPoweredOff() - RemoteException: {}", (Throwable)remoteException);
                }
                catch (Exception exception) {
                    logger.error("areAllVMsPoweredOff() - Exception:{} ", (Throwable)exception);
                }
            } else {
                logger.info("areAllVMsPoweredOff() -  HostSystem is null, unable to determine if VMs are powered off");
            }
        }
        logger.info("areAllVMsPoweredOff() - end, result: {}", (Object)bl2);
        return bl2;
    }

    public void rescanAllHba(HostSystem hostSystem, String string) {
        logger.info("rescanAllHba() - start, host: {}", (Object)string);
        if (hostSystem == null) {
            logger.warn("rescanAllHba() - hostSystem is null");
            return;
        }
        try {
            if (hostSystem.getHostStorageSystem() == null) {
                logger.warn("rescanAllHba() - HostStorageSystem is null");
                return;
            }
            logger.info("rescanAllHba() - calling rescanAllHba to update host inventory");
            hostSystem.getHostStorageSystem().rescanAllHba();
            int n = this.virtualConfigurationManager.getHostRescanAllHbaDuration();
            try {
                logger.debug("rescanAllHba() - delaying: {} seconds", (Object)n);
                TimeUnit.SECONDS.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                logger.error("rescanAllHba() - InterruptedException");
            }
        }
        catch (HostConfigFault hostConfigFault) {
            logger.error("rescanAllHba() - HostConfigFault: " + String.valueOf((Object)hostConfigFault));
        }
        catch (RuntimeFault runtimeFault) {
            logger.error("rescanAllHba() - RuntimeFault: " + String.valueOf((Object)runtimeFault));
        }
        catch (RuntimeException runtimeException) {
            logger.error("rescanAllHba() - RuntimeException: " + String.valueOf(runtimeException));
        }
        catch (Exception exception) {
            logger.error("rescanAllHba() - Exception: " + String.valueOf(exception));
        }
        logger.debug("rescanAllHba() - end");
    }

    public HostSystem getHostSystem(String string) {
        HostSystem hostSystem = null;
        logger.debug("getHostSystem() - start, host: {}", (Object)string);
        try {
            ServiceInstance serviceInstance = this.vmwareConnection.getVCenterConnection();
            if (serviceInstance != null && !this.vmwareConnection.isVCenterOffline()) {
                hostSystem = this.getHostUsingIPOrDNSName(serviceInstance, string);
            } else {
                logger.debug("getHostSystem() - using direct ESX connection");
                String string2 = this.getESXIConnStr(serviceInstance, string);
                ServiceInstance serviceInstance2 = this.vmwareConnection.getESXiHostInstance(string2);
                if (serviceInstance2 != null) {
                    hostSystem = this.getHostUsingIPOrDNSName(serviceInstance2, string2);
                } else {
                    logger.info("getHostSystem() - ESXiServiceInstance is null for connStr: {}", (Object)string2);
                }
            }
        }
        catch (Exception exception) {
            logger.error("getHostSystem() - Exception: ", (Throwable)exception);
        }
        logger.debug("getHostSystem() - end");
        return hostSystem;
    }

    public HostSystem getHostSystemDirectConnection(String string) {
        HostSystem hostSystem = null;
        logger.debug("getHostSystemDirectConnection() - start, host: {}", (Object)string);
        try {
            logger.debug("getHostSystemDirectConnection() - using direct ESX connection");
            ServiceInstance serviceInstance = this.vmwareConnection.getESXiHostInstance(string);
            if (serviceInstance != null) {
                hostSystem = this.getHostUsingIPOrDNSName(serviceInstance, string);
            } else {
                logger.info("getHostSystemDirectConnection() - ESXiServiceInstance is null for connStr: {}", (Object)string);
            }
        }
        catch (Exception exception) {
            logger.error("getHostSystemDirectConnection() - Exception: ", (Throwable)exception);
        }
        logger.debug("getHostSystemDirectConnection() - end");
        return hostSystem;
    }

    public HostSystem getHostSystemDirectConnOrVCenter(String string) {
        HostSystem hostSystem = null;
        logger.debug("getHostSystemDirectConnOrVCenter() - start, host: {}", (Object)string);
        try {
            logger.debug("getHostSystemDirectConnOrVCenter() - using direct ESX connection");
            ServiceInstance serviceInstance = this.vmwareConnection.getESXiHostInstance(string);
            if (serviceInstance != null) {
                hostSystem = this.getHostUsingIPOrDNSName(serviceInstance, string);
            } else {
                logger.info("getHostSystemDirectConnOrVCenter() - ESXiServiceInstance is null, trying vCenter connection");
                ServiceInstance serviceInstance2 = this.vmwareConnection.getVCenterConnection();
                if (serviceInstance2 != null) {
                    hostSystem = this.getHostUsingIPOrDNSName(serviceInstance2, string);
                } else {
                    logger.info("getHostSystemDirectConnOrVCenter() - vCenter service instance is null");
                }
            }
        }
        catch (Exception exception) {
            logger.error("getHostSystemDirectConnOrVCenter() - Exception: ", (Throwable)exception);
        }
        logger.debug("getHostSystemDirectConnOrVCenter() - end");
        return hostSystem;
    }

    public String getVsanDatastoreName(HostSystem hostSystem) {
        if (hostSystem == null) {
            logger.info("getVsanDatastoreName() - hostSystem is null");
            return null;
        }
        logger.debug("getVsanDatastoreName() - start");
        String string = null;
        try {
            Datastore[] datastoreArray;
            for (Datastore datastore : datastoreArray = hostSystem.getDatastores()) {
                DatastoreSummary datastoreSummary = datastore.getSummary();
                if (datastoreSummary == null || !datastoreSummary.getType().equals(VSAN_DATASTORE_TYPE)) continue;
                if (string == null) {
                    string = datastoreSummary.getName();
                    logger.info("getVsanDatastoreName() - set to: {}", (Object)string);
                    continue;
                }
                logger.info("getVsanDatastoreName() - already set, found: {}", (Object)datastoreSummary.getName());
            }
        }
        catch (RemoteException remoteException) {
            logger.error("getVsanDatastoreName() - RemoteException: ", (Throwable)remoteException);
        }
        catch (Exception exception) {
            logger.error("getVsanDatastoreName() - Exception: ", (Throwable)exception);
        }
        logger.debug("getVsanDatastoreName() - end, result: {}", string);
        return string;
    }

    public boolean areAllHostsOnline(@NonNull Set<String> set) {
        if (set == null) {
            throw new IllegalArgumentException("hosts is marked non-null but is null");
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Can't process an empty host set.");
        }
        return set.stream().filter(string -> StringUtils.isNotBlank((CharSequence)string)).map(string -> this.isHostHealthy((String)string)).allMatch(bl -> Boolean.TRUE.equals(bl));
    }

    public boolean isHostHealthy(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        logger.debug("isHostHealthy() - Checking host: {}", (Object)string);
        boolean bl = false;
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't check a blank host.");
        }
        HostSystem hostSystem = this.getHostSystem(string);
        bl = hostSystem != null ? this.isHostHealthy(hostSystem, true) : false;
        logger.info("isHostHealthy() - Status of Host {} is {}", (Object)string, (Object)bl);
        return bl;
    }

    public boolean isHostHealthy(@NonNull HostSystem hostSystem, boolean bl) {
        if (hostSystem == null) {
            throw new IllegalArgumentException("hostSystem is marked non-null but is null");
        }
        return this.isHostHealthy(hostSystem, hostSystem.getName(), bl);
    }

    public boolean isHostHealthy(HostSystem hostSystem, String string, boolean bl) {
        logger.debug("isHostHealthy() - start, host: {}, isHostInMaintenanceModeUnhealthy: {}", (Object)string, (Object)bl);
        boolean bl2 = true;
        if (hostSystem == null) {
            logger.warn("isHostHealthy() - host: {} hostSystem is null", (Object)string);
            bl2 = false;
        } else {
            if (!this.checkIfHostIsResponding(hostSystem)) {
                logger.info("isHostHealthy() - host: {} not responding", (Object)string);
                bl2 = false;
            }
            if (bl2 && !this.checkIfHostIsPoweredOn(hostSystem)) {
                logger.info("isHostHealthy() - host: {} powered off", (Object)string);
                bl2 = false;
            }
            if (bl2 && hostSystem.getRuntime().isInMaintenanceMode()) {
                logger.info("isHostHealthy() - host: {} in Maintenance Mode", (Object)string);
                if (bl) {
                    bl2 = false;
                }
            }
        }
        logger.info("isHostHealthy() - end, healthy: {}", (Object)bl2);
        return bl2;
    }

    public HostSystem getValidHostSystem(HostSystem hostSystem, String string) {
        if (hostSystem == null || !this.isHostSystemValid(hostSystem, string)) {
            logger.info("getValidHostSystem() - hostSystem is null or invalid");
            hostSystem = this.getHostSystem(string);
        }
        return hostSystem;
    }

    public String getPCNSHostFromHostSystems(Map<String, HostSystem> map, String string) {
        logger.debug("getPCNSHostFromHostSystems() - start, checking host systems for PCNS host IP {}", (Object)string);
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.info("getPCNSHostFromHostSystems() - PCNS host IP is null, cannot be matched with any host, returning null");
            return null;
        }
        String string2 = null;
        for (Map.Entry<String, HostSystem> entry : map.entrySet()) {
            String string3 = entry.getKey();
            HostSystem hostSystem = entry.getValue();
            String string4 = this.getESXiHostIPAddress(hostSystem);
            logger.info("getPCNSHostFromHostSystems() - checking host name {} and IP {}", (Object)string3, (Object)string4);
            if (!StringUtils.equalsIgnoreCase((CharSequence)string4, (CharSequence)string) && !StringUtils.equalsIgnoreCase((CharSequence)string3, (CharSequence)string)) continue;
            logger.debug("getPCNSHostFromHostSystems() - host IP {} or name {} and PCNS host IP {} match", (Object)string4, (Object)string3, (Object)string);
            string2 = string3;
            break;
        }
        logger.info("getPCNSHostFromHostSystems() - end, returning host {}", string2);
        return string2;
    }

    public boolean isPCNSHost(ServiceInstance serviceInstance, String string, @NonNull HostSystem hostSystem) {
        if (hostSystem == null) {
            throw new IllegalArgumentException("pcnsHostSystem is marked non-null but is null");
        }
        return this.isPCNSHost(serviceInstance, hostSystem.getName(), string, hostSystem);
    }

    public boolean isPCNSHost(ServiceInstance serviceInstance, String string, String string2, HostSystem hostSystem) {
        logger.debug("isPCNSHost() - start, checking host {}", (Object)string2);
        if (serviceInstance == null) {
            logger.error("isPCNSHost() - service instance is null, unable to check PCNS host");
            return false;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{string, string2})) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)string2)) {
            logger.info("isPCNSHost() - PCNS host {} and critical host {} match by hostname", (Object)string, (Object)string2);
            return true;
        }
        String string3 = null;
        if (hostSystem != null) {
            string3 = this.virtualConfigurationManager.getIPFromHostName(hostSystem.getName());
        }
        if (StringUtils.equalsIgnoreCase(string3, (CharSequence)string2)) {
            logger.info("isPCNSHost() - PCNS host IP {} and critical host {} match by hostname", (Object)string3, (Object)string2);
            return true;
        }
        ServiceInstance serviceInstance2 = null;
        if (this.vmwareConnection.validateServiceInstance()) {
            logger.debug("isPCNSHost() - using vCenter service instance");
            serviceInstance2 = this.vmwareConnection.getVCenterConnection();
        } else {
            logger.debug("isPCNSHost() - trying ESXi host service instance for host {}", (Object)string2);
            serviceInstance2 = this.vmwareConnection.getESXiHostInstance(string2);
        }
        if (serviceInstance2 == null) {
            logger.info("isPCNSHost() - failed to retrieve service instance for host {}", (Object)string2);
            return false;
        }
        HostSystem hostSystem2 = this.getHostUsingIPOrDNSName(serviceInstance2, string2);
        if (hostSystem2 == null) {
            logger.info("isPCNSHost() - failed to retrieve host system for host {}", (Object)string2);
            return false;
        }
        String string4 = hostSystem2.getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)string4)) {
            logger.info("isPCNSHost() - PCNS host {} and critical host {} match by current hostname", (Object)string, (Object)string4);
            return true;
        }
        String string5 = this.virtualConfigurationManager.getIPFromHostName(hostSystem2.getName());
        logger.debug("isPCNSHost() - host to match has following IP {}", (Object)string5);
        if (StringUtils.isNotBlank((CharSequence)string5) && StringUtils.equalsAnyIgnoreCase((CharSequence)string5, (CharSequence[])new CharSequence[]{string, string3})) {
            logger.info("isPCNSHost() - PCNS host {} and critical host match by current IP {}", (Object)string, (Object)string5);
            return true;
        }
        logger.info("isPCNSHost() - PCNS host {} and critical host {} do not match ", (Object)string, (Object)string2);
        return false;
    }

    public boolean setAutoStartPolicy(@NonNull ServiceInstance serviceInstance) {
        if (serviceInstance == null) {
            throw new IllegalArgumentException("si is marked non-null but is null");
        }
        logger.debug("setAutoStartPolicy() - start");
        if (!this.virtualConfigurationManager.isVxRail() && !this.virtualConfigurationManager.isESXi()) {
            logger.info("setAutoStartPolicy() - Setting auto-start policy is not supported.");
            return false;
        }
        HostSystem hostSystem = this.getHostSystemOnWhichPCNSInstalled(serviceInstance);
        if (hostSystem == null) {
            logger.warn("setAutoStartPolicy() - Could not find PCNS host to set autostart policy.");
            return false;
        }
        VirtualMachine virtualMachine = this.getVirtualMachineOnWhichPCNSInstalled(serviceInstance);
        if (virtualMachine == null) {
            logger.info("setAutoStartPolicy() - Could not find PCNS VM to set autostart policy.");
            return false;
        }
        try {
            AutoStartPowerInfo autoStartPowerInfo;
            HostAutoStartManager hostAutoStartManager = hostSystem.getHostAutoStartManager();
            HostAutoStartManagerConfig hostAutoStartManagerConfig = hostAutoStartManager.getConfig();
            Object[] objectArray = hostAutoStartManagerConfig.getPowerInfo();
            AutoStartDefaults autoStartDefaults = hostAutoStartManagerConfig.getDefaults();
            autoStartDefaults.setEnabled(Boolean.valueOf(true));
            hostAutoStartManagerConfig.setDefaults(autoStartDefaults);
            if (objectArray == null) {
                objectArray = new AutoStartPowerInfo[]{};
            }
            if ((autoStartPowerInfo = this.findPcnsAutostartPolicy((AutoStartPowerInfo[])objectArray, virtualMachine)) == null) {
                autoStartPowerInfo = new AutoStartPowerInfo();
                autoStartPowerInfo.setKey(virtualMachine.getMOR());
                objectArray = (AutoStartPowerInfo[])ArrayUtils.insert((int)0, (Object[])objectArray, (Object[])new AutoStartPowerInfo[]{autoStartPowerInfo});
                hostAutoStartManagerConfig.setPowerInfo((AutoStartPowerInfo[])objectArray);
            }
            autoStartPowerInfo.setStartAction(AutoStartPolicyAction.POWER_ON.getAction());
            autoStartPowerInfo.setStartDelay(this.utils.getAutostartDelay());
            autoStartPowerInfo.setStartOrder(this.getPcnsAutostartOrder(serviceInstance, hostSystem, (AutoStartPowerInfo[])objectArray));
            autoStartPowerInfo.setStopAction(AutoStartPolicyAction.SYSTEM_DEFAULT.getAction());
            autoStartPowerInfo.setStopDelay(this.virtualConfigurationManager.getShutdownDuration());
            autoStartPowerInfo.setWaitForHeartbeat(AutoStartWaitHeartbeatSetting.systemDefault);
            logger.debug("setAutoStartPolicy() - Reconfigure Autostart policy...");
            hostAutoStartManager.reconfigureAutostart(hostAutoStartManagerConfig);
            return true;
        }
        catch (RemoteException remoteException) {
            logger.info("setAutoStartPolicy() - Could not reach Host Auto Start Manager to set autostart policy.");
            logger.debug((Object)remoteException);
            return false;
        }
    }

    private AutoStartPowerInfo findPcnsAutostartPolicy(@NonNull AutoStartPowerInfo[] autoStartPowerInfoArray, @NonNull VirtualMachine virtualMachine) {
        if (autoStartPowerInfoArray == null) {
            throw new IllegalArgumentException("policies is marked non-null but is null");
        }
        if (virtualMachine == null) {
            throw new IllegalArgumentException("pcnsVM is marked non-null but is null");
        }
        logger.trace("findPcnsAutoStartPolicy() - start");
        AutoStartPowerInfo autoStartPowerInfo = null;
        for (AutoStartPowerInfo autoStartPowerInfo2 : autoStartPowerInfoArray) {
            if (!autoStartPowerInfo2.getKey().equals((Object)virtualMachine.getMOR())) continue;
            autoStartPowerInfo = autoStartPowerInfo2;
            break;
        }
        logger.debug("findPcnsAutoStartPolicy() - found PCNS policy: {}", (Object)(autoStartPowerInfo != null ? 1 : 0));
        logger.trace("findPcnsAutoStartPolicy() - end");
        return autoStartPowerInfo;
    }

    private VirtualMachine findVcsaVM(@NonNull VirtualMachine[] virtualMachineArray, @NonNull ServiceInstance serviceInstance) {
        if (virtualMachineArray == null) {
            throw new IllegalArgumentException("vms is marked non-null but is null");
        }
        if (serviceInstance == null) {
            throw new IllegalArgumentException("si is marked non-null but is null");
        }
        VirtualMachine virtualMachine = null;
        for (VirtualMachine virtualMachine2 : virtualMachineArray) {
            if (!this.isVCenterServerInstalledOnVM(virtualMachine2, serviceInstance)) continue;
            virtualMachine = virtualMachine2;
            break;
        }
        return virtualMachine;
    }

    private int getVMStartOrder(VirtualMachine virtualMachine, @NonNull AutoStartPowerInfo[] autoStartPowerInfoArray) {
        if (autoStartPowerInfoArray == null) {
            throw new IllegalArgumentException("policies is marked non-null but is null");
        }
        if (virtualMachine == null) {
            return 0;
        }
        int n = 0;
        for (AutoStartPowerInfo autoStartPowerInfo : autoStartPowerInfoArray) {
            if (!autoStartPowerInfo.getKey().equals((Object)virtualMachine.getMOR())) continue;
            n = autoStartPowerInfo.getStartOrder();
            break;
        }
        return n;
    }

    private int getPcnsAutostartOrder(@NonNull ServiceInstance serviceInstance, @NonNull HostSystem hostSystem, @NonNull AutoStartPowerInfo[] autoStartPowerInfoArray) throws RemoteException {
        if (serviceInstance == null) {
            throw new IllegalArgumentException("si is marked non-null but is null");
        }
        if (hostSystem == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        if (autoStartPowerInfoArray == null) {
            throw new IllegalArgumentException("policies is marked non-null but is null");
        }
        VirtualMachine[] virtualMachineArray = hostSystem.getVms();
        VirtualMachine virtualMachine = this.vxRailUtils.findVxRailManagerVM(virtualMachineArray);
        VirtualMachine virtualMachine2 = this.findVcsaVM(virtualMachineArray, serviceInstance);
        int n = this.getVMStartOrder(virtualMachine, autoStartPowerInfoArray);
        logger.debug("getPcnsAutoStartOrder() - Found VxRailManager start order: {}", (Object)n);
        int n2 = this.getVMStartOrder(virtualMachine2, autoStartPowerInfoArray);
        logger.debug("getPcnsAutoStartOrder() - Found VCSA start order: {}", (Object)n2);
        int n3 = NumberUtils.max((int)0, (int)n, (int)n2) + 1;
        logger.debug("getPcnsAutoStartOrder() - PCNS Start order: {}", (Object)n3);
        return n3;
    }

    public boolean addStartupTaskForPcns(@NonNull ServiceInstance serviceInstance) {
        if (serviceInstance == null) {
            throw new IllegalArgumentException("serviceInstance is marked non-null but is null");
        }
        if (!this.virtualConfigurationManager.isVxRail()) {
            logger.info("addStartupTaskForPcns() - Setting auto-start task is not supported for non-VxRail clusters.");
            return false;
        }
        HostSystem hostSystem = this.getHostSystemOnWhichPCNSInstalled(serviceInstance);
        if (hostSystem == null) {
            logger.warn("addStartupTaskForPcns() - Could not find PCNS host to set auto-start task.");
            return false;
        }
        VirtualMachine virtualMachine = this.getVirtualMachineOnWhichPCNSInstalled(serviceInstance);
        if (virtualMachine == null) {
            logger.info("addStartupTaskForPcns() - Could not find PCNS VM to set auto-start task.");
            return false;
        }
        ScheduledTaskManager scheduledTaskManager = serviceInstance.getScheduledTaskManager();
        if (scheduledTaskManager == null) {
            logger.debug("addStartupTaskForPcns() - Could not get handle on Scheduled Task Manager.");
            return false;
        }
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
        String string = MessageFormat.format(Utils.getResourceString(resourceBundleWrapper, PCNS_STARTUP_TASK_NAME), virtualMachine.getName());
        String string2 = Utils.getResourceString(resourceBundleWrapper, PCNS_STARTUP_TASK_DESCRIPTION);
        if (this.taskNameExists(scheduledTaskManager, string, virtualMachine)) {
            logger.debug("addStartupTaskForPcns() - Startup task already in place for PCNS");
            return false;
        }
        try {
            ScheduledTaskSpec scheduledTaskSpec = this.createAfterStartupTaskSpec(hostSystem, string, string2, this.vxRailUtils.getScheduledTaskDelay());
            scheduledTaskManager.createScheduledTask((ManagedEntity)virtualMachine, scheduledTaskSpec);
            return true;
        }
        catch (RemoteException remoteException) {
            logger.error("addStartupTaskForPcns() - Failed to set startup task due to: ", (Throwable)remoteException);
            return false;
        }
    }

    private ScheduledTaskSpec createAfterStartupTaskSpec(@NonNull HostSystem hostSystem, @NonNull String string, @NonNull String string2, int n) {
        if (hostSystem == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("taskName is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("description is marked non-null but is null");
        }
        n = Math.max(n, 0);
        n = Math.min(n, Integer.MAX_VALUE);
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't set a blank task name!");
        }
        MethodAction methodAction = new MethodAction();
        methodAction.setName(POWER_ON_VM_TASK_METHOD_NAME);
        MethodActionArgument methodActionArgument = new MethodActionArgument();
        methodActionArgument.setValue((Object)hostSystem.getMOR());
        MethodActionArgument[] methodActionArgumentArray = new MethodActionArgument[]{methodActionArgument};
        methodAction.setArgument(methodActionArgumentArray);
        AfterStartupTaskScheduler afterStartupTaskScheduler = new AfterStartupTaskScheduler();
        afterStartupTaskScheduler.setMinute(n);
        ScheduledTaskSpec scheduledTaskSpec = new ScheduledTaskSpec();
        scheduledTaskSpec.setName(string);
        scheduledTaskSpec.setDescription(string2);
        scheduledTaskSpec.setEnabled(true);
        scheduledTaskSpec.setAction((Action)methodAction);
        scheduledTaskSpec.setScheduler((TaskScheduler)afterStartupTaskScheduler);
        return scheduledTaskSpec;
    }

    private boolean taskNameExists(@NonNull ScheduledTaskManager scheduledTaskManager, @NonNull String string, @NonNull VirtualMachine virtualMachine) {
        if (scheduledTaskManager == null) {
            throw new IllegalArgumentException("stm is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("taskName is marked non-null but is null");
        }
        if (virtualMachine == null) {
            throw new IllegalArgumentException("targetVM is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't abide blank task names.");
        }
        logger.debug("taskNameExists() - Checking for task associated to {}", (Object)virtualMachine);
        boolean bl = false;
        try {
            ScheduledTask[] scheduledTaskArray = scheduledTaskManager.getScheduledTasks();
            if (scheduledTaskArray != null) {
                bl = Arrays.stream(scheduledTaskArray).anyMatch(scheduledTask -> scheduledTask.getInfo() != null && StringUtils.equals((CharSequence)string, (CharSequence)scheduledTask.getInfo().getName()) && scheduledTask.getInfo().getEntity().equals((Object)virtualMachine.getMOR()));
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.warn("taskNameExists() - Error in finding PCNS startup task for {}", (Object)virtualMachine, (Object)nullPointerException);
        }
        logger.debug("taskNameExists() - Found task associated to {}: {}", (Object)virtualMachine, (Object)bl);
        return bl;
    }

    @Generated
    public void setClusterUtils(@NonNull ClusterUtils clusterUtils) {
        if (clusterUtils == null) {
            throw new IllegalArgumentException("clusterUtils is marked non-null but is null");
        }
        this.clusterUtils = clusterUtils;
    }

    @Generated
    public void setVirtualLoggingUtils(@NonNull VirtualizationLoggingUtils virtualizationLoggingUtils) {
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("virtualLoggingUtils is marked non-null but is null");
        }
        this.virtualLoggingUtils = virtualizationLoggingUtils;
    }

    @Generated
    public void setVirtualConfigurationManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
    }

    @Generated
    public void setConfigurationManager(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("configurationManager is marked non-null but is null");
        }
        this.configurationManager = configurationManager;
    }

    @Generated
    public void setVsanUtils(@NonNull VsanUtils vsanUtils) {
        if (vsanUtils == null) {
            throw new IllegalArgumentException("vsanUtils is marked non-null but is null");
        }
        this.vsanUtils = vsanUtils;
    }

    @Generated
    public void setVmPrioritizationUtils(@NonNull VMPrioritizationUtils vMPrioritizationUtils) {
        if (vMPrioritizationUtils == null) {
            throw new IllegalArgumentException("vmPrioritizationUtils is marked non-null but is null");
        }
        this.vmPrioritizationUtils = vMPrioritizationUtils;
    }

    @Generated
    public void setVirtualMachineUtils(@NonNull VirtualMachineUtils virtualMachineUtils) {
        if (virtualMachineUtils == null) {
            throw new IllegalArgumentException("virtualMachineUtils is marked non-null but is null");
        }
        this.virtualMachineUtils = virtualMachineUtils;
    }

    @Generated
    public void setVirtualisationStatusStore(@NonNull VirtualisationStatusStore virtualisationStatusStore) {
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtualisationStatusStore is marked non-null but is null");
        }
        this.virtualisationStatusStore = virtualisationStatusStore;
    }

    @Generated
    public void setVmwareConnection(@NonNull VMWareConnection vMWareConnection) {
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        this.vmwareConnection = vMWareConnection;
    }

    @Generated
    public void setVxRailUtils(@NonNull VxRailUtils vxRailUtils) {
        if (vxRailUtils == null) {
            throw new IllegalArgumentException("vxRailUtils is marked non-null but is null");
        }
        this.vxRailUtils = vxRailUtils;
    }

    @Generated
    public void setUtils(@NonNull Utils utils) {
        if (utils == null) {
            throw new IllegalArgumentException("utils is marked non-null but is null");
        }
        this.utils = utils;
    }

    public static enum HostsStarted {
        NONE,
        SOME,
        ALL;

    }
}

