/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.vmware;

import com.apcc.m11.components.webserver.util.virtualization.vmware.ServiceInstanceConnectionResult;
import com.apcc.m11.components.webserver.util.virtualization.vmware.ServiceInstanceResult;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.trustmanagement.SavingTrustManager;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.NotAuthenticated;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.ws.CustomSSLTrustContextCreator;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Callable;
import javax.net.ssl.TrustManager;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VCenterConnectionCallable
implements Callable<ServiceInstanceResult> {
    private static final Logger logger = LogManager.getLogger(VCenterConnectionCallable.class);
    URL url = null;
    String username = null;
    String password = null;
    boolean skipCertCheck = false;
    private TrustStoreManager trustStoreManager;

    public VCenterConnectionCallable(@NonNull URL uRL, String string, String string2, boolean bl, @NonNull TrustStoreManager trustStoreManager) {
        if (uRL == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        if (trustStoreManager == null) {
            throw new IllegalArgumentException("trustStoreManager is marked non-null but is null");
        }
        this.trustStoreManager = trustStoreManager;
        this.url = uRL;
        this.username = string;
        this.password = string2;
        this.skipCertCheck = bl;
    }

    @Override
    public ServiceInstanceResult call() {
        logger.debug("call() - start, vCenter: {}", (Object)this.url.getHost());
        ServiceInstanceResult serviceInstanceResult = new ServiceInstanceResult();
        ServiceInstanceConnectionResult serviceInstanceConnectionResult = ServiceInstanceConnectionResult.SUCCESS;
        try {
            ServiceInstance serviceInstance = this.makeServiceInstance(this.url, this.username, this.password, this.skipCertCheck);
            serviceInstanceResult.setServiceInstance(serviceInstance);
        }
        catch (NotAuthenticated notAuthenticated) {
            logger.debug("call() - failed connecting to: {}, NotAuthenticated: {}", (Object)this.url.getHost(), (Object)notAuthenticated);
            serviceInstanceConnectionResult = ServiceInstanceConnectionResult.NOT_AUTHENTICATED;
            serviceInstanceResult.setException((Exception)((Object)notAuthenticated));
        }
        catch (InvalidLogin invalidLogin) {
            logger.debug("call() - failed connecting to: {}, InvalidLogin: {}", (Object)this.url.getHost(), (Object)invalidLogin);
            serviceInstanceConnectionResult = ServiceInstanceConnectionResult.INVALID_LOGIN;
            serviceInstanceResult.setException((Exception)((Object)invalidLogin));
        }
        catch (MalformedURLException malformedURLException) {
            logger.debug("call() - failed connecting to: {}, MalformedURLException: {}", (Object)this.url.getHost(), (Object)malformedURLException);
            serviceInstanceConnectionResult = ServiceInstanceConnectionResult.MALFORMED_URL_EXCEPTION;
            serviceInstanceResult.setException(malformedURLException);
        }
        catch (Exception exception) {
            logger.debug("call() - failed connecting to: {}, Exception: {}", (Object)this.url.getHost(), (Object)exception);
            String string = exception.getMessage();
            if (string.contains("InvalidLogin")) {
                ServiceManager.getInstance().getShutdownLogger().logShutdownReason(this.url.getHost(), 225);
            }
            if (string.contains("NoPermission") || string.contains("Permission denied")) {
                ServiceManager.getInstance().getShutdownLogger().logShutdownReason(this.url.getHost(), 227);
            }
            serviceInstanceConnectionResult = ServiceInstanceConnectionResult.EXCEPTION;
            serviceInstanceResult.setException(exception);
        }
        serviceInstanceResult.setServiceInstanceConnectionResult(serviceInstanceConnectionResult);
        logger.debug("call() - end, result: {}", (Object)serviceInstanceConnectionResult);
        return serviceInstanceResult;
    }

    private ServiceInstance makeServiceInstance(URL uRL, String string, String string2, boolean bl) throws RemoteException, MalformedURLException {
        ServiceInstance serviceInstance;
        if (bl) {
            serviceInstance = new ServiceInstance(uRL, string, string2, bl);
        } else {
            SavingTrustManager savingTrustManager = null;
            CustomSSLTrustContextCreator.setContextAlreadyCreated((boolean)false);
            try {
                savingTrustManager = this.trustStoreManager.makeSavingTrustManager();
                serviceInstance = new ServiceInstance(uRL, string, string2, (TrustManager)savingTrustManager);
            }
            catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
                logger.error("makeServiceInstance() Error getting Saving Trust Manager, just using certCheck instead", (Throwable)generalSecurityException);
                serviceInstance = new ServiceInstance(uRL, string, string2, bl);
            }
        }
        return serviceInstance;
    }
}

