/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.vmware;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.vmware.ESXiConnectionCallable;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostLoginException;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.ServiceInstanceConnectionResult;
import com.apcc.m11.components.webserver.util.virtualization.vmware.ServiceInstanceResult;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VCenterConnectionCallable;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareDetails;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VirtualMachineUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.trustmanagement.SavingTrustManager;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.util.HostNameLookUpTable;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.NotAuthenticated;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.ws.Client;
import com.vmware.vim25.ws.CustomSSLTrustContextCreator;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMWareConnection {
    private static final String PROCESS_CONNECTION_FAILURE_FAILED_CONNECTING_TO_HOST = "processConnectionFailure() - failed connecting to host: ";
    private static final String PROCESS_CONNECTION_FAILURE_LOG = "processConnectionFailure() - ";
    private static final String DOMAIN_SUFFIX = "@localos";
    private static final String DOMAIN_PREFIX = "localos//";
    private static final Logger logger = LogManager.getLogger(VMWareConnection.class);
    public static final Integer NOT_VCSA_CONFIG = 0;
    public static final Integer VM_HOST_NOT_FOUND = -1;
    public static final Integer VM_POWERED_OFF = -2;
    public static final Integer VM_POWERED_ON = 1;
    public static final Integer NOT_VMA_CONFIG = 0;
    public static final Integer VM_NOT_FOUND = -3;
    private static final int VSPHERE_CONNECT_TIMEOUT = 10000;
    private static final int VSPHERE_READ_TIMEOUT = 15000;
    private Semaphore checkStatusMutex = new Semaphore(1);
    private Optional<ServiceInstance> vCenterServiceInstance = Optional.empty();
    private Integer vCSAStatus = NOT_VCSA_CONFIG;
    private Integer vMAStatus = null;
    private boolean vCenterOffline = false;
    private boolean vCenterServerConnectionState = true;
    private Map<String, ServiceInstance> hostMap = new ConcurrentHashMap<String, ServiceInstance>();
    private Map<String, Boolean> hostConnectionStateMap = new ConcurrentHashMap<String, Boolean>();
    private static final String URL_TEMPLATE = "{0}://{1}:{2}/sdk";
    private String vCenterConn = null;
    private Integer loggedVCSAStatus = NOT_VCSA_CONFIG;
    private boolean disableCheckStatus = false;
    @NonNull
    private VirtualisationStatusStore virtualisationStatusStore;
    @NonNull
    private AuthHelper authHelper;
    @NonNull
    private VirtualConfigurationManager virtualConfigurationManager;
    @NonNull
    private HostSystemUtils hostSystemUtils;
    @NonNull
    private VirtualMachineUtils virtualMachineUtils;
    @NonNull
    private ConfigurationManager configurationManager;
    @NonNull
    private ApplicationErrorHandler applicationErrorHandler;
    @NonNull
    private TrustStoreManager trustStoreManager;

    public VMWareConnection() {
    }

    public VMWareConnection(@NonNull VirtualisationStatusStore virtualisationStatusStore, @NonNull AuthHelper authHelper, @NonNull VirtualConfigurationManager virtualConfigurationManager, @NonNull HostSystemUtils hostSystemUtils, @NonNull VirtualMachineUtils virtualMachineUtils, @NonNull ConfigurationManager configurationManager, @NonNull ApplicationErrorHandler applicationErrorHandler) {
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtualisationStatusStore is marked non-null but is null");
        }
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        if (virtualMachineUtils == null) {
            throw new IllegalArgumentException("virtualMachineUtils is marked non-null but is null");
        }
        if (configurationManager == null) {
            throw new IllegalArgumentException("configManager is marked non-null but is null");
        }
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("applicationErrorHandler is marked non-null but is null");
        }
        this.authHelper = authHelper;
        this.hostSystemUtils = hostSystemUtils;
        this.virtualConfigurationManager = virtualConfigurationManager;
        this.virtualisationStatusStore = virtualisationStatusStore;
        this.virtualMachineUtils = virtualMachineUtils;
        this.configurationManager = configurationManager;
        this.applicationErrorHandler = applicationErrorHandler;
    }

    public ServiceInstance getVCenterConnection(String string, String string2, String string3, boolean bl, boolean bl2) {
        logger.debug("getVCenterConnection() - URL: {}, Username: {}, Password: {}, SkipCerts: {}, StoreDetails: {}", (Object)string, (Object)StringUtils.isNotBlank((CharSequence)string2), (Object)StringUtils.isNotBlank((CharSequence)string3), (Object)bl, (Object)bl2);
        if (bl2) {
            this.virtualConfigurationManager.setServerIP(string);
            this.authHelper.setVCenterUser(string2);
            this.authHelper.setVCenterPassword(string3);
            this.setVCenterConnectionFromPermStorage();
        }
        this.setVCenterServiceInstance(this.getVCenterConnection(string, string2, string3, bl));
        this.runStatusCheck();
        return this.vCenterServiceInstance.orElse(null);
    }

    public synchronized ServiceInstance getVCenterConnection(VMWareDetails vMWareDetails, boolean bl) throws RemoteException, MalformedURLException {
        if (vMWareDetails == null) {
            return null;
        }
        ServiceInstance serviceInstance = null;
        if (!bl) {
            URL uRL;
            this.logoutVCenterServer();
            try {
                uRL = this.getVCenterURL(vMWareDetails.getServerIp(), vMWareDetails.getProtocol(), vMWareDetails.getPort());
            }
            catch (MalformedURLException malformedURLException) {
                logger.error("getVCenterConnection - Failed to create URL for {}, due to {}", (Object)vMWareDetails.getServerIp(), (Object)malformedURLException);
                return null;
            }
            serviceInstance = this.makeServiceInstance(uRL, vMWareDetails.getUsername(), vMWareDetails.getPassword());
            if (serviceInstance != null) {
                Client client = serviceInstance.getServerConnection().getVimService().getWsc();
                client.setConnectTimeout(this.getConnectTimeout());
                client.setReadTimeout(this.getReadTimeout());
            }
        } else if (!this.vCenterServiceInstance.isPresent() || !this.compareVCenterSessionDetails(vMWareDetails)) {
            URL uRL;
            this.logoutVCenterServer();
            try {
                uRL = this.getVCenterURL(vMWareDetails.getServerIp(), vMWareDetails.getProtocol(), vMWareDetails.getPort());
            }
            catch (MalformedURLException malformedURLException) {
                logger.error("getVCenterConnection - Failed to create a URL for {}, due to {}", (Object)vMWareDetails.getServerIp(), (Object)malformedURLException);
                return null;
            }
            serviceInstance = this.makeServiceInstance(uRL, vMWareDetails.getUsername(), vMWareDetails.getPassword());
            if (serviceInstance != null) {
                Client client = serviceInstance.getServerConnection().getVimService().getWsc();
                client.setConnectTimeout(this.getConnectTimeout());
                client.setReadTimeout(this.getReadTimeout());
                if (!this.isvCenterServerConnectionSuccessful()) {
                    this.setVCenterOffline(false);
                    this.postVCenterOnlineEvent();
                    this.setvCenterServerConnectionSuccessful(true);
                }
            }
        }
        this.setVCenterServiceInstance(serviceInstance);
        this.runStatusCheck();
        return this.vCenterServiceInstance.orElse(null);
    }

    private ServiceInstance makeServiceInstance(URL uRL, String string, String string2) throws RemoteException, MalformedURLException {
        ServiceInstance serviceInstance = null;
        SavingTrustManager savingTrustManager = null;
        try {
            CustomSSLTrustContextCreator.setContextAlreadyCreated((boolean)false);
            savingTrustManager = this.trustStoreManager.makeSavingTrustManager();
            serviceInstance = new ServiceInstance(uRL, string, string2, (TrustManager)savingTrustManager);
        }
        catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            logger.error("makeServiceInstance() Error getting Saving Trust Manager", (Throwable)generalSecurityException);
        }
        return serviceInstance;
    }

    private synchronized ServiceInstance getVCenterConnection(String string, String string2, String string3, boolean bl) {
        URL uRL;
        logger.debug("getVCenterConnection() - start, server IP: {}", (Object)string);
        try {
            uRL = new URL(this.getVCenterURL(string));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("getVCenterConnection() - Failed to create URL for {} due to {}", (Object)string, (Object)malformedURLException);
            return null;
        }
        if (!this.vCenterServiceInstance.isPresent() && this.isVcsaConnectionValid()) {
            int n = this.getConnectTimeout();
            Future<ServiceInstanceResult> future = Executors.newCachedThreadPool().submit(new VCenterConnectionCallable(uRL, string2, string3, bl, this.trustStoreManager));
            try {
                ServiceInstanceResult serviceInstanceResult = future.get(n, TimeUnit.MILLISECONDS);
                logger.debug("getVCenterConnection(...) - vCenter connection thread has completed");
                if (serviceInstanceResult != null && serviceInstanceResult.getServiceInstanceConnectionResult() == ServiceInstanceConnectionResult.SUCCESS) {
                    logger.debug("getVCenterConnection(...) - connection to vCenter: {} was successful, setting timeouts", (Object)this.vCenterConn);
                    ServiceInstance serviceInstance = serviceInstanceResult.getServiceInstance();
                    Client client = serviceInstance.getServerConnection().getVimService().getWsc();
                    client.setConnectTimeout(n);
                    client.setReadTimeout(this.getReadTimeout());
                    if (!this.isvCenterServerConnectionSuccessful()) {
                        this.setVCenterOffline(false);
                        this.postVCenterOnlineEvent();
                        this.setvCenterServerConnectionSuccessful(true);
                    }
                    this.setVCenterServiceInstance(serviceInstance);
                } else {
                    this.vCenterConnectionFailure(serviceInstanceResult);
                }
            }
            catch (TimeoutException timeoutException) {
                logger.error("getVCenterConnection(...) - timed out while trying to establish a connection to vCenter: {}", (Object)this.vCenterConn);
                this.logVCenterOffline();
            }
            catch (InterruptedException interruptedException) {
                logger.error("getVCenterConnection(...) - InterruptedException: {} while trying to connect to vCenter: {}", (Object)interruptedException, (Object)this.vCenterConn);
                this.logVCenterOffline();
                Thread.currentThread().interrupt();
            }
            catch (CompletionException | ExecutionException exception) {
                logger.error("getVCenterConnection(...) - ExecutionException: {} while trying to connect to vCenter: {}", (Object)exception, (Object)this.vCenterConn);
                this.logVCenterOffline();
            }
            catch (Exception exception) {
                logger.error("getVCenterConnection(...) - Exception: {} while trying to connect to vCenter: {}", (Object)exception, (Object)this.vCenterConn);
                this.logVCenterOffline();
            }
        }
        logger.debug("getVCenterConnection(...) - end");
        return this.vCenterServiceInstance.orElse(null);
    }

    private void vCenterConnectionFailure(ServiceInstanceResult serviceInstanceResult) {
        ServiceInstanceConnectionResult serviceInstanceConnectionResult;
        logger.debug("vCenterConnectionFailure() - start");
        if (serviceInstanceResult == null) {
            logger.error("vCenterConnectionFailure() - failed connecting to vCenter: {}", (Object)this.vCenterConn);
            this.logVCenterOffline();
            return;
        }
        if (serviceInstanceResult.getException() != null) {
            this.logVCenterErrorToConsole("vCenterConnectionFailure() - failed connecting to vCenter: " + this.vCenterConn + " - ", serviceInstanceResult.getException());
        }
        if ((serviceInstanceConnectionResult = serviceInstanceResult.getServiceInstanceConnectionResult()) == ServiceInstanceConnectionResult.NOT_AUTHENTICATED || serviceInstanceConnectionResult == ServiceInstanceConnectionResult.INVALID_LOGIN) {
            this.logVCenterAuthFailure();
        }
        if (serviceInstanceConnectionResult == ServiceInstanceConnectionResult.EXCEPTION) {
            this.logVCenterOffline();
        }
    }

    private boolean isVcsaConnectionValid() {
        String string = this.virtualisationStatusStore.getProperty("VCSA_VM");
        String string2 = this.virtualisationStatusStore.getProperty("VCSA_HOST");
        if (string != null && string2 != null) {
            logger.debug("isVcsaConnectionValid() - not attempting connection, found VCSA_VM: {} and VCSA_HOST: {} keys in properties file", (Object)string, (Object)string2);
            this.setVCenterOffline(true);
            this.logVCenterOffline();
            return false;
        }
        return true;
    }

    public ServiceInstance getVCenterConnection(int n, long l, @NonNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("retryPeriodUnits is marked non-null but is null");
        }
        if (!this.virtualConfigurationManager.areVCenterCredentialsSet()) {
            logger.debug("getVCenterConnection() - VCenter Credentials not set.  Not attempting connection");
            return null;
        }
        n = Math.max(1, n);
        l = Math.max(0L, l);
        logger.debug("getVCenterConnection() - Retries: {}, Period: {}, Units: {}", (Object)n, (Object)l, (Object)timeUnit);
        ServiceInstance serviceInstance = null;
        do {
            if ((serviceInstance = this.getVCenterConnection()) != null) continue;
            logger.debug("getVCenterConnection() - Failed to get VCenter Connection.  Retries left: {}", (Object)n);
            new CountdownTimer(l, timeUnit).sleep();
        } while (serviceInstance == null && --n > 0);
        logger.debug("getVCenterConnection() - Got connection: {}", (Object)(serviceInstance != null ? 1 : 0));
        return serviceInstance;
    }

    public ServiceInstance getVCenterConnectionWithRetries() {
        logger.debug("getVCenterConnectionWithRetries() - start.");
        return this.getVCenterConnection(3, 5L, TimeUnit.SECONDS);
    }

    public synchronized ServiceInstance getVCenterConnection() {
        logger.debug("getVCenterConnection() - start");
        if (this.isVCenterOffline()) {
            logger.debug("getVCenterConnection() - PCNS has taken VCSA offline.  Not attempting reconnection");
            return this.vCenterServiceInstance.orElse(null);
        }
        if (this.vCenterServiceInstance.isPresent() && !this.isValidServiceInstance()) {
            logger.debug("getVCenterConnection() - VCSA connection not valid.  Logging out.");
            this.logoutVCenterServer();
        }
        if (!this.vCenterServiceInstance.isPresent()) {
            logger.debug("getVCenterConnection() - Attempting reconnect to VCSA...");
            this.setVCenterConnectionFromPermStorage();
        }
        this.runStatusCheck();
        logger.debug("getVCenterConnection() - end");
        return this.vCenterServiceInstance.orElse(null);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void runStatusCheck() {
        if (this.checkStatusMutex.tryAcquire()) {
            try {
                VMWareConnection.logger.debug("runStatusCheck() - disableCheckStatus: {}", (Object)this.disableCheckStatus);
                if (this.disableCheckStatus) ** GOTO lbl12
                this.vCSAStatus = this.checkVCSAStatus();
                this.vMAStatus = this.checkVMAStatus();
            }
            finally {
                this.checkStatusMutex.release();
            }
        } else {
            VMWareConnection.logger.debug("runStatusCheck() - Check already underway.");
        }
lbl12:
        // 3 sources

        VMWareConnection.logger.debug("runStatusCheck() - end");
    }

    private synchronized boolean compareVCenterSessionDetails(VMWareDetails vMWareDetails) {
        try {
            return this.vCenterServiceInstance.isPresent() && this.vCenterServiceInstance.get().getServerConnection().getUrl().toString().equalsIgnoreCase(this.getURL(vMWareDetails.getServerIp(), vMWareDetails.getProtocol(), vMWareDetails.getPort()).toString()) && this.vCenterServiceInstance.get().getServerConnection().getUsername().equalsIgnoreCase(vMWareDetails.getUsername()) && vMWareDetails.getPassword().equalsIgnoreCase(this.authHelper.getVCenterPassword()) && vMWareDetails.isSkipCertCheck() == this.virtualConfigurationManager.isSkipCertCheck();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private void postVCenterOnlineEvent() {
        try {
            String string = new VirtualizationFeaturesFormatter(31).format(null);
            this.applicationErrorHandler.put(string);
            this.setvCenterServerConnectionSuccessful(true);
            logger.info("postVCenterOnlineEvent() - connection to VCenter Server successfully established");
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("postVCenterOnlineEvent() - FormatterException | UnsupportedLocaleException: ", throwable);
        }
    }

    public synchronized void setVCenterOffline(boolean bl) {
        logger.debug("setVCenterStatus() - setting vCenterOffline to: {}", (Object)bl);
        this.vCenterOffline = bl;
    }

    public synchronized boolean isVCenterOffline() {
        return this.vCenterOffline;
    }

    public synchronized boolean validateServiceInstance() {
        logger.debug("validateServiceInstance() - start");
        boolean bl = false;
        if (this.isvCenterServerConnectionSuccessful()) {
            logger.debug("validateServiceInstance() - connection successful");
            bl = this.isValidServiceInstance();
            if (!bl) {
                this.setVCenterServiceInstance(null);
                this.logVCenterOffline();
            }
        }
        logger.debug("validateServiceInstance() - result: {}", (Object)bl);
        return bl;
    }

    private synchronized boolean isValidServiceInstance() {
        logger.debug("isValidServiceInstance() - start");
        boolean bl = false;
        try {
            logger.debug("isValidServiceInstance() - vCenterServiceInstance present: {}", (Object)this.vCenterServiceInstance.isPresent());
            if (this.vCenterServiceInstance.isPresent() && this.vCenterServiceInstance.get().getSessionManager() != null && this.vCenterServiceInstance.get().getSessionManager().getCurrentSession() != null) {
                String string = this.vCenterServiceInstance.get().getSessionManager().getCurrentSession().getKey();
                String string2 = this.vCenterServiceInstance.get().getSessionManager().getCurrentSession().getUserName();
                logger.debug("isValidServiceInstance() - Session ID: {}", (Object)string);
                if (this.vCenterServiceInstance.get().getSessionManager().sessionIsActive(string, string2)) {
                    logger.debug("isValidServiceInstance() - valid session found");
                    bl = !this.hostSystemUtils.isVCSAShuttingDown(this.vCenterServiceInstance.get());
                }
            }
        }
        catch (InvalidLogin | NotAuthenticated throwable) {
            this.logVCenterAuthFailure();
            logger.error("isValidServiceInstance() - unable to log into vCenter host: {} - {}", (Object)this.vCenterConn, (Object)throwable.getMessage());
            logger.debug("isValidServiceInstance() - unable to log into vCenter host: {} - ", (Object)this.vCenterConn, (Object)throwable);
        }
        catch (RemoteException remoteException) {
            this.logoutVCenterServer();
            String string = remoteException.getMessage();
            if (string.contains("NoPermission") || string.contains("Permission denied")) {
                ServiceManager.getInstance().getShutdownLogger().logShutdownReason(this.vCenterConn, 227);
            }
            if (remoteException.getCause() instanceof ConnectException || remoteException.getCause() instanceof SocketTimeoutException) {
                this.logVCenterOffline();
            }
            logger.error("isValidServiceInstance() - unable to connect to vCenter host: {} - {}", (Object)this.vCenterConn, (Object)remoteException.getMessage());
            logger.debug("isValidServiceInstance() - unable to connect to vCenter host: {} - ", (Object)this.vCenterConn, (Object)remoteException);
        }
        catch (Exception exception) {
            this.logoutVCenterServer();
            logger.error("isValidServiceInstance() - unable to connect to vCenter host: {} - {}", (Object)this.vCenterConn, (Object)exception.getMessage());
            logger.debug("isValidServiceInstance() - unable to connect to vCenter host: {} - ", (Object)this.vCenterConn, (Object)exception);
        }
        logger.debug("isValidServiceInstance() - end, result: {}", (Object)bl);
        return bl;
    }

    public void logVCenterOffline() {
        try {
            if (this.isvCenterServerConnectionSuccessful()) {
                String string = new VirtualizationFeaturesFormatter(16).format(null);
                this.applicationErrorHandler.put(string);
                this.setvCenterServerConnectionSuccessful(false);
            }
        }
        catch (Exception exception) {
            logger.error("logVCenterOffline() - Exception: ", (Throwable)exception);
        }
    }

    public void logVCenterAuthFailure() {
        try {
            if (this.isvCenterServerConnectionSuccessful()) {
                String string = new VirtualizationFeaturesFormatter(17).format(null);
                this.applicationErrorHandler.put(string);
                this.setvCenterServerConnectionSuccessful(false);
            }
        }
        catch (Exception exception) {
            logger.error("logVCenterAuthFailure() - Exception: ", (Throwable)exception);
        }
    }

    private synchronized ServiceInstance setVCenterConnectionFromPermStorage() {
        String string = this.virtualConfigurationManager.getVCenterUsername();
        String string2 = this.virtualConfigurationManager.getVCenterPassword();
        boolean bl = this.virtualConfigurationManager.isSkipCertCheck();
        if (string != null && string2 != null) {
            this.setVCenterServiceInstance(this.getVCenterConnection(null, string, string2, bl));
        }
        this.runStatusCheck();
        return this.vCenterServiceInstance.orElse(null);
    }

    public synchronized void logoutVCenterServer(boolean bl) {
        if (this.vCenterServiceInstance.isPresent()) {
            try {
                if (bl && this.vCenterServiceInstance.get().getSessionManager() != null) {
                    this.vCenterServiceInstance.get().getSessionManager().logout();
                    if (this.isValidServiceInstance()) {
                        logger.error("logoutVCenterServer() - vCenter server session couldn't be finished");
                    }
                }
                this.vCenterServiceInstance.get().getServerConnection().logout();
            }
            catch (RemoteException remoteException) {
                logger.error("logoutVCenterServer() - RemoteException: ", (Throwable)remoteException);
            }
            this.setVCenterServiceInstance(null);
            this.setvCenterServerConnectionSuccessful(true);
        }
    }

    public synchronized void logoutVCenterServer() {
        if (this.vCenterServiceInstance.isPresent()) {
            this.vCenterServiceInstance.get().getServerConnection().logout();
            this.setVCenterServiceInstance(null);
            this.setvCenterServerConnectionSuccessful(true);
        }
    }

    public void logoutESXiHost(String string) {
        ServiceInstance serviceInstance = this.hostMap.get(string = this.toHostname(string));
        if (serviceInstance != null) {
            serviceInstance.getServerConnection().logout();
            this.hostMap.remove(string);
        }
    }

    private URL getVCenterURL(String string, String string2, String string3) throws MalformedURLException {
        Object object = "";
        URL uRL = null;
        logger.debug("getVCenterURL() - start, URL: {}, Protocol: {}, Port: {}", (Object)string, (Object)string2, (Object)string3);
        object = StringUtils.isNotEmpty((CharSequence)string) ? string : this.virtualConfigurationManager.getServerIP();
        if (object != null) {
            this.vCenterConn = object;
            if (((String)object).indexOf(58) >= 0 && !((String)object).startsWith("[") && !((String)object).endsWith("]")) {
                object = "[" + (String)object + "]";
            }
            uRL = this.getURL((String)object, string2, string3);
        }
        logger.debug("getVCenterURL() - end, result: {}", uRL);
        return uRL;
    }

    private String getVCenterURL(String string) {
        Object object = "";
        String string2 = "";
        logger.debug("getvCenterServerURL() - start, result: {}", (Object)string);
        object = StringUtils.isNotEmpty((CharSequence)string) ? string : this.virtualConfigurationManager.getServerIP();
        if (StringUtils.isNotBlank((CharSequence)object)) {
            this.vCenterConn = object;
            if (((String)object).indexOf(58) >= 0 && !((String)object).startsWith("[") && !((String)object).endsWith("]")) {
                object = "[" + (String)object + "]";
            }
            string2 = this.getURL((String)object);
        }
        logger.debug("getvCenterServerURL() - end, result: {}", (Object)string2);
        return string2;
    }

    private String getURL(String object) {
        logger.debug("getURL() - start, hostname: {}", object);
        String string = null;
        String string2 = this.virtualConfigurationManager.getServerProtocol();
        int n = this.virtualConfigurationManager.getServerPort(string2);
        if (StringUtils.countMatches((CharSequence)object, (CharSequence)":") > 1) {
            logger.debug("getURL() - ipv6 address in URL: {}", object);
            if (!StringUtils.startsWith((CharSequence)object, (CharSequence)"[")) {
                object = "[" + (String)object;
            }
            if (!StringUtils.endsWith((CharSequence)object, (CharSequence)"]")) {
                object = (String)object + "]";
            }
            logger.debug("getURL() - ipv6 address fixed to: {}", object);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        arrayList.add((String)object);
        arrayList.add(String.valueOf(n));
        if (object != null) {
            string = MessageFormat.format(URL_TEMPLATE, arrayList.toArray());
        }
        logger.debug("getURL() - end, result: {}", string);
        return string;
    }

    private URL getURL(String object, String string, String string2) throws MalformedURLException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{object, string, string2})) {
            throw new IllegalArgumentException("URL inputs can't be blank.");
        }
        URL uRL = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        logger.debug("getURL() - start, hostname: {}, protocol: {}, port: {}", object, (Object)string, (Object)string2);
        if (StringUtils.countMatches((CharSequence)object, (CharSequence)":") > 1) {
            logger.debug("getURL() - ipv6 address in URL: {}", object);
            if (!StringUtils.startsWith((CharSequence)object, (CharSequence)"[")) {
                object = "[" + (String)object;
            }
            if (!StringUtils.endsWith((CharSequence)object, (CharSequence)"]")) {
                object = (String)object + "]";
            }
            logger.debug("getURL() - ipv6 address fixed to: {}", object);
        }
        arrayList.add((String)object);
        arrayList.add(string2);
        if (object != null) {
            String string3 = MessageFormat.format(URL_TEMPLATE, arrayList.toArray());
            try {
                uRL = new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                logger.warn("getURL() - Failed to crate URL from spec: {}, due to {}", (Object)string3, (Object)malformedURLException);
                throw malformedURLException;
            }
        }
        logger.debug("getURL() - end, result: {}", uRL);
        return uRL;
    }

    private void logVCenterErrorToConsole(String string, Exception exception) {
        if (this.isvCenterServerConnectionSuccessful()) {
            logger.error(string + ". " + (exception != null && exception.getMessage() != null ? exception.getMessage() : "[no details available]"));
        }
    }

    private ServiceInstance setESXiHostConnectionFromPermStorage(String string) {
        logger.debug("setESXiHostConnectionFromPermStorage() - start");
        ServiceInstance serviceInstance = null;
        String string2 = null;
        String string3 = null;
        if (this.virtualConfigurationManager.isUnmanagedHost()) {
            string2 = this.authHelper.getEsxHostUser();
            string3 = this.authHelper.getEsxHostPassword();
        } else {
            string2 = this.virtualConfigurationManager.getVCenterUsername();
            string3 = this.virtualConfigurationManager.getVCenterPassword();
        }
        if (string2 != null && string3 != null) {
            serviceInstance = this.getESXiHostConnection(string, string2, string3, false);
        }
        logger.debug("setESXiHostConnectionFromPermStorage() - end");
        return serviceInstance;
    }

    public ServiceInstance getESXiHostInstance() {
        logger.debug("getESXiHostInstance() - start");
        String string = this.virtualConfigurationManager.getServerIP();
        if (StringUtils.isEmpty((CharSequence)string)) {
            logger.debug("getESXiHostInstance() - server IP/hostname is NULL, cannot retrieve connection");
            return null;
        }
        ServiceInstance serviceInstance = this.hostMap.get(string = this.toHostname(string));
        if (serviceInstance == null) {
            if (this.isESXiHostConnectionSuccessful(string)) {
                serviceInstance = this.setESXiHostConnectionFromPermStorage(string);
                if (serviceInstance == null) {
                    logger.debug("getESXiHostInstance() - connection from permanent storage is NULL, returning NULL");
                    return null;
                }
                this.hostMap.put(string, serviceInstance);
            }
        } else {
            this.validateESXiConnection(string);
        }
        logger.debug("getESXiHostInstance() - end");
        return this.hostMap.get(string);
    }

    private void validateESXiConnection(String string) {
        logger.debug("validateESXiConnection() - start, host: {}", (Object)string);
        try {
            string = this.toHostname(string);
            ServiceInstance serviceInstance = this.hostMap.get(string);
            if (serviceInstance != null) {
                serviceInstance.currentTime();
                logger.debug("validateESXiConnection() - ESXi service instance is valid");
            } else {
                logger.error("validateESXiConnection() - host: {} not found in ESXi connection map", (Object)string);
                this.logoutESXiAndCreateNewInstance(string);
            }
        }
        catch (NotAuthenticated notAuthenticated) {
            logger.error("validateESXiConnection() - host: {} - {}, attempting reconnection", (Object)string, (Object)notAuthenticated.getLocalizedMessage());
            logger.debug("validateESXiConnection() - host: {}, session timeout, attempting reconnection", (Object)string);
            this.logoutESXiAndCreateNewInstance(string);
        }
        catch (InvalidLogin invalidLogin) {
            logger.error("validateESXiConnection() - host: {}, InvalidLogin: ", (Object)string, (Object)invalidLogin);
        }
        catch (RemoteException remoteException) {
            logger.error("validateESXiConnection() - host: {}, RemoteException occurred, attempting reconnection", (Object)string);
            logger.debug((Object)remoteException);
            this.logoutESXiAndCreateNewInstance(string);
        }
        catch (Exception exception) {
            logger.error("validateESXiConnection() - host: {}, Exception occurred, attempting reconnection", (Object)string, (Object)exception);
            this.logoutESXiAndCreateNewInstance(string);
        }
        logger.debug("validateESXiConnection() - end");
    }

    private void logoutESXiAndCreateNewInstance(String string) {
        logger.debug("logoutESXiAndCreateNewInstance() - start, host: {}", (Object)string);
        try {
            string = this.toHostname(string);
            ServiceInstance serviceInstance = this.hostMap.get(string);
            if (serviceInstance != null) {
                this.hostMap.remove(string);
                serviceInstance.getServerConnection().logout();
            }
        }
        catch (Exception exception) {
            logger.error("logoutESXiAndCreateNewInstance() - host: {}, Exception: ", (Object)string, (Object)exception);
        }
        this.setESXiHostConnectionFromPermStorage(string);
        logger.debug("logoutESXiAndCreateNewInstance() - end");
    }

    public ServiceInstance getESXiHostInstance(VMWareDetails vMWareDetails) throws RemoteException, MalformedURLException {
        if (vMWareDetails == null) {
            return null;
        }
        logger.debug("getESXiHostInstanceConnection() - start");
        URL uRL = null;
        String string = vMWareDetails.getServerIp();
        if (string != null) {
            uRL = this.getURL(string, vMWareDetails.getProtocol(), vMWareDetails.getPort());
        }
        if (this.hostMap.get(string = this.toHostname(string)) == null) {
            ServiceInstance serviceInstance = this.makeServiceInstance(uRL, vMWareDetails.getUsername(), vMWareDetails.getPassword());
            if (serviceInstance != null) {
                this.hostMap.put(string, serviceInstance);
                Client client = serviceInstance.getServerConnection().getVimService().getWsc();
                client.setConnectTimeout(this.getConnectTimeout());
                client.setReadTimeout(this.getReadTimeout());
                if (!this.isESXiHostConnectionSuccessful(string)) {
                    this.postESXIHostOnlineEvent();
                    this.setESXiHostConnectionSuccessful(string, true);
                }
                logger.info("getESXiHostInstanceConnection() - connection to ESXi host: {} successfully established", (Object)string);
            }
        } else {
            this.validateESXiConnection(string);
        }
        logger.debug("getESXiHostInstanceConnection() - end");
        return this.hostMap.get(string);
    }

    public ServiceInstance getESXiHostInstance(String string) {
        return this.getESXiHostConnection(string, this.virtualConfigurationManager.getEsxHostUsername(), this.virtualConfigurationManager.getEsxHostPassword(), false);
    }

    public ServiceInstance getESXiHostInstance(String string, boolean bl) {
        return this.getESXiHostConnection(string, this.virtualConfigurationManager.getEsxHostUsername(), this.virtualConfigurationManager.getEsxHostPassword(), bl);
    }

    public ServiceInstance getESXiHostInstance(String string, boolean bl, boolean bl2) throws HostLoginException {
        return this.getESXiHostConnection(string, this.virtualConfigurationManager.getEsxHostUsername(), this.virtualConfigurationManager.getEsxHostPassword(), bl, bl2);
    }

    private void postESXIHostOnlineEvent() {
        logger.debug("postESXIHostOnlineEvent() - start");
        if (!this.virtualConfigurationManager.isUnmanagedHost()) {
            return;
        }
        try {
            String string = new VirtualizationFeaturesFormatter(47).format(null);
            this.applicationErrorHandler.put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("postESXIHostOnlineEvent() - FormatterException | UnsupportedLocaleException: ", throwable);
        }
    }

    private ServiceInstance getESXiHostConnection(String string, String string2, String string3, boolean bl) {
        ServiceInstance serviceInstance = null;
        try {
            serviceInstance = this.getESXiHostConnection(string, string2, string3, bl, false);
        }
        catch (HostLoginException hostLoginException) {
            logger.error("getESXiHostConnection() should not return an exception when the argument is set to false", (Throwable)hostLoginException);
        }
        return serviceInstance;
    }

    private ServiceInstance getESXiHostConnection(String string, String string2, String string3, boolean bl, boolean bl2) throws HostLoginException {
        block13: {
            logger.debug("getESXiHostConnection() - start, host: {}", (Object)string);
            try {
                if (string == null || string.isEmpty()) {
                    if (this.virtualConfigurationManager.isUnmanagedHost()) {
                        string = this.virtualConfigurationManager.getServerIP();
                        logger.debug("getESXiHostConnection() - reading server IP from ini, found: {}", (Object)string);
                    } else {
                        logger.error("getESXiHostConnection() - unable to connect to host null");
                        return null;
                    }
                }
                if (this.hostMap.get(string = this.toHostname(string)) == null) {
                    string2 = this.removeLocalosFromUsername(string2);
                    boolean bl3 = this.virtualConfigurationManager.isSkipCertCheck();
                    Future<ServiceInstanceResult> future = Executors.newCachedThreadPool().submit(new ESXiConnectionCallable(this.getURL(string), string, string2, string3, bl3));
                    int n = this.getConnectTimeout();
                    try {
                        ServiceInstanceResult serviceInstanceResult = future.get(n, TimeUnit.MILLISECONDS);
                        logger.debug("getESXiHostConnection() - connection thread has completed");
                        if (serviceInstanceResult != null && serviceInstanceResult.getServiceInstanceConnectionResult() == ServiceInstanceConnectionResult.SUCCESS) {
                            logger.debug("getESXiHostConnection() - connection to ESXi host: {} was successful, setting timeouts", (Object)string);
                            this.hostMap.put(string, serviceInstanceResult.getServiceInstance());
                            Client client = serviceInstanceResult.getServiceInstance().getServerConnection().getVimService().getWsc();
                            client.setConnectTimeout(n);
                            client.setReadTimeout(this.getReadTimeout());
                            if (!this.isESXiHostConnectionSuccessful(string)) {
                                this.postESXIHostOnlineEvent();
                                this.setESXiHostConnectionSuccessful(string, true);
                            }
                            break block13;
                        }
                        this.processConnectionFailure(serviceInstanceResult, bl, string, bl2);
                    }
                    catch (TimeoutException timeoutException) {
                        logger.error("getESXiHostConnection() - timed out while trying to establish a connection to ESXi host: {}", (Object)string);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error("getESXiHostConnection() - InterruptedException: {} while trying to connect to ESXi host: {}", (Object)interruptedException, (Object)string);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException executionException) {
                        logger.error("getESXiHostConnection() - ExecutionException: {} while trying to connect to ESXi host: {}", (Object)executionException, (Object)string);
                    }
                    break block13;
                }
                this.validateESXiConnection(string);
            }
            catch (HostLoginException hostLoginException) {
                throw hostLoginException;
            }
            catch (Exception exception) {
                logger.error("getESXiHostConnection() - Exception: {} while trying to connect to ESXi host: {}", (Object)exception, (Object)string);
            }
        }
        logger.debug("getESXiHostConnection() - end");
        return this.hostMap.get(string);
    }

    private void processConnectionFailure(ServiceInstanceResult serviceInstanceResult, boolean bl, String string, boolean bl2) throws HostLoginException {
        logger.debug("processConnectionFailure() - start");
        if (serviceInstanceResult == null) {
            logger.error("processConnectionFailure() - failed connecting to ESXi host: {}, connection result is null", (Object)string);
            return;
        }
        ServiceInstanceConnectionResult serviceInstanceConnectionResult = serviceInstanceResult.getServiceInstanceConnectionResult();
        if (serviceInstanceConnectionResult == ServiceInstanceConnectionResult.NO_PERMISSION || serviceInstanceConnectionResult == ServiceInstanceConnectionResult.INVALID_LOGIN) {
            if (bl) {
                logger.error("processConnectionFailure() - unable to log directly into host: {}, (NoPermission or InvalidLogin)", (Object)string);
                logger.debug(PROCESS_CONNECTION_FAILURE_LOG, (Throwable)serviceInstanceResult.getException());
            } else {
                this.logESXiErrorToConsole("processConnectionFailure() - unable to log directly into host: " + string + " - (NoPermission or InvalidLogin) ", serviceInstanceResult.getException(), string);
            }
            this.logESXiHostAuthFailure(string);
            if (bl2) {
                throw new HostLoginException();
            }
        }
        if (serviceInstanceConnectionResult == ServiceInstanceConnectionResult.REMOTE_EXCEPTION) {
            if (bl) {
                logger.error("processConnectionFailure() - failed connecting to host: {}, (RemoteException)", (Object)string);
                logger.debug(PROCESS_CONNECTION_FAILURE_LOG, (Throwable)serviceInstanceResult.getException());
            } else {
                String string2;
                Throwable throwable = ExceptionUtils.getRootCause((Throwable)serviceInstanceResult.getException());
                if (throwable instanceof UnknownHostException) {
                    ServiceManager.getInstance().getShutdownLogger().logShutdownReason(string, 228);
                }
                if ((string2 = ExceptionUtils.getRootCauseMessage((Throwable)serviceInstanceResult.getException())).contains("NoPermission") || string2.contains("Permission denied")) {
                    ServiceManager.getInstance().getShutdownLogger().logShutdownReason(string, 226);
                }
                this.logESXiErrorToConsole(PROCESS_CONNECTION_FAILURE_FAILED_CONNECTING_TO_HOST + string + " - (RemoteException) ", serviceInstanceResult.getException(), string);
            }
            this.logESXiOffline(string);
        }
        if (serviceInstanceConnectionResult == ServiceInstanceConnectionResult.MALFORMED_URL_EXCEPTION) {
            if (bl) {
                logger.error("processConnectionFailure() - failed connecting to host: {} because: {}", (Object)string, (Object)serviceInstanceResult.getException().getMessage());
                logger.debug(PROCESS_CONNECTION_FAILURE_LOG, (Throwable)serviceInstanceResult.getException());
            } else {
                this.logESXiErrorToConsole(PROCESS_CONNECTION_FAILURE_FAILED_CONNECTING_TO_HOST + string + " - (MalformedURLException) ", serviceInstanceResult.getException(), string);
            }
        }
        if (serviceInstanceConnectionResult == ServiceInstanceConnectionResult.EXCEPTION) {
            if (bl) {
                logger.error("processConnectionFailure() - failed connecting to host: {} because: {}", (Object)string, (Object)serviceInstanceResult.getException().getMessage());
                logger.debug(PROCESS_CONNECTION_FAILURE_LOG, (Throwable)serviceInstanceResult.getException());
            } else {
                this.logESXiErrorToConsole(PROCESS_CONNECTION_FAILURE_FAILED_CONNECTING_TO_HOST + string + " - (other Exception) ", serviceInstanceResult.getException(), string);
            }
        }
    }

    public String removeLocalosFromUsername(String string) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)(string = StringUtils.trim((String)string)), (CharSequence)DOMAIN_PREFIX)) {
            string = StringUtils.removeStartIgnoreCase((String)string, (String)DOMAIN_PREFIX);
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)string, (CharSequence)DOMAIN_SUFFIX)) {
            string = StringUtils.removeEndIgnoreCase((String)string, (String)DOMAIN_SUFFIX);
        }
        logger.debug("removeLocalosFromUsername() - connecting to ESXi host with username: {}", (Object)string);
        return string;
    }

    private void logESXiErrorToConsole(String string, Exception exception, String string2) {
        if (this.isESXiHostConnectionSuccessful(string2)) {
            logger.error(string + (exception != null && exception.getMessage() != null ? exception.getMessage() : "[no details available]"));
            logger.debug((Object)exception);
        }
    }

    public void logESXiOffline(String string) {
        logger.debug("logESXiOffline() - start, host: {}", (Object)string);
        try {
            string = this.toHostname(string);
            if (this.isESXiHostConnectionSuccessful(string)) {
                if (this.virtualConfigurationManager.isUnmanagedHost()) {
                    String string2 = new VirtualizationFeaturesFormatter(18).format(null);
                    this.applicationErrorHandler.put(string2);
                }
                this.setESXiHostConnectionSuccessful(string, false);
            }
        }
        catch (Exception exception) {
            logger.error("logESXiOffline() - Exception: ", (Throwable)exception);
        }
    }

    public void logESXiHostAuthFailure(String string) {
        logger.debug("logESXiHostAuthFailure() - start, host: {}", (Object)string);
        try {
            string = this.toHostname(string);
            if (this.isESXiHostConnectionSuccessful(string)) {
                if (this.virtualConfigurationManager.isUnmanagedHost()) {
                    String string2 = new VirtualizationFeaturesFormatter(19).format(null);
                    this.applicationErrorHandler.put(string2);
                }
                this.setESXiHostConnectionSuccessful(string, false);
            }
        }
        catch (Exception exception) {
            logger.error("logESXiHostAuthFailure() - Exception: ", (Throwable)exception);
        }
    }

    private void setESXiHostConnectionSuccessful(String string, boolean bl) {
        logger.debug("setESXiHostConnectionSuccessful() - host: {}, state: {}", (Object)string, (Object)bl);
        this.hostConnectionStateMap.put(string, bl);
    }

    private boolean isESXiHostConnectionSuccessful(String string) {
        boolean bl = true;
        Boolean bl2 = this.hostConnectionStateMap.get(string);
        if (bl2 != null) {
            bl = bl2;
        }
        logger.debug("isESXiHostConnectionSuccessful() - host: {}, result: {}", (Object)string, (Object)bl);
        return bl;
    }

    public synchronized void setvCenterServerConnectionSuccessful(boolean bl) {
        this.vCenterServerConnectionState = bl;
    }

    public synchronized boolean isvCenterServerConnectionSuccessful() {
        logger.debug("isvCenterServerConnectionSuccessful() - result: {}", (Object)this.vCenterServerConnectionState);
        return this.vCenterServerConnectionState;
    }

    private String toHostname(String string) {
        String string2 = string;
        String string3 = HostNameLookUpTable.getInstance().lookUp(string);
        if (string3 != null) {
            logger.debug("toHostname() - found: {}", (Object)string3);
            string2 = string3;
        } else {
            logger.debug("toHostname() - not found, returning: {}", (Object)string2);
        }
        return string2;
    }

    private synchronized Integer checkVCSAStatus() {
        logger.debug("checkVCSAStatus() - start");
        int n = NOT_VCSA_CONFIG;
        if (this.vCenterServiceInstance.isPresent() && this.virtualConfigurationManager.isVCSA()) {
            VirtualMachine virtualMachine;
            logger.debug("checkVCSAStatus() - is expected");
            HostSystem hostSystem = null;
            if (this.isvCenterServerConnectionSuccessful()) {
                hostSystem = this.hostSystemUtils.getHostSystemWithVCSAInstalled();
            }
            n = hostSystem != null ? ((virtualMachine = this.hostSystemUtils.getVCenterServerVM(this.vCenterServiceInstance.orElse(null))) != null ? (this.virtualMachineUtils.isPoweredOn(virtualMachine) ? VM_POWERED_ON.intValue() : VM_POWERED_OFF.intValue()) : VM_NOT_FOUND) : VM_HOST_NOT_FOUND;
        }
        logger.debug("checkVCSAStatus() - end, result: {}", (Object)n);
        return n;
    }

    private synchronized Integer checkVMAStatus() {
        logger.debug("checkVMAStatus() - start");
        int n = NOT_VMA_CONFIG;
        if (this.vCenterServiceInstance.isPresent() && this.virtualConfigurationManager.isPCNSInstalledOnVMA()) {
            VirtualMachine virtualMachine;
            HostSystem hostSystem = this.hostSystemUtils.getHostSystemOnWhichPCNSInstalled(this.vCenterServiceInstance.get());
            n = hostSystem != null ? ((virtualMachine = this.hostSystemUtils.getVirtualMachineOnWhichPCNSInstalled(this.vCenterServiceInstance.get())) != null ? (this.virtualMachineUtils.isPoweredOn(virtualMachine) ? VM_POWERED_ON.intValue() : VM_POWERED_OFF.intValue()) : VM_NOT_FOUND) : VM_HOST_NOT_FOUND;
        }
        logger.debug("checkVMAStatus() - end, returning: {}", (Object)n);
        return n;
    }

    private int getConnectTimeout() {
        int n = 10000;
        if (this.configurationManager.containsKey("HostConfigSettings", "VMware_connect_timeout")) {
            try {
                n = this.configurationManager.getInt("HostConfigSettings", "VMware_connect_timeout");
                n = (int)TimeUnit.SECONDS.toMillis(n);
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.error("getConnectTimeout() - NoSuchElementException | ConversionException: " + String.valueOf(throwable));
            }
        } else if (this.virtualConfigurationManager.isESXi()) {
            logger.debug("getConnectTimeout() - adding default connection timeout value to ini");
            this.configurationManager.setProperty("HostConfigSettings", "VMware_connect_timeout", TimeUnit.MILLISECONDS.toSeconds(n));
        }
        logger.debug("getConnectTimeout() - end, result: {} (milliseconds)", (Object)n);
        return n;
    }

    private int getReadTimeout() {
        int n = 15000;
        if (this.configurationManager.containsKey("HostConfigSettings", "VMware_read_timeout")) {
            try {
                n = this.configurationManager.getInt("HostConfigSettings", "VMware_read_timeout");
                n = (int)TimeUnit.SECONDS.toMillis(n);
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.error("getReadTimeOut() - " + String.valueOf(throwable));
            }
        } else {
            logger.debug("getReadTimeout() - adding default read timeout value to ini");
            this.configurationManager.setProperty("HostConfigSettings", "VMware_read_timeout", TimeUnit.MILLISECONDS.toSeconds(n));
        }
        logger.debug("getReadTimeout() - end, result: {} (milliseconds)", (Object)n);
        return n;
    }

    public synchronized Integer getVCSAStatus() {
        return this.vCSAStatus;
    }

    public synchronized Integer getVMAStatus() {
        return this.vMAStatus;
    }

    public void setDisableCheckStatus(boolean bl) {
        this.disableCheckStatus = bl;
    }

    public Integer getLoggedVCSAStatus() {
        return this.loggedVCSAStatus;
    }

    public void setLoggedVCSAStatus(Integer n) {
        this.loggedVCSAStatus = n;
    }

    public ServiceInstance getServiceInstance(String string) {
        logger.debug("getServiceInstance() - start");
        if (this.validateServiceInstance()) {
            return this.getVCenterConnection();
        }
        logger.debug("getServiceInstance() - trying ESXi service instance");
        return this.getESXiHostInstance(string);
    }

    private synchronized void setVCenterServiceInstance(ServiceInstance serviceInstance) {
        this.vCenterServiceInstance = Optional.ofNullable(serviceInstance);
    }

    @Generated
    public void setVirtualisationStatusStore(@NonNull VirtualisationStatusStore virtualisationStatusStore) {
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtualisationStatusStore is marked non-null but is null");
        }
        this.virtualisationStatusStore = virtualisationStatusStore;
    }

    @Generated
    public void setAuthHelper(@NonNull AuthHelper authHelper) {
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        this.authHelper = authHelper;
    }

    @Generated
    public void setVirtualConfigurationManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
    }

    @Generated
    public void setHostSystemUtils(@NonNull HostSystemUtils hostSystemUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setVirtualMachineUtils(@NonNull VirtualMachineUtils virtualMachineUtils) {
        if (virtualMachineUtils == null) {
            throw new IllegalArgumentException("virtualMachineUtils is marked non-null but is null");
        }
        this.virtualMachineUtils = virtualMachineUtils;
    }

    @Generated
    public void setConfigurationManager(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("configurationManager is marked non-null but is null");
        }
        this.configurationManager = configurationManager;
    }

    @Generated
    public void setApplicationErrorHandler(@NonNull ApplicationErrorHandler applicationErrorHandler) {
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("applicationErrorHandler is marked non-null but is null");
        }
        this.applicationErrorHandler = applicationErrorHandler;
    }

    @Generated
    public void setTrustStoreManager(@NonNull TrustStoreManager trustStoreManager) {
        if (trustStoreManager == null) {
            throw new IllegalArgumentException("trustStoreManager is marked non-null but is null");
        }
        this.trustStoreManager = trustStoreManager;
    }
}

