/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.vmware;

import com.vmware.vim25.VirtualAppVAppState;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.VirtualApp;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualApplianceUtils {
    private static final Logger logger = LogManager.getLogger(VirtualApplianceUtils.class);

    public String getAppState(VirtualApp virtualApp) {
        logger.debug("isVAppStarted() - start");
        return virtualApp.getSummary().getVAppState().toString();
    }

    public boolean isVAppStarted(VirtualApp virtualApp) {
        logger.debug("isVAppStarted() - start");
        return virtualApp.getSummary().getVAppState().toString().equalsIgnoreCase(VirtualAppVAppState.started.toString());
    }

    public boolean isVAppStarting(VirtualApp virtualApp) {
        logger.debug("isVAppStarting() - start");
        return virtualApp.getSummary().getVAppState().toString().equalsIgnoreCase(VirtualAppVAppState.starting.toString());
    }

    public boolean isVAppStopped(VirtualApp virtualApp) {
        logger.debug("isVAppStopped() - start");
        return virtualApp.getSummary().getVAppState().toString().equalsIgnoreCase(VirtualAppVAppState.stopped.toString());
    }

    public String getVappDataCenterName(VirtualApp virtualApp) {
        VirtualApp virtualApp2 = virtualApp;
        while (!(virtualApp2 instanceof Datacenter)) {
            virtualApp2 = virtualApp2.getParent();
        }
        String string = "";
        if (virtualApp2 != null && virtualApp2.getName() != null) {
            string = StringEscapeUtils.escapeHtml4((String)virtualApp2.getName());
        }
        return string;
    }
}

