/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.vmware;

import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.vmware.vim25.GuestNicInfo;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.NetIpConfigInfo;
import com.vmware.vim25.NetIpConfigInfoIpAddress;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VirtualMachineConnectionState;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualMachineUtils {
    private static final Logger logger = LogManager.getLogger(VirtualMachineUtils.class);
    private static final String VCLS_VM_PATTERN = "^vCLS.*";
    private Pattern vClsPattern;
    private Matcher vClsMatcher;

    public boolean isConnected(VirtualMachine virtualMachine) {
        boolean bl = false;
        try {
            if (virtualMachine != null && virtualMachine.getRuntime() != null) {
                logger.debug("isConnected() - VM: {}", (Object)virtualMachine.getName());
                if (virtualMachine.getRuntime().getConnectionState() == VirtualMachineConnectionState.connected) {
                    bl = true;
                } else {
                    logger.debug("isConnected() - not connected");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            logger.error("isConnected() - RuntimeException: " + String.valueOf(runtimeException));
        }
        catch (Exception exception) {
            logger.error("isConnected() - Exception: " + String.valueOf(exception));
        }
        return bl;
    }

    public boolean isPoweredOff(@NonNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new IllegalArgumentException("vmSystem is marked non-null but is null");
        }
        boolean bl = false;
        logger.debug("isPoweredOff() - VM: {}", (Object)virtualMachine.getName());
        bl = virtualMachine.getRuntime() != null ? virtualMachine.getRuntime().getPowerState().equals((Object)VirtualMachinePowerState.poweredOff) : true;
        logger.debug("isPoweredOff() - end, VM: {}, Powered Off: {}", (Object)virtualMachine.getName(), (Object)bl);
        return bl;
    }

    public boolean isPoweredOn(VirtualMachine virtualMachine) {
        boolean bl = false;
        try {
            if (virtualMachine != null && virtualMachine.getRuntime() != null) {
                logger.debug("isPoweredOn() - VM: {} ", (Object)virtualMachine.getName());
                if (virtualMachine.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOn) {
                    VirtualMachineConnectionState virtualMachineConnectionState = virtualMachine.getRuntime().getConnectionState();
                    if (virtualMachineConnectionState == VirtualMachineConnectionState.connected) {
                        bl = true;
                    } else {
                        logger.debug("isPoweredOn() - not connected state: {} ", (Object)virtualMachineConnectionState);
                    }
                } else {
                    logger.debug("isPoweredOn() - not powered on");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            logger.error("isPoweredOn() - RuntimeException: " + String.valueOf(runtimeException));
        }
        catch (Exception exception) {
            logger.error("isPoweredOn() - Exception: " + String.valueOf(exception));
        }
        logger.debug("isPoweredOn() - end, result: {}", (Object)bl);
        return bl;
    }

    public VirtualMachine getVirtualMachineFromVMName(ServiceInstance serviceInstance, String string) throws InvalidProperty, RuntimeFault, RemoteException {
        logger.debug("getVirtualMachineFromVMName() - start, serviceInstance: {}, vmName: {}", (Object)serviceInstance, (Object)string);
        VirtualMachine virtualMachine = (VirtualMachine)new InventoryNavigator((ManagedEntity)serviceInstance.getRootFolder()).searchManagedEntity("VirtualMachine", string);
        if (virtualMachine == null) {
            logger.debug("getVirtualMachineFromVMName() - unable to find VM: {} in inventory", (Object)string);
        }
        logger.debug("getVirtualMachineFromVMName() - end");
        return virtualMachine;
    }

    public Set<VirtualMachine> getVirtualMachinesStartingWith(@NonNull ServiceInstance serviceInstance, @NonNull String string) throws RemoteException {
        ManagedEntity[] managedEntityArray;
        if (serviceInstance == null) {
            throw new IllegalArgumentException("serviceInstance is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("startWith is marked non-null but is null");
        }
        HashSet<VirtualMachine> hashSet = new HashSet<VirtualMachine>();
        logger.debug("getVirtualMachinesStartingWith() - looking for VMs beginning with {}", (Object)string);
        for (ManagedEntity managedEntity : managedEntityArray = new InventoryNavigator((ManagedEntity)serviceInstance.getRootFolder()).searchManagedEntities("VirtualMachine")) {
            VirtualMachine virtualMachine = (VirtualMachine)managedEntity;
            if (!StringUtils.startsWithIgnoreCase((CharSequence)virtualMachine.getName(), (CharSequence)string)) continue;
            hashSet.add(virtualMachine);
        }
        return hashSet;
    }

    public Set<String> getIPAddressesForVM(@NonNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new IllegalArgumentException("vm is marked non-null but is null");
        }
        HashSet<String> hashSet = new HashSet<String>();
        logger.debug("getIPAddressesForVM() - Looking for NICs for VM: {}", (Object)virtualMachine.getName());
        GuestNicInfo[] guestNicInfoArray = virtualMachine.getGuest().getNet();
        if (guestNicInfoArray != null) {
            for (GuestNicInfo guestNicInfo : guestNicInfoArray) {
                NetIpConfigInfoIpAddress[] netIpConfigInfoIpAddressArray;
                if (guestNicInfo == null || guestNicInfo.getNetwork() == null) {
                    logger.debug("getIPAddressesForVM() - NIC or configured network for NIC is null {}, skipping this NIC {}", (Object)guestNicInfo);
                    continue;
                }
                logger.debug("getIPAddressesForVM() - Looking for IP addresses for NIC: {}", (Object)guestNicInfo.getNetwork());
                NetIpConfigInfo netIpConfigInfo = guestNicInfo.getIpConfig();
                if (netIpConfigInfo == null) {
                    logger.error("getIPAddressesForVM() - failed to retrieve IP configuration for NIC: {}", (Object)guestNicInfo.getNetwork());
                    continue;
                }
                for (NetIpConfigInfoIpAddress netIpConfigInfoIpAddress : netIpConfigInfoIpAddressArray = netIpConfigInfo.getIpAddress()) {
                    logger.debug("getIPAddressesForVM() - VM: {}, IP: {}", (Object)virtualMachine.getName(), (Object)netIpConfigInfoIpAddress.ipAddress);
                    hashSet.add(netIpConfigInfoIpAddress.getIpAddress());
                }
            }
            if (hashSet.isEmpty()) {
                logger.debug("getIPAddressesForVM() - Failed to get IP details for any VM.");
                throw new IllegalStateException("No IP details for OVCs retrieved.");
            }
        } else {
            logger.debug("getIPAddressesForVM() - Failed to get GuestNicInfo. VM is possibly offline.");
            throw new IllegalStateException("VM is offline. Can't enumerate IP addresses.");
        }
        return hashSet;
    }

    public boolean isVmIp(@NonNull String string, @NonNull VirtualMachine virtualMachine) {
        if (string == null) {
            throw new IllegalArgumentException("ip is marked non-null but is null");
        }
        if (virtualMachine == null) {
            throw new IllegalArgumentException("vm is marked non-null but is null");
        }
        boolean bl = false;
        logger.debug("isVmIp() - checking VM {} for NIC with IP: {}", (Object)virtualMachine.getName(), (Object)string);
        try {
            bl = this.getIPAddressesForVM(virtualMachine).contains(string);
        }
        catch (IllegalStateException illegalStateException) {
            logger.debug("isVmIp() - VM in invalid state for checking IP address(es)", (Object)virtualMachine.getName());
        }
        return bl;
    }

    public boolean isVClsVm(@NonNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new IllegalArgumentException("vm is marked non-null but is null");
        }
        boolean bl = false;
        try {
            bl = this.checkVCLsVmName(virtualMachine.getName());
            logger.debug("isVClsVm() - VM {} is vCLS VM: {}", (Object)virtualMachine.getName(), (Object)bl);
        }
        catch (NullPointerException nullPointerException) {
            logger.error("isVClsVm() - failed to retrieve VM name, error: {}", (Throwable)nullPointerException);
        }
        return bl;
    }

    public boolean checkVCLsVmName(String string) {
        if (this.vClsPattern == null || this.vClsMatcher == null) {
            this.vClsPattern = Pattern.compile(VCLS_VM_PATTERN);
            this.vClsMatcher = this.vClsPattern.matcher("");
        }
        return this.vClsPattern.matcher(string).matches();
    }

    public List<VirtualMachine> filterOutVCLSVms(List<VirtualMachine> list) {
        logger.debug("filterOutVCLSVms() - start");
        if (list == null || list.isEmpty()) {
            logger.debug("filterOutVCLSVms() - list is null or empty");
            return list;
        }
        logger.debug("filterOutVCLSVms() - start, retrieved vmList of size {}", (Object)list.size());
        return list.stream().filter(virtualMachine -> !this.isVClsVm((VirtualMachine)virtualMachine)).collect(Collectors.toList());
    }

    public List<PrioritizedVM> filterOutVCLSVmsFromPrioritizedVMList(List<PrioritizedVM> list) {
        logger.debug("filterOutVCLSVmsFromPrioritizedVMList() - start");
        if (list == null || list.isEmpty()) {
            logger.debug("filterOutVCLSVmsFromPrioritizedVMList() - list is null or empty");
            return list;
        }
        logger.debug("filterOutVCLSVmsFromPrioritizedVMList() - start, retrieved vmList of size {}", (Object)list.size());
        return list.stream().filter(prioritizedVM -> {
            if (prioritizedVM.isVirtualApp()) {
                return true;
            }
            VirtualMachine virtualMachine = prioritizedVM.getVirtualMachine();
            if (virtualMachine == null) {
                logger.warn("filterOutVCLSVmsFromPrioritizedVMList() - unable to retrieve VirtualMachine for {}", (Object)virtualMachine);
                return false;
            }
            return !this.isVClsVm(virtualMachine);
        }).collect(Collectors.toList());
    }
}

