/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization.vxrail;

import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.util.virtualization.VirtualizationLoggingUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VirtualMachineUtils;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.InetAddressValidator;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.nmc.NmcConnectionManager;
import com.apcc.pcns.nmc.NmcRestConnection;
import com.apcc.pcns.nmc.request.NmcDetails;
import com.apcc.pcns.restservice.ConnectionFailException;
import com.apcc.pcns.restservice.RestConnectionStatus;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.trustmanagement.UnverifiedCertificateManager;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.vxrail.VxRailConnection;
import com.apcc.pcns.vxrail.VxRailConnectionManager;
import com.apcc.pcns.vxrail.VxRailDetails;
import com.vmware.vim25.mo.VirtualMachine;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;

public class VxRailUtils {
    public static final String VX_RAIL = "VxRail";
    private static Logger logger = LogManager.getLogger(VxRailUtils.class);
    private static final String ESRS_VM_PATTERN = "ESRS_VE";
    private VirtualMachine vxRailManagerVm = null;
    @NonNull
    private VirtualMachineUtils virtualMachineUtils;
    @NonNull
    private ConfigurationManager config;
    @NonNull
    VirtualConfigurationManager virtualConfig;
    @NonNull
    VirtualizationLoggingUtils virtualLoggingUtils;
    @NonNull
    AuthHelper authHelper;
    @NonNull
    NmcConnectionManager nmcConnectionManager;
    @NonNull
    VxRailConnectionManager vxRailConnectionManager;
    @NonNull
    private HostSystemUtils hostSystemUtils;
    @NonNull
    private VsanUtils vsanUtils;
    @NonNull
    private UnverifiedCertificateManager unverifiedCertificateManager;
    @NonNull
    private TrustStoreManager trustStoreManager;

    public List<VirtualMachine> filterOutVxRailSpecialVms(List<VirtualMachine> list) {
        logger.debug("filterOutVxRailSpecialVms() - start");
        if (list == null || list.isEmpty()) {
            logger.debug("filterOutVxRailSpecialVms() - list is null or empty");
            return list;
        }
        logger.debug("filterOutVxRailSpecialVms() - start, retrieved vmList of size {}", (Object)list.size());
        return list.stream().filter(virtualMachine -> !this.isSystemVm((VirtualMachine)virtualMachine)).collect(Collectors.toList());
    }

    public List<PrioritizedVM> filterOutVxRailSpecialVmFromPrioritizedVMs(List<PrioritizedVM> list) {
        logger.debug("filterOutVxRailSpecialVmFromPrioritizedVMs() - start");
        if (list == null || list.isEmpty()) {
            logger.debug("filterOutVxRailSpecialVmFromPrioritizedVMs() - list is null");
            return list;
        }
        logger.debug("filterOutVxRailSpecialVmFromPrioritizedVMs() - retrieved vmList of size {}", (Object)list.size());
        return list.stream().filter(prioritizedVM -> !this.isSystemVm((PrioritizedVM)prioritizedVM)).collect(Collectors.toList());
    }

    private boolean isSystemVm(VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            return false;
        }
        if (this.virtualMachineUtils.isVClsVm(virtualMachine)) {
            logger.debug("isSystemVm() - vCLS VM found");
            return true;
        }
        if (this.isVxRailManagerVm(virtualMachine)) {
            logger.debug("isSystemVm() - VxRail manager VM found");
            return true;
        }
        if (this.isEsrsVm(virtualMachine)) {
            logger.debug("isSystemVm() - ESRS VM found");
            return true;
        }
        return false;
    }

    private boolean isSystemVm(PrioritizedVM prioritizedVM) {
        boolean bl = false;
        if (prioritizedVM.isVirtualApp()) {
            logger.debug("isSystemVm() - priorizied VM {} is vApp, not filtering it out", (Object)prioritizedVM.getVMName());
            return false;
        }
        if (prioritizedVM.isvSanWitness()) {
            logger.debug("isSystemVm() - vSan Witness VM found: {}", (Object)prioritizedVM.getVMName());
            return true;
        }
        VirtualMachine virtualMachine = prioritizedVM.getVirtualMachine();
        if (virtualMachine == null) {
            logger.error("isSystemVm() - priorizied VM {} has no virtual machine set, cannot check for IPs", (Object)prioritizedVM.getVMName());
            return false;
        }
        if (this.isVxRailManagerVm(virtualMachine)) {
            logger.debug("isSystemVm() - VxRail manager VM found");
            return true;
        }
        if (this.virtualMachineUtils.isVClsVm(virtualMachine)) {
            logger.debug("isSystemVm() - vCLS VM found");
            return true;
        }
        if (this.isEsrsVm(virtualMachine)) {
            logger.debug("isSystemVm() - ESRS VM found");
            return true;
        }
        if (prioritizedVM.isVCSA()) {
            logger.debug("isSystemVm() - VCSA VM found");
            return true;
        }
        return bl;
    }

    private boolean isEsrsVm(VirtualMachine virtualMachine) {
        boolean bl = false;
        try {
            bl = StringUtils.startsWithIgnoreCase((CharSequence)virtualMachine.getName(), (CharSequence)ESRS_VM_PATTERN);
            logger.debug("isEsrsVm() - VM {} is ESRS VM: {}", (Object)virtualMachine.getName(), (Object)bl);
        }
        catch (NullPointerException nullPointerException) {
            logger.error("isEsrsVm() - failed to retrieve VM name, error: {}", (Throwable)nullPointerException);
        }
        return bl;
    }

    public boolean isVxRailManagerVm(VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            logger.debug("isVxRailManagerVm() - VM is null, no check needed");
            return false;
        }
        if (this.vxRailManagerVm != null && virtualMachine == this.vxRailManagerVm) {
            try {
                logger.debug("isVxRailManagerVm() - VM {} is VxRail Manager VM", (Object)virtualMachine.getName());
            }
            catch (NullPointerException nullPointerException) {
                logger.error("isVxRailManagerVm() - failed to retrieve VM names, error: {}", (Throwable)nullPointerException);
            }
            return true;
        }
        String string = this.getClusterIP();
        if (StringUtils.isEmpty((CharSequence)string)) {
            logger.error("isVxRailManagerVm() - VxRail Manager IP/FQDN not configured, cannot detect VM");
            return false;
        }
        VirtualMachine virtualMachine2 = null;
        try {
            String string2 = InetAddress.getByName(string).getHostAddress();
            logger.debug("isVxRailManagerVm() - retrieving VxRail Manager {} by IP {}", (Object)string, (Object)string2);
            virtualMachine2 = this.hostSystemUtils.getVirtualMachineByIp(string2);
        }
        catch (UnknownHostException unknownHostException) {
            logger.error("isVxRailManagerVm() - Unknown host {}, cannot determine VxRail Manager VM by IP, error: {}", (Object)string, (Object)unknownHostException);
        }
        if (virtualMachine2 == null) {
            logger.debug("isVxRailManagerVm() - retrieving vxRail Manager by FQDN {}", (Object)string);
            virtualMachine2 = this.hostSystemUtils.getVirtualMachineByDnsName(string);
        }
        if (virtualMachine2 != null) {
            try {
                if (virtualMachine == virtualMachine2 || StringUtils.equals((CharSequence)virtualMachine2.getName(), (CharSequence)virtualMachine.getName())) {
                    logger.debug("isVxRailManagerVm() - VM is VxRailManager VM and needs to be filtered out");
                    this.vxRailManagerVm = virtualMachine;
                    return true;
                }
                logger.debug("isVxRailManagerVm() - VM does not match VxRailManager VM");
                return false;
            }
            catch (NullPointerException nullPointerException) {
                logger.error("isVxRailManagerVm() - failed to retrieve VM names, error: {}", (Throwable)nullPointerException);
            }
        }
        if (this.virtualMachineUtils.isVmIp(string, virtualMachine)) {
            logger.debug("isVxRailManagerVm() - VM has VxRailManager VM IP configured and needs to be filtered out");
            this.vxRailManagerVm = virtualMachine;
            return true;
        }
        return false;
    }

    public VirtualMachine findVxRailManagerVM(@NonNull VirtualMachine[] virtualMachineArray) {
        if (virtualMachineArray == null) {
            throw new IllegalArgumentException("vms is marked non-null but is null");
        }
        VirtualMachine virtualMachine = null;
        for (VirtualMachine virtualMachine2 : virtualMachineArray) {
            if (!this.isVxRailManagerVm(virtualMachine2)) continue;
            virtualMachine = virtualMachine2;
            break;
        }
        return virtualMachine;
    }

    public VxRailDetails loadVxRailDetails() {
        logger.debug("loadVxRailDetails() - start");
        String string = this.getClusterIP();
        VxRailDetails vxRailDetails = new VxRailDetails(string);
        vxRailDetails.setShutdownDelay(this.getShutdownDelay());
        vxRailDetails.setShutdownDuration(this.getShutdownDuration());
        vxRailDetails.setVxRailUsername(this.authHelper.getVCenterUser());
        vxRailDetails.setVxRailPassword(this.authHelper.getVCenterPassword());
        logger.debug("loadVxRailDetails() - end, creating details for host {}", (Object)string);
        return vxRailDetails;
    }

    public void saveVxRailDetails(@NonNull VxRailDetails vxRailDetails) {
        if (vxRailDetails == null) {
            throw new IllegalArgumentException("details is marked non-null but is null");
        }
        this.config.setProperty("VxRailClusterDetails", "Cluster_Ip", vxRailDetails.getVxRailManagerIp());
        this.config.setProperty("VxRailClusterDetails", "cluster_shutdown_delay", vxRailDetails.getShutdownDelay());
        this.config.setProperty("VxRailClusterDetails", "cluster_shutdown_duration", vxRailDetails.getShutdownDuration());
    }

    public int getShutdownDelay() {
        int n = VMSettings.VXRAIL_DEFAULT_CLUSTER_SHUTDOWN_DELAY;
        if (this.config.containsKey("VxRailClusterDetails", "cluster_shutdown_delay")) {
            IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(VMSettings.VXRAIL_DEFAULT_CLUSTER_SHUTDOWN_DELAY);
            intRangeSetValidator.add(0, 172800);
            n = this.config.getInt("VxRailClusterDetails", "cluster_shutdown_delay", intRangeSetValidator);
        }
        return n;
    }

    public void getShutdownDelay(VMSettings vMSettings, String string) {
        vMSettings.setVxRailShutdownDelay(this.getShutdownDelay());
    }

    public int getShutdownDuration() {
        int n = 300;
        if (this.config.containsKey("VxRailClusterDetails", "cluster_shutdown_duration")) {
            IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(300);
            intRangeSetValidator.add(0, 172800);
            n = this.config.getInt("VxRailClusterDetails", "cluster_shutdown_duration", intRangeSetValidator);
        }
        return n;
    }

    public void getShutdownDuration(VMSettings vMSettings, String string) {
        vMSettings.setVxRailShutdownDuration(this.getShutdownDuration());
    }

    public void doClusterShutdown() {
        logger.debug("doClusterShutdown() - start");
        VxRailDetails vxRailDetails = new VxRailDetails(this.getClusterIP());
        vxRailDetails.setShutdownDelay(this.getShutdownDelay());
        vxRailDetails.setShutdownDuration(this.getShutdownDuration());
        vxRailDetails.setVxRailUsername(this.authHelper.getVCenterUser());
        vxRailDetails.setVxRailPassword(this.authHelper.getVCenterPassword());
        vxRailDetails.setVxRailCert(this.getClusterCert());
        vxRailDetails.setPcnsIp(this.virtualConfig.getLocalHostIP());
        vxRailDetails.setRetryLimit(this.getRetryLimit());
        vxRailDetails.setRetryInterval(this.getRetryInterval());
        vxRailDetails.setNetworkTimeout(this.getNetworkTimeout());
        vxRailDetails.setDryrun(this.isDryRun());
        List<String> list = this.getNmcIps();
        int n = this.getNMCPort();
        String string = this.authHelper.getPowerChuteUsername();
        String string2 = this.authHelper.getAuthenticationPhrase();
        this.sendNmcClusterStopRequestWithRetries(vxRailDetails, list, n, string, string2);
    }

    private boolean sendNmcClusterStopRequestWithRetries(@NonNull VxRailDetails vxRailDetails, @NonNull List<String> list, int n, @NonNull String string, @NonNull String string2) {
        if (vxRailDetails == null) {
            throw new IllegalArgumentException("vxRailDetails is marked non-null but is null");
        }
        if (list == null) {
            throw new IllegalArgumentException("nmcs is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("user is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("pass is marked non-null but is null");
        }
        logger.debug("sendNmcClusterStopRequestWithRetries() - start");
        boolean bl = false;
        int n2 = 0;
        do {
            for (String string3 : list) {
                logger.debug("sendNmcClusterStopRequestWithRetries() - attempt shutdown via nmc:{}", (Object)string3);
                NmcDetails nmcDetails = new NmcDetails();
                nmcDetails.setUsername(string);
                nmcDetails.setPassword(string2);
                nmcDetails.setNmcIp(string3);
                nmcDetails.setPort(n);
                nmcDetails.setAcceptUntrustedCerts(this.isNMCAcceptAllCerts());
                nmcDetails.setConnectionTimeout(this.getNMCConnectionTimeout());
                this.virtualLoggingUtils.logNMCClusterShutdownCommandSentEvent(string3, VX_RAIL);
                if (this.sendNmcClusterStopRequest(nmcDetails, vxRailDetails)) {
                    logger.info("sendNmcClusterStopRequestWithRetries() - succesfull shutdown via nmc:{}", (Object)string3);
                    this.virtualLoggingUtils.logNMCClusterShutdownSuccessEvent(string3, VX_RAIL);
                    bl = true;
                    break;
                }
                logger.debug("sendNmcClusterStopRequestWithRetries() - unsuccesfull shutdown via nmc:{}", (Object)string3);
                this.virtualLoggingUtils.logNMCClusterShutdownNotCompleteEvent(string3, VX_RAIL);
            }
            ++n2;
            if (bl) continue;
            new CountdownTimer(vxRailDetails.getRetryInterval().intValue(), TimeUnit.SECONDS).sleep();
        } while (!bl && n2 < vxRailDetails.getRetryLimit());
        logger.debug("sendNmcClusterStopRequestWithRetries() - end, success: {}", (Object)bl);
        return bl;
    }

    public boolean sendNmcClusterStopRequest(@NonNull NmcDetails nmcDetails, @NonNull VxRailDetails vxRailDetails) {
        if (nmcDetails == null) {
            throw new IllegalArgumentException("nmcDetails is marked non-null but is null");
        }
        if (vxRailDetails == null) {
            throw new IllegalArgumentException("vxRailDetails is marked non-null but is null");
        }
        logger.info("sendNMCClusterStopRequest() {} ", (Object)nmcDetails.getNmcIp(), (Object)vxRailDetails.getVxRailManagerIp());
        NmcRestConnection nmcRestConnection = this.nmcConnectionManager.getConnection(nmcDetails);
        try {
            nmcRestConnection.stopVxRailCluster(vxRailDetails, this.virtualLoggingUtils);
        }
        catch (IllegalStateException | RemoteException exception) {
            logger.error("Unable to use NMC {} to shutdown the VxRail Cluster", (Object)nmcDetails.getNmcIp());
            return false;
        }
        return true;
    }

    public String getClusterIP() {
        InetAddressValidator inetAddressValidator = new InetAddressValidator();
        return this.config.getString("VxRailClusterDetails", "Cluster_Ip", inetAddressValidator);
    }

    public X509Certificate getClusterCert() {
        logger.debug("getVxRailClusterCert() - start");
        Optional<X509Certificate> optional = this.trustStoreManager.getVxRailCertificate();
        X509Certificate x509Certificate = optional.orElse(null);
        if (x509Certificate != null) {
            logger.debug("getClusterCert(): VxRail Certificate: {}", (Object)x509Certificate.getSubjectX500Principal().getName());
        } else {
            logger.error("getClusterCert(): VxRail certificate has not been added to PowerChute-keystore");
        }
        logger.debug("getVxRailClusterCert() - end");
        return x509Certificate;
    }

    public void setShutdownDelay(Integer n) {
        this.config.setProperty("VxRailClusterDetails", "cluster_shutdown_delay", n);
    }

    public void setShutdownDuration(Integer n) {
        this.config.setProperty("VxRailClusterDetails", "cluster_shutdown_duration", n);
    }

    public Integer getNetworkTimeout() {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(15);
        intRangeSetValidator.add(0, 172800);
        int n = 15;
        if (this.config.containsKey("VxRailClusterDetails", "network_timeout")) {
            n = this.config.getInt("VxRailClusterDetails", "network_timeout", intRangeSetValidator);
        }
        return n;
    }

    public void getNetworkTimeout(VMSettings vMSettings, String string) {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(15);
        intRangeSetValidator.add(0, 172800);
        String string2 = "network_timeout";
        try {
            if (this.config.containsKey(string, string2)) {
                vMSettings.setVxRailNetworkTimeout(this.config.getInt(string, string2, intRangeSetValidator));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
    }

    public void setNetworkTimeout(Integer n) {
        this.config.setProperty("VxRailClusterDetails", "network_timeout", n);
    }

    public Integer getRetryInterval() {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(15);
        intRangeSetValidator.add(0, 172800);
        int n = 10;
        if (this.config.containsKey("VxRailClusterDetails", "retry_interval")) {
            n = this.config.getInt("VxRailClusterDetails", "retry_interval", intRangeSetValidator);
        }
        return n;
    }

    public void getRetryInterval(VMSettings vMSettings, String string) {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(15);
        intRangeSetValidator.add(0, 172800);
        String string2 = "retry_interval";
        try {
            if (this.config.containsKey(string, string2)) {
                vMSettings.setVxRailRetryInterval(this.config.getInt(string, string2, intRangeSetValidator));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
    }

    public void setRetryInterval(Integer n) {
        this.config.setProperty("VxRailClusterDetails", "retry_interval", n);
    }

    public Integer getRetryLimit() {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(3);
        intRangeSetValidator.add(0, 172800);
        int n = 3;
        if (this.config.containsKey("VxRailClusterDetails", "retry_limit")) {
            n = this.config.getInt("VxRailClusterDetails", "retry_limit", intRangeSetValidator);
        }
        return n;
    }

    public void getRetryLimit(VMSettings vMSettings, String string) {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(3);
        intRangeSetValidator.add(0, 172800);
        String string2 = "retry_limit";
        try {
            if (this.config.containsKey(string, string2)) {
                vMSettings.setVxRailRetryLimit(this.config.getInt(string, string2, intRangeSetValidator));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
    }

    public void setRetryLimit(Integer n) {
        this.config.setProperty("VxRailClusterDetails", "retry_limit", n);
    }

    public List<String> getNmcIps() {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.config.containsKey("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(n))) {
            arrayList.add(this.config.getString("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(n)));
            ++n;
        }
        return arrayList;
    }

    public Integer getNMCPort() {
        Integer n;
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(443);
        intRangeSetValidator.add(443);
        intRangeSetValidator.add(5000, 32678);
        try {
            n = this.config.getInt("NetworkManagementCard", "port", intRangeSetValidator);
        }
        catch (IllegalArgumentException | ConversionException throwable) {
            logger.error((Object)throwable);
            n = (Integer)intRangeSetValidator.getDefault();
        }
        return n;
    }

    public boolean isNMCAcceptAllCerts() {
        return this.config.getBoolean("NetworkManagementCard", "acceptCerts", false);
    }

    public Integer getNMCConnectionTimeout() {
        return this.config.getInt("NetworkManagementCard", "network_timeout", 10);
    }

    protected VxRailConnection getVxRailConnection(VxRailDetails vxRailDetails) {
        return this.vxRailConnectionManager.getConnection(vxRailDetails);
    }

    public RestConnectionStatus checkConnection(@NonNull VxRailDetails vxRailDetails) {
        if (vxRailDetails == null) {
            throw new IllegalArgumentException("vxRailDetails is marked non-null but is null");
        }
        logger.debug("checkConnection() - start");
        RestConnectionStatus restConnectionStatus = RestConnectionStatus.OK;
        boolean bl = vxRailDetails.hasValidConnectionDetails();
        if (!bl) {
            throw new IllegalArgumentException("Host, username or password cannot be empty");
        }
        VxRailConnection vxRailConnection = this.getVxRailConnection(vxRailDetails);
        try {
            String string = vxRailConnection.getClusterProductVersion();
            logger.info("checkConnection() - connection established, VxRail Application version: {}", (Object)string);
        }
        catch (RemoteException remoteException) {
            restConnectionStatus = RestConnectionStatus.UNAVAILABLE;
            Throwable throwable = remoteException.getCause();
            if (throwable instanceof ConnectionFailException) {
                boolean bl2;
                ConnectionFailException connectionFailException = (ConnectionFailException)((Object)throwable);
                if (HttpStatus.UNAUTHORIZED == connectionFailException.getStatusCode()) {
                    logger.error("checkConnection() - credentials invalid, returning {}", (Object)RestConnectionStatus.UNAUTHORIZED);
                    return RestConnectionStatus.UNAUTHORIZED;
                }
                if (HttpStatus.SERVICE_UNAVAILABLE == connectionFailException.getStatusCode() && (bl2 = this.unverifiedCertificateManager.addCertificateChainByException("vxrail", remoteException))) {
                    restConnectionStatus = RestConnectionStatus.CERTIFICATE_UNTRUSTED;
                }
            }
            logger.error("checkConnection() - unable to connect to VxRail service, returning {}, error: {}", (Object)restConnectionStatus, (Object)remoteException);
            return restConnectionStatus;
        }
        catch (Exception exception) {
            logger.error("checkConnection() - unable to connect to VxRail service, returning {}, error: {}", (Object)RestConnectionStatus.UNAVAILABLE, (Object)exception);
            return RestConnectionStatus.UNAVAILABLE;
        }
        logger.debug("checkConnection() - end, connection established");
        return restConnectionStatus;
    }

    public boolean isVcsaOnVxRailVsanHost() {
        boolean bl = this.virtualConfig.isVxRail();
        boolean bl2 = this.virtualConfig.isVCSA();
        boolean bl3 = this.vsanUtils.isVcsaOnAVsanHost();
        logger.debug("isVcsaOnVxRailVsanHost() - VxRail Supported: {}, VCSA Supported: {}, VCSA deployed to VSAN: {}", (Object)bl, (Object)bl2, (Object)bl3);
        return bl && bl2 && bl3;
    }

    public boolean isDryRun() {
        return this.config.getBoolean("VxRailClusterDetails", "dry_run", false);
    }

    public void setDryRun(Boolean bl) {
        this.config.setProperty("VxRailClusterDetails", "dry_run", bl);
    }

    public int getScheduledTaskDelay() {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(VMSettings.VXRAIL_DEFAULT_SCHEDULED_START_DELAY);
        intRangeSetValidator.add(0, 172800);
        int n = VMSettings.VXRAIL_DEFAULT_SCHEDULED_START_DELAY;
        try {
            if (this.config.containsKey("VxRailClusterDetails", "scheduled_start_delay")) {
                n = this.config.getInt("VxRailClusterDetails", "scheduled_start_delay", intRangeSetValidator);
            } else {
                this.config.setProperty("VxRailClusterDetails", "scheduled_start_delay", VMSettings.VXRAIL_DEFAULT_SCHEDULED_START_DELAY);
            }
        }
        catch (IllegalArgumentException | ConversionException throwable) {
            logger.warn("getScheduledTaskDelay() - Unexpected exception: {}", throwable);
        }
        n = (int)TimeUnit.MINUTES.convert(n, TimeUnit.SECONDS);
        logger.debug("getScheduledTaskDelay() - VM Scheduled Task delay read from INI as: {}", (Object)n);
        return n;
    }

    public boolean checkNmcShutdownSupport(@NonNull NmcDetails nmcDetails) {
        if (nmcDetails == null) {
            throw new IllegalArgumentException("nmcDetails is marked non-null but is null");
        }
        boolean bl = false;
        NmcRestConnection nmcRestConnection = this.nmcConnectionManager.getConnection(nmcDetails);
        bl = nmcRestConnection.checkShutdownSupport();
        logger.debug("checkNmcShutdownSupport() - NMC {} support shutdown command: {}", (Object)nmcDetails.getNmcIp(), (Object)bl);
        return bl;
    }

    public boolean hasNonClusterHosts() {
        logger.debug("hasNonClusterHosts() - start");
        boolean bl = false;
        LinkedHashSet<String> linkedHashSet = this.virtualConfig.getConfiguredHosts();
        logger.debug("hasNonClusterHosts() - configured hosts: {},", linkedHashSet);
        Set<String> set = this.hostSystemUtils.getHostsPartOfCluster(linkedHashSet);
        logger.debug("hasNonClusterHosts() - cluster hosts: {}", set);
        if (set.isEmpty()) {
            logger.info("hasNonClusterHosts() - Can't determine cluster hosts.  Returning false.");
            return bl;
        }
        HashSet<String> hashSet = new HashSet<String>(linkedHashSet);
        hashSet.removeAll(set);
        logger.debug("hasNonClusterHosts() - Unconfigured cluster hosts: {}", hashSet);
        bl = !hashSet.isEmpty();
        logger.debug("hasNonClusterHosts() - end, result: {}", (Object)bl);
        return bl;
    }

    @Generated
    public void setVirtualMachineUtils(@NonNull VirtualMachineUtils virtualMachineUtils) {
        if (virtualMachineUtils == null) {
            throw new IllegalArgumentException("virtualMachineUtils is marked non-null but is null");
        }
        this.virtualMachineUtils = virtualMachineUtils;
    }

    @Generated
    public void setConfig(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Generated
    public void setVirtualConfig(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfig is marked non-null but is null");
        }
        this.virtualConfig = virtualConfigurationManager;
    }

    @Generated
    public void setVirtualLoggingUtils(@NonNull VirtualizationLoggingUtils virtualizationLoggingUtils) {
        if (virtualizationLoggingUtils == null) {
            throw new IllegalArgumentException("virtualLoggingUtils is marked non-null but is null");
        }
        this.virtualLoggingUtils = virtualizationLoggingUtils;
    }

    @Generated
    public void setAuthHelper(@NonNull AuthHelper authHelper) {
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        this.authHelper = authHelper;
    }

    @Generated
    public void setNmcConnectionManager(@NonNull NmcConnectionManager nmcConnectionManager) {
        if (nmcConnectionManager == null) {
            throw new IllegalArgumentException("nmcConnectionManager is marked non-null but is null");
        }
        this.nmcConnectionManager = nmcConnectionManager;
    }

    @Generated
    public void setVxRailConnectionManager(@NonNull VxRailConnectionManager vxRailConnectionManager) {
        if (vxRailConnectionManager == null) {
            throw new IllegalArgumentException("vxRailConnectionManager is marked non-null but is null");
        }
        this.vxRailConnectionManager = vxRailConnectionManager;
    }

    @Generated
    public void setHostSystemUtils(@NonNull HostSystemUtils hostSystemUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setVsanUtils(@NonNull VsanUtils vsanUtils) {
        if (vsanUtils == null) {
            throw new IllegalArgumentException("vsanUtils is marked non-null but is null");
        }
        this.vsanUtils = vsanUtils;
    }

    @Generated
    public void setUnverifiedCertificateManager(@NonNull UnverifiedCertificateManager unverifiedCertificateManager) {
        if (unverifiedCertificateManager == null) {
            throw new IllegalArgumentException("unverifiedCertificateManager is marked non-null but is null");
        }
        this.unverifiedCertificateManager = unverifiedCertificateManager;
    }

    @Generated
    public void setTrustStoreManager(@NonNull TrustStoreManager trustStoreManager) {
        if (trustStoreManager == null) {
            throw new IllegalArgumentException("trustStoreManager is marked non-null but is null");
        }
        this.trustStoreManager = trustStoreManager;
    }
}

