/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.ds.events.flexevents;

import com.apcc.m11.arch.ObjectId;
import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;

public enum EnvironmentalEvents {
    ContactFault1("1", "310"),
    ContactFault2("2", "312"),
    ContactFault3("3", "314"),
    ContactFault4("4", "316"),
    ContactNormal1("5", "311"),
    ContactNormal2("6", "313"),
    ContactNormal3("7", "315"),
    ContactNormal4("8", "317"),
    HumidityInRangeProbe1("9", "307"),
    HumidityInRangeProbe2("10", "309"),
    HumidityOutOfRangeProbe1("11", "306"),
    HumidityOutOfRangeProbe2("12", "308"),
    TempInRangeProbe1("13", "303"),
    TempInRangeProbe2("14", "305"),
    TempOutOfRangeProbe1("15", "302"),
    TempOutOfRangeProbe2("16", "304"),
    EnvironmentCommunicationEstablished("17", "301"),
    EnvironmentCommunicationLost("18", "300"),
    EnvironmentNoCommunicationSinceLastReboot("19"),
    IntegratedEnvCommunicationEstablished("20", "301");

    private static final String GROUP = "3.5.1.7.";
    private final ObjectId objectId;
    private String eventId;

    public static Optional<EnvironmentalEvents> findByObjectId(@NonNull ObjectId objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("id is marked non-null but is null");
        }
        return Arrays.stream(EnvironmentalEvents.values()).filter(environmentalEvents -> objectId.equals((Object)environmentalEvents.getObjectId())).findFirst();
    }

    private EnvironmentalEvents(String string2) {
        this.objectId = new ObjectId(GROUP + string2);
    }

    private EnvironmentalEvents(String string2, String string3) {
        this.objectId = new ObjectId(GROUP + string2);
        this.eventId = string3;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public String getEventId() {
        return this.eventId;
    }
}

