/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.ds.events.flexevents;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.ds.events.flexevents.EnvironmentalEvents;
import com.apcc.m11.ds.events.flexevents.RESTEvents;
import com.apcc.m11.ds.events.flexevents.RuntimeVerifierEvents;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.WebServerEvents;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import com.apcc.m11.ds.events.flexevents.powersource.Bypass;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.events.flexevents.powersource.LoadCapability;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Redundancy;
import com.apcc.m11.ds.events.flexevents.powersource.Temperature;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventLists {
    public static final int DEFAULT_EVENT_SHUTDOWN_DELAY = 0;
    public static final int DEFAULT_ON_BATTERY_SHUTDOWN_DELAY = 120;
    public static final int MIN_EVENT_SHUTDOWN_DELAY = 0;
    public static final int MAX_EVENT_SHUTDOWN_DELAY = 172800;
    public static final int MIN_NOTIFICATION_DELAY = 0;
    public static final int MAX_NOTIFICATION_DELAY = 7200;
    public static final int DEFAULT_NOTIFICATION_DELAY = 0;
    public static final int MIN_NOTIFICATION_REPEAT_INTERVAL = 0;
    public static final int MAX_NOTIFICATION_REPEAT_INTERVAL = 7200;
    public static final int DEFAULT_NOTIFICATION_REPEAT_INTERVAL = 0;
    public static final int MIN_COMMAND_FILE_DELAY = 0;
    public static final int MAX_COMMAND_FILE_DELAY = 172800;
    public static final int DEFAULT_COMMAND_FILE_DELAY = 0;
    public static final int MIN_COMMAND_FILE_DURATION = 0;
    public static final int MAX_COMMAND_FILE_DURATION = 7200;
    public static final int DEFAULT_COMMAND_FILE_DURATION = 0;
    private static Map<ObjectId, String> eventMap;
    private static Map<ObjectId, String> environmentalMap;
    private static Set<ObjectId> nonShutdownEvents;
    private static Map<ObjectId, String> configurableShutdownEvents;

    public static List<ObjectId> getEnvironmentalEvents() {
        Cloneable cloneable;
        if (environmentalMap == null) {
            cloneable = new HashMap();
            for (EnvironmentalEvents environmentalEvents : EnvironmentalEvents.values()) {
                cloneable.put(environmentalEvents.getObjectId(), environmentalEvents.name());
            }
            environmentalMap = cloneable;
        }
        cloneable = new ArrayList();
        cloneable.addAll(environmentalMap.keySet());
        return cloneable;
    }

    public static boolean isOnBatteryEvent(String string) {
        boolean bl = false;
        if (string != null) {
            bl = UtilityLineStatus.PowerFailed.name().equalsIgnoreCase(string);
        }
        return bl;
    }

    public static List<ObjectId> getEvents() {
        Cloneable cloneable;
        if (eventMap == null) {
            cloneable = new HashMap();
            cloneable.put(UtilityLineStatus.PowerFailed.getObjectId(), UtilityLineStatus.PowerFailed.name());
            cloneable.put(UtilityLineStatus.PowerRestored.getObjectId(), UtilityLineStatus.PowerRestored.name());
            cloneable.put(UtilityLineStatus.Overload.getObjectId(), UtilityLineStatus.Overload.name());
            cloneable.put(UtilityLineStatus.OverloadSolved.getObjectId(), UtilityLineStatus.OverloadSolved.name());
            cloneable.put(UtilityLineStatus.PowerOff.getObjectId(), UtilityLineStatus.PowerOff.name());
            cloneable.put(UtilityLineStatus.OutletOff.getObjectId(), UtilityLineStatus.OutletOff.name());
            cloneable.put(UtilityLineStatus.OutletOn.getObjectId(), UtilityLineStatus.OutletOn.name());
            cloneable.put(RuntimeVerifierEvents.RunTimeExceeded.getObjectId(), RuntimeVerifierEvents.RunTimeExceeded.name());
            cloneable.put(RuntimeVerifierEvents.RunTimeWithinRange.getObjectId(), RuntimeVerifierEvents.RunTimeWithinRange.name());
            cloneable.put(RuntimeVerifierEvents.RunTimeRemaining.getObjectId(), RuntimeVerifierEvents.RunTimeRemaining.name());
            cloneable.put(RuntimeVerifierEvents.RunTimeRemainingCleared.getObjectId(), RuntimeVerifierEvents.RunTimeRemainingCleared.name());
            cloneable.put(RuntimeVerifierEvents.RunTimeRemainingCmdFile.getObjectId(), RuntimeVerifierEvents.RunTimeRemainingCmdFile.name());
            cloneable.put(RuntimeVerifierEvents.RunTimeRemainingCmdFileCleared.getObjectId(), RuntimeVerifierEvents.RunTimeRemainingCmdFileCleared.name());
            cloneable.put(Battery.LowBattery.getObjectId(), Battery.LowBattery.name());
            cloneable.put(Battery.ReturnFromLowBattery.getObjectId(), Battery.ReturnFromLowBattery.name());
            cloneable.put(Battery.BatteryDischarged.getObjectId(), Battery.BatteryDischarged.name());
            cloneable.put(Battery.BatteryChargeInRange.getObjectId(), Battery.BatteryChargeInRange.name());
            cloneable.put(Bypass.FaultBypassEnabled.getObjectId(), Bypass.FaultBypassEnabled.name());
            cloneable.put(Bypass.BypassEnabled.getObjectId(), Bypass.BypassEnabled.name());
            cloneable.put(Bypass.BypassManualEnabled.getObjectId(), Bypass.BypassManualEnabled.name());
            cloneable.put(Bypass.BypassDisabled.getObjectId(), Bypass.BypassDisabled.name());
            cloneable.put(Bypass.BypassContactorFailed.getObjectId(), Bypass.BypassContactorFailed.name());
            cloneable.put(Bypass.BypassContactorOk.getObjectId(), Bypass.BypassContactorOk.name());
            cloneable.put(Communication.CommunicationLostOnBattery.getObjectId(), Communication.CommunicationLostOnBattery.name());
            cloneable.put(Communication.CommunicationLost.getObjectId(), Communication.CommunicationLost.name());
            cloneable.put(Communication.NetCommunicationLost.getObjectId(), Communication.NetCommunicationLost.name());
            cloneable.put(Communication.CommunicationEstablished.getObjectId(), Communication.CommunicationEstablished.name());
            cloneable.put(Communication.MonitoringStarted.getObjectId(), Communication.MonitoringStarted.name());
            cloneable.put(Communication.CannotCommunicate.getObjectId(), Communication.CannotCommunicate.name());
            cloneable.put(Communication.CannotCommunicateResolved.getObjectId(), Communication.CannotCommunicateResolved.name());
            cloneable.put(Redundancy.MinRedundancyLost.getObjectId(), Redundancy.MinRedundancyLost.name());
            cloneable.put(Redundancy.MinRedundancyRegained.getObjectId(), Redundancy.MinRedundancyRegained.name());
            cloneable.put(Redundancy.ParallelRedundancyLost.getObjectId(), Redundancy.ParallelRedundancyLost.name());
            cloneable.put(Redundancy.ParallelRedundancyRegained.getObjectId(), Redundancy.ParallelRedundancyRegained.name());
            cloneable.put(Temperature.MaxInternalTempExceeded.getObjectId(), Temperature.MaxInternalTempExceeded.name());
            cloneable.put(Temperature.MaxInternalTempInRange.getObjectId(), Temperature.MaxInternalTempInRange.name());
            cloneable.put(LoadCapability.MinLoadCapabilityLost.getObjectId(), LoadCapability.MinLoadCapabilityLost.name());
            cloneable.put(LoadCapability.MinLoadCapabilityRegained.getObjectId(), LoadCapability.MinLoadCapabilityRegained.name());
            cloneable.put(ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId(), ShutdownEvents.PowerSourceTurnOffInitiated.name());
            cloneable.put(ShutdownEvents.PowerSourceTurnOffCancelled.getObjectId(), ShutdownEvents.PowerSourceTurnOffCancelled.name());
            cloneable.put(ShutdownEvents.ShutdownStarting.getObjectId(), ShutdownEvents.ShutdownStarting.name());
            cloneable.put(ShutdownEvents.ShutdownOnBattery.getObjectId(), ShutdownEvents.ShutdownOnBattery.name());
            cloneable.put(ShutdownEvents.TurnOffUpsStarting.getObjectId(), ShutdownEvents.TurnOffUpsStarting.name());
            cloneable.put(ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId(), ShutdownEvents.UPSOutletTurnOffInitiated.name());
            cloneable.put(ShutdownEvents.UPSMainOutletTurnOffInitiated.getObjectId(), ShutdownEvents.UPSMainOutletTurnOffInitiated.name());
            cloneable.put(ShutdownEvents.UPSOutletTurnOffInitiatedCancelled.getObjectId(), ShutdownEvents.UPSOutletTurnOffInitiatedCancelled.name());
            cloneable.put(MultipleEvent.MultipleCriticalEvent.getObjectId(), MultipleEvent.MultipleCriticalEvent.name());
            cloneable.put(MultipleEvent.MultipleCriticalEventResolved.getObjectId(), MultipleEvent.MultipleCriticalEventResolved.name());
            cloneable.put(MultipleEvent.SinglePowerFailed.getObjectId(), MultipleEvent.SinglePowerFailed.name());
            cloneable.put(MultipleEvent.SinglePowerRestored.getObjectId(), MultipleEvent.SinglePowerRestored.name());
            cloneable.put(MultipleEvent.SingleOutletOff.getObjectId(), MultipleEvent.SingleOutletOff.name());
            cloneable.put(MultipleEvent.SingleOutletRestored.getObjectId(), MultipleEvent.SingleOutletRestored.name());
            cloneable.put(MultipleEvent.CriticalEvent.getObjectId(), MultipleEvent.CriticalEvent.name());
            cloneable.put(MultipleEvent.CriticalEventResolved.getObjectId(), MultipleEvent.CriticalEventResolved.name());
            cloneable.put(Communication.ParallelSilconNotSupported.getObjectId(), Communication.ParallelSilconNotSupported.name());
            cloneable.put(Communication.ParallelSilconSupported.getObjectId(), Communication.ParallelSilconSupported.name());
            cloneable.put(WebServerEvents.AccountLockOut.getObjectId(), WebServerEvents.AccountLockOut.name());
            cloneable.put(RESTEvents.RemoteShutdownEvent.getObjectId(), RESTEvents.RemoteShutdownEvent.name());
            cloneable.put(RESTEvents.RemoteShutdownEventResolved.getObjectId(), RESTEvents.RemoteShutdownEventResolved.name());
            eventMap = cloneable;
        }
        cloneable = new ArrayList();
        cloneable.addAll(eventMap.keySet());
        return cloneable;
    }

    public static List<ObjectId> getAllEvents() {
        List<ObjectId> list = EventLists.getEvents();
        list.addAll(EventLists.getEnvironmentalEvents());
        return list;
    }

    public static Map<ObjectId, String> getAllEventsMap() {
        HashMap<ObjectId, String> hashMap = new HashMap<ObjectId, String>();
        if (eventMap == null || environmentalMap == null) {
            EventLists.getAllEvents();
        }
        hashMap.putAll(environmentalMap);
        hashMap.putAll(eventMap);
        return hashMap;
    }

    public static String getEventNameForObjectId(ObjectId objectId) {
        String string = objectId.toString();
        EventLists.getAllEvents();
        if (eventMap.containsKey(objectId)) {
            string = eventMap.get(objectId);
        } else if (environmentalMap.containsKey(objectId)) {
            string = environmentalMap.get(objectId);
        }
        return string;
    }

    public static Set<ObjectId> getNonShutdownEvents() {
        if (nonShutdownEvents == null) {
            HashSet<ObjectId> hashSet = new HashSet<ObjectId>();
            hashSet.add(UtilityLineStatus.PowerRestored.getObjectId());
            hashSet.add(UtilityLineStatus.OverloadSolved.getObjectId());
            hashSet.add(RuntimeVerifierEvents.RunTimeWithinRange.getObjectId());
            hashSet.add(RuntimeVerifierEvents.RunTimeRemainingCleared.getObjectId());
            hashSet.add(RuntimeVerifierEvents.RunTimeRemainingCmdFileCleared.getObjectId());
            hashSet.add(Battery.BatteryChargeInRange.getObjectId());
            hashSet.add(Bypass.BypassContactorOk.getObjectId());
            hashSet.add(Bypass.BypassDisabled.getObjectId());
            hashSet.add(Communication.CommunicationEstablished.getObjectId());
            hashSet.add(Communication.CannotCommunicateResolved.getObjectId());
            hashSet.add(Communication.MonitoringStarted.getObjectId());
            hashSet.add(Communication.CannotCommunicate.getObjectId());
            hashSet.add(ShutdownEvents.ShutdownStarting.getObjectId());
            hashSet.add(ShutdownEvents.TurnOffUpsStarting.getObjectId());
            hashSet.add(ShutdownEvents.ShutdownOnBattery.getObjectId());
            hashSet.add(ShutdownEvents.ShutdownCanceled.getObjectId());
            hashSet.add(Redundancy.MinRedundancyRegained.getObjectId());
            hashSet.add(Redundancy.ParallelRedundancyRegained.getObjectId());
            hashSet.add(Temperature.MaxInternalTempInRange.getObjectId());
            hashSet.add(Temperature.HumidityNormal.getObjectId());
            hashSet.add(Temperature.TemperatureNormal.getObjectId());
            hashSet.add(LoadCapability.MinLoadCapabilityRegained.getObjectId());
            hashSet.add(MultipleEvent.SinglePowerRestored.getObjectId());
            hashSet.add(MultipleEvent.SingleOutletRestored.getObjectId());
            hashSet.add(MultipleEvent.MultipleCriticalEventResolved.getObjectId());
            hashSet.add(MultipleEvent.CriticalEventResolved.getObjectId());
            hashSet.add(WebServerEvents.AccountLockOut.getObjectId());
            hashSet.add(Communication.ParallelSilconNotSupported.getObjectId());
            hashSet.add(Communication.ParallelSilconSupported.getObjectId());
            hashSet.add(EnvironmentalEvents.ContactNormal1.getObjectId());
            hashSet.add(EnvironmentalEvents.ContactNormal2.getObjectId());
            hashSet.add(EnvironmentalEvents.ContactNormal3.getObjectId());
            hashSet.add(EnvironmentalEvents.ContactNormal4.getObjectId());
            hashSet.add(EnvironmentalEvents.HumidityInRangeProbe1.getObjectId());
            hashSet.add(EnvironmentalEvents.HumidityInRangeProbe2.getObjectId());
            hashSet.add(EnvironmentalEvents.TempInRangeProbe1.getObjectId());
            hashSet.add(EnvironmentalEvents.TempInRangeProbe2.getObjectId());
            hashSet.add(EnvironmentalEvents.EnvironmentCommunicationEstablished.getObjectId());
            hashSet.add(EnvironmentalEvents.EnvironmentCommunicationLost.getObjectId());
            hashSet.add(EnvironmentalEvents.EnvironmentNoCommunicationSinceLastReboot.getObjectId());
            hashSet.add(EnvironmentalEvents.IntegratedEnvCommunicationEstablished.getObjectId());
            hashSet.add(RESTEvents.RemoteShutdownEventResolved.getObjectId());
            nonShutdownEvents = hashSet;
        }
        return nonShutdownEvents;
    }

    public static Map<ObjectId, String> getConfigurableShutdownEvents() {
        if (configurableShutdownEvents == null) {
            LinkedHashMap<ObjectId, String> linkedHashMap = new LinkedHashMap<ObjectId, String>();
            linkedHashMap.put(UtilityLineStatus.PowerFailed.getObjectId(), UtilityLineStatus.PowerFailed.name());
            linkedHashMap.put(RuntimeVerifierEvents.RunTimeExceeded.getObjectId(), RuntimeVerifierEvents.RunTimeExceeded.name());
            linkedHashMap.put(RuntimeVerifierEvents.RunTimeRemaining.getObjectId(), RuntimeVerifierEvents.RunTimeRemaining.name());
            linkedHashMap.put(Battery.BatteryDischarged.getObjectId(), Battery.BatteryDischarged.name());
            linkedHashMap.put(Bypass.FaultBypassEnabled.getObjectId(), Bypass.FaultBypassEnabled.name());
            linkedHashMap.put(Bypass.BypassEnabled.getObjectId(), Bypass.BypassEnabled.name());
            linkedHashMap.put(Bypass.BypassManualEnabled.getObjectId(), Bypass.BypassManualEnabled.name());
            linkedHashMap.put(Bypass.BypassContactorFailed.getObjectId(), Bypass.BypassContactorFailed.name());
            linkedHashMap.put(Communication.CommunicationLostOnBattery.getObjectId(), Communication.CommunicationLostOnBattery.name());
            linkedHashMap.put(Communication.CommunicationLost.getObjectId(), Communication.CommunicationLost.name());
            linkedHashMap.put(Communication.NetCommunicationLost.getObjectId(), Communication.NetCommunicationLost.name());
            linkedHashMap.put(Redundancy.MinRedundancyLost.getObjectId(), Redundancy.MinRedundancyLost.name());
            linkedHashMap.put(LoadCapability.MinLoadCapabilityLost.getObjectId(), LoadCapability.MinLoadCapabilityLost.name());
            linkedHashMap.put(Temperature.MaxInternalTempExceeded.getObjectId(), Temperature.MaxInternalTempExceeded.name());
            linkedHashMap.put(UtilityLineStatus.Overload.getObjectId(), UtilityLineStatus.Overload.name());
            linkedHashMap.put(Redundancy.ParallelRedundancyLost.getObjectId(), Redundancy.ParallelRedundancyLost.name());
            linkedHashMap.put(EnvironmentalEvents.EnvironmentCommunicationLost.getObjectId(), EnvironmentalEvents.EnvironmentCommunicationLost.name());
            linkedHashMap.put(EnvironmentalEvents.TempOutOfRangeProbe1.getObjectId(), EnvironmentalEvents.TempOutOfRangeProbe1.name());
            linkedHashMap.put(EnvironmentalEvents.TempOutOfRangeProbe2.getObjectId(), EnvironmentalEvents.TempOutOfRangeProbe2.name());
            linkedHashMap.put(EnvironmentalEvents.HumidityOutOfRangeProbe1.getObjectId(), EnvironmentalEvents.HumidityOutOfRangeProbe1.name());
            linkedHashMap.put(EnvironmentalEvents.HumidityOutOfRangeProbe2.getObjectId(), EnvironmentalEvents.HumidityOutOfRangeProbe2.name());
            linkedHashMap.put(EnvironmentalEvents.ContactFault1.getObjectId(), EnvironmentalEvents.ContactFault1.name());
            linkedHashMap.put(EnvironmentalEvents.ContactFault2.getObjectId(), EnvironmentalEvents.ContactFault2.name());
            linkedHashMap.put(EnvironmentalEvents.ContactFault3.getObjectId(), EnvironmentalEvents.ContactFault3.name());
            linkedHashMap.put(EnvironmentalEvents.ContactFault4.getObjectId(), EnvironmentalEvents.ContactFault4.name());
            configurableShutdownEvents = linkedHashMap;
        }
        return configurableShutdownEvents;
    }

    public static boolean isCommandFileEnabled(ObjectId objectId) {
        EventLists.createMaps();
        boolean bl = eventMap.containsKey(objectId) || environmentalMap.containsKey(objectId);
        return bl;
    }

    public static boolean isLoggingEnabled(ObjectId objectId) {
        EventLists.createMaps();
        boolean bl = eventMap.containsKey(objectId) || environmentalMap.containsKey(objectId);
        return bl;
    }

    public static boolean isShutdownEnabled(ObjectId objectId) {
        EventLists.createMaps();
        boolean bl = (eventMap.containsKey(objectId) || environmentalMap.containsKey(objectId)) && !nonShutdownEvents.contains(objectId);
        return bl;
    }

    public static boolean isNotificationEnabled(ObjectId objectId) {
        EventLists.createMaps();
        boolean bl = eventMap.containsKey(objectId) || environmentalMap.containsKey(objectId);
        return bl;
    }

    private static void createMaps() {
        EventLists.getEvents();
        EventLists.getEnvironmentalEvents();
        EventLists.getNonShutdownEvents();
    }

    public static int getDefaultShutdownDelay(String string) {
        int n = 0;
        if (EventLists.isOnBatteryEvent(string)) {
            n = 120;
        }
        return n;
    }
}

