/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.analytics;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.m11.components.webserver.model.VM;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.simplivity.SimplivityUtils;
import com.apcc.m11.ds.events.flexevents.EventLists;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.hyperflex.HyperflexConnection;
import com.apcc.pcns.hyperflex.HyperflexDetails;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixService;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.util.OSVersionInfo;
import com.apcc.pcns.util.ResourceBundleWrapper;
import com.apcc.pcns.vxrail.VxRailConnection;
import com.apcc.pcns.vxrail.VxRailDetails;
import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalyseConfiguration {
    private static final Logger logger = LogManager.getLogger(AnalyseConfiguration.class);
    @NonNull
    private ConfigurationManager config;
    protected ServiceManager services;
    protected OSVersionInfo os;
    private int retryDelay = 10;

    public AnalyseConfiguration(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.os = OSVersionInfo.getOSVersionInfo();
        this.config = configurationManager;
    }

    public Map<String, Object> getCustomProperties() {
        logger.debug("getCustomProperties()");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("PCNSLanguage", Locale.getDefault().getLanguage());
        if (this.os != null) {
            hashMap.put("PCNSOSName", this.os.getName());
            hashMap.put("PCNSOSEdition", this.os.getEdition());
            hashMap.put("PCNSOSVersion", this.os.getVersion());
        }
        hashMap.put("JDK_Version", System.getProperty("java.vm.name", "") + " (" + System.getProperty("java.vm.version", "") + ")");
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Object object;
            Integer n;
            this.addPropertyFromIniValue(hashMap, "NetworkManagementCard", "mode");
            this.addPropertyFromIniValue(hashMap, "Networking", "NetworkConfig");
            Integer n2 = 0;
            while (this.config.containsKey("NetworkManagementCard", "IP_" + (n2 + 1))) {
                n = n2;
                n2 = n2 + 1;
            }
            hashMap.put("UPS_Count", n2);
            n = 0;
            while (this.config.containsSection("advanced_ups_setup_" + n)) {
                object = n;
                n = n + 1;
            }
            if (n > 0) {
                hashMap.put("UPS_Group_Count", n);
            }
            this.addPropertiesHCI(hashMap, hashSet);
            this.addTagFromIniIfEnabled(hashSet, "HostDetails", "is_VCSA");
            this.addTagFromIniIfEnabled(hashSet, "HostConfigSettings", "Skip_Maintenance_Mode");
            this.addTagFromIniIfEnabled(hashSet, "HostConfigSettings", "vm_prioritization_enabled");
            this.addTagFromIniIfEnabled(hashSet, "HostConfigSettings", "enable_hvstopcluster");
            this.addPropertyFromIniMaxAdvanced(hashMap, n, "HostConfigSettings", "vsan_ftt_level", "enable_vsan_ftt", "vsan_ftt_level");
            this.addPropertyFromIniMaxAdvanced(hashMap, n, "HostConfigSettings", "cluster_shutdown_duration", null, "cluster_shutdown_duration");
            this.addPropertyFromIniMaxAdvanced(hashMap, n, "HostConfigSettings", "cluster_startup_duration", null, "cluster_startup_duration");
            this.addPropertyFromIniValue(hashMap, "VxRailClusterDetails", "cluster_shutdown_delay");
            this.addPropertyFromIniValue(hashMap, "VxRailClusterDetails", "cluster_shutdown_duration");
            this.addPropertyFromIniValue(hashMap, "HostConfigSettings", "autostart_delay");
            this.addTagSSHActions(hashSet, hashMap);
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "Shutdown", "turnOffUps");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "Shutdown", "turnOffSOG");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "Shutdown", "shutdownCommandFileEnabled");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "enable_host_maintenance");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "enable_host_shutdown");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "delay_maintenance_mode");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "enable_guest_vm_migration");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "enable_guest_vm_vapp_shutdown");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "enable_guest_vm_vapp_startup");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "uvm_startup_enable", "enable_guest_vm_vapp_startup");
            this.addPropertyFromIniMaxAdvanced(hashMap, n, "HostConfigSettings", "cvm_shutdown_duration", null, "cvm_shutdown_duration");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "cvm_startup_enable");
            this.addPropertyFromIniMaxAdvanced(hashMap, n, "HostConfigSettings", "cvm_startup_duration", "cvm_startup_enable", "cvm_startup_duration");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "afs_shutdown_enable");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "afs_startup_enable");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "ongoing_replication_abort_delay_enable");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "enable_vsan_ftt");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "enable_custom_target_vm_migration");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "metro_availability_disable");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "metro_availability_re-enable");
            this.addTagFromIniIfEnabledAdvanced(hashSet, n, "HostConfigSettings", "ovc_startup_enable");
            this.addTagFromIniIfEnabled(hashSet, "HostConfigSettings", ConfigurationKeys.ENABLE_PLUGIN);
            this.addTagFromIniIfEnabled(hashSet, "HostConfigSettings", "startup_waits_for_all_hosts_online");
            this.addTagFromIniIfEnabled(hashSet, "Networking", "isPCNSonVM");
            this.addTagFromIniIfEnabled(hashSet, "SNMP", "SNMPv1_Enabled");
            this.addTagFromIniIfEnabled(hashSet, "SNMP", "SNMPv3_Enabled");
            this.addTagFromIniIfEnabled(hashSet, "SNMP", "LostCommsEvents_Enabled", "LostComms_Trap");
            this.addTagFromIniIfEnabled(hashSet, "SNMP", "UPSCriticalEvents_Enabled", "CriticalEvent_Trap");
            this.addSNMPTrapReceiverProperty(hashMap);
            object = this.getShutdownEvents();
            hashMap.put("Shutdown_events", object.keySet().toArray());
            hashMap.put("Shutdown_event_delay", object.entrySet().stream().filter(entry -> !Objects.isNull(entry.getValue())).map(entry -> String.format("%s:%06d", entry.getKey(), entry.getValue())).collect(Collectors.toList()).toArray());
            hashMap.put("Cmd_events", this.getCmdFileEvents().toArray());
        }
        catch (Exception exception) {
            logger.warn("Error creating custom tags.  Will continue as best it can, but some tags will be missing.", (Throwable)exception);
        }
        logger.debug("feature tags:{}", hashSet);
        hashMap.put("features", hashSet.toArray());
        logger.debug("Custom Properties: {}", hashMap);
        return hashMap;
    }

    private String addPropertyFromIniValue(Map<String, Object> map, String string, String string2) {
        String string3 = this.config.getString(string, string2);
        if (!StringUtils.isBlank((CharSequence)string3)) {
            map.put(string2, string3);
        }
        return string3;
    }

    private String addTagFromIniValue(Set<String> set, String string, String string2) {
        String string3 = this.config.getString(string, string2);
        if (!StringUtils.isBlank((CharSequence)string3)) {
            set.add(string3);
        }
        return string3;
    }

    private void addTagFromIniIfEnabled(Set<String> set, String string, String string2) {
        this.addTagFromIniIfEnabled(set, string, string2, string2);
    }

    private void addTagFromIniIfEnabled(Set<String> set, String string, String string2, String string3) {
        try {
            if (this.config.getBoolean(string, string2).booleanValue()) {
                set.add(string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void addTagFromIniIfEnabledAdvanced(Set<String> set, Integer n, String string, String string2) {
        this.addTagFromIniIfEnabledAdvanced(set, n, string, string2, string2);
    }

    private void addTagFromIniIfEnabledAdvanced(Set<String> set, Integer n, String string, String string2, String string3) {
        try {
            if (this.config.getBoolean(string, string2).booleanValue()) {
                set.add(string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (int i = 0; i <= n; ++i) {
            try {
                if (!this.config.getBoolean("advanced_ups_setup_" + i, string2).booleanValue()) continue;
                set.add(string3);
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    private void addPropertyFromIniMaxAdvanced(Map<String, Object> map, Integer n, String string, String string2, String string3, String string4) {
        Integer n2 = null;
        try {
            if (string3 == null || this.config.getBoolean(string, string3).booleanValue()) {
                n2 = this.config.getInt(string, string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        for (int i = 0; i <= n; ++i) {
            try {
                String string5 = "advanced_ups_setup_" + i;
                if (string3 != null && !this.config.getBoolean(string5, string3).booleanValue()) continue;
                Integer n3 = this.config.getInt(string5, string2);
                if (n2 != null && n3 <= n2) continue;
                n2 = n3;
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (n2 != null) {
            map.put(string4, n2);
        } else if (this.config.containsKey(string, string2)) {
            map.put(string4, "disabled");
        }
    }

    private void addTagSSHActions(Set<String> set, Map<String, Object> map) {
        int n = 0;
        Set<String> set2 = this.config.getSections();
        set2 = set2.stream().filter(string -> string.startsWith("SSHAction")).filter(string -> this.config.getBoolean((String)string, "ssh_action_enabled")).collect(Collectors.toSet());
        n = set2.size();
        set2.stream().forEach(string -> {
            String string2 = this.config.getString((String)string, "ssh_action_sequence");
            if (StringUtils.equals((CharSequence)string2, (CharSequence)SSHActionTrigger.ON_STARTUP.getIniSetting())) {
                set.add("sshAction_" + SSHActionTrigger.ON_STARTUP.getIniSetting());
            } else if (StringUtils.equals((CharSequence)string2, (CharSequence)SSHActionTrigger.AFTER_HOST_SHUTDOWN.getIniSetting())) {
                set.add("sshAction_" + SSHActionTrigger.AFTER_HOST_SHUTDOWN.getIniSetting());
            } else if (StringUtils.equals((CharSequence)string2, (CharSequence)SSHActionTrigger.BEFORE_HOST_SHUTDOWN.getIniSetting())) {
                set.add("sshAction_" + SSHActionTrigger.BEFORE_HOST_SHUTDOWN.getIniSetting());
            } else if (StringUtils.equals((CharSequence)string2, (CharSequence)SSHActionTrigger.BEFORE_VM_SHUTDOWN.getIniSetting())) {
                set.add("sshAction_" + SSHActionTrigger.BEFORE_VM_SHUTDOWN.getIniSetting());
            }
        });
        if (n > 0) {
            set.add("ssh_action_enabled");
        }
        map.put("ssh_action_enabled", n);
    }

    private void addSNMPTrapReceiverProperty(Map<String, Object> map) {
        String string = "SNMP";
        int n = 0;
        int n2 = 1;
        while (this.config.containsKey("SNMP", "TrapReceiver_" + n2 + "_Enabled")) {
            if (this.config.getBoolean("SNMP", "TrapReceiver_" + n2 + "_Enabled").booleanValue()) {
                ++n;
            }
            ++n2;
        }
        map.put("SNMPTrapReceivers", n);
    }

    private void addPropertiesHCI(Map<String, Object> map, HashSet<String> hashSet) {
        Object object;
        logger.debug("addPropertiesHCI() - start");
        String string = this.addPropertyFromIniValue(map, "Networking", "VirtualInstall");
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.debug("addPropertiesHCI() - no virtualisation enabled");
            return;
        }
        String string2 = this.addTagFromIniValue(hashSet, "HostDetails", "ConfigurationMode");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if ("VMWare".equals(string)) {
            object = this.getWithRetry(this::getVMWareVersion);
            string3 = this.safeGet((List<String>)object, 0);
            string4 = this.safeGet((List<String>)object, 1);
            if ("Managed".equals(string2)) {
                object = this.getWithRetry(this::getVCenterVersion);
                string5 = this.safeGet((List<String>)object, 0);
                string6 = this.safeGet((List<String>)object, 1);
            }
        }
        if ("Hyper-V".equals(string) && "Managed".equals(string2)) {
            object = this.getSCVMMVersion();
            string5 = this.safeGet((List<String>)object, 0);
            string6 = this.safeGet((List<String>)object, 1);
        }
        if ("Nutanix".equals(string)) {
            string2 = "Managed";
            hashSet.add(string2);
        }
        this.safePut(map, "VirtualInstall_version", string3);
        this.safePut(map, "VirtualInstall_build", string4);
        this.safePut(map, "VirtualManager_version", string5);
        this.safePut(map, "VirtualManager_build", string6);
        object = this.config.getString("HostDetails", "hyperconverged_support");
        if (StringUtils.isNotBlank((CharSequence)object) && !"none".equals(object)) {
            map.put("hyperconverged_support", object);
        } else if ("Nutanix".equalsIgnoreCase(string)) {
            object = "nutanixAHV";
            map.put("hyperconverged_support", object);
        } else if (this.services != null && this.services.getVsanUtils().isVsanCluster()) {
            object = "vSAN";
            map.put("hyperconverged_support", object);
        }
        String string7 = null;
        switch (StringUtils.defaultString((String)object)) {
            case "hyperflex": {
                logger.debug("addPropertiesHCI() - Hyperflex version");
                string7 = this.safeGet(this.getWithRetry(this::getHyperflexVersion), 0);
                break;
            }
            case "simplivity": {
                logger.debug("addPropertiesHCI() - Simplivity version");
                string7 = this.safeGet(this.getWithRetry(this::getSimplivityVersion), 0);
                break;
            }
            case "nutanix": 
            case "nutanixAHV": {
                logger.debug("addPropertiesHCI() - Nutanix version");
                string7 = this.safeGet(this.getWithRetry(this::getNutanixVersion), 0);
                break;
            }
            case "vxrail": {
                logger.debug("addPropertiesHCI() - vxRail version");
                string7 = this.safeGet(this.getWithRetry(this::getVxRailVersion), 0);
                break;
            }
            default: {
                logger.debug("addPropertiesHCI() - no HCI version for {}", object);
            }
        }
        this.safePut(map, "hci_version", string7);
        if ("Managed".equals(string2)) {
            map.put("HyperVisor_nodes", this.getHostList().size());
        }
        this.addProtectedVMCounts(map, string, string2);
        logger.debug("addPropertiesHCI() - end");
    }

    private List<String> getHostList() {
        logger.debug("getHostList() - start");
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.config.getString("HostConfigSettings", "hostlist");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            String[] stringArray = string.split("\\|");
            arrayList.addAll(Arrays.asList(stringArray));
        }
        int n = 0;
        while (this.config.containsKey("advanced_ups_setup_" + n, "hostlist")) {
            string = this.config.getString("advanced_ups_setup_" + n, "hostlist");
            if (StringUtils.isNotBlank((CharSequence)string)) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("\\|")) {
                    String[] stringArray2 = string2.split("&");
                    arrayList.add(stringArray2[0]);
                }
            }
            ++n;
        }
        logger.debug("getHostList() - found {}", arrayList);
        arrayList = arrayList.stream().map(VsanUtils::removeVsanTagsFromHostname).collect(Collectors.toList());
        logger.debug("getHostList() - returns {}", arrayList);
        return arrayList;
    }

    private void addProtectedVMCounts(Map<String, Object> map, String string, String string2) {
        Object object;
        Object object2;
        logger.debug("addProtectedVMCounts() - start");
        List<PrioritizedVM> list = null;
        if (StringUtils.equals((CharSequence)"VMWare", (CharSequence)string) && "Managed".equals(string2)) {
            list = this.services.getHostSystemUtils().getPrioritizationVMs();
            list = this.services.getVMPriorityTreeHelper().filterOutSpecialHCIVMs(list);
            if (list != null) {
                list = list.stream().filter(prioritizedVM -> !prioritizedVM.isvSanWitness()).collect(Collectors.toList());
            }
        }
        if (StringUtils.equals((CharSequence)"Nutanix", (CharSequence)string)) {
            object2 = Utils.getWebServerResourceBundle(Locale.getDefault());
            object = ((ResourceBundleWrapper)object2).getResourceBundle().getString("VMPrioritization.DefaultClusterName");
            list = this.services.getNutanixUtils().getPrioritizationVMs((String)object);
        }
        if (list != null) {
            logger.debug("addProtectedVMCounts() - vm list {}", list.stream().map(VM::getVMName).collect(Collectors.toList()));
            object2 = (int)list.stream().filter(VM::isVirtualApp).count();
            logger.debug("addProtectedVMCounts() - user vapp count:{}", object2);
            object = (int)list.stream().filter(prioritizedVM -> !prioritizedVM.isVirtualApp()).count();
            logger.debug("addProtectedVMCounts() - user vm count:{}", object);
            map.put("VM_count", object);
            if (!StringUtils.equals((CharSequence)"Nutanix", (CharSequence)string)) {
                map.put("VApp_count", object2);
            }
        }
    }

    private List<String> getWithRetry(Supplier<List<String>> supplier) {
        List<String> list = null;
        int n = 0;
        while (list == null && n < 3) {
            ++n;
            try {
                list = supplier.get();
            }
            catch (Exception exception) {
                logger.debug("getWithRetry() - error calling {}, will try again");
            }
            if (list != null && !list.isEmpty() && !list.stream().allMatch(Objects::isNull)) continue;
            list = null;
            CountdownTimer countdownTimer = new CountdownTimer(this.retryDelay, TimeUnit.SECONDS);
            countdownTimer.sleep();
        }
        logger.debug("getWithRetry() - end. returning {} after {} attempts", list, (Object)n);
        return list;
    }

    private String safeGet(List<String> list, int n) {
        if (list != null && n < list.size()) {
            return list.get(n);
        }
        return null;
    }

    private void safePut(Map<String, Object> map, String string, String string2) {
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    protected List<String> getVCenterVersion() {
        ServiceInstance serviceInstance = this.services.getVmWareConnection().getVCenterConnection();
        ArrayList<String> arrayList = null;
        if (serviceInstance != null) {
            AboutInfo aboutInfo = serviceInstance.getServiceContent().getAbout();
            arrayList = new ArrayList<String>();
            arrayList.add(aboutInfo.getVersion());
            arrayList.add(aboutInfo.getBuild());
            logger.info("getVCenterVersion() - got version from {} {}", (Object)aboutInfo.getFullName(), arrayList);
        } else {
            logger.info("getVCenterVersion() - serviceInstance is unavailable, can't get vCenter version.  Proceeding without it.");
        }
        logger.debug("getVCenterVersion() - returning {}", arrayList);
        return arrayList;
    }

    protected List<String> getSCVMMVersion() {
        ArrayList<String> arrayList = null;
        String string = this.services.getHyperVUtils().getSCVMMVersion();
        logger.debug("getSCVMMVersion() - build string {}", (Object)string);
        if (string != null) {
            arrayList = new ArrayList<String>();
            String[] stringArray = string.split("\\.");
            CharSequence[] charSequenceArray = Arrays.copyOf(stringArray, 2);
            String string2 = String.join((CharSequence)".", charSequenceArray);
            arrayList.add(string2);
            arrayList.add(string);
        }
        logger.debug("getSCVMMVersion() - returning {}", arrayList);
        return arrayList;
    }

    protected List<String> getVMWareVersion() {
        Object object;
        ArrayList<String> arrayList = null;
        List<String> list = this.getHostList();
        if (list.isEmpty() && StringUtils.isNotBlank((CharSequence)(object = this.config.getString("HostDetails", "Server")))) {
            logger.debug("getVMWareVersion() - Using HostDetails.Server host");
            list.add((String)object);
        }
        for (String string : list) {
            try {
                HostSystem hostSystem = this.services.getHostSystemUtils().getHostSystemDirectConnection(string);
                if (hostSystem == null) {
                    logger.debug("getVMWareVersion() - host system connection failed, returned: {}, skipping to next host", (Object)hostSystem);
                    continue;
                }
                AboutInfo aboutInfo = hostSystem.getServerConnection().getServiceInstance().getAboutInfo();
                arrayList = new ArrayList<String>();
                arrayList.add(aboutInfo.getVersion());
                arrayList.add(aboutInfo.getBuild());
                if (!arrayList.stream().allMatch(Objects::nonNull)) continue;
                logger.info("getVMWareVersion() - got version from host:{}", (Object)string);
                break;
            }
            catch (NullPointerException nullPointerException) {
                logger.info("getVMWareVersion() - unable to get version from host:{}.  Will try the other hosts.", (Object)string, (Object)nullPointerException);
            }
        }
        logger.debug("getVMWareVersion() - returning {}", arrayList);
        return arrayList;
    }

    protected List<String> getHyperflexVersion() {
        String string = null;
        HyperflexDetails hyperflexDetails = this.services.getHyperflexUtils().loadHyperflexDetails();
        HyperflexConnection hyperflexConnection = this.services.getHyperflexConnectionManager().getConnection(hyperflexDetails);
        String string2 = this.services.getHyperflexUtils().getClusterUuidFromConfig();
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            try {
                string2 = hyperflexConnection.getClusterUuid();
                string = hyperflexConnection.getClusterProductVersion(string2);
            }
            catch (RemoteException remoteException) {
                logger.info("getHyperflexVersion() - unable to get version at the moment", (Throwable)remoteException);
            }
        }
        logger.debug("getHyperflexVersion() - returning:{}", string);
        return Arrays.asList(string);
    }

    protected List<String> getSimplivityVersion() {
        String string = null;
        SimplivityUtils simplivityUtils = this.services.getSimplivityUtils();
        string = simplivityUtils.getVersion();
        logger.debug("getSimplivityVersion() - returning:{}", (Object)string);
        return Arrays.asList(string);
    }

    protected List<String> getNutanixVersion() {
        logger.debug("getNutanixVersion() - start()");
        String string = null;
        NutanixConnection nutanixConnection = null;
        try {
            nutanixConnection = NutanixService.getInstance().getClusterConnection();
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            logger.info("getNutanixVersion() - Exception getting Nutanix connection,   Can't get Nutanix Version, proceeding without it.", (Throwable)exception);
        }
        try {
            if (nutanixConnection != null) {
                nutanixConnection.connect();
                string = nutanixConnection.getVersion();
                nutanixConnection.disconnect();
            } else {
                logger.info("getNutanixVersion() - Nutanix connection is unavailable.  Can't get Nutanix Version, proceeding without it.");
            }
        }
        catch (RemoteException remoteException) {
            logger.info("getNutanixVersion() - Exception getting Nutanix Version.    Can't get Nutanix Version, proceeding without it.", (Throwable)remoteException);
        }
        logger.debug("getNutanixVersion() - returning:{}", (Object)string);
        return Arrays.asList(string);
    }

    protected List<String> getVxRailVersion() {
        logger.trace("getVxRailVersion() - start");
        String string = null;
        VxRailDetails vxRailDetails = this.services.getVxRailUtils().loadVxRailDetails();
        VxRailConnection vxRailConnection = this.services.getVxRailConnectionManager().getConnection(vxRailDetails);
        try {
            string = vxRailConnection.getClusterProductVersion();
        }
        catch (RemoteException remoteException) {
            logger.info("getVxRailVersion() - unable to get version at the moment", (Throwable)remoteException);
        }
        logger.debug("getVxRailVersion() - returning:{}", (Object)string);
        return Arrays.asList(string);
    }

    protected Map<String, Integer> getShutdownEvents() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Map<ObjectId, String> map = EventLists.getConfigurableShutdownEvents();
        for (String string : map.values()) {
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
            boolean bl = false;
            Integer n = null;
            try {
                bl = this.config.getBoolean(configurationKeys.getSection(), configurationKeys.getEnableShutdownKey());
                n = this.config.getInt(configurationKeys.getSection(), configurationKeys.getShutdownDelayKey());
            }
            catch (Exception exception) {
                logger.debug("getShutdownEvents() - {} - Not enabled because it is not in the ini file,or invalid value.  {}-{}", (Object)string, (Object)configurationKeys.getSection(), (Object)configurationKeys.getEnableShutdownKey());
            }
            if (bl) {
                hashMap.put(string, n);
                continue;
            }
            logger.debug("getShutdownEvents() - {} - Not enabled  {}-{}", (Object)string, (Object)configurationKeys.getSection(), (Object)configurationKeys.getEnableShutdownKey());
        }
        return hashMap;
    }

    protected Set<String> getCmdFileEvents() {
        HashSet<String> hashSet = new HashSet<String>();
        Map<ObjectId, String> map = EventLists.getAllEventsMap();
        for (String string : map.values()) {
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
            boolean bl = false;
            try {
                bl = this.config.getBoolean(configurationKeys.getSection(), configurationKeys.getEnableCommandFileKey());
            }
            catch (Exception exception) {
                logger.debug("getCmdFileEvents() - {} - Not enabled because it is not in the ini file,or invalid value.  {}-{}", (Object)string, (Object)configurationKeys.getSection(), (Object)configurationKeys.getEnableShutdownKey());
            }
            if (bl) {
                hashSet.add(string);
                continue;
            }
            logger.debug("getCmdFileEvents() - {} - Not enabled  {}-{}", (Object)string, (Object)configurationKeys.getSection(), (Object)configurationKeys.getEnableShutdownKey());
        }
        return hashSet;
    }

    @Generated
    public void setServices(ServiceManager serviceManager) {
        this.services = serviceManager;
    }

    @Generated
    public void setOs(OSVersionInfo oSVersionInfo) {
        this.os = oSVersionInfo;
    }

    @Generated
    public void setRetryDelay(int n) {
        this.retryDelay = n;
    }
}

