/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.analytics;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.ds.powersource.Battery;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.m11.ds.powersource.Configuration;
import com.apcc.m11.ds.powersource.Identification;
import com.apcc.m11.ds.services.RuntimeVerificationGroup;
import com.apcc.pcns.util.CountdownTimer;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalyseUPSs {
    private static final Logger logger = LogManager.getLogger(AnalyseUPSs.class);
    protected IDataSource dataSource = null;
    private DateTimeFormatter intDateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd", Locale.US);
    private DateTimeFormatter longYearDateFormatter = DateTimeFormatter.ofPattern("MM/dd/yyyy", Locale.US);
    private DateTimeFormatter shortYearDateFormatter = DateTimeFormatter.ofPattern("MM/dd/yy", Locale.US);
    private long runtimeVerifierWait = 30L;

    public void doUpdateUPSDetails(Map<String, Object[]> map, Map<String, Object> map2, @NonNull Long l, int n) {
        if (l == null) {
            throw new IllegalArgumentException("heartbeatInterval is marked non-null but is null");
        }
        logger.debug("doUpdateUPSDetails() - start");
        CountdownTimer countdownTimer = new CountdownTimer(l, TimeUnit.MINUTES);
        logger.info("doUpdateUPSDetails() - Attempt to get the UPS details.  UPS needs to be in communications");
        boolean bl = false;
        while (!countdownTimer.hasElapsed() && !bl) {
            Object object;
            try {
                object = 2;
                GetResult getResult = this.dataSource.get(Communication.CommunicationStatus.getObjectId());
                if (!getResult.hasError() && getResult.getValue() instanceof Integer) {
                    object = (Integer)getResult.getValue();
                }
                if ((Integer)object == 1) {
                    logger.info("doUpdateUPSDetails() - UPS communications established");
                    this.addUpdateUPSDetails(map, map2);
                    this.addShutdownDurationsWithWait(map2);
                    logger.debug("doUpdateUPSDetails() - Data Collected");
                    bl = true;
                } else {
                    logger.debug("doUpdateUPSDetails() - UPS communications not established");
                }
            }
            catch (CommunicationException | InvalidObjectIdException throwable) {
                logger.info("doUpdateUPSDetails() - unable to get the UPS details.  Will re-attempt", throwable);
            }
            catch (Exception exception) {
                logger.info("doUpdateUPSDetails() - unable to get the UPS details.", (Throwable)exception);
                bl = true;
            }
            if (bl) continue;
            object = new CountdownTimer(n, TimeUnit.SECONDS);
            ((CountdownTimer)object).sleep();
        }
        logger.debug("doUpdateUPSDetails() - end");
    }

    protected void addUpdateUPSDetails(Map<String, Object[]> map, Map<String, Object> map2) {
        Object[] objectArray;
        logger.debug("addUpdateUPSDetails() - start");
        this.addPropertyFromM11Array(map, "UPS_Model", Identification.ModelNameList.getObjectId());
        this.addPropertyFromM11Array(map, "UPS_FW", Identification.FirmwareRevision.getObjectId());
        this.addPropertyFromM11Array(map, "UPS_SKU", Identification.UPS_SKU.getObjectId());
        this.addPropertyFromM11Array(map, "NMC_FW", Identification.NMC_FW.getObjectId());
        this.addPropertyFromM11Array(map, "NMC_SKU", Identification.NMC_SKU.getObjectId());
        this.addPropertyFromM11Array(map, "UPS_low_batt", Configuration.LowBatteryRuntimeList.getObjectId());
        this.addPropertyFromM11Array(map, "UPS_runtime", Battery.RuntimeRemainingList.getObjectId());
        Object[] objectArray2 = this.m11Value(Identification.ManufactureDate.getObjectId());
        if (objectArray2 != null) {
            objectArray2 = this.dateToIntegerArray(objectArray2);
            map.put("UPS_manuf_date", objectArray2);
            map2.put("UPS_manuf_year_min", this.minYearInDateArray(objectArray2));
            map2.put("UPS_manuf_year_max", this.maxYearInDateArray(objectArray2));
        }
        if ((objectArray = this.m11Value(Battery.LastBatteryReplacementDate.getObjectId())) != null) {
            objectArray = this.dateToIntegerArray(objectArray);
            map.put("UPS_batt_rep_date", objectArray);
            map2.put("UPS_batt_rep_year_min", this.minYearInDateArray(objectArray));
            map2.put("UPS_batt_rep_year_max", this.maxYearInDateArray(objectArray));
        }
    }

    void addPropertyFromM11Array(Map<String, Object[]> map, String string, ObjectId objectId) {
        Object[] objectArray = this.m11Value(objectId);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof String)) continue;
                objectArray[i] = ((String)objectArray[i]).trim();
            }
            map.put(string, objectArray);
        }
    }

    private Object[] m11Value(ObjectId objectId) {
        logger.debug("m11Value() - start {}", (Object)objectId);
        Object[] objectArray = null;
        try {
            GetResult getResult = this.dataSource.get(objectId);
            Object object = null;
            if (Objects.isNull(getResult) || getResult.hasError()) {
                logger.debug("m11Value() - no result available for {}", (Object)objectId);
                return objectArray;
            }
            object = getResult.getValue();
            if (Objects.isNull(object)) {
                logger.debug("m11Value() - result is null for {}", (Object)objectId);
            } else if (object instanceof String) {
                objectArray = new String[]{object};
            } else if (object instanceof Vector) {
                Vector vector = (Vector)object;
                objectArray = !vector.isEmpty() && vector.get(0) instanceof Date ? vector.stream().map(this::dateToInteger).toArray() : vector.toArray();
            } else if (object instanceof Integer) {
                objectArray = new Integer[]{object};
            } else if (object instanceof Date) {
                objectArray = new Integer[]{this.dateToInteger(object)};
            } else {
                logger.info("m11Value() - invalid type {} for {}", object.getClass(), (Object)objectId);
            }
        }
        catch (Exception exception) {
            logger.warn("m11Value() Error getting the m11 values for {}", (Object)objectId);
        }
        logger.debug("m11Value() - returns {} for {}", objectArray, (Object)objectId);
        return objectArray;
    }

    private void addShutdownDurationsWithWait(Map<String, Object> map) {
        logger.debug("addShutdownDurationsWithWait() - start");
        Integer n = null;
        GetResult getResult = null;
        int n2 = 0;
        do {
            ++n2;
            try {
                Integer[] integerArray;
                getResult = this.dataSource.get(RuntimeVerificationGroup.TotalShutdownDurations.getObjectId());
                if (getResult == null || getResult.getValue() == null) {
                    logger.info("addShutdownDurationsWithWait() - Total Shutdown Durations not available yet.  Waiting.");
                    integerArray = new CountdownTimer(this.runtimeVerifierWait, TimeUnit.SECONDS);
                    integerArray.sleep();
                    continue;
                }
                if (getResult.getValue() instanceof Integer[]) {
                    integerArray = (Integer[])getResult.getValue();
                    n = Collections.max(Arrays.asList(integerArray));
                    continue;
                }
                logger.info("addShutdownDurationsWithWait() - invalid type ({}) returned for Shutdown Duration.", getResult.getValue().getClass());
            }
            catch (CommunicationException | InvalidObjectIdException throwable) {
                logger.info("addShutdownDurationsWithWait() - unable to get TotalShutdownDurations yet. ", throwable);
            }
        } while (n == null && n2 < 4);
        if (n != null) {
            logger.debug("addShutdownDurationsWithWait() - adding shutdown duration {}", n);
            map.put("Shutdown_duration", n);
        }
    }

    private Integer dateToInteger(Object object) {
        if (object instanceof Date) {
            ZonedDateTime zonedDateTime = ((Date)object).toInstant().atZone(ZoneId.systemDefault());
            String string = zonedDateTime.format(this.intDateFormatter);
            return Integer.valueOf(string);
        }
        return 0;
    }

    protected Integer minYearInDateArray(@NonNull Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("in is marked non-null but is null");
        }
        Integer n = null;
        for (Object object : objectArray) {
            if (!(object instanceof Integer)) continue;
            try {
                LocalDate localDate = LocalDate.parse(object.toString(), this.intDateFormatter);
                Integer n2 = localDate.getYear();
                if (n != null && n2 >= n) continue;
                n = n2;
            }
            catch (DateTimeParseException dateTimeParseException) {
                logger.warn("minYearInDateArray() - ingnoring invalid date {}", object);
            }
        }
        return n;
    }

    protected Integer maxYearInDateArray(@NonNull Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("in is marked non-null but is null");
        }
        Integer n = null;
        for (Object object : objectArray) {
            if (!(object instanceof Integer)) continue;
            try {
                LocalDate localDate = LocalDate.parse(object.toString(), this.intDateFormatter);
                Integer n2 = localDate.getYear();
                if (n != null && n2 <= n) continue;
                n = n2;
            }
            catch (DateTimeParseException dateTimeParseException) {
                logger.warn("maxYearInDateArray() - ingnoring invalid date {}", object);
            }
        }
        return n;
    }

    protected Integer[] dateToIntegerArray(@NonNull Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("in is marked non-null but is null");
        }
        Integer[] integerArray = new Integer[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                logger.debug("dateToIntegerArray() - Invalid input null");
                integerArray[i] = 0;
                continue;
            }
            if (objectArray[i] instanceof Integer) {
                integerArray[i] = (Integer)objectArray[i];
                continue;
            }
            if (objectArray[i] instanceof String) {
                integerArray[i] = this.dateStringToInteger((String)objectArray[i]);
                continue;
            }
            logger.warn("dateToIntegerArray() - Invalid input type:{}", objectArray[i].getClass());
            integerArray[i] = 0;
        }
        return integerArray;
    }

    private Integer dateStringToInteger(String string) {
        Integer n = 0;
        TemporalAccessor temporalAccessor = null;
        try {
            temporalAccessor = this.longYearDateFormatter.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            logger.trace("dateToIntegerArray() - not the first date type, try the second");
        }
        if (temporalAccessor == null) {
            try {
                temporalAccessor = this.shortYearDateFormatter.parse(string);
            }
            catch (DateTimeParseException dateTimeParseException) {
                logger.warn("dateToIntegerArray() - Invalid date format:{}", (Object)string);
            }
        }
        if (temporalAccessor != null) {
            String string2 = this.intDateFormatter.format(temporalAccessor);
            n = Integer.valueOf(string2);
        }
        return n;
    }

    @Generated
    public void setDataSource(IDataSource iDataSource) {
        this.dataSource = iDataSource;
    }

    @Generated
    public void setRuntimeVerifierWait(long l) {
        this.runtimeVerifierWait = l;
    }
}

