/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.analytics;

import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.analytics.AnalyseConfiguration;
import com.apcc.pcns.analytics.AnalyseUPSs;
import com.apcc.pcns.analytics.CountlyManager;
import com.apcc.pcns.configservice.ProductVersion;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.serviceaware.InitializationAdapter;
import com.apcc.pcns.threadpool.ThreadService;
import com.apcc.pcns.util.CountdownTimer;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalyticsService
extends InitializationAdapter
implements Runnable {
    private static final Logger logger = LogManager.getLogger(AnalyticsService.class);
    private ScheduledFuture<?> heartBeatFuture;
    private ThreadService threadService;
    @NonNull
    private ConfigurationManager config;
    @NonNull
    private ProductVersion productVersion;
    protected IDataSource dataSource = null;
    protected ServiceManager services;
    private AnalyseConfiguration analyseConfiguration;
    private AnalyseUPSs analyseUPSs;
    protected String applicationKey;
    private String applicationSalt;
    protected String applicationURL = "https://schneider.count.ly/";
    private Integer start = 1;
    private Long heartbeatInterval = TimeUnit.MINUTES.convert(7L, TimeUnit.DAYS);
    public static final String FEATURETAGS = "features";
    public static final String SHUTDOWN_EVENTS = "Shutdown_events";
    public static final String SHUTDOWN_EVENT_DELAY = "Shutdown_event_delay";
    public static final String COMMAND_FILE_EVENTS = "Cmd_events";
    public static final String SSH_ACTION_TAG = "sshAction_";
    public static final String LOSTCOMMS_TRAP = "LostComms_Trap";
    public static final String CRITICALEVENT_TRAP = "CriticalEvent_Trap";
    public static final String UPS_LOW_BATTERY_DURATION = "UPS_low_batt";
    public static final String UPS_RUNTIME_REMAINING = "UPS_runtime";
    public static final String UPS_MANUFACTURE_DATE = "UPS_manuf_date";
    public static final String UPS_MANUFACTURE_YEAR_MIN = "UPS_manuf_year_min";
    public static final String UPS_MANUFACTURE_YEAR_MAX = "UPS_manuf_year_max";
    public static final String UPS_BATTERY_REPLACEMENT_DATE = "UPS_batt_rep_date";
    public static final String UPS_BATTERY_REPLACEMENT_YEAR_MIN = "UPS_batt_rep_year_min";
    public static final String UPS_BATTERY_REPLACEMENT_YEAR_MAX = "UPS_batt_rep_year_max";
    public static final String UPS_FW = "UPS_FW";
    public static final String UPS_MODEL = "UPS_Model";
    public static final String NMC_SKU = "NMC_SKU";
    public static final String NMC_FW = "NMC_FW";
    public static final String UPS_SKU = "UPS_SKU";
    public static final String MAX_SHUTDOWN_DURATION = "Shutdown_duration";
    public static final String SNMP_TRAP_RECEIVERS = "SNMPTrapReceivers";
    public static final String HCI_VERSION = "hci_version";
    public static final String HCI_VERSION_VSAN = "vSAN";
    public static final String HCI_VERSION_AHV = "nutanixAHV";
    public static final String VIRT_VERSION = "VirtualInstall_version";
    public static final String VIRT_BUILD = "VirtualInstall_build";
    public static final String VIRT_MANAGER_VERSION = "VirtualManager_version";
    public static final String VIRT_MANAGER_BUILD = "VirtualManager_build";
    public static final String HYPERVISOR_NODES = "HyperVisor_nodes";
    public static final String USER_VM_COUNT = "VM_count";
    public static final String USER_VAPP_COUNT = "VApp_count";
    private CountlyManager countly = null;

    public AnalyticsService(ThreadService threadService, @NonNull ConfigurationManager configurationManager, @NonNull ProductVersion productVersion) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        if (productVersion == null) {
            throw new IllegalArgumentException("productVersion is marked non-null but is null");
        }
        logger.debug("AnalyticsService");
        this.threadService = threadService;
        this.config = configurationManager;
        this.productVersion = productVersion;
        this.applicationKey = productVersion.getCountlyApiKey();
        this.applicationSalt = productVersion.getCountlySalt();
        this.analyseConfiguration = new AnalyseConfiguration(configurationManager);
        this.analyseUPSs = new AnalyseUPSs();
        this.loadConfigfromIni();
    }

    public void setServices(ServiceManager serviceManager) {
        this.analyseConfiguration.setServices(serviceManager);
    }

    public void setDataSource(IDataSource iDataSource) {
        this.dataSource = iDataSource;
        this.analyseUPSs.setDataSource(iDataSource);
    }

    @Override
    public void start() {
        logger.info("initService() - Initialising the CEIP Service");
        this.initCountlyMannager();
        if (!this.countly.isQueueEmpty()) {
            this.countly.initCountlySDK();
        }
        if (Boolean.TRUE.equals(this.isCEIPEnabled())) {
            this.startHeartBeat();
        } else {
            logger.info("initService() - CEIP is not enabled.");
        }
    }

    protected void startHeartBeat() {
        logger.debug("startHeartBeat");
        if (this.threadService != null) {
            logger.info("Starting CEIP service URL:{} start delay:{} minutes, repeat Interval:{} minutes", (Object)this.applicationURL, (Object)this.start, (Object)this.heartbeatInterval);
            if (this.heartBeatFuture != null && !this.heartBeatFuture.isCancelled()) {
                this.heartBeatFuture.cancel(false);
            }
            this.heartBeatFuture = this.threadService.scheduleAtFixedRate(this, this.start.intValue(), this.heartbeatInterval, TimeUnit.MINUTES);
        } else {
            logger.debug("threadService not set");
        }
    }

    protected void stopHeartBeat() {
        logger.debug("stopHeartBeat");
        if (this.heartBeatFuture != null) {
            this.heartBeatFuture.cancel(false);
        }
    }

    private void loadConfigfromIni() {
        String string;
        String string2 = this.config.getString("CustomerExperienceImprovement", "CEIPKey");
        if (!StringUtils.isBlank((CharSequence)string2)) {
            this.applicationKey = string2;
            logger.info("loadConfigfromIni() - using a value for {} from ini file", (Object)"CEIPKey");
        }
        if (!StringUtils.isBlank((CharSequence)(string = this.config.getString("CustomerExperienceImprovement", "CEIPURL")))) {
            this.applicationURL = string;
            logger.info("loadConfigfromIni() - using value {}={} from ini file", (Object)"CEIPURL", (Object)string2);
        }
        try {
            this.start = this.config.getInt("CustomerExperienceImprovement", "CEIPStartDelay");
            logger.info("loadConfigfromIni() - using value {}={} from ini file", (Object)"CEIPStartDelay", (Object)this.start);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace("using default start delay");
        }
        try {
            this.heartbeatInterval = this.config.getInt("CustomerExperienceImprovement", "CEIPRepeatInterval").longValue();
            logger.info("loadConfigfromIni() - using value {}={} from ini file", (Object)"CEIPRepeatInterval", (Object)this.heartbeatInterval);
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.trace("using default repeat");
        }
    }

    @Override
    public void run() {
        try {
            logger.debug("run() - start ");
            if (!Boolean.TRUE.equals(this.isCEIPEnabled())) {
                logger.info("CEIP is disabled.  Not running heartbeat.");
                return;
            }
            String string = this.getServerID();
            logger.info("Running CEIP heartbeat Server ID:{}  URL:{} ", (Object)string, (Object)this.applicationURL);
            this.initCountlyMannager();
            this.countly.startSession();
            this.countly.updateUser(this.getCustomProperties());
            this.countly.sendHeartbeat(this.heartbeatInterval);
            this.countly.endSession();
            HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            this.analyseUPSs.doUpdateUPSDetails(hashMap, hashMap2, this.heartbeatInterval, 60);
            if (!hashMap.isEmpty() || !hashMap2.isEmpty()) {
                this.countly.startSession();
                this.countly.updateUPSInfo(hashMap, hashMap2);
                this.countly.endSession();
            }
        }
        catch (Exception exception) {
            logger.info("Unable to send Analytics at this stage.  Will try again later, PCNS will still function correctly ", (Throwable)exception);
        }
        logger.debug("run() - end");
    }

    protected CountlyManager createCountlyManager() {
        return new CountlyManager();
    }

    private void initCountlyMannager() {
        if (this.countly != null) {
            logger.debug("initCountly()  Countly already Initialised");
            return;
        }
        logger.debug("initCountly() - Create a new countly manager");
        this.countly = this.createCountlyManager();
        logger.debug("initCountly() - applicationKey:{}", (Object)this.applicationKey);
        this.countly.setApplicationKey(this.applicationKey);
        logger.debug("initCountly() - ApplicationURL:{}", (Object)this.getApplicationURL());
        this.countly.setApplicationSalt(this.applicationSalt);
        this.countly.setApplicationURL(this.getApplicationURL());
        String string = this.getServerID();
        logger.debug("initCountly() - serverID:{}", (Object)string);
        this.countly.setPowerchuteServerID(string);
        logger.debug("initCountly() - PowerchuteVersion:{}", (Object)this.productVersion.getVersion());
        this.countly.setPowerchuteVersion(this.productVersion.getVersion());
        this.countly.setHasConsent(this.isCEIPEnabled());
    }

    public void stop() {
        logger.debug("run() - end");
        if (this.heartBeatFuture != null) {
            this.heartBeatFuture.cancel(false);
        }
    }

    public Boolean isCEIPEnabled() {
        Boolean bl = null;
        try {
            bl = this.config.getBoolean("CustomerExperienceImprovement", "CEIPEnabled");
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.debug("CEIP enabled not set in ini yet.");
        }
        logger.debug("isCEIPEnabled()={}", (Object)bl);
        return bl;
    }

    public void doCEIPConsent(boolean bl) {
        Boolean bl2 = this.isCEIPEnabled();
        if (bl2 != null && bl2.equals(bl)) {
            logger.debug("setCEIPEnabled({}) : no change", (Object)bl);
            return;
        }
        this.initCountlyMannager();
        logger.info("doCEIPConsent() - Change the CEIP Enabled to: {}", (Object)bl);
        this.countly.startSession();
        this.countly.updateConsent(bl);
        this.countly.endSession();
        logger.debug("setCEIPEnabled(): Update the consent in the ini file.");
        this.config.setProperty("CustomerExperienceImprovement", "CEIPEnabled", bl);
        if (!bl && Boolean.TRUE.equals(bl2)) {
            this.stopHeartBeat();
        }
        if (bl) {
            this.startHeartBeat();
        }
    }

    public void doTrialLicenseActivated() {
        logger.debug("doTrialLicenseActivated() - start");
        this.initCountlyMannager();
        this.countly.startSession();
        logger.info("doTrialLicenseActivated() - Send CEIP TrialLicenseActivated");
        this.countly.sendTrialLicenseActivated(true);
        this.countly.endSession();
    }

    public void doTrialLicenseExpired() {
        logger.debug("doTrialLicenseExpired() - start");
        this.initCountlyMannager();
        this.countly.startSession();
        logger.info("doTrialLicenseExpired() - Send CEIP doTrialLicenseExpired");
        this.countly.sendTrialLicenseExpired(true);
        this.countly.endSession();
    }

    public void doSubscriptionLicenseActivatedNoPreviousTrial() {
        logger.debug("doSubscriptionLicenseActivatedNoPreviousTrial() - start");
        this.initCountlyMannager();
        this.countly.startSession();
        logger.info("doSubscriptionLicenseActivatedNoPreviousTrial() - Send CEIP doSubscriptionLicenseActivatedNoPreviousTrial");
        this.countly.sendSubscriptionLicenseActivatedNoPreviousTrial(true);
        this.countly.endSession();
    }

    public void doSubscriptionLicenseActivatedPreviousTrialActivated() {
        logger.debug("doSubscriptionLicenseActivatedPreviousTrialActivated() - start");
        this.initCountlyMannager();
        this.countly.startSession();
        logger.info("doSubscriptionLicenseActivatedPreviousTrialActivated() - Send CEIP doSubscriptionLicenseActivatedPreviousTrialActivated");
        this.countly.sendSubscriptionLicenseActivatedPreviousTrialActivated(true);
        this.countly.endSession();
    }

    public void doRenewalSubscriptionLicenseActivated() {
        logger.debug("doRenewalSubscriptionLicenseActivated() - start");
        this.initCountlyMannager();
        this.countly.startSession();
        logger.info("doRenewalSubscriptionLicenseActivated() - Send CEIP doRenewalSubscriptionLicenseActivated");
        this.countly.sendRenewalSubscriptionLicenseActivated(true);
        this.countly.endSession();
    }

    public void doSilentInstall() {
        logger.debug("doSilentInstall() - start");
        this.initCountlyMannager();
        this.countly.startSession();
        logger.info("doSilentInstall() - Send CEIP SilentInstall");
        this.countly.sendInstall(true);
        this.countly.endSession();
    }

    public void doAsyncUpdateUser() {
        logger.debug("doAsyncUpdateUser() - start");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AnalyticsService.this.doUpdateUser();
            }
        };
        this.threadService.schedule(runnable, this.start, TimeUnit.MINUTES);
    }

    public void doUpdateUser() {
        logger.debug("doUpdateUser() - start");
        this.initCountlyMannager();
        this.countly.startSession();
        logger.debug("Update the users properties on countly");
        this.countly.updateUser(this.getCustomProperties());
        this.countly.endSession();
    }

    private Map<String, Object> getCustomProperties() {
        logger.debug("getCustomProperties() - start");
        Map<String, Object> map = this.analyseConfiguration.getCustomProperties();
        map.put("PCNSBuildTag", this.productVersion.getBuildTag());
        map.put("hasConsented", this.isCEIPEnabled());
        logger.info("getCustomProperties() - CEIP Properties are: {}", map);
        return map;
    }

    public void waitForCountlyToComplete(int n) {
        logger.debug("waitForCountlyToComplete({}) - start", (Object)n);
        if (this.countly != null) {
            this.countly.waitForQueueEmpty(n);
        }
        logger.debug("waitForCountlyToComplete() - done");
    }

    private String getServerID() {
        String string = this.productVersion.getServerID();
        while (StringUtils.isBlank((CharSequence)string)) {
            CountdownTimer countdownTimer = new CountdownTimer(500L, TimeUnit.MILLISECONDS);
            countdownTimer.sleep();
            string = this.productVersion.getServerID();
        }
        logger.debug("getServerID() - returns {}", (Object)string);
        return string;
    }

    @Generated
    public void setAnalyseUPSs(AnalyseUPSs analyseUPSs) {
        this.analyseUPSs = analyseUPSs;
    }

    @Generated
    public String getApplicationKey() {
        return this.applicationKey;
    }

    @Generated
    public String getApplicationSalt() {
        return this.applicationSalt;
    }

    @Generated
    public String getApplicationURL() {
        return this.applicationURL;
    }
}

