/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.analytics;

import com.apcc.pcns.analytics.CountlyLogAdapter;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import ly.count.sdk.java.Config;
import ly.count.sdk.java.Countly;
import ly.count.sdk.java.Event;
import ly.count.sdk.java.Session;
import ly.count.sdk.java.UserEditor;
import ly.count.sdk.java.internal.LogCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CountlyManager {
    protected static final String PCNS_COUNTRY = "PCNSCountry";
    private static final Logger logger = LogManager.getLogger(CountlyManager.class);
    private final String sessionDir;
    private static final String TRIAL_LICENSE_EXPIRED = "TrialLicenseExpired";
    private static final String TRIAL_LICENSE_ACTIVATION = "TrialLicenseActivation";
    private static final String SUBSCRIPTION_LICENSE_ACTIVATED_NO_PREVIOUS_TRIAL = "SubscriptionLicenseActivatedNoPreviousTrial";
    private static final String SUBSCRIPTION_LICENSE_ACTIVATED_PREVIOUS_TRIAL_ACTIVATED = "SubscriptionLicenseActivatedPreviousTrialActivated";
    private static final String RENEWAL_SUBSCRIPTION_LICENSE_ACTIVATED = "RenewalSubscriptionLicenseActivated";
    @NonNull
    private String powerchuteServerID;
    @NonNull
    private String powerchuteVersion;
    private String applicationKey;
    private String applicationSalt;
    private String applicationURL;
    protected Boolean hasConsent = null;
    private Integer iteration = 0;

    public CountlyManager() {
        String string = System.getProperty("user.dir");
        string = string.replace("\"", "");
        this.sessionDir = string + File.separatorChar + "session";
    }

    public void initCountlySDK() {
        if (!this.isCountlyInit()) {
            logger.debug("Countly needs initializing");
            Config config = new Config(this.applicationURL, this.applicationKey).setSendUpdateEachSeconds((int)TimeUnit.SECONDS.convert(4L, TimeUnit.HOURS)).setLoggingLevel(Config.LoggingLevel.ERROR).enableFeatures(new Config.Feature[]{Config.Feature.Events, Config.Feature.Sessions, Config.Feature.UserProfiles, Config.Feature.Location}).setLogListener((LogCallback)new CountlyLogAdapter()).setCustomDeviceId(this.powerchuteServerID).enableParameterTamperingProtection(this.applicationSalt);
            config.setApplicationVersion(this.powerchuteVersion);
            config.setRequiresConsent(false);
            File file = new File(this.sessionDir);
            boolean bl = file.mkdirs();
            logger.debug("made directories: {}", (Object)bl);
            this.countlyInit(file, config);
            logger.debug("Countly initialised");
            logger.debug("Countly sessionStatus:  {}", (Object)Countly.session().isActive());
        } else {
            logger.debug("Countly already initialised");
        }
    }

    public void startSession() {
        logger.debug("startSession()");
        if (Boolean.FALSE.equals(this.hasConsent)) {
            logger.debug("User has opted out");
            return;
        }
        this.initCountlySDK();
        logger.debug("start the session");
        Session session = this.getCountlySession();
        this.beginSession(session);
        logger.debug("Countly sessionStatus:  {}", (Object)Countly.session().isActive());
        logger.debug("startSession()");
    }

    public void updateUser(Map<String, Object> map) {
        logger.debug("updateUser() - start {}", map);
        if (Boolean.FALSE.equals(this.hasConsent)) {
            logger.info("updateUser() - User has opted out");
            return;
        }
        if (this.isCountlyInit()) {
            Session session = this.getCountlySession();
            this.beginSession(session);
            UserEditor userEditor = session.user().edit();
            Locale locale = Locale.getDefault();
            String string2 = locale.getCountry();
            logger.debug("updateUser() - set the country- locale:{}  Country:{}", (Object)locale, (Object)locale.getCountry());
            userEditor.set(PCNS_COUNTRY, (Object)string2);
            if (map != null) {
                map.forEach((string, object) -> userEditor.set(string, object));
            } else {
                logger.warn("updateUser() - received null customProperties.  This shouldnt happen");
            }
            userEditor.commit();
            session.update();
            logger.info("updateUser() - Update the CEIP information on the user {} County:{} Properties:{}", (Object)this.powerchuteServerID, (Object)string2, map);
        } else {
            logger.info("updateUser() - Countly not initialised");
        }
        logger.debug("updateUser() - done");
    }

    public void updateUPSInfo(@NonNull Map<String, Object[]> map, @NonNull Map<String, Object> map2) {
        if (map == null) {
            throw new IllegalArgumentException("upsPropertiesArray is marked non-null but is null");
        }
        if (map2 == null) {
            throw new IllegalArgumentException("upsProperties is marked non-null but is null");
        }
        logger.debug("updateUPSInfo() - start {},{}", map, map2);
        if (Boolean.FALSE.equals(this.hasConsent)) {
            logger.info("updateUPSInfo() - User has opted out");
            return;
        }
        if (this.isCountlyInit()) {
            Session session = this.getCountlySession();
            this.beginSession(session);
            UserEditor userEditor = session.user().edit();
            map.forEach((arg_0, arg_1) -> ((UserEditor)userEditor).set(arg_0, arg_1));
            map2.forEach((arg_0, arg_1) -> ((UserEditor)userEditor).set(arg_0, arg_1));
            userEditor.commit();
            session.update();
            logger.info("updateUPSInfo() Updated the CEIP information on the UPSs for user {}: {}", (Object)this.powerchuteServerID, map);
        } else {
            logger.info("updateUPSInfo() - Countly not initialised");
        }
        logger.debug("updateUPSInfo() - done");
    }

    public void sendHeartbeat(Long l) {
        logger.debug("sendHeartbeat() - start");
        Session session = this.getCountlySession();
        this.iteration = this.iteration + 1;
        session.event("heartBeat").addSegment("BeatsSinceRestart", this.iteration.toString()).addSegment("Interval", l.toString()).record();
        logger.info("Sending heartBeat event for {} iteration:{}  interval:{}", (Object)this.powerchuteServerID, (Object)this.iteration, (Object)l);
        session.update();
        logger.debug("sendHeartbeat() - end");
    }

    public void sendInstall(boolean bl) {
        logger.debug("sendSilentInstall() - start silent:{}", (Object)bl);
        if (Boolean.FALSE.equals(this.hasConsent)) {
            logger.debug("User has opted out");
            return;
        }
        Session session = this.getCountlySession();
        Event event = session.event("Install");
        event.addSegment("PCNSVersion", this.powerchuteVersion);
        event.addSegment("SilentInstall", Boolean.toString(bl));
        event.record();
        logger.info("Sending silentInstall Event: PCNSVersion:{} ", (Object)this.powerchuteVersion);
        session.update();
        logger.debug("sendSilentInstall() - end");
    }

    public void sendTrialLicenseActivated(boolean bl) {
        logger.debug("sendTrialLicenseActivated() - start trialLicense:{}", (Object)bl);
        if (Boolean.FALSE.equals(this.hasConsent)) {
            logger.debug("User has opted out");
            return;
        }
        Session session = this.getCountlySession();
        Event event = session.event(TRIAL_LICENSE_ACTIVATION);
        event.addSegment("PCNSVersion", this.powerchuteVersion);
        event.addSegment("TrialLicenseActivated", Boolean.toString(bl));
        event.record();
        logger.info("Sending TrialLicenseActivated Event: PCNSVersion:{} ", (Object)this.powerchuteVersion);
        session.update();
        logger.debug("sendTrialLicenseActivated() - end");
    }

    public void sendTrialLicenseExpired(boolean bl) {
        logger.debug("sendTrialLicenseExpired() - start trialLicense:{}", (Object)bl);
        if (Boolean.FALSE.equals(this.hasConsent)) {
            logger.debug("User has opted out");
            return;
        }
        Session session = this.getCountlySession();
        Event event = session.event(TRIAL_LICENSE_EXPIRED);
        event.addSegment("PCNSVersion", this.powerchuteVersion);
        event.addSegment(TRIAL_LICENSE_EXPIRED, Boolean.toString(bl));
        event.record();
        logger.info("Sending TrialLicenseExpired Event: PCNSVersion:{} ", (Object)this.powerchuteVersion);
        session.update();
        logger.debug("sendTrialLicenseExpired() - end");
    }

    public void sendSubscriptionLicenseActivatedNoPreviousTrial(boolean bl) {
        logger.debug("sendSubscriptionLicenseActivated() - start subscriptionLicense:{}", (Object)bl);
        if (Boolean.FALSE.equals(this.hasConsent)) {
            logger.debug("User has opted out");
            return;
        }
        Session session = this.getCountlySession();
        Event event = session.event(SUBSCRIPTION_LICENSE_ACTIVATED_NO_PREVIOUS_TRIAL);
        event.addSegment("PCNSVersion", this.powerchuteVersion);
        event.addSegment(SUBSCRIPTION_LICENSE_ACTIVATED_NO_PREVIOUS_TRIAL, Boolean.toString(bl));
        event.record();
        logger.info("Sending SubscriptionLicenseActivated Event: PCNSVersion:{} ", (Object)this.powerchuteVersion);
        session.update();
        logger.debug("sendSubscriptionLicenseActivated() - end");
    }

    public void sendSubscriptionLicenseActivatedPreviousTrialActivated(boolean bl) {
        logger.debug("sendSubscriptionLicenseActivatedPreviousTrialActivated() - start subscriptionLicense:{}", (Object)bl);
        if (Boolean.FALSE.equals(this.hasConsent)) {
            logger.debug("User has opted out");
            return;
        }
        Session session = this.getCountlySession();
        Event event = session.event(SUBSCRIPTION_LICENSE_ACTIVATED_PREVIOUS_TRIAL_ACTIVATED);
        event.addSegment("PCNSVersion", this.powerchuteVersion);
        event.addSegment(SUBSCRIPTION_LICENSE_ACTIVATED_PREVIOUS_TRIAL_ACTIVATED, Boolean.toString(bl));
        event.record();
        logger.info("Sending SubscriptionLicenseActivated Event: PCNSVersion:{} ", (Object)this.powerchuteVersion);
        session.update();
        logger.debug("sendSubscriptionLicenseActivatedPreviousTrialActivated() - end");
    }

    public void sendRenewalSubscriptionLicenseActivated(boolean bl) {
        logger.debug("sendRenewalSubscriptionLicenseActivated() - start subscriptionLicense:{}", (Object)bl);
        if (Boolean.FALSE.equals(this.hasConsent)) {
            logger.debug("User has opted out");
            return;
        }
        Session session = this.getCountlySession();
        Event event = session.event(RENEWAL_SUBSCRIPTION_LICENSE_ACTIVATED);
        event.addSegment("PCNSVersion", this.powerchuteVersion);
        event.addSegment(RENEWAL_SUBSCRIPTION_LICENSE_ACTIVATED, Boolean.toString(bl));
        event.record();
        logger.info("Sending RenewalSubscriptionLicenseActivated Event: PCNSVersion:{} ", (Object)this.powerchuteVersion);
        session.update();
        logger.debug("sendRenewalSubscriptionLicenseActivated() - end");
    }

    public void endSession() {
        Session session;
        logger.debug("endSession() - start");
        if (this.isCountlyInit() && (session = this.getCountlySession()).isActive()) {
            session.update();
            session.end();
            session.getEnded();
        }
        logger.debug("endSession() - end");
    }

    public void updateConsent(boolean bl) {
        logger.debug("updateConsent({})", (Object)bl);
        if (this.hasConsent != null && this.hasConsent.equals(bl)) {
            logger.warn("updateConsent() Consent already set to {} ", (Object)bl);
        } else {
            Boolean bl2 = this.hasConsent;
            this.hasConsent = bl;
            if (Boolean.FALSE.equals(bl2)) {
                this.startSession();
            }
            Session session = this.getCountlySession();
            UserEditor userEditor = session.user().edit();
            Locale locale = Locale.getDefault();
            logger.debug("updateConsent set county: {}  Country:{}", (Object)locale, (Object)locale.getCountry());
            userEditor.set(PCNS_COUNTRY, (Object)Locale.getDefault().getCountry());
            userEditor.set("hasConsented", (Object)bl);
            session.event("setConsent").addSegment("Opt-In", Boolean.toString(bl)).record();
            userEditor.commit();
            session.update();
        }
    }

    protected boolean isCountlyInit() {
        return Countly.isInitialized();
    }

    protected void countlyInit(File file, Config config) {
        Countly.init((File)file, (Config)config);
    }

    protected Session getCountlySession() {
        return Countly.session();
    }

    public boolean waitForQueueEmpty(int n) {
        logger.debug("waitForQueueEmpty() - start {}", (Object)n);
        for (int i = 0; i < n; ++i) {
            if (this.isQueueEmpty()) {
                logger.debug("waitForQueueEmpty() - empty");
                return true;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                logger.debug("waitForQueueEmpty() - sleep interupted is ok.");
                Thread.currentThread().interrupt();
            }
        }
        logger.debug("waitForQueueEmpty() - giving up");
        return false;
    }

    public boolean isQueueEmpty() {
        logger.trace("isQueueEmpty() - start");
        File file2 = new File(this.sessionDir);
        Object[] objectArray = file2.listFiles((file, string) -> string.matches("\\[CLY\\]_request.*"));
        if (objectArray == null || objectArray.length == 0) {
            logger.trace("isQueueEmpty() - true");
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("isQueueEmpty() - false {}", (Object)Arrays.toString(objectArray));
        }
        return false;
    }

    private void beginSession(Session session) {
        if (!session.isActive()) {
            logger.debug("beginSession() - starting the session");
            if (session.begin() == null) {
                logger.info("beginSession() - unable to start countly session");
            }
        }
    }

    @Generated
    public void setPowerchuteServerID(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("powerchuteServerID is marked non-null but is null");
        }
        this.powerchuteServerID = string;
    }

    @Generated
    public void setPowerchuteVersion(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("powerchuteVersion is marked non-null but is null");
        }
        this.powerchuteVersion = string;
    }

    @Generated
    public void setApplicationKey(String string) {
        this.applicationKey = string;
    }

    @Generated
    public void setApplicationSalt(String string) {
        this.applicationSalt = string;
    }

    @Generated
    public void setApplicationURL(String string) {
        this.applicationURL = string;
    }

    @Generated
    public void setHasConsent(Boolean bl) {
        this.hasConsent = bl;
    }
}

