/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice;

import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.components.autoupdate.AutoUpdateComponent;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.pcns.configservice.TrafficLightColours;
import com.apcc.pcns.configservice.validation.ValidationSettings;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import lombok.NonNull;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuthHelper {
    private static final Logger logger = LogManager.getLogger(AuthHelper.class);
    private IPermanentStorage aPermanentStorage;
    private ValidationSettings encryptor;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private AtomicBoolean credentialsSet = new AtomicBoolean(false);

    public boolean hasCredentials() {
        if (!this.credentialsSet.get()) {
            this.credentialsSet.set(StringUtils.isNotBlank((CharSequence)this.getPowerChuteUsername()));
        }
        return this.credentialsSet.get();
    }

    public void setNutanixAuthDetails(String string, String string2, String string3) {
        this.verifyReady();
        logger.debug("setNutanixAuthDetails() - start");
        String string4 = this.getNutanixClusterPassword();
        String string5 = this.getNutanixHostPassword();
        String string6 = this.getNutanixSshKeyPassphrase();
        try {
            String string7;
            if (StringUtils.isNotBlank((CharSequence)string) && !string.equals(string4)) {
                string7 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "NutanixClusterSerialNumber", string7);
            } else if (StringUtils.isBlank((CharSequence)string)) {
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "NutanixClusterSerialNumber", "");
            }
            if (StringUtils.isNotBlank((CharSequence)string2) && !string2.equals(string5)) {
                string7 = this.encryptor.encrypt(string2);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "NutanixHostSerialNumber", string7);
            } else if (StringUtils.isBlank((CharSequence)string2)) {
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "NutanixHostSerialNumber", "");
            }
            if (StringUtils.isNotBlank((CharSequence)string3) && !string3.equals(string6)) {
                string7 = this.encryptor.encrypt(string3);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "NutanixKeySerialNumber", string7);
            } else if (StringUtils.isBlank((CharSequence)string3)) {
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "NutanixKeySerialNumber", "");
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setNutanixAuthDetails: {}", (Throwable)storageEntryException);
        }
        logger.debug("setNutanixAuthDetails() - end");
    }

    public String getNutanixClusterPassword() {
        logger.debug("getNutanixClusterPassword() - start");
        String string = "";
        this.verifyReady();
        try {
            Object object = this.readFromM11(PowerSourceComponent.kSharedComponentId, "NutanixClusterSerialNumber");
            if (object instanceof String && !StringUtils.isBlank((CharSequence)((String)object))) {
                string = this.encryptor.decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.debug("getNutanixPassword: ", (Throwable)storageEntryException);
        }
        logger.debug("getNutanixClusterPassword() - end, Password found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public String getNutanixHostPassword() {
        String string = "";
        this.verifyReady();
        try {
            Object object = this.readFromM11(PowerSourceComponent.kSharedComponentId, "NutanixHostSerialNumber");
            if (object instanceof String && !StringUtils.isBlank((CharSequence)((String)object))) {
                string = this.encryptor.decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.debug("getNutanixHostPassword() - Failed to find the Nutanix Host Password: ", (Throwable)storageEntryException);
        }
        logger.debug("getNutanixHostPassword() - end, Password found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public String getNutanixSshKeyPassphrase() {
        String string = "";
        this.verifyReady();
        try {
            Object object = this.readFromM11(PowerSourceComponent.kSharedComponentId, "NutanixKeySerialNumber");
            if (object instanceof String && !StringUtils.isBlank((CharSequence)((String)object))) {
                string = this.encryptor.decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.debug("getNutanixSshKeyPassphrase: Failed to find Nutanix SSH Key Passphrase", (Throwable)storageEntryException);
        }
        logger.debug("getNutanixSshKeyPassphrase() - end, Password found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public String getSimplivityPassword() {
        String string = "";
        this.verifyReady();
        try {
            Object object = this.readFromM11(PowerSourceComponent.kSharedComponentId, "SimplivityClusterPassword");
            if (object instanceof String && !StringUtils.isBlank((CharSequence)((String)object))) {
                string = this.encryptor.decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.debug("getSimplivityPassword() - Failed to find Simplivity Password", (Throwable)storageEntryException);
        }
        logger.debug("getSimplivityPassword() - end, Password found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public void setPermanentStorage(@NonNull IPermanentStorage iPermanentStorage) {
        if (iPermanentStorage == null) {
            throw new IllegalArgumentException("permanentStorage is marked non-null but is null");
        }
        logger.debug("setPermanentStorage() - start");
        if (this.aPermanentStorage != null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.aPermanentStorage = iPermanentStorage;
            if (this.encryptor == null) {
                this.initializeEncryptor();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setSimplivityPassword(String string) {
        logger.debug("setSimplivityPassword() - start");
        this.verifyReady();
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        try {
            String string2 = this.getSimplivityPassword();
            if (StringUtils.isNotBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "SimplivityClusterPassword", string3);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.warn("setSimplivityPassword() - Issue setting Simplivity Cluster Password: {}", (Throwable)storageEntryException);
        }
    }

    private void initializeEncryptor() {
        logger.debug("initializeEncryptor() - start");
        String string = this.retrieveRandomNumberinM11();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.encryptor = new ValidationSettings(string);
        } else {
            logger.error("initializeEncryptor() - unable to initialise encryption");
        }
    }

    private String retrieveRandomNumberinM11() {
        logger.debug("retrieveRandomNumberinM11() - start");
        String string = null;
        try {
            if (this.aPermanentStorage != null) {
                Object object = this.readFromM11(PowerSourceComponent.kSharedComponentId, "Validation");
                if (object instanceof String && !StringUtils.isBlank((CharSequence)((String)object))) {
                    string = (String)object;
                } else {
                    logger.error("retrieveRandomNumberinM11() found a non-string");
                }
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.debug("retrieveRandomNumberinM11() - failed to find an existing value.  Will create a new one.", (Throwable)storageEntryException);
            string = this.createAndSaveNewRandomNumber();
        }
        logger.debug("retrieveRandomNumberinM11 - end");
        return string;
    }

    private String createAndSaveNewRandomNumber() {
        logger.debug("createAndSaveNewRandomNumber() - start");
        String string = this.getRandomKey();
        try {
            this.writeToM11(PowerSourceComponent.kSharedComponentId, "Validation", string);
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("createAndSaveNewRandomNumber() - Failed to save new key", (Throwable)storageEntryException);
        }
        logger.debug("createAndSaveNewRandomNumber() - New key returned: ", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public String getHyperflexPassword() {
        logger.debug("getHyperflexPassword() - start");
        String string = "";
        this.verifyReady();
        try {
            Object object = this.readFromM11(PowerSourceComponent.kSharedComponentId, "HyperflexAuthPassword");
            if (object instanceof String && !StringUtils.isBlank((CharSequence)((String)object))) {
                string = this.encryptor.decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.debug("getHyperflexPassword() - Failed to load key from storage.");
        }
        logger.debug("getHyperflexPassword() - end, Password found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public void setHyperflexPassword(String string) {
        logger.debug("setHyperflexPassword() - start");
        String string2 = this.getHyperflexPassword();
        if (StringUtils.isNotBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
            String string3 = this.encryptor.encrypt(string);
            try {
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "HyperflexAuthPassword", string3);
            }
            catch (StorageEntryException storageEntryException) {
                logger.warn("setHyperflexPassword() - Issue setting Hyperflex Cluster password: {}", (Throwable)storageEntryException);
            }
        }
        logger.debug("setHyperflexPassword() - end");
    }

    public String getEsxHostPassword() {
        logger.debug("getEsxHostPassword() - start");
        this.verifyReady();
        String string = this.decryptFromM11(PowerSourceComponent.kSharedComponentId, "ESXiHostSerialNumber");
        logger.debug("getEsxHostPassword() - end, Password found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public String getEsxHostUser() {
        logger.debug("getEsxHostUser() - start");
        this.verifyReady();
        String string = this.decryptFromM11(PowerSourceComponent.kSharedComponentId, "ESXiHostTurnOffPoint");
        logger.debug("getEsxHostUser() - end, User found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public void setEsxCredentials(String string, String string2) {
        logger.debug("setEsxCredentials() - start");
        this.setEsxHostUser(string);
        this.setEsxHostPassword(string2);
        logger.debug("setEsxCredentials() - end");
    }

    public void setEsxHostPassword(String string) {
        logger.debug("setEsxHostPassword() - start");
        this.verifyReady();
        String string2 = this.getEsxHostPassword();
        try {
            if (!StringUtils.isBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "ESXiHostSerialNumber", string3);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setEsxHostPassword() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
        logger.debug("setEsxHostPassword() - end");
    }

    public void setEsxHostUser(String string) {
        logger.debug("setEsxHostUser() - start");
        this.verifyReady();
        String string2 = this.getEsxHostUser();
        try {
            if (!StringUtils.isBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "ESXiHostTurnOffPoint", string3);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setEsxHostUser() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
        logger.debug("setEsxHostUser() - end");
    }

    public String getVCenterPassword() {
        logger.debug("getVCenterPassword() - start");
        String string = "";
        this.verifyReady();
        string = this.decryptFromM11(PowerSourceComponent.kSharedComponentId, "vCenterSerialNumber");
        string = StringUtils.defaultString((String)string);
        logger.debug("getVCenterPassword() - end, Password found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public void setVCenterPassword(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("pass is marked non-null but is null");
        }
        logger.debug("setVCenterPassword() - start");
        this.verifyReady();
        String string2 = this.getVCenterPassword();
        try {
            if (!StringUtils.isBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string, (CharSequence)string2)) {
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "vCenterSerialNumber", string3);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setVCenterPassword() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
    }

    public String getVCenterUser() {
        logger.debug("getVCenterUser() - start");
        this.verifyReady();
        String string = this.decryptFromM11(PowerSourceComponent.kSharedComponentId, "vCenterTurnOffPoint");
        string = StringUtils.defaultString((String)string);
        logger.debug("getVCenterUser() - end, User found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public void setVCenterUser(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        logger.debug("setVCenterUser() - start");
        this.verifyReady();
        String string2 = this.getVCenterUser();
        try {
            if (!StringUtils.isBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string, (CharSequence)string2)) {
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "vCenterTurnOffPoint", string3);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setVCenterUser() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
    }

    public String getProxyUsername() {
        logger.debug("getProxyUsername() - start");
        String string = "";
        this.verifyReady();
        string = this.decryptFromM11(AutoUpdateComponent.kComponentId, "UpdateFrequency");
        logger.debug("getProxyUsername() - end, User found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public void setProxyUsername(String string) {
        this.verifyReady();
        try {
            String string2 = this.getProxyUsername();
            if (StringUtils.isNotBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string, (CharSequence)string2)) {
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(AutoUpdateComponent.kComponentId, "UpdateFrequency", string3);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("getProxyUsername() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
    }

    public String getProxyPassword() {
        logger.debug("getProxyPassword() - start");
        this.verifyReady();
        String string = this.decryptFromM11(AutoUpdateComponent.kComponentId, "UpdateNumber");
        logger.debug("getProxyPassword() - end, Password found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public void setProxyPassword(String string) {
        logger.debug("setProxyPassword() - start");
        this.verifyReady();
        try {
            String string2 = this.getProxyPassword();
            if (StringUtils.isNotBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string, (CharSequence)string2)) {
                logger.debug("setProxyPassword() - Writing proxy password to storage...");
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(AutoUpdateComponent.kComponentId, "UpdateNumber", string3);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setProxyPassword() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
        logger.debug("setProxyPassword() - end");
    }

    private String decryptFromM11(@NonNull ComponentID componentID, @NonNull String string) {
        if (componentID == null) {
            throw new IllegalArgumentException("component is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        logger.debug("decryptFromM11() - start {}.{}", (Object)componentID.getID(), (Object)string);
        String string2 = null;
        try {
            Object object = this.readFromM11(componentID, string);
            if (object instanceof String && !StringUtils.isBlank((CharSequence)((String)object))) {
                string2 = this.encryptor.decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.trace("decryptFromM11() - value not found in permanent storage", (Throwable)storageEntryException);
        }
        logger.debug("decryptFromM11() - end {}.{}, Found Value: {}", (Object)componentID.getID(), (Object)string, (Object)StringUtils.isNotBlank(string2));
        return string2;
    }

    public boolean isReady() {
        return this.aPermanentStorage != null && this.encryptor != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readFromM11(@NonNull ComponentID componentID, @NonNull String string) throws StorageEntryException {
        if (componentID == null) {
            throw new IllegalArgumentException("component is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        this.lock.readLock().lock();
        logger.debug("readFromM11() - Component: {}, Key: {}", (Object)componentID.getID(), (Object)string);
        Object object = null;
        try {
            object = this.aPermanentStorage.readData(componentID, string);
        }
        finally {
            this.lock.readLock().unlock();
        }
        logger.debug("readFromM11() - Component: {}, Key: {}, Value found: {}", (Object)componentID.getID(), (Object)string, (Object)(object != null ? 1 : 0));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToM11(@NonNull ComponentID componentID, @NonNull String string, Object object) throws StorageEntryException {
        if (componentID == null) {
            throw new IllegalArgumentException("component is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        this.lock.writeLock().lock();
        logger.debug("writeToM11() - Component: {}, Key: {}", (Object)componentID.getID(), (Object)string);
        try {
            this.aPermanentStorage.writeData(componentID, string, object);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        logger.debug("writeToM11() - end. Component: {}, Key: {}", (Object)componentID.getID(), (Object)string);
    }

    private void clearValue(@NonNull ComponentID componentID, @NonNull String string) throws StorageEntryException {
        if (componentID == null) {
            throw new IllegalArgumentException("component is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        this.lock.writeLock().lock();
        logger.debug("clearValue() - Component: {}, Key: {}", (Object)componentID.getID(), (Object)string);
        try {
            this.aPermanentStorage.removeData(componentID, string);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        logger.debug("clearValue() - end. Component: {}, Key: {}", (Object)componentID.getID(), (Object)string);
    }

    public void setPowerChuteUsername(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        logger.debug("setPowerChuteUsername() - start");
        this.verifyReady();
        try {
            if (StringUtils.isNotBlank((CharSequence)string) && !string.equals(this.getPowerChuteUsername())) {
                String string2 = this.encryptor.encrypt(string);
                this.aPermanentStorage.writeData(PowerSourceComponent.kSharedComponentId, "UPSTurnOffPoint", (Object)string2);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setPowerChuteUsername() - Failed to write value to storage", (Throwable)storageEntryException);
        }
        logger.debug("setPowerChuteUsername() - end");
    }

    public String getPowerChuteUsername() {
        logger.debug("getPowerChuteUsername() - start");
        this.verifyReady();
        String string = null;
        try {
            Object object = this.aPermanentStorage.readData(PowerSourceComponent.kSharedComponentId, "UPSTurnOffPoint");
            if (object instanceof String) {
                string = this.encryptor.decrypt((String)object);
            } else {
                logger.error("getPowerChuteUsername() found a non-string");
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.warn("getPowerChuteUsername() - Failed to find the PowerChute username", (Throwable)storageEntryException);
        }
        logger.debug("getPowerChuteUsername() - Found PowerChute username: {}", (Object)StringUtils.isNotBlank(string));
        return string;
    }

    public void setPowerChutePassword(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        logger.debug("setPowerChutePassword - start");
        this.verifyReady();
        try {
            this.aPermanentStorage.writeData(PowerSourceComponent.kSharedComponentId, "PowerSourceUPSSerialNumber", (Object)this.encryptor.encrypt(string));
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setPowerChutePassword() - Failed to write value to storage.", (Throwable)storageEntryException);
        }
        logger.debug("setPowerChutePassword() - end");
    }

    public String getPowerChutePassword() {
        logger.debug("getPowerChutePassword() - start");
        this.verifyReady();
        String string = null;
        try {
            logger.debug("getPowerChutePassword() - From: {}", (Object)this.aPermanentStorage.getClass());
            Object object = this.aPermanentStorage.readData(PowerSourceComponent.kSharedComponentId, "PowerSourceUPSSerialNumber");
            if (object instanceof String) {
                string = this.encryptor.decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.warn("getPowerChutePassword() - Failed to find the PowerChute password", (Throwable)storageEntryException);
        }
        logger.debug("getPowerChutePassword() - Found PowerChute password: {}", (Object)StringUtils.isNotBlank(string));
        return string;
    }

    public void setAuthenticationPhrase(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("authPhrase is marked non-null but is null");
        }
        logger.debug("setAuthenticationPhrase() - start");
        this.verifyReady();
        try {
            if (StringUtils.isNotBlank((CharSequence)string) && !string.equals(this.getAuthenticationPhrase())) {
                String string2 = this.encryptor.encrypt(string);
                this.aPermanentStorage.writeData(PowerSourceComponent.kSharedComponentId, "PowerSourceUPSId", (Object)string2);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setAuthenticationPhrase() - Failed to write value to storage: ", (Throwable)storageEntryException);
        }
        logger.debug("setAuthenticationPhrase() - end");
    }

    public String getAuthenticationPhrase() {
        logger.debug("getAuthenticationPhrase() - start");
        this.verifyReady();
        String string = null;
        try {
            Object object = this.aPermanentStorage.readData(PowerSourceComponent.kSharedComponentId, "PowerSourceUPSId");
            if (object instanceof String) {
                string = this.encryptor.decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.warn("getAuthenticationPhrase() - Failed to find authentication phrase in secure storage.", (Throwable)storageEntryException);
        }
        logger.debug("getAuthenticationPhrase() - Found authentication phrase: {}", (Object)StringUtils.isNotBlank(string));
        return string;
    }

    public void setLicensingActivationId(String string) {
        logger.debug("setLicensingActivationId() - start");
        this.verifyReady();
        String string2 = this.getLicensingActivationId();
        try {
            if (!StringUtils.isBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
                logger.debug("setLicensingActivationId() - Activation ID Set");
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "LicensingActivationId", string3);
                logger.debug("setLicensingActivationId() - Activation ID Written to M11");
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setLicensingActivationId() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
        logger.debug("setLicensingActivationId() - end");
    }

    public void removeLicensingActivationId() {
        logger.debug("removeLicensingActivationId() - start");
        this.verifyReady();
        try {
            this.clearValue(PowerSourceComponent.kSharedComponentId, "LicensingActivationId");
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("removeLicensingActivationId() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
        logger.debug("removeLicensingActivationId() - end");
    }

    public String getLicensingActivationId() {
        logger.debug("getLicensingActivationId() - start");
        this.verifyReady();
        String string = StringUtils.defaultString((String)this.decryptFromM11(PowerSourceComponent.kSharedComponentId, "LicensingActivationId"));
        logger.debug("getLicensingActivationId() - end, ActivationId found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public void setLicensingProxyUsername(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("proxyUsername is marked non-null but is null");
        }
        logger.debug("setLicensingProxyUsername() - start");
        this.verifyReady();
        String string2 = this.getLicensingProxyUsername();
        try {
            if (StringUtils.isNotBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
                logger.debug("setLicensingProxyUsername() - Username Set");
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "LicensingProxyUsername", string3);
                logger.debug("setLicensingProxyUsername() - Username Written to M11");
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setLicensingProxyUsername() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
        logger.debug("setLicensingProxyUsername() - end");
    }

    public String getLicensingProxyUsername() {
        logger.debug("getLicensingProxyUsername() - start");
        this.verifyReady();
        String string = this.decryptFromM11(PowerSourceComponent.kSharedComponentId, "LicensingProxyUsername");
        logger.debug("getLicensingProxyUsername() - Found username: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public void removeLicensingProxyUsername() {
        logger.debug("removeLicensingProxyUsername() - start");
        this.verifyReady();
        try {
            this.clearValue(PowerSourceComponent.kSharedComponentId, "LicensingProxyUsername");
        }
        catch (StorageEntryException storageEntryException) {
            // empty catch block
        }
        logger.debug("removeLicensingProxyUsername() - end");
    }

    public void setLicensingProxyPassword(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("proxyPassword is marked non-null but is null");
        }
        logger.debug("setLicensingProxyPassword() - start");
        this.verifyReady();
        String string2 = this.getLicensingProxyPassword();
        try {
            if (StringUtils.isNotBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
                logger.debug("setLicensingProxyPassword() - Proxy Password Set");
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "LicensingProxyPassword", string3);
                logger.debug("setLicensingProxyPassword() - Proxy Password Written to M11");
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setLicensingProxyPassword() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
        logger.debug("setLicensingProxyPassword() - end");
    }

    public String getLicensingProxyPassword() {
        logger.debug("getLicensingProxyPassword() - start");
        String string = "";
        this.verifyReady();
        string = this.decryptFromM11(PowerSourceComponent.kSharedComponentId, "LicensingProxyPassword");
        logger.debug("getLicensingProxyPassword() - end, Proxy Password found");
        return string;
    }

    public boolean isLicensingProxyPasswordSet() {
        logger.debug("isLicensingProxyPasswordSet() - start");
        boolean bl = false;
        String string = this.getLicensingProxyPassword();
        bl = StringUtils.isNotBlank((CharSequence)string);
        logger.debug("isLicensingProxyPasswordSet() - end, isSet: {}", (Object)bl);
        return bl;
    }

    public void removeLicensingProxyPassword() {
        logger.debug("removeLicensingProxyPassword() - start");
        this.verifyReady();
        try {
            this.clearValue(PowerSourceComponent.kSharedComponentId, "LicensingProxyPassword");
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("removeLicensingProxyPassword() - StorageEntryException: {}", (Throwable)storageEntryException);
        }
        logger.debug("removeLicensingProxyPassword() - end");
    }

    public String getLicensingDeviceId() {
        logger.debug("getLicensingDeviceId() - start");
        this.verifyReady();
        String string = this.decryptFromM11(PowerSourceComponent.kSharedComponentId, "LicensingDeviceId");
        string = StringUtils.defaultString((String)string);
        logger.debug("getLicensingDeviceId() - end, licensing device ID found: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public void setLicensingDeviceId(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("deviceId is marked non-null but is null");
        }
        logger.debug("setLicensingDeviceId() - start");
        this.verifyReady();
        try {
            String string2 = this.getLicensingDeviceId();
            if (StringUtils.isNotBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string, (CharSequence)string2)) {
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "LicensingDeviceId", string3);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setLicensingDeviceId() - Failed to write value to storage.", (Throwable)storageEntryException);
        }
        logger.debug("setLicensingDeviceId() - end");
    }

    public boolean checkUsername(String string) {
        boolean bl = Pattern.matches("^[\\w\" \"!\"#$%&'()\\\\*+,-./:;<=>?@\\^`{|}\\[\\]~]{1,128}$", string);
        logger.debug("checkUsername() - Username matches regex: {}", (Object)bl);
        return bl;
    }

    public boolean isPasswordValid(String string) {
        boolean bl = Pattern.matches("(^\\S).{10,126}(\\S$)", string);
        boolean bl2 = StringUtils.isNotBlank((CharSequence)string);
        boolean bl3 = !string.equals(this.getPowerChutePassword());
        logger.debug("checkPassword() - isRegexCompatible: {}, isNotBlank: {}, isNotSame: {}", (Object)bl, (Object)bl2, (Object)bl3);
        return bl && bl2 && bl3;
    }

    public boolean checkAuth(String string) {
        boolean bl = Pattern.matches("^\\S.{13,30}\\S$", string);
        logger.debug("checkAuth() - Authentication phrase matches regex: {}", (Object)bl);
        return bl;
    }

    public String getSSHActionUserName(String string) {
        logger.debug("getSSHActionUserName() - start");
        this.verifyReady();
        return this.getValue(string, "ssh_user_name");
    }

    public void setSSHActionUserName(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        logger.debug("setSSHActionUserName() - start");
        this.verifyReady();
        this.setValue(string, "ssh_user_name", string2);
    }

    public String getSSHActionPassword(String string) {
        logger.debug("getSSHActionPassword() - start");
        this.verifyReady();
        return this.getValue(string, "ssh_pasword");
    }

    public void setSSHActionPassword(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        logger.debug("setSSHActionPassword() - start");
        this.verifyReady();
        this.setValue(string, "ssh_pasword", string2);
    }

    public String getSSHActionKeyfilePassword(String string) {
        logger.debug("getSSHActionKeyfilePassword() - start");
        this.verifyReady();
        return this.getValue(string, "ssh_keyfile_password");
    }

    public void setSSHActionKeyfilePassword(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        logger.debug("setSSHActionKeyfilePassword() - start");
        this.verifyReady();
        this.setValue(string, "ssh_keyfile_password", string2);
    }

    public void removeSSHActionUsername(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        logger.debug("removeSSHActionUsername() - start");
        this.verifyReady();
        try {
            this.clearValue(PowerSourceComponent.kSharedComponentId, this.makeStorageKey(string, "ssh_user_name"));
        }
        catch (StorageEntryException storageEntryException) {
            // empty catch block
        }
    }

    public void removeSSHActionPassword(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        logger.debug("removeSSHActionPassword() - start");
        this.verifyReady();
        try {
            this.clearValue(PowerSourceComponent.kSharedComponentId, this.makeStorageKey(string, "ssh_pasword"));
        }
        catch (StorageEntryException storageEntryException) {
            // empty catch block
        }
    }

    public void removeSSHActionKeyfilePassword(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        logger.debug("removeSSHActionKeyfilePassword() - start");
        this.verifyReady();
        try {
            this.clearValue(PowerSourceComponent.kSharedComponentId, this.makeStorageKey(string, "ssh_keyfile_password"));
        }
        catch (StorageEntryException storageEntryException) {
            // empty catch block
        }
    }

    public void setTrustStorePassword(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        this.setPowerChuteKeystorePassword(string);
    }

    public String getTrustStorePassword() {
        return this.getPowerChuteKeystorePassword();
    }

    public void setPowerChuteKeystorePassword(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        logger.debug("setPowerChuteKeystorePassword() - start");
        this.verifyReady();
        String string2 = this.getPowerChuteKeystorePassword();
        try {
            if (!StringUtils.isBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string, (CharSequence)string2)) {
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "PowerChuteKeystorePasswordenc", string3);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setPowerChuteKeystorePassword() - Failed to write value to storage: ", (Throwable)storageEntryException);
        }
    }

    public String getPowerChuteKeystorePassword() {
        logger.debug("getPowerChuteKeystorePassword() - start");
        this.verifyReady();
        String string = this.decryptFromM11(PowerSourceComponent.kSharedComponentId, "PowerChuteKeystorePasswordenc");
        string = StringUtils.defaultString((String)string);
        logger.debug("getPowerChuteKeystorePassword() - Found PowerChute trust store password: {}", (Object)StringUtils.isNotEmpty((CharSequence)string));
        return string;
    }

    public void setWebserverKeystorePassword(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        logger.debug("setWebserverKeystorePassword() - start");
        this.verifyReady();
        String string2 = this.getWebserverKeystorePassword();
        try {
            if (!StringUtils.isBlank((CharSequence)string) && !StringUtils.equals((CharSequence)string, (CharSequence)string2)) {
                String string3 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "KeystorePasswordenc", string3);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setWebserverKeystorePassword() - Failed to write value to storage: ", (Throwable)storageEntryException);
        }
    }

    public String getWebserverKeystorePassword() {
        logger.debug("getWebserverKeystorePassword() - start");
        this.verifyReady();
        String string = this.decryptFromM11(PowerSourceComponent.kSharedComponentId, "KeystorePasswordenc");
        string = StringUtils.defaultString((String)string);
        logger.debug("getWebserverKeystorePassword() - Found webserver keystore password: {}", (Object)StringUtils.isNotEmpty((CharSequence)string));
        return string;
    }

    public void setSNMPAuthPassphrase(int n, @NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        logger.debug("setSNMPAuthPassphrase() - Setting SNMPv3 Auth Passphrase for profile {}.", (Object)n);
        this.verifyReady();
        this.setValue("SNMP", "SNMPv3_AUTH_PASSPHRASE_Profile_" + n, string);
    }

    public String getSNMPPrivPassphrase(int n) {
        logger.debug("getSNMPPrivPassphrase() - Profile: {}", (Object)n);
        this.verifyReady();
        String string = this.getValue("SNMP", "SNMPv3_PRIV_PASSPHRASE_Profile_" + n);
        string = StringUtils.defaultString((String)string);
        logger.debug("getSNMPPrivPassphrase() - Found SNMPv3 Priv Passphrase for profile {}: {}", (Object)n, (Object)StringUtils.isNotEmpty((CharSequence)string));
        return string;
    }

    public void setSNMPPrivPassphrase(int n, @NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        logger.debug("getSNMPPrivPassphrase() - Setting SNMPv3 Priv Passphrase for profile {}.", (Object)n);
        this.verifyReady();
        this.setValue("SNMP", "SNMPv3_PRIV_PASSPHRASE_Profile_" + n, string);
    }

    public void removeSNMPPrivPassphrase(int n) {
        logger.debug("removeSNMPPrivPassphrase() - Profile: {}", (Object)n);
        this.verifyReady();
        try {
            this.clearValue(PowerSourceComponent.kSharedComponentId, this.makeStorageKey("SNMP", "SNMPv3_PRIV_PASSPHRASE_Profile_" + n));
        }
        catch (StorageEntryException storageEntryException) {
            // empty catch block
        }
    }

    public String getSNMPAuthPassphrase(int n) {
        logger.debug("getSNMPAuthPassphrase() - Profile: {}", (Object)n);
        this.verifyReady();
        String string = this.getValue("SNMP", "SNMPv3_AUTH_PASSPHRASE_Profile_" + n);
        string = StringUtils.defaultString((String)string);
        logger.debug("setSNMPAuthPassphrase() - Found SNMPv3 Auth Passphrase for profile {}: {}", (Object)n, (Object)StringUtils.isNotEmpty((CharSequence)string));
        return string;
    }

    public void removeSNMPAuthPassphrase(int n) {
        logger.debug("removeSNMPAuthPassphrase() - Profile: {}", (Object)n);
        this.verifyReady();
        try {
            this.clearValue(PowerSourceComponent.kSharedComponentId, this.makeStorageKey("SNMP", "SNMPv3_AUTH_PASSPHRASE_Profile_" + n));
        }
        catch (StorageEntryException storageEntryException) {
            // empty catch block
        }
    }

    public String getRandomKey() {
        logger.debug("getRandomKey() - start");
        String string = "";
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DES");
            keyGenerator.init(new SecureRandom());
            SecretKey secretKey = keyGenerator.generateKey();
            string = Hex.encodeHexString((byte[])secretKey.getEncoded());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error((Object)noSuchAlgorithmException);
        }
        logger.debug("getRandomKey() - end");
        return string;
    }

    private void setValue(@NonNull String string, @NonNull String string2, @NonNull String string3) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("value is marked non-null but is null");
        }
        logger.debug("setValue() - Section: {}, Key: {}", (Object)string, (Object)string2);
        this.verifyReady();
        if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2)) {
            throw new IllegalArgumentException("Can't use blank section or key values.");
        }
        String string4 = this.makeStorageKey(string, string2);
        String string5 = this.getValue(string, string2);
        try {
            if (!StringUtils.isBlank((CharSequence)string3) && !StringUtils.equals((CharSequence)string5, (CharSequence)string3)) {
                String string6 = this.encryptor.encrypt(string3);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, string4, string6);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setValue() - Failed to write value to storage: ", (Throwable)storageEntryException);
        }
    }

    private String getValue(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        logger.debug("getValue() - Section: {}, Key: {}", (Object)string, (Object)string2);
        this.verifyReady();
        String string3 = this.makeStorageKey(string, string2);
        String string4 = this.decryptFromM11(PowerSourceComponent.kSharedComponentId, string3);
        logger.debug("getValue() - end, Found value for {}_{}: {}", (Object)string, (Object)string2, (Object)StringUtils.isNotBlank((CharSequence)string4));
        return string4;
    }

    private String makeStorageKey(String string, String string2) {
        return string + "_" + string2;
    }

    private void verifyReady() {
        if (!this.isReady()) {
            logger.error("verifyReady() - permanent storage is not set");
            throw new IllegalStateException("Permanent Storage is not set");
        }
    }

    public void setSoftwareUpdateStatus(TrafficLightColours trafficLightColours) {
        String string = trafficLightColours.toString();
        logger.debug("setSoftwareUpdateStatus() - Setting status: {}", (Object)string);
        this.verifyReady();
        try {
            if (StringUtils.isNotBlank((CharSequence)string)) {
                String string2 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "SoftwareUpdateStatus", string2);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setSoftwareUpdateStatus(): Failed to write value to storage: {}", (Throwable)storageEntryException);
        }
        logger.debug("setSoftwareUpdateStatus() Set", (Object)string);
    }

    public void setSoftwareUpdateResponseText(String string) {
        logger.debug("setSoftwareUpdateResponseText() - Setting status: {}", (Object)string);
        this.verifyReady();
        try {
            if (StringUtils.isNotBlank((CharSequence)string)) {
                String string2 = this.encryptor.encrypt(string);
                this.writeToM11(PowerSourceComponent.kSharedComponentId, "SoftwareUpdateResponse", string2);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error("setSoftwareUpdateResponseText(): Failed to write value to storage: {}", (Throwable)storageEntryException);
        }
    }

    public TrafficLightColours getSoftwareUpdateStatus() {
        logger.debug("getSoftwareUpdateStatus() - start");
        String string = "";
        this.verifyReady();
        TrafficLightColours trafficLightColours = TrafficLightColours.RED;
        try {
            Object object = this.readFromM11(PowerSourceComponent.kSharedComponentId, "SoftwareUpdateStatus");
            if (object instanceof String && !StringUtils.isBlank((CharSequence)((String)object))) {
                string = this.encryptor.decrypt((String)object);
                trafficLightColours = TrafficLightColours.valueOf(string);
            }
        }
        catch (StorageEntryException storageEntryException) {
            trafficLightColours = TrafficLightColours.RED;
            logger.debug("getSoftwareUpdateStatus: ", (Throwable)storageEntryException);
        }
        logger.debug("getSoftwareUpdateStatus() - end");
        return trafficLightColours;
    }

    public String getSoftwareUpdateResponseText() {
        logger.debug("getSoftwareUpdateResponseText() - start");
        String string = null;
        this.verifyReady();
        try {
            Object object = this.readFromM11(PowerSourceComponent.kSharedComponentId, "SoftwareUpdateResponse");
            if (object instanceof String && !StringUtils.isBlank((CharSequence)((String)object))) {
                string = this.encryptor.decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.debug("SoftwareUpdateResponseText: ", (Throwable)storageEntryException);
        }
        logger.debug("getSoftwareUpdateResponseText() - end, status found: {}", (Object)StringUtils.isNotBlank(string));
        return string;
    }

    public boolean checkCredentials(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("username is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("password is marked non-null but is null");
        }
        logger.debug("checkCredentials() - start");
        this.verifyReady();
        String string3 = this.getPowerChuteUsername();
        String string4 = this.getPowerChutePassword();
        boolean bl = StringUtils.isNotEmpty((CharSequence)string3) && StringUtils.isNotEmpty((CharSequence)string4) && StringUtils.equals((CharSequence)string, (CharSequence)string3) && StringUtils.equals((CharSequence)string2, (CharSequence)string4);
        logger.debug("checkCredentials() - Candidate credentials match stored credentials: {}", (Object)bl);
        return bl;
    }
}

