/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice;

import com.apcc.m11.components.Notifier.DelayedBroadcaster;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.configservice.ProductVersion;
import com.apcc.pcns.serviceaware.InitializationAdapter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigurationStartupActions
extends InitializationAdapter {
    private static final Logger logger = LogManager.getLogger(ConfigurationStartupActions.class);
    private ProductVersion productVersion;

    public ConfigurationStartupActions(@NonNull ProductVersion productVersion) {
        if (productVersion == null) {
            throw new IllegalArgumentException("productVersion is marked non-null but is null");
        }
        logger.trace("ConfigurationService Constructor");
        this.productVersion = productVersion;
    }

    @Override
    public void start() {
        this.logApplicationStarting();
        String string = System.getProperty("iniFile", "javaVersionFile.log");
        this.checkJavaVersionFile(string);
    }

    private void logApplicationStarting() {
        logger.error("=== Starting PowerChute Network Shutdown {} Build: {} ===", (Object)this.productVersion.getVersion(), (Object)this.productVersion.getBuildTag());
        logger.info("=== Starting PowerChute Network Shutdown {} Build: {} ===", (Object)this.productVersion.getVersion(), (Object)this.productVersion.getBuildTag());
        String string = System.getProperty("os.name");
        if (Utils.isBroadcastSupported() && Locale.getDefault().getDisplayLanguage().equals(Locale.JAPANESE.getDisplayLanguage()) && !string.toLowerCase().startsWith("windows") && !string.toLowerCase().startsWith("mac")) {
            logger.error("Japanese Language Notifications not supported by this OS.  Notifications will be in English");
            DelayedBroadcaster.setLocale(Locale.ENGLISH);
        }
    }

    private void checkJavaVersionFile(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Java Virtual Machine Details \n");
        stringBuilder.append("Version : " + System.getProperty("java.version") + "\n");
        stringBuilder.append("Location : " + System.getProperty("java.home") + "\n");
        try {
            Files.write(Paths.get(string, new String[0]), stringBuilder.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            logger.info((Object)iOException);
        }
    }
}

