/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.HttpProtocol;
import com.apcc.pcns.configservice.validation.InetAddressValidator;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.configservice.validation.StringSetValidator;
import com.apcc.pcns.licensing.ActivationMethod;
import com.apcc.pcns.licensing.ILicensingConfigManager;
import java.io.File;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LicensingConfigurationManager
implements ILicensingConfigManager {
    private ConfigurationManager config;
    private static final int DEFAULT_PROXY_PORT = 80;
    private static final int DEFAULT_LLS_PORT = 443;
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private static final Logger logger = LogManager.getLogger(LicensingConfigurationManager.class);
    private static final String LICENSE_FILE_PATH = FilenameUtils.normalize((String)(System.getProperty("user.dir") + File.separator + ".." + File.separator + "user_files"));

    public LicensingConfigurationManager() {
        this(ServiceManager.getInstance().getConfigurationManager());
    }

    public LicensingConfigurationManager(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Override
    public String getLicenseFilePath() {
        return LICENSE_FILE_PATH;
    }

    @Override
    public String getProxyAddress() {
        return this.config.getString("Licensing", "licensingProxyAddress");
    }

    @Override
    public void setProxyAddress(String string) {
        this.config.setProperty("Licensing", "licensingProxyAddress", string);
    }

    @Override
    public int getProxyPort() {
        Integer n = 80;
        if (this.config.containsKey("Licensing", "licensingProxyPort")) {
            IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(80);
            intRangeSetValidator.add(0, 65535);
            n = this.config.getInt("Licensing", "licensingProxyPort", intRangeSetValidator);
        }
        return n;
    }

    @Override
    public void setProxyPort(int n) {
        this.config.setProperty("Licensing", "licensingProxyPort", n);
    }

    @Override
    public void clearProxyDetails() {
        this.config.clearProperty("Licensing", "licensingProxyAddress");
        this.config.clearProperty("Licensing", "licensingProxyPort");
    }

    @Override
    public String getCloudLicensingServerAddress() {
        return this.config.getString("Licensing", "cloudLicensingServerAddress");
    }

    @Override
    public String getLicensingPortalAddress() {
        return this.config.getString("Licensing", "licensingPortalAddress");
    }

    @Override
    public ActivationMethod getActivationMethod() {
        String string = this.config.getString("Licensing", "licensingActivationMethod");
        return ActivationMethod.getMethod(string);
    }

    @Override
    public void setActivationMethod(ActivationMethod activationMethod) {
        if (activationMethod != null) {
            this.config.setProperty("Licensing", "licensingActivationMethod", activationMethod.getValue());
        }
    }

    @Override
    public void clearActivationMethod() {
        this.config.clearProperty("Licensing", "licensingActivationMethod");
    }

    @Override
    public void setLLSAddress(String string) {
        this.config.setProperty("Licensing", "localLicensingServerAddress", string);
    }

    @Override
    public String getLLSAddress() {
        String string = null;
        InetAddressValidator inetAddressValidator = new InetAddressValidator();
        if (this.config.containsKey("Licensing", "localLicensingServerAddress")) {
            string = this.config.getString("Licensing", "localLicensingServerAddress", inetAddressValidator);
        }
        return string;
    }

    @Override
    public void clearLLSAddress() {
        this.config.clearProperty("Licensing", "localLicensingServerAddress");
    }

    @Override
    public int getLLSPort() {
        Integer n = 443;
        if (this.config.containsKey("Licensing", "localLicensingServerPort")) {
            IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(443);
            intRangeSetValidator.add(0, 65535);
            n = this.config.getInt("Licensing", "localLicensingServerPort", intRangeSetValidator);
        }
        return n;
    }

    @Override
    public void setLLSPort(int n) {
        this.config.setProperty("Licensing", "localLicensingServerPort", n);
    }

    @Override
    public void clearLLSPort() {
        this.config.clearProperty("Licensing", "localLicensingServerPort");
    }

    @Override
    public String getLLSProtocol() {
        StringSetValidator stringSetValidator = new StringSetValidator("https");
        stringSetValidator.add("http");
        stringSetValidator.add("https");
        String string = "https";
        if (this.config.containsKey("Licensing", "localLicensingServerProtocol")) {
            try {
                string = this.config.getString("Licensing", "localLicensingServerProtocol", stringSetValidator);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("getLLSProtocol() - IllegalArgumentException {}", (Throwable)illegalArgumentException);
                string = "https";
            }
            catch (ConversionException conversionException) {
                logger.error("getLLSProtocol() - ConversionException {}", (Throwable)conversionException);
                string = "https";
            }
        }
        return string;
    }

    @Override
    public boolean setLLSProtocol(HttpProtocol httpProtocol) {
        this.config.setProperty("Licensing", "localLicensingServerProtocol", httpProtocol.getValue());
        return true;
    }

    @Override
    public void clearLLSProtocol() {
        this.config.clearProperty("Licensing", "localLicensingServerProtocol");
    }
}

