/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice;

import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProductVersion {
    private static final Logger logger = LogManager.getLogger(ProductVersion.class);
    private static final String BUILD_TAG_KEY = "product.build.tag";
    private static final String VERSION_KEY = "product.build.version";
    private static final String DATE_KEY = "product.build.date";
    private static final String COUNTLY_API_KEY = "countly_api_key";
    private static final String COUNTLY_SALT = "countly_salt";
    private static final String IDENTITY_CLIENT_KEY = "identity_client";
    private static final String VERSION_PROPERTIES = "/com/apcc/pcns/version.properties";
    private static final String VERSION_UNKNOWN = "Unknown";
    @NonNull
    private ConfigurationManager config;
    private String version = "Unknown";
    private String countlySalt = null;
    private String buildTag = "Unknown";
    private IPermanentStorage m11Storage = null;
    private Date buildDate = null;
    private String countlyApiKey = null;
    private String identityDataBase64 = null;

    public ProductVersion() {
        logger.debug("ProductVersion() - start");
        try (InputStream inputStream = ProductVersion.class.getResourceAsStream(VERSION_PROPERTIES);){
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                this.version = properties.getProperty(VERSION_KEY);
                this.buildTag = properties.getProperty(BUILD_TAG_KEY);
                String string = properties.getProperty(DATE_KEY);
                this.buildDate = new SimpleDateFormat("yyyy/MM/dd HH:mm").parse(string);
                logger.debug("ProductVersion() - loaded verion:{} build:{} buildDate:{}", (Object)this.version, (Object)this.buildTag, (Object)this.getBuildDate());
                this.countlyApiKey = properties.getProperty(COUNTLY_API_KEY);
                this.countlySalt = properties.getProperty(COUNTLY_SALT);
                this.identityDataBase64 = properties.getProperty(IDENTITY_CLIENT_KEY);
            } else {
                logger.warn("Failed to load version.properties file.");
            }
        }
        catch (IOException iOException) {
            logger.warn("Failed to load version.properties file: {}", (Throwable)iOException);
        }
        catch (ParseException parseException) {
            logger.warn("Failed to parse build date from version.properties file: {}", (Throwable)parseException);
        }
        catch (Exception exception) {
            logger.warn("Failed to load version.properties: {}", (Throwable)exception);
        }
    }

    public void setConfig(ConfigurationManager configurationManager) {
        this.config = configurationManager;
        try {
            String string = configurationManager.getString("SoftwareUpdate", "fakeProductVersion");
            if (string != null) {
                this.version = string;
            }
        }
        catch (ConversionException conversionException) {
            logger.trace("Not using fake product version");
        }
    }

    public String getServerID() {
        logger.debug("getServerID() - start");
        String string = null;
        string = this.config.getString("CustomerExperienceImprovement", "CEIPRandomID");
        if (StringUtils.isBlank((CharSequence)string)) {
            if (this.m11Storage == null) {
                logger.error("getServerID called before init");
            } else {
                ComponentID componentID = new ComponentID("SoftwareUpdate");
                try {
                    Object object = this.m11Storage.readData(componentID, "ServerID");
                    if (object instanceof String) {
                        string = (String)object;
                        logger.debug("loaded ServerID");
                        this.config.setProperty("CustomerExperienceImprovement", "CEIPRandomID", string);
                    }
                }
                catch (StorageEntryException storageEntryException) {
                    logger.debug("Unable to load updateURL, using null", (Throwable)storageEntryException);
                }
            }
            if (string == null) {
                string = UUID.randomUUID().toString();
                logger.debug("Created a new serverID:{}", (Object)string);
                this.config.setProperty("CustomerExperienceImprovement", "CEIPRandomID", string);
            }
        }
        logger.debug("getServerID() - end {}", (Object)string);
        return string;
    }

    public String getCopyrightYear() {
        if (this.buildDate == null) {
            return VERSION_UNKNOWN;
        }
        return new SimpleDateFormat("yyyy").format(this.buildDate);
    }

    public String getMajorMinorVersion() {
        String string = "0.0";
        if (!StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)VERSION_UNKNOWN)) {
            String[] stringArray = this.version.split("\\.");
            string = stringArray[0].concat(".").concat(stringArray[1]);
        }
        return string;
    }

    public byte[] getIdentity() {
        byte[] byArray = null;
        if (StringUtils.isNotBlank((CharSequence)this.identityDataBase64)) {
            byArray = Base64.getDecoder().decode(this.identityDataBase64);
        }
        return byArray;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setVersion(String string) {
        this.version = string;
    }

    @Generated
    public String getCountlySalt() {
        return this.countlySalt;
    }

    @Generated
    public String getBuildTag() {
        return this.buildTag;
    }

    @Generated
    public void setM11Storage(IPermanentStorage iPermanentStorage) {
        this.m11Storage = iPermanentStorage;
    }

    @Generated
    public Date getBuildDate() {
        return this.buildDate;
    }

    @Generated
    public String getCountlyApiKey() {
        return this.countlyApiKey;
    }
}

