/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice;

import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.m11.components.webserver.model.SSHSettings;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSHActionConfigurator {
    private static final Logger logger = LogManager.getLogger(SSHActionConfigurator.class);
    public static final int MIN_INDEX = 0;
    public static final int MAX_INDEX = 100;
    private ConfigurationManager config;
    private AdvancedSetupHelper advancedSetupHelper;
    private AuthHelper authHelper;
    @NonNull
    private UserFilePathValidator validator;

    public SSHActionConfigurator(@NonNull ConfigurationManager configurationManager, @NonNull AuthHelper authHelper, @NonNull AdvancedSetupHelper advancedSetupHelper) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        this.authHelper = authHelper;
        this.config = configurationManager;
        this.advancedSetupHelper = advancedSetupHelper;
        this.validator = new UserFilePathValidator();
    }

    public boolean hasFreeSlot() {
        return this.findNextIndex() != null;
    }

    public void create(@NonNull SSHSettings sSHSettings) {
        if (sSHSettings == null) {
            throw new IllegalArgumentException("sshConfig is marked non-null but is null");
        }
        this.validatePaths(sSHSettings);
        Integer n = this.findNextIndex();
        if (n != null) {
            sSHSettings.setIndex(n);
            String string = this.getSection(n);
            this.save(string, sSHSettings);
            Set<String> set = this.config.getSections();
            for (String string2 : set) {
                if (!StringUtils.startsWith((CharSequence)string2, (CharSequence)"advanced_ups_setup_")) continue;
                this.config.setProperty(string2, string, false);
            }
        } else {
            String string = "Maximum number of SSH Actions already defined.  Can't create a new entry.";
            logger.warn(string);
            throw new IndexOutOfBoundsException(string);
        }
    }

    public void update(int n, @NonNull SSHSettings sSHSettings) {
        if (sSHSettings == null) {
            throw new IllegalArgumentException("sshConfig is marked non-null but is null");
        }
        this.validatePaths(sSHSettings);
        this.validateIndex(n);
        String string = this.getSection(n);
        this.save(string, sSHSettings);
    }

    public SSHSettings read(int n, boolean bl) {
        this.validateIndex(n);
        if (!this.isIndexUsed(n)) {
            return null;
        }
        SSHSettings sSHSettings = null;
        String string = this.getSection(n);
        try {
            String string2 = this.config.getString(string, "ssh_action_name");
            String string3 = this.config.getString(string, "ssh_target");
            String string4 = this.config.getString(string, "ssh_command_path");
            String string5 = this.authHelper.getSSHActionUserName(string);
            String string6 = this.config.getString(string, "ssh_keyfile_path");
            sSHSettings = new SSHSettings(string2, string5, string3, string4);
            sSHSettings.setIndex(n);
            sSHSettings.setEnabled(this.config.getBoolean(string, "ssh_action_enabled"));
            sSHSettings.setDuration(this.config.getInt(string, "action_duration"));
            sSHSettings.setDelay(this.config.getInt(string, "action_delay"));
            sSHSettings.setPort(this.config.getInt(string, "ssh_port"));
            sSHSettings.setTrigger(SSHActionTrigger.fromIniSetting(this.config.getString(string, "ssh_action_sequence")));
            boolean bl2 = true;
            if (!this.validator.isValid(string4)) {
                logger.error("read() - Invalid ssh command path detected for SSH Action: {}.  Disabling the action.", (Object)string);
                sSHSettings.setEnabled(false);
                bl2 = false;
            }
            if (StringUtils.isNotBlank((CharSequence)string6)) {
                if (this.validator.isValid(string6)) {
                    sSHSettings.setSshKeyPath(string6);
                } else {
                    logger.error("read() - Invalid ssh key path detected for SSH Action: {}.  Disabling the action.", (Object)string);
                    sSHSettings.setEnabled(false);
                    bl2 = false;
                }
            }
            if (bl || !bl2) {
                sSHSettings.setPassword(this.authHelper.getSSHActionPassword(string));
                sSHSettings.setSshKeyPassword(this.authHelper.getSSHActionKeyfilePassword(string));
            }
            if (this.config.containsKey(string, "ssh_prompt_regex")) {
                sSHSettings.setCustomPrompt(this.config.getString(string, "ssh_prompt_regex"));
            }
            if (!bl2) {
                this.save(this.getSection(n), sSHSettings);
            }
        }
        catch (IllegalArgumentException | ConversionException throwable) {
            logger.warn((Object)throwable);
        }
        return sSHSettings;
    }

    public List<SSHSettings> readAll(boolean bl) {
        LinkedList<SSHSettings> linkedList = new LinkedList<SSHSettings>();
        Set<String> set = this.config.getSections();
        for (String string : set) {
            if (!StringUtils.startsWith((CharSequence)string, (CharSequence)"SSHAction")) continue;
            try {
                int n = Integer.parseInt(StringUtils.substringAfter((String)string, (String)"SSHAction"));
                SSHSettings sSHSettings = this.read(n, bl);
                if (sSHSettings == null) continue;
                linkedList.add(sSHSettings);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return linkedList;
    }

    public void delete(int n) {
        this.validateIndex(n);
        String string = this.getSection(n);
        List<UPSSetup> list = this.advancedSetupHelper.readUPSSetupsFromConfig();
        for (UPSSetup uPSSetup : list) {
            uPSSetup.removeSSHSetting(string);
        }
        this.advancedSetupHelper.saveUPSSetupsToConfig(list);
        if (this.config.containsSection(string)) {
            this.config.clearSection(string);
        }
        this.authHelper.removeSSHActionUsername(string);
        this.authHelper.removeSSHActionPassword(string);
        this.authHelper.removeSSHActionKeyfilePassword(string);
    }

    private void validateIndex(int n) {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("Index is out of bounds.");
        }
    }

    private void validatePaths(@NonNull SSHSettings sSHSettings) {
        if (sSHSettings == null) {
            throw new IllegalArgumentException("sshConfig is marked non-null but is null");
        }
        if (!this.validator.isValid(sSHSettings.getCommandFilePath())) {
            throw new IllegalArgumentException("SSH command file is not valid.");
        }
        if (StringUtils.isNotBlank((CharSequence)sSHSettings.getSshKeyPath()) && !this.validator.isValid(sSHSettings.getSshKeyPath())) {
            throw new IllegalArgumentException("SSH key file path is not valid");
        }
    }

    private Integer findNextIndex() {
        Integer n = null;
        for (int i = 0; i < 100; ++i) {
            if (this.isIndexUsed(i)) continue;
            n = i;
            break;
        }
        return n;
    }

    private boolean isIndexUsed(int n) {
        return this.config.containsSection(this.getSection(n));
    }

    private String getSection(int n) {
        return "SSHAction" + n;
    }

    private void save(String string, SSHSettings sSHSettings) {
        this.config.setProperty(string, "ssh_action_name", sSHSettings.getName());
        this.config.setProperty(string, "ssh_target", sSHSettings.getTargetHost());
        this.config.setProperty(string, "ssh_command_path", sSHSettings.getCommandFilePath());
        this.config.setProperty(string, "ssh_action_enabled", sSHSettings.isEnabled());
        this.config.setProperty(string, "action_delay", sSHSettings.getDelay());
        this.config.setProperty(string, "action_duration", sSHSettings.getDuration());
        this.config.setProperty(string, "ssh_port", sSHSettings.getPort());
        this.config.setProperty(string, "ssh_action_sequence", sSHSettings.getTrigger().getIniSetting());
        String string2 = sSHSettings.getSshKeyPath();
        if (string2 != null) {
            this.config.setProperty(string, "ssh_keyfile_path", string2);
        }
        if (sSHSettings.hasUsername()) {
            this.authHelper.setSSHActionUserName(string, sSHSettings.getUsername());
        }
        if (sSHSettings.hasPassword()) {
            this.authHelper.setSSHActionPassword(string, sSHSettings.getPassword());
        }
        if (sSHSettings.hasSshKeyPassword()) {
            this.authHelper.setSSHActionKeyfilePassword(string, sSHSettings.getSshKeyPassword());
        }
    }

    public List<String> getSSHActionsConfigured() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            if (!this.isIndexUsed(i)) continue;
            arrayList.add(this.getSection(i));
        }
        return arrayList;
    }

    @Generated
    public void setValidator(@NonNull UserFilePathValidator userFilePathValidator) {
        if (userFilePathValidator == null) {
            throw new IllegalArgumentException("validator is marked non-null but is null");
        }
        this.validator = userFilePathValidator;
    }
}

