/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice;

import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.webserver.util.CfgWizardHelper;
import com.apcc.m11.ds.events.flexevents.EventLists;
import com.apcc.m11.ds.events.flexevents.RESTEvents;
import com.apcc.m11.util.Base64;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManagerImpl;
import com.apcc.pcns.configservice.validation.EncryptUtils;
import com.apcc.pcns.configservice.validation.ValidationUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.RandomIvGenerator;

public class UpgradeIniConverter {
    private static final String M11_CFG = "m11.cfg";
    private static final String GROUP1 = "group1";
    private static final Logger LOGGER = LogManager.getLogger(UpgradeIniConverter.class);
    private static final String EMPTY_STRING = "";
    private static final String APP_PATH = "applicationDirectory";
    public static final int EXIT_CANT_READ_M11 = 1;
    public static final int EXIT_CANT_WRITE_M11 = 2;
    private ConfigurationManagerImpl config;
    private Hashtable<String, Object> m11Config;
    private ValidationUtil baseKeyEncryptor;
    private StandardPBEStringEncryptor oldAlgoEncryptor;
    private StandardPBEStringEncryptor newAlgoEncryptor;
    private String jasyptRandomNumberBaseKey;
    private String jrnThresholdBaseKey;
    private String validationBaseKeyEncrypted;
    private String validationBaseKeyPlaintext;

    public static void main(String[] stringArray) {
        LOGGER.debug("main: {}", (Object[])stringArray);
        String string = null;
        UpgradeIniConverter upgradeIniConverter = new UpgradeIniConverter();
        String string2 = System.getProperty(APP_PATH, EMPTY_STRING);
        if (StringUtils.isNotEmpty((CharSequence)string2)) {
            File file = new File(string2 + File.separator + GROUP1 + File.separator + M11_CFG);
            LOGGER.debug("main() - m11 path: {}", (Object)file);
            upgradeIniConverter.readM11Config(file);
            upgradeIniConverter.logM11Contents();
            string = string2 + File.separator + GROUP1 + File.separator + "pcnsconfig.ini";
            LOGGER.debug("main() - INI path: {}", (Object)string);
            upgradeIniConverter.readINI(string);
            boolean bl = upgradeIniConverter.migrateM11Configuration();
            if (bl) {
                upgradeIniConverter.writeM11Config(file);
                upgradeIniConverter.logM11Contents();
            }
            upgradeIniConverter.convert();
            String string3 = string2 + File.separator + GROUP1 + File.separator + "pcnsconfig_backup.ini";
            try {
                FileUtils.copyFile((File)new File(string), (File)new File(string3));
            }
            catch (IOException iOException) {
                LOGGER.debug("Error converting backup INI file: ", (Throwable)iOException);
            }
            LOGGER.debug("Done");
        } else {
            LOGGER.error("Error applicationDirectory missing.");
        }
        System.exit(0);
    }

    private void logM11Contents() {
        LOGGER.debug("Logging M11 contents...");
        for (Map.Entry<String, Object> entry : this.m11Config.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            LOGGER.debug("Key: {}, Value: {}", (Object)string, object);
        }
    }

    public void readM11Config(File file) {
        if (file.exists()) {
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));){
                LOGGER.debug("Reading contents of {}", (Object)file);
                this.m11Config = (Hashtable)objectInputStream.readObject();
            }
            catch (IOException | ClassNotFoundException exception) {
                LOGGER.error("Error Code: {}", (Object)1, (Object)exception);
            }
        } else {
            LOGGER.debug("M11 file doesn't exist: {}", (Object)file.getAbsolutePath());
        }
    }

    public void writeM11Config(File file) {
        LOGGER.debug("Writing values to {}", (Object)file);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));){
            objectOutputStream.writeObject(this.m11Config);
        }
        catch (IOException iOException) {
            LOGGER.error("Error Code: {}", (Object)2, (Object)iOException);
        }
    }

    private void setBaseKeys() {
        this.jasyptRandomNumberBaseKey = this.getSharedComponentJasyptRandomNumberKey();
        this.jrnThresholdBaseKey = this.getSharedComponentJRNThresholdKey();
        this.setSharedComponentValidationKeys();
    }

    private String getEncryptUtilsRandomNumberBaseKey() throws IllegalStateException {
        String string = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.jrnThresholdBaseKey, this.jasyptRandomNumberBaseKey});
        LOGGER.debug("getEncryptUtilsRandomNumberBaseKey(): Found base key: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    private String getSharedComponentJasyptRandomNumberKey() {
        String string = null;
        try {
            string = this.decryptBaseKey(PowerSourceComponent.kSharedComponentId, "JasyptRandomNumber");
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.error("getSharedComponentJasyptRandomNumberKey() - Failed to find base key: ", (Throwable)illegalStateException);
        }
        LOGGER.debug("getSharedComponentJasyptRandomNumberKey() - Found key: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    private String getSharedComponentJRNThresholdKey() {
        String string = null;
        try {
            string = this.decryptBaseKey(EncryptUtils.kComponentId, EncryptUtils.kRandomNumberId);
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.error("getSharedComponentJRNThresholdKey() - Failed to find base key.", (Throwable)illegalStateException);
        }
        LOGGER.debug("getSharedComponentJRNThresholdKey() - Found key: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    private void setSharedComponentValidationKeys() {
        Object object = this.m11Config.get(PowerSourceComponent.kSharedComponentId.getID() + ".Validation");
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        }
        String string2 = null;
        try {
            string2 = this.decryptBaseKey(PowerSourceComponent.kSharedComponentId, "Validation");
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.debug("getSharedComponentValidationKey() - Failed to decrypt the validation base key. {}", (Throwable)illegalStateException);
        }
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            this.validationBaseKeyEncrypted = string2;
            this.validationBaseKeyPlaintext = null;
        } else {
            this.validationBaseKeyEncrypted = null;
            this.validationBaseKeyPlaintext = string;
        }
        LOGGER.debug("getSharedComponentValidationKey() - Encrypted key: {}, Plaintext key: {}", (Object)StringUtils.isNotBlank((CharSequence)this.validationBaseKeyEncrypted), (Object)StringUtils.isNotBlank((CharSequence)this.validationBaseKeyPlaintext));
    }

    private String decryptBaseKey(ComponentID componentID, String string) throws IllegalStateException {
        LOGGER.debug("decryptBaseKey() - Component: {}, key: {}", (Object)componentID.getID(), (Object)string);
        Object object = this.m11Config.get(componentID.getID() + "." + string);
        String string2 = null;
        if (object instanceof String) {
            string2 = (String)object;
        }
        if (StringUtils.isEmpty(string2)) {
            throw new IllegalStateException("Can't find encrypted base key.");
        }
        String string3 = this.baseKeyEncryptor.decrypt(string2);
        LOGGER.debug("decryptBaseKey() - Found value: {}", (Object)string3);
        return string3;
    }

    private String getAuthHelperRandomNumberBaseKey() {
        String string = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.validationBaseKeyPlaintext, this.validationBaseKeyEncrypted, this.jasyptRandomNumberBaseKey});
        LOGGER.debug("getAuthHelperRandomNumberBaseKey(): Found base key: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    private boolean isEncryptUtilsMigrtationRequired() {
        return StringUtils.isNotBlank((CharSequence)this.jrnThresholdBaseKey) || StringUtils.isNotBlank((CharSequence)this.jasyptRandomNumberBaseKey);
    }

    private void migrateEncryptUtilsKeys() {
        String string;
        if (!this.isEncryptUtilsMigrtationRequired()) {
            LOGGER.warn("migrateEncryptUtilsKeys() - Base keys for EncryptUtils are not present, so we are not migrating configurations based on them.");
            return;
        }
        try {
            string = this.getEncryptUtilsRandomNumberBaseKey();
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.error("Can't read base key for EncryptUtils. Some configurations can't be migrated.", (Throwable)illegalStateException);
            return;
        }
        this.oldAlgoEncryptor = new StandardPBEStringEncryptor();
        this.oldAlgoEncryptor.setPassword(string);
        this.oldAlgoEncryptor.initialize();
        this.migrateSSHSettings();
        this.migrateSNMPv3Settings();
        this.migrateTrustStorePassword();
        this.migrateKeystorePasswords();
        this.m11Config.remove(EncryptUtils.kComponentId.getID() + "." + EncryptUtils.kRandomNumberId);
        this.m11Config.remove(PowerSourceComponent.kSharedComponentId.getID() + ".JasyptRandomNumber");
    }

    private boolean isAuthHelperMigrationRequired() {
        String string = this.getAuthHelperRandomNumberBaseKey();
        boolean bl = StringUtils.equals((CharSequence)this.validationBaseKeyPlaintext, (CharSequence)string) && StringUtils.isNotBlank((CharSequence)string);
        LOGGER.debug("isAuthHelperMigrationRequired() - Plaintext key already in use: {}", (Object)bl);
        return !bl;
    }

    private void migrateAuthHelperKeys() {
        LOGGER.debug("migrateAuthHelperKeys() - start");
        if (!this.isAuthHelperMigrationRequired()) {
            LOGGER.debug("migrateAuthHelperKeys() - Migration is not required...");
            return;
        }
        String string = this.getAuthHelperRandomNumberBaseKey();
        this.oldAlgoEncryptor = new StandardPBEStringEncryptor();
        this.oldAlgoEncryptor.setPassword(string);
        this.oldAlgoEncryptor.initialize();
        HashSet<CallSite> hashSet = new HashSet<CallSite>();
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".ESXiHostSerialNumber")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".ESXiHostTurnOffPoint")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".HyperflexAuthPassword")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".vCenterSerialNumber")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".vCenterTurnOffPoint")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".UpdateNumber")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".UpdateFrequency")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".LicensingActivationId")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".LicensingDeviceId")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".LicensingProxyPassword")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".LicensingProxyUsername")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".NutanixClusterSerialNumber")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".NutanixHostSerialNumber")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".NutanixKeySerialNumber")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".PowerSourceUPSId")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".PowerSourceUPSSerialNumber")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".UPSTurnOffPoint")));
        hashSet.add((CallSite)((Object)(PowerSourceComponent.kSharedComponentId.getID() + ".SimplivityClusterPassword")));
        for (String string2 : hashSet) {
            this.replaceKey(string2, string2);
        }
        LOGGER.debug("migrateAuthHelperKeys() - end");
    }

    public boolean migrateM11Configuration() {
        String string;
        LOGGER.debug("migrateM11Configuration() - start");
        if (this.m11Config == null) {
            LOGGER.warn("migrateM11Configuration() - No reference to m11Config. Can't process it...");
            return false;
        }
        this.baseKeyEncryptor = new ValidationUtil();
        AuthHelper authHelper = new AuthHelper();
        this.setBaseKeys();
        try {
            string = this.getAuthHelperRandomNumberBaseKey();
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.debug("migrateM11Configuration() - Exception reading AuthHelper base key: {}", (Throwable)illegalStateException);
            string = authHelper.getRandomKey();
        }
        LOGGER.debug("migrateM11Configuration() - Create v 5.0 Encryptor...");
        this.newAlgoEncryptor = new StandardPBEStringEncryptor();
        this.newAlgoEncryptor.setAlgorithm("PBEWithHMACSHA512AndAES_256");
        this.newAlgoEncryptor.setIvGenerator((IvGenerator)new RandomIvGenerator());
        this.newAlgoEncryptor.setKeyObtentionIterations(10000);
        this.newAlgoEncryptor.setPassword(string);
        this.newAlgoEncryptor.initialize();
        this.migrateEncryptUtilsKeys();
        this.migrateAuthHelperKeys();
        this.m11Config.put(PowerSourceComponent.kSharedComponentId.getID() + ".Validation", string);
        LOGGER.debug("migrateM11Configuration() - done");
        return true;
    }

    private void replaceKey(String string, String string2) {
        if (this.m11Config.containsKey(string)) {
            Object object = this.m11Config.get(string);
            this.m11Config.remove(string);
            String string3 = null;
            if (object instanceof String) {
                string3 = (String)object;
            }
            if (StringUtils.isBlank(string3)) {
                this.m11Config.put(string2, string3);
            } else {
                try {
                    String string4 = this.oldAlgoEncryptor.decrypt(string3);
                    String string5 = this.newAlgoEncryptor.encrypt(string4);
                    this.m11Config.put(string2, string5);
                    LOGGER.debug("replaceKey() - Replacing {} with {}", (Object)string, (Object)string2);
                }
                catch (EncryptionInitializationException | EncryptionOperationNotPossibleException throwable) {
                    LOGGER.error("replaceKey() - Failed to replace key {} with {}", (Object)string, (Object)string2, (Object)throwable);
                }
            }
        }
    }

    private boolean replaceKeyWithDecode(String string, String string2) {
        boolean bl = false;
        if (this.m11Config.containsKey(string)) {
            Object object = this.m11Config.get(string);
            this.m11Config.remove(string);
            if (object instanceof String) {
                bl = this.decodeAndReplace(string, string2, bl, (String)object);
            }
        }
        return bl;
    }

    private boolean decodeAndReplace(String string, String string2, boolean bl, String string3) {
        try {
            String string4 = string3;
            String string5 = this.oldAlgoEncryptor.decrypt(string4);
            if (string5 != null) {
                string5 = new String(Base64.decode((byte[])string5.getBytes()));
            }
            String string6 = this.newAlgoEncryptor.encrypt(string5);
            this.m11Config.put(string2, string6);
            bl = true;
            LOGGER.debug("decodeAndReplace() - Replacing {} with {}", (Object)string, (Object)string2);
        }
        catch (EncryptionInitializationException | EncryptionOperationNotPossibleException throwable) {
            LOGGER.error("decodeAndReplace() - Failed to replace key {} with {}", (Object)string, (Object)string2, (Object)throwable);
        }
        return bl;
    }

    private void migrateSSHSettings() {
        LOGGER.debug("migrateSSHSettings() - start");
        Set set = this.config.getSections().stream().filter(string -> StringUtils.contains((CharSequence)string, (CharSequence)"SSHAction")).collect(Collectors.toSet());
        for (String string2 : set) {
            String string3 = EncryptUtils.kComponentId.getID() + "." + EncryptUtils.getPermStorageKey(string2, "ssh_user_name");
            String string4 = PowerSourceComponent.kSharedComponentId.getID() + "." + string2 + "_ssh_user_name";
            this.replaceKey(string3, string4);
            string3 = EncryptUtils.kComponentId.getID() + "." + EncryptUtils.getPermStorageKey(string2, "ssh_keyfile_password");
            string4 = PowerSourceComponent.kSharedComponentId.getID() + "." + string2 + "_ssh_keyfile_password";
            this.replaceKey(string3, string4);
            string3 = EncryptUtils.kComponentId.getID() + "." + EncryptUtils.getPermStorageKey(string2, "ssh_pasword");
            string4 = PowerSourceComponent.kSharedComponentId.getID() + "." + string2 + "_ssh_pasword";
            this.replaceKey(string3, string4);
        }
        LOGGER.debug("migrateSSHSettings() - end");
    }

    private void migrateKeystorePasswords() {
        LOGGER.debug("migrateKeystorePasswords() - start");
        String string = EncryptUtils.kComponentId.getID() + "." + EncryptUtils.getPermStorageKey(PowerSourceComponent.kSharedComponentId.getID(), "KeystorePasswordenc");
        String string2 = PowerSourceComponent.kSharedComponentId.getID() + ".KeystorePasswordenc";
        boolean bl = this.replaceKeyWithDecode(string, string2);
        if (!bl) {
            string = PowerSourceComponent.kSharedComponentId.getID() + ".KeystorePassword";
            if (this.m11Config.containsKey(string)) {
                this.replaceKeyWithDecode(string, string2);
            } else {
                String string3 = this.newAlgoEncryptor.encrypt("0a15k8mk1oiw26uv4np29def73x0bjsh");
                this.m11Config.put(string2, string3);
            }
        }
        LOGGER.debug("migrateKeystorePasswords() - end");
    }

    private void migrateTrustStorePassword() {
        LOGGER.debug("migrateTrustStorePassword() - start");
        String string = PowerSourceComponent.kSharedComponentId.getID() + ".PowerChuteKeystorePasswordenc";
        String string2 = EncryptUtils.kComponentId.getID() + "." + EncryptUtils.getPermStorageKey(PowerSourceComponent.kSharedComponentId.getID(), "PowerChuteKeystorePasswordenc");
        String string3 = PowerSourceComponent.kSharedComponentId.getID() + ".PowerChuteKeystorePassword";
        if (this.m11Config.containsKey(string2)) {
            this.replaceKeyWithDecode(string2, string);
        } else if (this.m11Config.containsKey(string3)) {
            this.replaceKeyWithDecode(string3, string);
        } else {
            String string4 = "password";
            String string5 = this.newAlgoEncryptor.encrypt(string4);
            this.m11Config.put(string, string5);
        }
        LOGGER.debug("migrateTrustStorePassword() - end");
    }

    private void migrateSNMPv3Settings() {
        LOGGER.debug("migrateSNMPv3Settings() - start");
        Set set = this.config.getSectionKeys("SNMP").stream().filter(string -> StringUtils.contains((CharSequence)string, (CharSequence)"SNMPv3_Name_Profile_")).collect(Collectors.toSet());
        for (String string2 : set) {
            int n = NumberUtils.toInt((String)StringUtils.remove((String)string2, (String)"SNMPv3_Name_Profile_"));
            if (n == 0) continue;
            String string3 = EncryptUtils.kComponentId.getID() + "." + EncryptUtils.getPermStorageKey("SNMP", "SNMPv3_AUTH_PASSPHRASE_Profile_" + n);
            String string4 = PowerSourceComponent.kSharedComponentId.getID() + ".SNMP_SNMPv3_AUTH_PASSPHRASE_Profile_" + n;
            this.replaceKey(string3, string4);
            string3 = EncryptUtils.kComponentId.getID() + "." + EncryptUtils.getPermStorageKey("SNMP", "SNMPv3_PRIV_PASSPHRASE_Profile_" + n);
            string4 = PowerSourceComponent.kSharedComponentId.getID() + ".SNMP_SNMPv3_PRIV_PASSPHRASE_Profile_" + n;
            this.replaceKey(string3, string4);
        }
        LOGGER.debug("migrateSNMPv3Sewttings() - end");
    }

    private void readINI(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.config = new ConfigurationManagerImpl(string);
            this.config.setAutoLog(true);
            this.config.setAutoSave(true);
        }
    }

    public void convert() {
        LOGGER.debug("convert() - start");
        this.config.setProperty("Networking", "ConfigComplete", false);
        this.setIfNotPresent("CustomerExperienceImprovement", "CEIPEnabled", true);
        if (this.isHyperV() && !this.isManaged()) {
            this.addHyperVStopClusterKeys();
        }
        if (this.isESXi() && this.isManaged()) {
            this.addVirtualizationKeys();
            this.addVMPrioritizationKeys();
            this.addDelayMaintenanceModeKeys();
        }
        if (this.isESXi()) {
            this.setIfNotPresent("HostDetails", "Skip_Cert_Check", true);
        }
        this.setIfNotPresent("HostDetails", "Skip_Cert_Check", false);
        this.addRemoteShutdownEventConfiguration();
        this.removeKeys();
        this.config.save();
        this.config = null;
        LOGGER.debug("convert() - end");
    }

    private void removeKeys() {
        this.clearProperty("Networking", "ssl_protocol");
        this.clearProperty("HostDetails", "nutanix_support");
        this.clearProperty("HyperflexClusterDetails", "accept_all_Certs");
        this.clearProperty("VxRailClusterDetails", "acceptCerts");
        if (!this.isManagedHostOrNutanixAHV()) {
            this.clearProperty("Shutdown", "executeCommandFileAfterHostShutdown");
        }
        if (!this.isESXi()) {
            this.clearProperty("HostConfigSettings", "VMware_connect_timeout");
        }
        if (this.isAdvancedConfig()) {
            Set set = this.config.getSections().stream().filter(string -> StringUtils.startsWith((CharSequence)string, (CharSequence)"advanced_ups_setup_")).collect(Collectors.toSet());
            for (String string2 : set) {
                this.clearProperty(string2, "vsan_prepare");
                this.clearProperty(string2, "vsan_recovery");
            }
        }
    }

    private void addRemoteShutdownEventConfiguration() {
        LOGGER.info("Adding Keys for RemoteShutdownEvent");
        String string = EventLists.getEventNameForObjectId(RESTEvents.RemoteShutdownEvent.getObjectId());
        ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
        this.setIfNotPresent("Events", configurationKeys.getEnableLoggingKey(), Boolean.TRUE);
        this.setIfNotPresent("Events", configurationKeys.getEnableCommandFileKey(), Boolean.FALSE);
        this.setIfNotPresent("Events", configurationKeys.getCommandFilePathKey(), EMPTY_STRING);
        this.setIfNotPresent("Events", configurationKeys.getCommandFileDelayKey(), 0);
        this.setIfNotPresent("Events", configurationKeys.getCommandFileDurationKey(), 0);
        this.setIfNotPresent("Events", configurationKeys.getEnableShutdownKey(), Boolean.TRUE);
        this.setIfNotPresent("Events", configurationKeys.getShutdownDelayKey(), 0);
        LOGGER.info("Adding Keys for RemoteShutdownEventResolved");
        string = EventLists.getEventNameForObjectId(RESTEvents.RemoteShutdownEventResolved.getObjectId());
        configurationKeys = new ConfigurationKeys(string);
        this.setIfNotPresent("Events", configurationKeys.getEnableLoggingKey(), Boolean.TRUE);
        this.setIfNotPresent("Events", configurationKeys.getEnableCommandFileKey(), Boolean.FALSE);
        this.setIfNotPresent("Events", configurationKeys.getCommandFilePathKey(), EMPTY_STRING);
        this.setIfNotPresent("Events", configurationKeys.getCommandFileDelayKey(), 0);
        this.setIfNotPresent("Events", configurationKeys.getCommandFileDurationKey(), 0);
    }

    private void addHyperVStopClusterKeys() {
        this.setIfNotPresent("HostConfigSettings", "enable_hvstopcluster", false);
        this.setIfNotPresent("HostConfigSettings", "hvstopcluster_duration", 120);
        this.setIfNotPresent("HostConfigSettings", "hvstartcluster_duration", 120);
    }

    private void addVMPrioritizationKeys() {
        this.setIfNotPresent("VMPrioritization", "vm_startup_duration_group_1", 0);
        this.setIfNotPresent("VMPrioritization", "vm_startup_duration_group_2", 0);
        this.setIfNotPresent("VMPrioritization", "vm_migration_duration_group_1", 0);
        this.setIfNotPresent("VMPrioritization", "vm_migration_duration_group_2", 0);
        this.setIfNotPresent("VMPrioritization", "vm_shutdown_duration_group_1", 0);
        this.setIfNotPresent("VMPrioritization", "vm_shutdown_duration_group_2", 0);
        this.setIfNotPresent("VMPrioritization", "vm_list_group_1", EMPTY_STRING);
        this.setIfNotPresent("VMPrioritization", "vm_list_group_2", EMPTY_STRING);
    }

    private void addVirtualizationKeys() {
        this.setIfNotPresent("HostConfigSettings", ConfigurationKeys.ENABLE_PLUGIN, false);
        this.setIfNotPresent("HostConfigSettings", "force_VApp_shutdown", false);
        this.setIfNotPresent("HostConfigSettings", "guest_vm_vapp_startup_duration", 120);
        this.setIfNotPresent("HostConfigSettings", "enable_guest_vm_vapp_startup", false);
        this.setIfNotPresent("HostConfigSettings", "guest_vm_vapp_shutdown_duration", 120);
        this.setIfNotPresent("HostConfigSettings", "enable_guest_vm_vapp_shutdown", false);
        this.setIfNotPresent("HostConfigSettings", "custom_target_hosts", EMPTY_STRING);
        this.setIfNotPresent("HostConfigSettings", "enable_custom_target_vm_migration", false);
        this.setIfNotPresent("HostDetails", "is_VCSA", false);
        this.setIfNotPresent("HostConfigSettings", "delay_maintenance_mode", false);
        this.setIfNotPresent("HostConfigSettings", "delay_maintenance_mode_timeout", 240);
        this.setIfNotPresent("HostConfigSettings", "enable_vCLS_duration", 180);
        this.setIfNotPresent("HostConfigSettings", "disable_ha_on_shutdown", true);
        this.setIfNotPresent("HostConfigSettings", "disable_ha_delay", 20);
        this.setIfNotPresent("HostConfigSettings", "enable_ha_delay", 20);
        this.setIfNotPresent("HostConfigSettings", "vsan_prepare", 120);
        this.setIfNotPresent("HostConfigSettings", "vsan_recovery", 120);
        CfgWizardHelper.addVMPrioritizationKeysToConfig(this.config, false);
        CfgWizardHelper.addExecuteCommandFileAfterHostShutdownToConfig(this.config);
    }

    private void addDelayMaintenanceModeKeys() {
        this.setIfNotPresent("HostConfigSettings", "delay_maintenance_mode", false);
        this.setIfNotPresent("HostConfigSettings", "delay_maintenance_mode_timeout", 240);
    }

    private void setIfNotPresent(String string, String string2, Object object) {
        if (!this.config.containsKey(string, string2)) {
            this.config.setProperty(string, string2, object);
        }
    }

    private void clearProperty(String string, String string2) {
        if (this.config.containsKey(string, string2)) {
            this.config.clearProperty(string, string2);
        }
    }

    private boolean isManaged() {
        try {
            if (this.config.containsKey("HostDetails", "ConfigurationMode")) {
                String string = this.config.getString("HostDetails", "ConfigurationMode");
                return "Managed".equalsIgnoreCase(string);
            }
            return false;
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)conversionException);
            return false;
        }
    }

    public boolean isNutanixAHV() {
        boolean bl = StringUtils.equalsIgnoreCase((CharSequence)this.config.getString("Networking", "VirtualInstall"), (CharSequence)"Nutanix");
        LOGGER.debug("isNutanixAHV() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isManagedHostOrNutanixAHV() {
        return this.isManaged() || this.isNutanixAHV();
    }

    private boolean isESXi() {
        try {
            if (this.config.containsKey("Networking", "VirtualInstall")) {
                String string = this.config.getString("Networking", "VirtualInstall");
                return "VMWare".equalsIgnoreCase(string);
            }
            return false;
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)conversionException);
            return false;
        }
    }

    private boolean isHyperV() {
        try {
            if (this.config.containsKey("Networking", "VirtualInstall")) {
                String string = this.config.getString("Networking", "VirtualInstall");
                return "Hyper-V".equalsIgnoreCase(string);
            }
            return false;
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)conversionException);
            return false;
        }
    }

    private boolean isAdvancedConfig() {
        try {
            if (this.config.containsKey("NetworkManagementCard", "mode")) {
                String string = this.config.getString("NetworkManagementCard", "mode");
                return "advanced".equalsIgnoreCase(string);
            }
            return false;
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)conversionException);
            return false;
        }
    }
}

