/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.omaha.LogUtils;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupOutletEvent;
import com.apcc.m11.components.shutdowner.ShutdownState;
import com.apcc.m11.components.shutdowner.ShutdownTimer;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanFaultToleranceThreshold;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.webserver.model.Host;
import com.apcc.m11.components.webserver.model.MappedHost;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareDetails;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.configservice.validation.StringSetValidator;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import com.apcc.pcns.nutanixservice.NutanixConnection;
import com.apcc.pcns.nutanixservice.NutanixService;
import com.apcc.pcns.userinterface.HyperconvergedSupport;
import com.apcc.pcns.util.HostNameLookUpTable;
import com.apcc.pcns.util.IPUtils;
import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ServiceInstance;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualConfigurationManager {
    private static final int DEFAULT_SHUTDOWN_DELAY = 10;
    private static final int MIN_SHUTDOWN_DELAY = 0;
    private static final int MAX_SHUTDOWN_DELAY = 7200;
    private static final int DEFAULT_SCRIPT_DELAY = 10;
    private static final Logger logger = LogManager.getLogger(VirtualConfigurationManager.class);
    public static final int DEFAULT_PCNS_SHUTDOWN_COMMAND_DELAY = 30;
    public static final String DEFAULT_PROTOCOL = "https";
    public static final int DEFAULT_PCNS_HTTP_PORT = 3052;
    public static final int DEFAULT_PCNS_HTTPS_PORT = 6547;
    public static final int DELAY_AFTER_VCSA_POWERED_ON_AND_CONNECTED = 30;
    private static final String MIN_VCENTER_VERSION_WEB_PLUGIN = "5.5";
    private static final String MIN_VCENTER_BUILD_WEB_PLUGIN = "1623099";
    private static Pattern hostPattern = Pattern.compile("[|]");
    private static Pattern outletPattern = Pattern.compile("[&]");
    public static final String DataCenterEntity = "Datacenter";
    public static final String ClusterEntity = "ClusterComputeResource";
    public static final String VirtualMachineEntity = "VirtualMachine";
    public static final String HostsystemEntity = "HostSystem";
    public static final String VirtualAppEntity = "VirtualApp";
    public static int DEFAULT_HTTPS_PORT = 443;
    public static int DEFAULT_HTTP_PORT = 80;
    public static final int MIN_PORT = 0;
    public static final int MAX_PORT = 65535;
    public static final String SCVMM_2008 = "2008";
    public static final int VM_REATTEMPT_STARTUP_DELAY_MINS = 2;
    public static final String VMWARE_DETAILS = "vmware_details";
    private ConfigurationManager config;
    @NonNull
    private HostSystemUtils hostSystemUtils;
    @NonNull
    private VsanUtils vsanUtils;
    @NonNull
    private AuthHelper authHelper;
    @NonNull
    private VirtualisationStatusStore virtualisationStatusStore;
    @NonNull
    private VMWareConnection vmwareConnection;
    private AdvancedSetupHelper advancedSetupHelper;

    public VirtualConfigurationManager() {
        this(ServiceManager.getInstance().getConfigurationManager());
    }

    public VirtualConfigurationManager(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    public VirtualConfigurationManager setAdvancedSetupHelper(AdvancedSetupHelper advancedSetupHelper) {
        this.advancedSetupHelper = advancedSetupHelper;
        return this;
    }

    public void setServerIP(String string) {
        logger.debug("setServerIP() - Setting value to: {}", (Object)string);
        this.config.setProperty("HostDetails", "Server", string);
    }

    public int getServerPort(String string) {
        Integer n;
        Integer n2 = n = Integer.valueOf(string.equalsIgnoreCase("http") ? DEFAULT_HTTP_PORT : DEFAULT_HTTPS_PORT);
        if (this.config.containsKey("HostDetails", "Server_PORT")) {
            Integer n3 = null;
            try {
                n3 = this.config.getInt("HostDetails", "Server_PORT", n);
                if (n3 != DEFAULT_HTTP_PORT && n3 != DEFAULT_HTTPS_PORT && (n3 < 0 || n3 > 65535)) {
                    logger.debug("Port out of bounds. Setting port to: " + n);
                    n3 = n;
                }
                n2 = (int)n3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Illegal argumnent returned when trying to retrieve the port from the ini. Using: " + n, (Throwable)illegalArgumentException);
                n2 = n;
            }
            catch (Exception exception) {
                logger.error("Exception occured when trying to retrieve the port from the ini. Using: " + n, (Throwable)exception);
                n2 = n;
            }
        }
        return n2;
    }

    public Integer getESXiConfigMode() {
        logger.debug("getESXiConfigMode() - start");
        Integer n = 2;
        try {
            String string = null;
            if (this.config.containsKey("HostDetails", "ConfigurationMode")) {
                string = this.config.getString("HostDetails", "ConfigurationMode");
                if (string.equalsIgnoreCase("Managed")) {
                    n = 2;
                } else if (string.equalsIgnoreCase("Unmanaged")) {
                    n = 1;
                }
            }
        }
        catch (ConversionException conversionException) {
            logger.error("getESXiConfigMode() - ConversionException: " + String.valueOf((Object)conversionException));
        }
        catch (Exception exception) {
            logger.error("getESXiConfigMode() - Exception: " + String.valueOf(exception));
        }
        logger.debug("getESXiConfigMode() - end, result: {}", (Object)n);
        return n;
    }

    public String getESXiConfigMode(Integer n) {
        logger.debug("getESXiConfigMode() - start");
        String string = "";
        if (n.equals(1)) {
            string = "Unmanaged";
        } else if (n.equals(2)) {
            string = "Managed";
        }
        logger.debug("getESXiConfigMode() - end, result: {}", (Object)string);
        return string;
    }

    public boolean isWebClientPluginSupported() {
        return this.isWebClientPluginSupported(this.vmwareConnection.getVCenterConnection());
    }

    public boolean isWebClientPluginSupported(ServiceInstance serviceInstance) {
        AboutInfo aboutInfo;
        logger.debug("isWebClientPluginSupported() - start");
        boolean bl = false;
        if (serviceInstance != null && (aboutInfo = serviceInstance.getAboutInfo()) != null) {
            logger.debug("isWebClientPluginSupported() - AboutInfo apiVersion: {}, build: {}, version: {}", (Object)aboutInfo.apiVersion, (Object)aboutInfo.build, (Object)aboutInfo.version);
            int n = Utils.compareVersionNumbers(aboutInfo.apiVersion, MIN_VCENTER_VERSION_WEB_PLUGIN);
            bl = n == 0 ? Utils.compareVersionNumbers(aboutInfo.build, MIN_VCENTER_BUILD_WEB_PLUGIN) >= 0 : n > 0;
        }
        logger.debug("isWebClientPluginSupported() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isLegacyPluginSupported() {
        return this.isLegacyPluginSupported(this.vmwareConnection.getVCenterConnection());
    }

    public boolean isLegacyPluginSupported(ServiceInstance serviceInstance) {
        AboutInfo aboutInfo;
        logger.debug("isWebClientPluginSupported() - start");
        boolean bl = false;
        if (serviceInstance != null && (aboutInfo = serviceInstance.getAboutInfo()) != null) {
            logger.debug("isWebClientPluginSupported() - AboutInfo apiVersion: {}, build: {}, version: {}", (Object)aboutInfo.apiVersion, (Object)aboutInfo.build, (Object)aboutInfo.version);
            bl = true;
        }
        logger.debug("isWebClientPluginSupported() - end, result: {}", (Object)bl);
        return bl;
    }

    public VMWareDetails loadServerDetails() {
        VMWareDetails vMWareDetails = new VMWareDetails();
        logger.debug("loadServerDetails() - start");
        if (this.isESXi()) {
            String string = "";
            try {
                String string2;
                if (this.config.containsKey("HostDetails", "Server_Protocol")) {
                    string = this.config.getString("HostDetails", "Server_Protocol");
                    vMWareDetails.setProtocol(string);
                } else {
                    vMWareDetails.setProtocol(DEFAULT_PROTOCOL);
                }
                string = "";
                if (this.config.containsKey("HostDetails", "Server_PORT")) {
                    string = this.config.getString("HostDetails", "Server_PORT");
                    vMWareDetails.setPort(string);
                } else {
                    string = DEFAULT_PROTOCOL.equalsIgnoreCase(vMWareDetails.getProtocol()) ? "443" : "80";
                    vMWareDetails.setPort(string);
                }
                string = "";
                if (this.config.containsKey("HostDetails", "Server")) {
                    string = this.config.getString("HostDetails", "Server");
                    vMWareDetails.setServerIp(string);
                }
                boolean bl = this.config.getBoolean("HostDetails", "Skip_Cert_Check", false);
                vMWareDetails.setSkipCertCheck(bl);
                if (this.config.containsKey("HostConfigSettings", ConfigurationKeys.PLUGIN_TYPE)) {
                    string2 = this.config.getString("HostConfigSettings", ConfigurationKeys.PLUGIN_TYPE);
                    if (string2 != null && string2.equalsIgnoreCase(ConfigurationKeys.WEB_CLIENT_PLUGIN)) {
                        vMWareDetails.setVCenterWebPlugin(true);
                        vMWareDetails.setVCenterPlugin(false);
                    } else if (string2 != null && string2.equalsIgnoreCase(ConfigurationKeys.LEGACY_PLUGIN)) {
                        vMWareDetails.setVCenterWebPlugin(false);
                        vMWareDetails.setVCenterPlugin(true);
                    }
                }
                if (this.config.containsKey("HostDetails", "is_VCSA")) {
                    boolean bl2 = this.config.getBoolean("HostDetails", "is_VCSA");
                    vMWareDetails.setVCenterInstalledOnaVM(bl2);
                }
                if (this.config.containsKey("HostDetails", "hyperconverged_support")) {
                    string2 = this.config.getString("HostDetails", "hyperconverged_support");
                    HyperconvergedSupport hyperconvergedSupport = HyperconvergedSupport.fromINISetting(string2);
                    vMWareDetails.setHyperconvergedSupport(hyperconvergedSupport);
                }
            }
            catch (ConversionException conversionException) {
                logger.error("loadServerDetails() - ConversionException", (Throwable)conversionException);
            }
        }
        logger.debug("loadServerDetails() - end");
        return vMWareDetails;
    }

    public VMWareDetails loadVCenterServerDetails() {
        logger.debug("loadVCenterServerDetails() - start");
        VMWareDetails vMWareDetails = this.loadServerDetails();
        if (vMWareDetails != null) {
            vMWareDetails.setUsername(this.authHelper.getVCenterUser());
            vMWareDetails.setPassword(this.authHelper.getVCenterPassword());
        }
        logger.debug("loadVCenterServerDetails() - end");
        return vMWareDetails;
    }

    public VMWareDetails loadESXiHostServerDetails() {
        logger.debug("loadESXiHostServerDetails() - start");
        VMWareDetails vMWareDetails = this.loadServerDetails();
        if (vMWareDetails != null) {
            vMWareDetails.setUsername(this.authHelper.getEsxHostUser());
            vMWareDetails.setPassword(this.authHelper.getEsxHostPassword());
        }
        logger.debug("loadESXiHostServerDetails() - end");
        return vMWareDetails;
    }

    public void saveVMWareDetails(VMWareDetails vMWareDetails, boolean bl) {
        String string = "HostDetails";
        logger.debug("saveVMWareDetails() - start");
        if (vMWareDetails != null) {
            String string2 = this.getServerIP();
            if (string2 != null && !vMWareDetails.getServerIp().equals(string2)) {
                logger.debug("saveVMWareDetails() - changing vCenter Server IP");
                this.clearVCLSDetectedInCluster();
            }
            this.config.setProperty(string, "Server", vMWareDetails.getServerIp());
            this.config.setProperty(string, "Skip_Cert_Check", vMWareDetails.isSkipCertCheck());
            this.config.setProperty(string, "Server_Protocol", vMWareDetails.getProtocol());
            this.config.setProperty(string, "Server_PORT", vMWareDetails.getPort());
            if (bl) {
                this.setServerIP(vMWareDetails.getServerIp());
                this.authHelper.setVCenterPassword(vMWareDetails.getPassword());
                this.authHelper.setVCenterUser(vMWareDetails.getUsername());
                this.config.setProperty(string, "is_VCSA", vMWareDetails.isVCenterInstalledOnaVM());
                this.config.setProperty(string, "hyperconverged_support", vMWareDetails.getHyperconvergedSupport().getIniSetting());
            } else {
                this.authHelper.setEsxCredentials(vMWareDetails.getUsername(), vMWareDetails.getPassword());
                this.config.clearProperty(string, "is_VCSA");
            }
        }
        logger.debug("saveVMWareDetails() - end");
    }

    public boolean isVCSA() {
        boolean bl = false;
        logger.debug("isVCSA() - start");
        if (!this.isESXi() || !this.isManagedHost()) {
            logger.trace("isVCSA() - not ESXi & Managed, returning false");
            return bl;
        }
        try {
            if (this.config.containsKey("HostDetails", "is_VCSA")) {
                bl = this.config.getBoolean("HostDetails", "is_VCSA");
            }
        }
        catch (ConversionException conversionException) {
            logger.error("isVCSA() - ConversionException - " + String.valueOf((Object)conversionException));
        }
        logger.trace("isVCSA() - end, result: {}", (Object)bl);
        return bl;
    }

    public void removeISVCSAKey() {
        logger.debug("removeISVCSAKey() - start");
        if (this.config.containsKey("HostDetails", "is_VCSA")) {
            this.config.clearProperty("HostDetails", "is_VCSA");
        }
        logger.debug("removeISVCSAKey() - end");
    }

    public boolean isPluginEnabled() {
        boolean bl = false;
        logger.debug("isPluginEnabled() - start");
        if (this.config.containsKey("HostConfigSettings", ConfigurationKeys.ENABLE_PLUGIN)) {
            try {
                bl = this.config.getBoolean("HostConfigSettings", ConfigurationKeys.ENABLE_PLUGIN);
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
        }
        logger.debug("isPluginEnabled() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isWebClientPluginEnabled() {
        boolean bl = false;
        logger.debug("isWebClientPluginEnabled() - start");
        if (this.isPluginEnabled() && this.config.containsKey("HostConfigSettings", ConfigurationKeys.PLUGIN_TYPE)) {
            try {
                bl = ConfigurationKeys.WEB_CLIENT_PLUGIN.equalsIgnoreCase(this.config.getString("HostConfigSettings", ConfigurationKeys.PLUGIN_TYPE));
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
        }
        logger.debug("isWebClientPluginEnabled() - end, result: {}", (Object)bl);
        return bl;
    }

    public String getServerIP() {
        String string = null;
        if (this.config.containsKey("HostDetails", "Server")) {
            string = this.config.getString("HostDetails", "Server", string);
        }
        return string;
    }

    public boolean isSkipCertCheck() {
        boolean bl = false;
        if (this.config.containsKey("HostDetails", "Skip_Cert_Check")) {
            bl = this.config.getBoolean("HostDetails", "Skip_Cert_Check", bl);
        }
        return bl;
    }

    public boolean isManagedHost() {
        String string;
        boolean bl = false;
        if (this.config.containsKey("HostDetails", "ConfigurationMode") && (string = this.config.getString("HostDetails", "ConfigurationMode", "")).equalsIgnoreCase("Managed")) {
            bl = true;
        }
        return bl;
    }

    public boolean isManagedESXi() {
        return this.isESXi() && this.isManagedHost();
    }

    public boolean isManagedESXiOrNutanixAHV() {
        return this.isManagedESXi() || this.isNutanixAHV();
    }

    public boolean isHCISystem() {
        return this.isNutanixESXi() || this.isNutanixAHV() || this.isHyperflex();
    }

    public boolean isManagedHostOrNutanixAHV() {
        return this.isManagedHost() || this.isNutanixAHV();
    }

    public boolean isManagedHyperV() {
        return this.isHyperV() && this.isManagedHost();
    }

    public boolean isUnmanagedHyperV() {
        return this.isHyperV() && this.isUnmanagedHost();
    }

    public boolean isExecuteCommandFileAfterHostShutdownSupported() {
        boolean bl = false;
        if (this.isManagedHostOrNutanixAHV()) {
            bl = true;
            if (this.isESXi()) {
                bl = !this.isPCNSInstalledOnVMA();
            } else if (this.isHyperV()) {
                String string = SCVMM_2008;
                String string2 = this.getSCVVMMVersion();
                bl = !string.equalsIgnoreCase(string2);
            }
        }
        return bl;
    }

    public boolean isESXi() {
        boolean bl = false;
        String string = this.getVirtualInstallValue();
        if (string != null && string.trim().equalsIgnoreCase("VMWare")) {
            bl = true;
        }
        logger.trace("isESXI() - end, result: {}", (Object)bl);
        return bl;
    }

    public String getVirtualInstallValue() {
        String string = "";
        if (this.config.containsKey("Networking", "VirtualInstall")) {
            try {
                string = this.config.getString("Networking", "VirtualInstall");
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        return string;
    }

    public String getSCVVMMVersion() {
        String string = "";
        if (this.config.containsKey("Networking", "SCVMMVersion")) {
            try {
                string = this.config.getString("Networking", "SCVMMVersion");
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        return string;
    }

    public boolean isHyperV() {
        boolean bl = false;
        String string = this.getVirtualInstallValue();
        if (string != null && string.trim().equalsIgnoreCase("Hyper-V")) {
            bl = true;
        }
        return bl;
    }

    public boolean isPCNSInstalledOnVMA() {
        boolean bl = false;
        if (this.config.containsKey("Networking", "isPCNSonVM")) {
            logger.debug("isPCNSInstalledOnVMA() - key found in ini file");
            String string = this.config.getString("Networking", "isPCNSonVM", "");
            if (!string.isEmpty()) {
                bl = Boolean.valueOf(string);
            }
        } else if (this.isESXi()) {
            logger.debug("isPCNSInstalledOnVMA() - key not found, checking via ESXi serviceInstance");
            ServiceInstance serviceInstance = null;
            if (this.isManagedHost()) {
                serviceInstance = this.vmwareConnection.getVCenterConnection();
            } else if (this.isUnmanagedHost()) {
                serviceInstance = this.vmwareConnection.getESXiHostInstance();
            }
            if (serviceInstance != null) {
                HostSystem hostSystem = this.hostSystemUtils.getHostSystemOnWhichPCNSInstalled(serviceInstance);
                if (hostSystem != null) {
                    bl = true;
                }
                this.config.setProperty("Networking", "isPCNSonVM", String.valueOf(bl));
                logger.debug("isPCNSInstalledOnVMA() - setting key: {} to: {}", (Object)"isPCNSonVM", (Object)bl);
            } else {
                logger.debug("isPCNSInstalledOnVMA() - no serviceInstance");
            }
        } else if (this.isNutanixAHV()) {
            bl = this.isPCNSInstalledOnAVMOrHost();
        }
        logger.debug("isPCNSInstalledOnVMA() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isPCNSInstalledOnAVMOrHost() {
        logger.debug("isPCNSInstalledOnAVMOrHost() - start");
        String string = this.getLocalHostIP();
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            return this.isPCNSInstalledOnAVM(string) || this.isPCNSInstalledOnHost(string);
        }
        logger.error("isPCNSInstalledOnAVMOrHost() - unable to get the local IP address");
        return false;
    }

    public boolean isPCNSInstalledOnAVM() {
        return this.isPCNSInstalledOnAVM(this.getLocalHostIP());
    }

    private boolean isPCNSInstalledOnAVM(String string) {
        logger.debug("isPCNSInstalledOnAVM() - start, localIp: {}", (Object)string);
        boolean bl = false;
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            try {
                NutanixConnection nutanixConnection = NutanixService.getInstance().getClusterConnection();
                nutanixConnection.connect();
                bl = nutanixConnection.isIpVmIp(string);
                nutanixConnection.disconnect();
            }
            catch (IOException | IllegalArgumentException exception) {
                logger.debug("isPCNSInstalledOnAVM() - failed to determine if PCNS is installed on a vm: {}", (Object)exception.getMessage());
            }
        }
        logger.debug("isPCNSInstalledOnAVM() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isPCNSIntalledOnHostInList(List<Host> list) {
        return this.isPCNSIntalledOnHostInList(this.getLocalHostIP(), list);
    }

    private boolean isPCNSIntalledOnHostInList(String string, List<Host> list) {
        if (list == null || list.isEmpty() || StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        return list.stream().anyMatch(host -> string.equals(host.getIPAddress()));
    }

    private boolean isPCNSInstalledOnHost(String string) {
        List<Host> list;
        logger.debug("isPCNSInstalledOnHost() - start, localIp: {}", (Object)string);
        if (StringUtils.isNotEmpty((CharSequence)string) && (list = this.hostSystemUtils.getAhvHosts()) != null && !list.isEmpty()) {
            for (Host host : list) {
                if (!string.equals(host.getIPAddress())) continue;
                logger.debug("isPCNSInstalledOnHost() - PCNS installed on host");
                return true;
            }
        }
        logger.debug("isPCNSInstalledOnHost() - end, not installed on host");
        return false;
    }

    public boolean isSimplivity() {
        boolean bl = false;
        if (this.config.containsKey("HostDetails", "hyperconverged_support")) {
            bl = StringUtils.equalsIgnoreCase((CharSequence)this.config.getString("HostDetails", "hyperconverged_support"), (CharSequence)"simplivity");
        }
        logger.trace("isSimplivity() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isNutanixAHV() {
        boolean bl = false;
        String string = this.getVirtualInstallValue();
        if (string != null && string.trim().equalsIgnoreCase("Nutanix")) {
            bl = true;
        }
        logger.trace("isNutanixAHV() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isNutanixESXi() {
        boolean bl = false;
        boolean bl2 = this.isNutanixSupported();
        String string = this.getVirtualInstallValue();
        if (string != null && string.trim().equalsIgnoreCase("VMWare") && bl2) {
            bl = true;
        }
        logger.trace("isNutanixESXi() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isNutanixSupported() {
        boolean bl = false;
        if (this.config.containsKey("HostDetails", "hyperconverged_support")) {
            bl = StringUtils.contains((CharSequence)this.config.getString("HostDetails", "hyperconverged_support"), (CharSequence)"nutanix");
        }
        logger.trace("isNutanixSupported() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isHyperflex() {
        boolean bl = false;
        if (this.config.containsKey("HostDetails", "hyperconverged_support")) {
            bl = StringUtils.equalsIgnoreCase((CharSequence)this.config.getString("HostDetails", "hyperconverged_support"), (CharSequence)"hyperflex");
        }
        logger.trace("isHyperflex() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isVxRail() {
        boolean bl = false;
        if (this.config.containsKey("HostDetails", "hyperconverged_support")) {
            bl = StringUtils.equalsIgnoreCase((CharSequence)this.config.getString("HostDetails", "hyperconverged_support"), (CharSequence)"vxrail");
        }
        logger.trace("isVxRail() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isUnmanagedHost() {
        String string;
        boolean bl = false;
        if (this.config.containsKey("HostDetails", "ConfigurationMode") && (string = this.config.getString("HostDetails", "ConfigurationMode", "")).equalsIgnoreCase("Unmanaged")) {
            bl = true;
        }
        return bl;
    }

    private List<String> parseHostList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isESXi() || this.isHyperV() || this.isNutanixAHV()) {
            String string2 = "";
            if (this.config.containsKey(string, "hostlist")) {
                string2 = this.config.getString(string, "hostlist");
            }
            boolean bl = string2.contains("&");
            String[] stringArray = null;
            String[] stringArray2 = null;
            if (StringUtils.isNotBlank((CharSequence)string2) && (stringArray = hostPattern.split(string2)) != null) {
                for (String string3 : stringArray) {
                    if (bl) {
                        stringArray2 = outletPattern.split(string3);
                        arrayList.add(stringArray2[0]);
                        continue;
                    }
                    arrayList.add(string3);
                }
            }
        }
        return arrayList;
    }

    public List<String> parseHostListParameter(String string) {
        return this.vsanUtils.removeVsanTagsFromHostlist(this.parseHostList(string));
    }

    public List<String> parseHostListParameterWithVsanTags(String string) {
        return this.parseHostList(string);
    }

    public LinkedHashSet<String> getProtectedHosts(Event event) {
        logger.debug("getProtectedHosts() - event: {}", event != null ? event.getObjectId() : event);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.isManagedHost() || this.isNutanixAHV()) {
            linkedHashSet.addAll(this.getManagedProtectedHosts(event));
        } else {
            logger.debug("getProtectedHosts() - non-managed event");
            String string = this.getServerIP();
            if (string != null) {
                linkedHashSet.add(string);
            }
        }
        logger.debug("getProtectedHosts() - hosts: {}", linkedHashSet);
        return linkedHashSet;
    }

    private LinkedHashSet<String> getManagedProtectedHosts(Event event) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (event instanceof AdvancedGroupOutletEvent) {
            linkedHashSet.addAll(this.getOutletGroupProtectedHosts(event));
        } else if (event instanceof AdvancedGroupEvent) {
            linkedHashSet.addAll(this.getAdvancedGroupProtectedHosts(event));
        } else {
            logger.debug("getManagedProtectedHosts() - managed non-advanced event");
            List<String> list = this.parseHostListParameterWithVsanTags("HostConfigSettings");
            linkedHashSet.addAll(list);
        }
        return linkedHashSet;
    }

    private LinkedHashSet<String> getAdvancedGroupProtectedHosts(Event event) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        logger.debug("getAdvancedGroupProtectedHosts() - managed AdvancedGroupEvent");
        AdvancedGroupEvent advancedGroupEvent = (AdvancedGroupEvent)event;
        UPSSetup uPSSetup = this.advancedSetupHelper.readUPSSetupFromConfig(advancedGroupEvent.getGroup());
        if (uPSSetup != null) {
            linkedHashSet.addAll(uPSSetup.getHosts());
            if (uPSSetup.isVirtualHostsShutdownEnabled()) {
                List<UPSSetup> list = this.advancedSetupHelper.readUPSSetupsFromConfig();
                for (UPSSetup uPSSetup2 : list) {
                    if (uPSSetup2.getGroup() == uPSSetup.getGroup()) continue;
                    linkedHashSet.addAll(uPSSetup2.getHosts());
                }
            }
        }
        return linkedHashSet;
    }

    private LinkedHashSet<String> getOutletGroupProtectedHosts(Event event) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        AdvancedGroupOutletEvent advancedGroupOutletEvent = (AdvancedGroupOutletEvent)event;
        logger.debug("getManagedProtectedHosts() - managed AdvancedGroupOutletEvent");
        UPSSetup uPSSetup = this.advancedSetupHelper.readUPSSetupFromConfig(advancedGroupOutletEvent.getGroup());
        if (uPSSetup != null) {
            linkedHashSet.addAll(uPSSetup.getHosts(advancedGroupOutletEvent.getOutletNumber()));
        }
        return linkedHashSet;
    }

    public LinkedHashSet<String> getProtectedVirtualHostsWithVsanTags(Event event) {
        return this.getProtectedHosts(event);
    }

    public Set<String> getProtectedVirtualHosts(Event event) {
        return this.vsanUtils.removeVsanTagsFromSet(this.getProtectedHosts(event), this.isESXi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCriticalHost(ShutdownState shutdownState, String string) {
        logger.debug("isCriticalHost() - start");
        if (shutdownState.getCriticalShutdownTimersCount() != 0) {
            logger.debug("check for critical timers on the host");
            logger.debug("isCriticalHost() - seek Lock");
            Object object = shutdownState.getCriticalShutdownTimersLock();
            synchronized (object) {
                logger.debug("isCriticalHost() - got Lock");
                for (ShutdownTimer shutdownTimer : shutdownState.getCriticalShutdownTimersList()) {
                    Set<String> set = this.getProtectedVirtualHosts(shutdownTimer.getTriggerEvent());
                    if (set == null || !set.contains(string)) continue;
                    logger.debug("isCriticalHost() - host critical because of:" + String.valueOf(shutdownTimer.getTriggerEvent()));
                    return true;
                }
            }
            logger.debug("isCriticalHost() - free Lock");
        }
        logger.debug("isCriticalHost() - host not critical ");
        return false;
    }

    public void clearCriticalHosts(ShutdownState shutdownState, Set<String> set) {
        logger.debug("clearCriticalHosts() - start, hosts: {}", set);
        if (this.isManagedHost() || this.isNutanixAHV()) {
            LinkedHashSet<String> linkedHashSet = shutdownState.getClearedHostSet(set);
            for (String string : linkedHashSet) {
                if (!this.isCriticalHost(shutdownState, string)) {
                    this.virtualisationStatusStore.unlockHostForShutdown(string);
                    continue;
                }
                logger.debug("clearCriticalHosts() - not clearing critical host: {}", (Object)string);
            }
            if (this.isESXi()) {
                this.hostSystemUtils.triggerNormalVCenterAlarmEvent(linkedHashSet);
                if (this.isManagedHost() && this.advancedSetupHelper.isAdvancedShutdownMode() && this.isVsanFTTEnabled()) {
                    new VsanFaultToleranceThreshold(shutdownState, ServiceManager.getInstance()).checkGroupLockRemoval();
                }
            }
        }
        logger.debug("clearCriticalHosts() - end");
    }

    public boolean isVsanFTTEnabled() {
        boolean bl = false;
        try {
            if (this.config.containsKey("HostConfigSettings", "enable_vsan_ftt")) {
                logger.debug("isVsanFTTEnabled() - found key: {}", (Object)"enable_vsan_ftt");
                bl = this.config.getBoolean("HostConfigSettings", "enable_vsan_ftt", bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("isVsanFTTEnabled() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("isVsanFTTEnabled() - end, result: {}", (Object)bl);
        return bl;
    }

    public int getVsanFTTLevel() {
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", "vsan_ftt_level")) {
                logger.debug("getVsanFTTLevel() - found key: {}", (Object)"vsan_ftt_level");
                n = this.config.getInt("HostConfigSettings", "vsan_ftt_level", n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getVsanFTTLevel() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getVsanFTTLevel() - end, result: {}", (Object)n);
        return n;
    }

    public LinkedHashSet<String> getConfiguredHosts() {
        return this.getConfiguredHosts(null);
    }

    public LinkedHashSet<String> getConfiguredHosts(Integer n) {
        logger.debug("getConfiguredHosts() - start: {}", (Object)n);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.advancedSetupHelper.isAdvancedShutdownMode()) {
            List<UPSSetup> list;
            if (n == null) {
                list = this.advancedSetupHelper.readUPSSetupsFromConfig();
            } else {
                list = new ArrayList<UPSSetup>();
                list.add(this.advancedSetupHelper.readUPSSetupFromConfig(n));
            }
            for (UPSSetup uPSSetup : list) {
                linkedHashSet.addAll(this.vsanUtils.removeVsanTagsFromSet(uPSSetup.getHosts(), this.isESXi()));
            }
        } else {
            linkedHashSet.addAll(this.parseHostListParameter("HostConfigSettings"));
        }
        logger.debug("getConfiguredHosts() - end: {}", linkedHashSet);
        return linkedHashSet;
    }

    public List<String> getMappedHostsList() {
        ArrayList<String> arrayList = new ArrayList();
        if (this.advancedSetupHelper.isAdvancedShutdownMode()) {
            Map<String, MappedHost> map = this.advancedSetupHelper.readMappedHostsFromConfig();
            if (map != null) {
                for (String string : map.keySet()) {
                    arrayList.add(string);
                }
            }
        } else {
            arrayList = this.parseHostListParameter("HostConfigSettings");
        }
        return arrayList;
    }

    public boolean hasClusterActiveCriticalEvent(ShutdownState shutdownState) {
        logger.debug("hasClusterActiveCriticalEvent() - start");
        List<String> list = this.getMappedHostsList();
        Optional<String> optional = list.stream().filter(string -> shutdownState.checkIfCriticalEventActive((String)string)).findFirst();
        if (optional.isPresent()) {
            logger.debug("hasClusterActiveCriticalEvent() - critical event active for host: {}", (Object)optional.get());
            return true;
        }
        return false;
    }

    public boolean isClusterLocked() {
        logger.debug("isClusterLocked() - start");
        List<String> list = this.getMappedHostsList();
        Optional<String> optional = list.stream().filter(string -> this.virtualisationStatusStore.isHostLockedForShutdown((String)string)).findFirst();
        if (optional.isPresent()) {
            logger.debug("isClusterLocked() - host: {} locked for shutdown", (Object)optional.get());
            return true;
        }
        return false;
    }

    public boolean isCvmHostUnhealthy(List<String> list) {
        logger.debug("isCvmHostUnhealthy() - start");
        Optional<String> optional = list.stream().filter(string -> {
            String string2 = this.virtualisationStatusStore.getCvmName((String)string);
            if (string2 == null) {
                logger.debug("isCvmHostUnhealthy() - host {} has no Controller VM to power on, skipping", string);
                return false;
            }
            HostSystem hostSystem = this.hostSystemUtils.getHostSystem((String)string);
            if (!this.hostSystemUtils.isHostHealthy(hostSystem, (String)string, true)) {
                logger.debug("isCvmHostUnhealthy() - host {} is not healthy, cannot start Controller VM", string);
                return true;
            }
            return false;
        }).findAny();
        if (optional.isPresent()) {
            logger.debug("isCvmHostUnhealthy() - host: {} not healthy", (Object)optional.get());
            return true;
        }
        logger.debug("isCvmHostUnhealthy() - end, all hosts either healthy or not relevant for Controller VM startup");
        return false;
    }

    public boolean isCvmStartupEnabled(int n) {
        if (this.advancedSetupHelper.isAdvancedShutdownMode()) {
            return this.getBooleanAdvanced(n, "cvm_startup_enable");
        }
        return this.getBooleanGlobal("cvm_startup_enable");
    }

    public boolean isStartupWaitsForAllHostsOnlineEnabled() {
        boolean bl = false;
        try {
            if (this.config.containsKey("HostConfigSettings", "startup_waits_for_all_hosts_online")) {
                logger.debug("isStartupWaitsForAllHostsOnlineEnabled() - found key: {}", (Object)"startup_waits_for_all_hosts_online");
                bl = this.config.getBoolean("HostConfigSettings", "startup_waits_for_all_hosts_online", bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("isStartupWaitsForAllHostsOnlineEnabled() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("isStartupWaitsForAllHostsOnlineEnabled() - end, result: {}", (Object)bl);
        return bl;
    }

    public String getCompressedAddress(String string) throws UnknownHostException {
        string = InetAddress.getByName(string).getHostAddress();
        return string.replaceFirst("(^|:)(0+(:|$)){2,8}", "::");
    }

    public String getServerProtocol() {
        StringSetValidator stringSetValidator = new StringSetValidator(DEFAULT_PROTOCOL);
        stringSetValidator.add("http");
        stringSetValidator.add(DEFAULT_PROTOCOL);
        String string = DEFAULT_PROTOCOL;
        if (this.config.containsKey("HostDetails", "Server_Protocol")) {
            try {
                string = this.config.getString("HostDetails", "Server_Protocol", stringSetValidator);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)illegalArgumentException);
                string = DEFAULT_PROTOCOL;
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException);
                string = DEFAULT_PROTOCOL;
            }
        }
        return string;
    }

    public String getUPSConfigMode() {
        String string = null;
        if (this.config.containsKey("NetworkManagementCard", "mode")) {
            string = this.config.getString("NetworkManagementCard", "mode", string);
        }
        return string;
    }

    public boolean getApplyGlobal() {
        boolean bl = true;
        try {
            if (this.config.containsKey("HostConfigSettings", "apply_vm_settings_to_all_nmcs")) {
                logger.debug("getApplyGlobal() - found key");
                bl = this.config.getBoolean("HostConfigSettings", "apply_vm_settings_to_all_nmcs", bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error((Object)noSuchElementException);
        }
        logger.debug("getApplyGlobal() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean getBooleanGlobal(String string) {
        boolean bl = false;
        try {
            if (this.config.containsKey("HostConfigSettings", string)) {
                logger.debug("getBooleanGlobal() - found key: {}", (Object)string);
                bl = this.config.getBoolean("HostConfigSettings", string, bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error((Object)noSuchElementException);
        }
        logger.debug("getBooleanGlobal() - end, key: {}, result: {}", (Object)string, (Object)bl);
        return bl;
    }

    public boolean getBooleanAdvanced(int n, String string) {
        boolean bl = false;
        try {
            if (this.config.containsKey("advanced_ups_setup_" + n, string)) {
                logger.debug("getBooleanAdvanced() - found advanced: {} key: {}", (Object)n, (Object)string);
                bl = this.config.getBoolean("advanced_ups_setup_" + n, string, bl);
            } else if (this.config.containsKey("HostConfigSettings", string)) {
                logger.debug("getBooleanAdvanced() - found key: {}", (Object)string);
                bl = this.config.getBoolean("HostConfigSettings", string, bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error((Object)noSuchElementException);
        }
        logger.debug("getBooleanAdvanced() - end, key: {}, result: {}", (Object)string, (Object)bl);
        return bl;
    }

    public int getDurationGlobal(String string) {
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", string)) {
                logger.debug("getDurationGlobal() - found key: {}", (Object)string);
                n = this.config.getInt("HostConfigSettings", string, n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error((Object)noSuchElementException);
        }
        logger.debug("getDurationGlobal() - end, key: {}, result: {}", (Object)string, (Object)n);
        return n;
    }

    public int getDurationAdvanced(int n, String string) {
        int n2 = 0;
        try {
            if (this.config.containsKey("advanced_ups_setup_" + n, string)) {
                logger.debug("getDurationAdvanced() - found advanced: {} key: {}", (Object)n, (Object)string);
                n2 = this.config.getInt("advanced_ups_setup_" + n, string, n2);
            } else if (this.config.containsKey("HostConfigSettings", string)) {
                logger.debug("getDurationAdvanced() - found key: {}", (Object)string);
                n2 = this.config.getInt("HostConfigSettings", string, n2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error((Object)noSuchElementException);
        }
        logger.debug("getDurationAdvanced() - end, key: {}, result: {}", (Object)string, (Object)n2);
        return n2;
    }

    public HyperconvergedSupport getHyperconvergedSupportValueFromSession(HttpSession httpSession) {
        VMWareDetails vMWareDetails = (VMWareDetails)httpSession.getAttribute(VMWARE_DETAILS);
        HyperconvergedSupport hyperconvergedSupport = HyperconvergedSupport.NONE;
        if (vMWareDetails != null) {
            logger.debug("getHyperconvergedSupportValueFromSession() - details != null");
            hyperconvergedSupport = vMWareDetails.getHyperconvergedSupport();
        }
        logger.debug("getHyperconvergedSupportValueFromSession() - end, result: {}", (Object)hyperconvergedSupport);
        return hyperconvergedSupport;
    }

    public void setHyperconvergedSupport(HyperconvergedSupport hyperconvergedSupport) {
        this.config.setProperty("HostDetails", "hyperconverged_support", hyperconvergedSupport.getIniSetting());
    }

    public String getNetworkConfig() {
        String string = null;
        if (ServiceManager.getInstance().getConfigurationManager().containsKey("Networking", "NetworkConfig")) {
            string = ServiceManager.getInstance().getConfigurationManager().getString("Networking", "NetworkConfig", string);
        }
        return string;
    }

    public void setManagedHost(boolean bl) {
        logger.debug("setManagedHost() - {}", (Object)bl);
        if (bl) {
            this.config.setProperty("HostDetails", "ConfigurationMode", "Managed");
        } else {
            this.config.setProperty("HostDetails", "ConfigurationMode", "Unmanaged");
        }
    }

    public void removeServerIP() {
        this.config.clearProperty("HostDetails", "Server");
    }

    public boolean isHostInCurrentSetup(LinkedHashSet<String> linkedHashSet, String string) {
        boolean bl = false;
        if (linkedHashSet != null && linkedHashSet.size() > 0) {
            for (String string2 : linkedHashSet) {
                String string3 = this.getFQDNFromIP(string2);
                String string4 = this.getIPFromHostName(string2);
                logger.debug("isHostInCurrentSetup() - checking host: {}, config: {}, IP: {}, FQDN: {}", (Object)string, (Object)string2, (Object)string4, (Object)string3);
                if (string2 == null || !string2.equalsIgnoreCase(string) && !string.equalsIgnoreCase(string3) && !string.equalsIgnoreCase(string4)) continue;
                logger.debug("isHostInCurrentSetup() - host found in current setup");
                bl = true;
                break;
            }
        }
        return bl;
    }

    public String getIPFromHostName(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            logger.error((Object)unknownHostException);
            return string;
        }
    }

    public boolean isHostnameResolvable(String string) {
        boolean bl = true;
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            bl = false;
        }
        return bl;
    }

    public String getFQDNFromIP(String string) {
        String string2;
        String string3 = string;
        if (IPUtils.isValidIPAddress(string) && (string2 = HostNameLookUpTable.getInstance().lookUp(string)) != null) {
            string3 = string2;
        }
        return string3;
    }

    public void removeHostsFromConfig(List<String> list) {
        String string;
        if (!this.config.containsKey("HostConfigSettings", "hostlist")) {
            return;
        }
        String string2 = this.config.getString("HostConfigSettings", "hostlist");
        if (StringUtils.isBlank((CharSequence)string2)) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = string = stringTokenizer.nextToken();
            if (VsanUtils.isHostnameWithVsanTags(string)) {
                string3 = VsanUtils.removeVsanTagsFromHostname(string3);
            }
            if (list == null || list.contains(string3)) continue;
            stringBuilder.append(string);
            stringBuilder.append("|");
        }
        string = "";
        if (stringBuilder.length() > 0 && stringBuilder.lastIndexOf("|") != -1) {
            string = stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        this.config.setProperty("HostConfigSettings", "hostlist", string);
    }

    public void postHostsRemovedEvent(List<String> list) {
        logger.debug("postHostsRemovedEvent() - start");
        Vector<String> vector = new Vector<String>();
        for (String string : list) {
            vector.add(string);
        }
        try {
            String string = new VirtualizationFeaturesFormatter((Integer)98, vector).format(null);
            ServiceManager.getInstance().getApplicationErrorHandler().put(string);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error((Object)throwable);
        }
        logger.debug("postHostsRemovedEvent() - end");
    }

    public boolean isSkipMaintenanceModeEnabled() {
        boolean bl = false;
        try {
            if (this.config.containsKey("HostConfigSettings", "Skip_Maintenance_Mode")) {
                logger.debug("isSkipMaintenanceModeEnabled() - found key: {}", (Object)"Skip_Maintenance_Mode");
                bl = this.config.getBoolean("HostConfigSettings", "Skip_Maintenance_Mode", bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("isSkipMaintenanceModeEnabled() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("isSkipMaintenanceModeEnabled() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isCheckVcsaIpAddressEnabled() {
        boolean bl = true;
        try {
            if (this.config.containsKey("HostConfigSettings", "check_vcsa_ip_address")) {
                logger.debug("isCheckVcsaIpAddressEnabled() - found key: {}", (Object)"check_vcsa_ip_address");
                bl = this.config.getBoolean("HostConfigSettings", "check_vcsa_ip_address", bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("isCheckVcsaIpAddressEnabled() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("isCheckVcsaIpAddressEnabled() - end, result: {}", (Object)bl);
        return bl;
    }

    public int getMaintenanceModeTimeoutDuration() {
        int n = 0;
        try {
            if (this.config.containsKey("HostDetails", "Maintenance_Mode_Duration")) {
                logger.debug("getMaintenanceModeTimeoutDuration() - found key: {}", (Object)"Maintenance_Mode_Duration");
                n = this.config.getInt("HostDetails", "Maintenance_Mode_Duration", n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getMaintenanceModeTimeoutDuration() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getMaintenanceModeTimeoutDuration() - end, result: {}", (Object)n);
        return n;
    }

    public boolean isDelayMaintenanceModeEnabled() {
        boolean bl = false;
        try {
            if (this.config.containsKey("HostConfigSettings", "delay_maintenance_mode")) {
                logger.debug("isDelayMaintenanceModeEnabled() - found key: {}", (Object)"delay_maintenance_mode");
                bl = this.config.getBoolean("HostConfigSettings", "delay_maintenance_mode", bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("isDelayMaintenanceModeEnabled() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("isDelayMaintenanceModeEnabled() - end, result: {}", (Object)bl);
        return bl;
    }

    public int getVsanSyncDuration() {
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", "vsan_sync_timeout")) {
                logger.debug("getVsanSyncDuration() - found key: {}", (Object)"vsan_sync_timeout");
                n = this.config.getInt("HostConfigSettings", "vsan_sync_timeout", n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getVsanSyncDuration() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getVsanSyncDuration() - end, result: {}", (Object)n);
        return n;
    }

    public int getVsanSyncRetryLimit() {
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", "vsan_sync_retry_limit")) {
                logger.debug("getVsanSyncRetryLimit() - found key: {}", (Object)"vsan_sync_retry_limit");
                n = this.config.getInt("HostConfigSettings", "vsan_sync_retry_limit", n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getVsanSyncRetryLimit() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getVsanSyncRetryLimit() - end, result: {}", (Object)n);
        return n;
    }

    public void setDefaultVsanSyncRetryLimit() {
        if (!this.config.containsKey("HostConfigSettings", "vsan_sync_retry_limit")) {
            logger.debug("setDefaultVsanSyncRetryLimit() - setting default {}: {}", (Object)"vsan_sync_retry_limit", (Object)10);
            this.config.setProperty("HostConfigSettings", "vsan_sync_retry_limit", 10);
        }
    }

    public int getWitnessVmStartupDuration() {
        int n = 60;
        try {
            if (this.config.containsKey("HostConfigSettings", "witness_vm_startup_duration")) {
                logger.debug("getWitnessVmStartupDuration() - found key: {}", (Object)"witness_vm_startup_duration");
                n = this.config.getInt("HostConfigSettings", "witness_vm_startup_duration", n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getWitnessVmStartupDuration() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getWitnessVmStartupDuration() - end, result: {}", (Object)n);
        return n;
    }

    public void setDefaultWitnessVmStartupDuration() {
        if (!this.config.containsKey("HostConfigSettings", "witness_vm_startup_duration")) {
            logger.debug("setWitnessVmStartupDuration() - setting default {}: {}", (Object)"witness_vm_startup_duration", (Object)60);
            this.config.setProperty("HostConfigSettings", "witness_vm_startup_duration", 60);
        }
    }

    public int getApiTaskWaitTimeout() {
        int n = 30;
        try {
            if (this.config.containsKey("HostConfigSettings", "api_task_wait_timeout")) {
                logger.debug("getApiTaskWaitTimeout() - found key: {}", (Object)"api_task_wait_timeout");
                n = this.config.getInt("HostConfigSettings", "api_task_wait_timeout", n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getApiTaskWaitTimeout() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getApiTaskWaitTimeout() - end, result: {}", (Object)n);
        return n;
    }

    public int getHostRescanAllHbaDuration() {
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", "vm_startup_rescan_hba_duration")) {
                logger.debug("getHostRescanAllHbaDuration() - found key: {}", (Object)"vm_startup_rescan_hba_duration");
                n = this.config.getInt("HostConfigSettings", "vm_startup_rescan_hba_duration", n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getHostRescanAllHbaDuration() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getHostRescanAllHbaDuration() - end, result: {}", (Object)n);
        return n;
    }

    public void setDefaultHostRescanAllHbaDuration() {
        if (!this.config.containsKey("HostConfigSettings", "vm_startup_rescan_hba_duration")) {
            logger.debug("setDefaultHostRescanAllHbaDuration() - setting default {}: {}", (Object)"vm_startup_rescan_hba_duration", (Object)15);
            this.config.setProperty("HostConfigSettings", "vm_startup_rescan_hba_duration", 15);
        }
    }

    public int getDelayMaintenanceModeTimeout() {
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", "delay_maintenance_mode_timeout")) {
                logger.debug("getDelayMaintenanceModeTimeout() - found key: {}", (Object)"delay_maintenance_mode_timeout");
                n = this.config.getInt("HostConfigSettings", "delay_maintenance_mode_timeout", n);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getDelayMaintenanceModeTimeout() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getDelayMaintenanceModeTimeout() - end, result: {}", (Object)n);
        return n;
    }

    public void setVCLSDetectedInCluster() {
        this.config.setProperty("HostConfigSettings", "vcls_detected_on_cluster", true);
    }

    public void clearVCLSDetectedInCluster() {
        this.config.clearProperty("HostConfigSettings", "vcls_detected_on_cluster");
    }

    public boolean hasVCLSBeenDetectedOnCluster() {
        boolean bl = false;
        try {
            if (this.config.containsKey("HostConfigSettings", "vcls_detected_on_cluster")) {
                logger.debug("hasVCLSBeenDetectedOnCluster() - found key: {}", (Object)"vcls_detected_on_cluster");
                bl = this.config.getBoolean("HostConfigSettings", "vcls_detected_on_cluster");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("hasVCLSBeenDetectedOnCluster() - ", (Throwable)noSuchElementException);
        }
        logger.debug("hasVCLSBeenDetectedOnCluster() - end, result: {}", (Object)bl);
        return bl;
    }

    public int getDisableVClsDelay() {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(180);
        intRangeSetValidator.add(0, VMSettings.MAX_DISABLE_VCLS_DURATION);
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", "disable_vCLS_duration")) {
                logger.debug("getEnableRetreatModeDelay() - found key: {}", (Object)"disable_vCLS_duration");
                n = this.config.getInt("HostConfigSettings", "disable_vCLS_duration", intRangeSetValidator);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getEnableRetreatModeDelay() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getEnableRetreatModeDelay() - end, result: {}", (Object)n);
        return n;
    }

    public int getEnableVClsDelay() {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(180);
        intRangeSetValidator.add(0, VMSettings.MAX_ENABLE_VCLS_DURATION);
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", "enable_vCLS_duration")) {
                logger.debug("getEnableVClsDelay() - found key: {}", (Object)"enable_vCLS_duration");
                n = this.config.getInt("HostConfigSettings", "enable_vCLS_duration", intRangeSetValidator);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getEnableVClsDelay() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getEnableVClsDelay() - end, result: {}", (Object)n);
        return n;
    }

    public boolean getDisableHAOnShutdown() {
        boolean bl = true;
        try {
            if (this.config.containsKey("HostConfigSettings", "disable_ha_on_shutdown")) {
                logger.debug("getDelayRetreatModeTimeout() - found key: {}", (Object)"disable_ha_on_shutdown");
                bl = this.config.getBoolean("HostConfigSettings", "disable_ha_on_shutdown");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getDisableHAOnShutdown() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        return bl;
    }

    public int getDisableHADelay() {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(20);
        intRangeSetValidator.add(0, VMSettings.MAX_DISABLE_HA_DELAY);
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", "disable_ha_delay")) {
                logger.debug("getDisableHADelay() - found key: {}", (Object)"disable_ha_delay");
                n = this.config.getInt("HostConfigSettings", "disable_ha_delay", intRangeSetValidator);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getDisableHADelay() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getDisableHADelay() - end, result: {}", (Object)n);
        return n;
    }

    public int getEnableHADelay() {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(20);
        intRangeSetValidator.add(0, VMSettings.MAX_ENABLE_HA_DELAY);
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", "enable_ha_delay")) {
                logger.debug("getEnableHADelay() - found key: {}", (Object)"enable_ha_delay");
                n = this.config.getInt("HostConfigSettings", "enable_ha_delay", intRangeSetValidator);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getEnableHADelay() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("getEnableHADelay() - end, result: {}", (Object)n);
        return n;
    }

    public boolean isShutdownAllVsanVMsEnabled() {
        boolean bl = false;
        try {
            if (this.config.containsKey("HostConfigSettings", "shutdown_all_vsan_vms")) {
                logger.debug("isShutdownAllVsanVMsEnabled() - found key: {}", (Object)"shutdown_all_vsan_vms");
                bl = this.config.getBoolean("HostConfigSettings", "shutdown_all_vsan_vms", bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("isShutdownVsanVMsEnabled() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        logger.debug("isShutdownVsanVMsEnabled() - end, result: {}", (Object)bl);
        return bl;
    }

    public boolean isForceVAppShutdownEnabled(int n) {
        boolean bl = this.advancedSetupHelper.isAdvancedShutdownMode() ? this.getBooleanAdvanced(n, "force_VApp_shutdown") : this.getBooleanGlobal("force_VApp_shutdown");
        return bl;
    }

    public boolean isCustomTargetHostsEnabled(int n) {
        boolean bl = this.advancedSetupHelper.isAdvancedShutdownMode() ? this.getBooleanAdvanced(n, "enable_custom_target_vm_migration") : this.getBooleanGlobal("enable_custom_target_vm_migration");
        return bl;
    }

    public String getLocalHostIP() {
        String string = null;
        string = this.config.getString("Networking", "localHostAddress", "");
        return string;
    }

    public boolean isHostAvailable(String string, int n, long l, TimeUnit timeUnit) {
        boolean bl = false;
        logger.debug("isHostAvailable() - checking if host: {} listens on port: {}, with timeout: {} ms", (Object)string, (Object)n, (Object)timeUnit.toMillis(l));
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(string, n), (int)timeUnit.toMillis(l));
            bl = true;
        }
        catch (UnknownHostException unknownHostException) {
            logger.error("isHostAvailable() - unknown host: {} - error: {}", (Object)string, (Object)unknownHostException);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            logger.debug("isHostAvailable() - socket timeout for host: {}, port: {}", (Object)string, (Object)n);
        }
        catch (IOException iOException) {
            logger.error("isHostAvailable() - cannot reach host: {} - error: {}", (Object)string, (Object)iOException);
        }
        logger.debug("isHostAvailable() - Host: {}, Port: {}, Result: {}", (Object)string, (Object)n, (Object)bl);
        return bl;
    }

    public int getCvmStartupDuration(boolean bl, int n) {
        if (bl) {
            return this.getDurationAdvanced(n, "cvm_startup_duration");
        }
        return this.getDurationGlobal("cvm_startup_duration");
    }

    public int getCvmShutdownDuration(boolean bl, int n) {
        if (bl) {
            return this.getDurationAdvanced(n, "cvm_shutdown_duration");
        }
        return this.getDurationGlobal("cvm_shutdown_duration");
    }

    public int getClusterShutdownDuration(boolean bl, int n) {
        if (bl) {
            return this.getDurationAdvanced(n, "cluster_shutdown_duration");
        }
        return this.getDurationGlobal("cluster_shutdown_duration");
    }

    public int getClusterStartupDuration(boolean bl, int n) {
        if (bl) {
            return this.getDurationAdvanced(n, "cluster_startup_duration");
        }
        return this.getDurationGlobal("cluster_startup_duration");
    }

    public void saveClusterUuidToConfig(String string, String string2) {
        logger.debug("saveClusterUuidToConfig() - start");
        if (StringUtils.isBlank((CharSequence)string2)) {
            logger.debug("saveClusterUuidToConfig() - no cluster uuid provided");
            return;
        }
        if (StringUtils.isBlank((CharSequence)string) || !this.config.containsSection(string)) {
            logger.error("saveClusterUuidToConfig() - blank or not existing section key: {}", (Object)string);
            return;
        }
        logger.debug("saveClusterUuidToConfig() - adding Cluster UUID {} to section {}", (Object)string2, (Object)string);
        this.config.setProperty(string, "cluster_uuid", string2);
        logger.debug("saveClusterUuidToConfig() - end");
    }

    public String getClusterUuidFromConfig(String string) throws IllegalArgumentException {
        logger.debug("getClusterUuidFromConfig() - start");
        String string2 = null;
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.error("getClusterUuidFromConfig() - blank or not existing section key: {}", (Object)string);
            throw new IllegalArgumentException("section key cannot be blank");
        }
        if (this.config.containsKey(string, "cluster_uuid")) {
            logger.debug("getClusterUuidFromConfig() - getting Cluster UUID for section {}", (Object)string);
            string2 = this.config.getString(string, "cluster_uuid");
        } else {
            logger.debug("getClusterUuidFromConfig() - unable to get Cluster UUID from configuration, no value found for key {} in section {}", (Object)"cluster_uuid", (Object)string);
        }
        logger.debug("getClusterUuidFromConfig() - end");
        return string2;
    }

    public boolean isConfigWizardComplete() {
        return this.config.getBoolean("Networking", "ConfigComplete", false);
    }

    public void setConfigWizardComplete() {
        this.config.setProperty("Networking", "ConfigComplete", true);
    }

    public String getProxyUsername() {
        String string = null;
        if (this.config.containsKey("SoftwareUpdate", "username") && StringUtils.isNotBlank((CharSequence)(string = StringUtils.trim((String)this.config.getString("SoftwareUpdate", "username")))) && this.authHelper.isReady()) {
            String string2 = this.authHelper.getProxyUsername();
            LogUtils.logMessage("ProxyUserNameChangedIni", string2, string);
            this.authHelper.setProxyUsername(string);
            this.config.clearProperty("SoftwareUpdate", "username");
        }
        return StringUtils.isBlank(string) ? this.authHelper.getProxyUsername() : string;
    }

    public String getProxyPassword() {
        String string = null;
        if (this.config.containsKey("SoftwareUpdate", "password") && StringUtils.isNotBlank((CharSequence)(string = StringUtils.trim((String)this.config.getString("SoftwareUpdate", "password")))) && this.authHelper.isReady()) {
            LogUtils.logMessage("ProxyPasswordChangedIni");
            this.authHelper.setProxyPassword(string);
            this.config.clearProperty("SoftwareUpdate", "password");
        }
        return StringUtils.isBlank(string) ? this.authHelper.getProxyPassword() : string;
    }

    public String getEsxHostUsername() {
        String string = null;
        string = this.isManagedESXi() ? this.getVCenterUsername() : this.authHelper.getEsxHostUser();
        logger.debug("getEsxHostUsername: Found username: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public String getEsxHostPassword() {
        String string = null;
        string = this.isManagedESXi() ? this.getVCenterPassword() : this.authHelper.getEsxHostPassword();
        logger.debug("getEsxHostPassword: Found password: {}", (Object)StringUtils.isNotBlank((CharSequence)string));
        return string;
    }

    public String getVCenterUsername() {
        String string = null;
        if (this.config.containsKey("HostDetails", "vcenter_username") && StringUtils.isNotBlank((CharSequence)(string = StringUtils.trim((String)this.config.getString("HostDetails", "vcenter_username")))) && this.authHelper.isReady()) {
            String string2 = this.authHelper.getVCenterUser();
            LogUtils.logMessage("VcenterUserNameChangedIni", string2, string);
            this.authHelper.setVCenterUser(string);
            this.config.clearProperty("HostDetails", "vcenter_username");
        }
        return StringUtils.isBlank(string) ? this.authHelper.getVCenterUser() : string;
    }

    public String getVCenterPassword() {
        String string = null;
        if (this.config.containsKey("HostDetails", "vcenter_password") && StringUtils.isNotBlank((CharSequence)(string = StringUtils.trim((String)this.config.getString("HostDetails", "vcenter_password")))) && this.authHelper.isReady()) {
            LogUtils.logMessage("VcenterPasswordChangedIni");
            this.authHelper.setVCenterPassword(string);
            this.config.clearProperty("HostDetails", "vcenter_password");
        }
        return StringUtils.isBlank(string) ? this.authHelper.getVCenterPassword() : string;
    }

    public boolean areVCenterCredentialsSet() {
        String string = this.getVCenterUsername();
        String string2 = this.getVCenterPassword();
        return string != null && string2 != null;
    }

    public int getActualVCSAVMShutdownDuration() {
        int n = this.getDurationGlobal("VCSA_shutdown_duration");
        int n2 = this.getDurationGlobal("VMware_connect_timeout");
        int n3 = n - 2 * n2;
        logger.debug("getActualVCSAVMShutdownDuration() - vCSA shutdown duration reduced by two times the connect timeout ({}): {}", (Object)n2, (Object)n3);
        if (n3 < 1) {
            logger.debug("getActualVCSAVMShutdownDuration() - vCSA shutdown duration less than twice the connect timeout, returning INI value instead");
            n3 = n;
        }
        return n3;
    }

    public String getPCNSHostIp() {
        String string = null;
        if (this.config.containsKey("HostDetails", "pcns_host")) {
            string = this.config.getString("HostDetails", "pcns_host");
        }
        logger.debug("getPCNSHostIp() - PCNS Host Ip: {}", string);
        return string;
    }

    public void setPCNSHostIp(String string) {
        if (StringUtils.isNotBlank((CharSequence)string) && !string.equals(this.getPCNSHostIp())) {
            logger.info("setPCNSHostIp() - Setting PCNS Host IP: {}", (Object)string);
            this.config.setProperty("HostDetails", "pcns_host", string);
        }
    }

    public String getPCNSVmName() {
        String string = null;
        if (this.config.containsKey("HostDetails", "pcns_vm")) {
            string = this.config.getString("HostDetails", "pcns_vm");
        }
        logger.debug("getPCNSVmName() - PCNS VM Name: {}", string);
        return string;
    }

    public void setPCNSVmName(String string) {
        if (StringUtils.isNotBlank((CharSequence)string) && !string.equals(this.getPCNSVmName())) {
            logger.debug("setPCNSVmName() - Setting PCNS VM Name: {}", (Object)string);
            this.config.setProperty("HostDetails", "pcns_vm", string);
        } else {
            logger.debug("setPCNSVmName() - Not Setting, it hasnt changed");
        }
    }

    public String getProtocol() {
        String string;
        StringSetValidator stringSetValidator = this.getProtocolValidator();
        try {
            string = this.config.getString("Networking", "protocol", stringSetValidator);
        }
        catch (IllegalArgumentException | ConversionException throwable) {
            logger.error((Object)throwable);
            string = DEFAULT_PROTOCOL;
        }
        return string;
    }

    public StringSetValidator getProtocolValidator() {
        StringSetValidator stringSetValidator = new StringSetValidator(DEFAULT_PROTOCOL);
        stringSetValidator.add("http");
        stringSetValidator.add(DEFAULT_PROTOCOL);
        return stringSetValidator;
    }

    public int getHttpPort() {
        Integer n;
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator();
        intRangeSetValidator.add(80);
        intRangeSetValidator.add(8080);
        intRangeSetValidator.add(3052);
        intRangeSetValidator.add(5000, 32768);
        try {
            n = this.config.getInt("Networking", "httpPort", intRangeSetValidator);
        }
        catch (IllegalArgumentException | ConversionException throwable) {
            logger.error((Object)throwable);
            n = 3052;
        }
        if (n != null) {
            return n;
        }
        return 3052;
    }

    public int getHttpsPort() {
        Integer n;
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator();
        intRangeSetValidator.add(443);
        intRangeSetValidator.add(6547);
        intRangeSetValidator.add(5000, 32768);
        try {
            n = this.config.getInt("Networking", "httpsPort", intRangeSetValidator);
        }
        catch (IllegalArgumentException | ConversionException throwable) {
            logger.error((Object)throwable);
            n = 6547;
        }
        if (n != null) {
            return n;
        }
        return 6547;
    }

    public String getShutdownCommandFile(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't read from a blank ini section");
        }
        if (StringUtils.isBlank((CharSequence)string2)) {
            throw new IllegalArgumentException("Can't read from a blank ini key.");
        }
        String string3 = this.config.getString(string, string2);
        UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
        if (!userFilePathValidator.isValid(string3 = Normalizer.normalize(string3, Normalizer.Form.NFKC), true)) {
            logger.error("getShutdownCommandFile() - Invalid command file path detected at section {}, key {}: {}", (Object)string, (Object)string2, (Object)string3);
            throw new IllegalStateException("Shutdown command file path is not valid.");
        }
        return string3;
    }

    public int getShutdownDelay() {
        Integer n = 10;
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(10);
        intRangeSetValidator.add(0, 7200);
        try {
            n = this.config.getInt("Shutdown", "shutdownDelay", intRangeSetValidator);
        }
        catch (IllegalArgumentException | NoSuchElementException | ConversionException throwable) {
            logger.error((Object)throwable);
            n = 10;
        }
        return n;
    }

    public int getShutdownDuration() {
        Integer n = 10;
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(10);
        intRangeSetValidator.add(0, 7200);
        try {
            n = this.config.getInt("Shutdown", "shutdownCommandDuration", intRangeSetValidator);
        }
        catch (IllegalArgumentException | NoSuchElementException | ConversionException throwable) {
            logger.error((Object)throwable);
            n = 10;
        }
        if (n > 0) {
            n = (int)Math.ceil((double)n.intValue() / 60.0);
        }
        return n;
    }

    public boolean isIPv6() {
        String string = this.config.getString("Networking", "NetworkConfig");
        return StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"IPV6");
    }

    public boolean isIPv6Multicast() {
        String string = this.config.getString("Networking", "IPv6NetworkConfig");
        return StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"multicast");
    }

    public boolean isIPv6Unicast() {
        String string = this.config.getString("Networking", "IPv6NetworkConfig");
        return StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"unicast");
    }

    public int getClusterPrepareDuration(boolean bl, int n) {
        if (bl) {
            return this.getDurationAdvanced(n, "vsan_prepare");
        }
        return this.getDurationGlobal("vsan_prepare");
    }

    public int getClusterRecoveryDuration(boolean bl, int n) {
        if (bl) {
            return this.getDurationAdvanced(n, "vsan_recovery");
        }
        return this.getDurationGlobal("vsan_recovery");
    }

    public boolean isTurnOffUPS() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)this.config.getBoolean("Shutdown", "turnOffUps"), (boolean)false);
    }

    public boolean isTurnOffSog() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)this.config.getBoolean("Shutdown", "turnOffSOG"), (boolean)false);
    }

    @Generated
    public void setHostSystemUtils(@NonNull HostSystemUtils hostSystemUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setVsanUtils(@NonNull VsanUtils vsanUtils) {
        if (vsanUtils == null) {
            throw new IllegalArgumentException("vsanUtils is marked non-null but is null");
        }
        this.vsanUtils = vsanUtils;
    }

    @Generated
    public void setAuthHelper(@NonNull AuthHelper authHelper) {
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        this.authHelper = authHelper;
    }

    @Generated
    public void setVirtualisationStatusStore(@NonNull VirtualisationStatusStore virtualisationStatusStore) {
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtualisationStatusStore is marked non-null but is null");
        }
        this.virtualisationStatusStore = virtualisationStatusStore;
    }

    @Generated
    public void setVmwareConnection(@NonNull VMWareConnection vMWareConnection) {
        if (vMWareConnection == null) {
            throw new IllegalArgumentException("vmwareConnection is marked non-null but is null");
        }
        this.vmwareConnection = vMWareConnection;
    }
}

