/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.configurationmanagers;

import com.apcc.pcns.configservice.configurationmanagers.ConfigurationInitialisationException;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.oslogger.OperatingSystemEventLogger;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractConfigurationManager
implements ConfigurationManager {
    private static final Logger logger = LogManager.getLogger(AbstractConfigurationManager.class);
    public static final Integer RELOAD_REFRESH_DELAY = 1;
    public static final TimeUnit RELOAD_REFRESH_UNIT = TimeUnit.MINUTES;
    protected ConfigurationManager delegate = null;
    protected boolean autoLog = false;
    protected boolean autoSave;
    private Set<String> restrictedKeys = new HashSet<String>();
    protected ApplicationErrorHandler errorHandler = null;
    protected OperatingSystemEventLogger osLogger;

    public AbstractConfigurationManager() {
        this.restrictedKeys.add("KeystorePassword");
        this.restrictedKeys.add("password");
        this.restrictedKeys.add("PowerChuteKeystorePassword");
        this.restrictedKeys.add("ssh_keyfile_password");
        this.restrictedKeys.add("ssh_pasword");
        this.restrictedKeys.add("licensingActivationId");
        this.restrictedKeys.add("licensingProxyUsername");
        this.restrictedKeys.add("licensingProxyPassword");
    }

    protected boolean isRestrictedKey(String string) {
        return this.restrictedKeys.contains(string) || StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"SNMPv3_AUTH_PASSPHRASE_Profile_") || StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"SNMPv3_PRIV_PASSPHRASE_Profile_");
    }

    @Override
    public void setDelegate(ConfigurationManager configurationManager) {
        this.delegate = configurationManager;
    }

    @Override
    public ApplicationErrorHandler getApplicationErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setApplicationErrorHandler(ApplicationErrorHandler applicationErrorHandler) {
        this.errorHandler = applicationErrorHandler;
    }

    @Override
    public void setAutoLog(boolean bl) {
        this.autoLog = bl;
    }

    @Override
    public boolean isAutoLog() {
        return this.autoLog;
    }

    @Override
    public void setAutoSave(boolean bl) {
    }

    @Override
    public boolean isAutoSave() {
        return false;
    }

    @Override
    public void save() {
    }

    @Override
    public void setProperty(String string, String string2, Object object) {
    }

    @Override
    public boolean containsSection(String string) {
        return false;
    }

    @Override
    public boolean containsKey(String string, String string2) {
        return false;
    }

    @Override
    public void clearProperty(String string, String string2) {
    }

    @Override
    public void reload() {
    }

    @Override
    public int keyCount(String string, String string2) {
        return 0;
    }

    @Override
    public Set<String> getSections() {
        return new HashSet<String>();
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }

    public static String getKey(String string, String string2) {
        return string + "." + string2;
    }

    public static String getDebugString(String string, String string2) {
        return "Section: " + string + ", Key: " + string2;
    }

    public static String getDebugValue(Object object) {
        String string = "null";
        if (object != null) {
            string = object.toString();
        }
        return ", Value: " + string;
    }

    protected void logConfigException(ConfigurationException configurationException, boolean bl) {
        logger.fatal("Error initialising configuration file: ", (Throwable)configurationException);
        if (bl) {
            if (this.osLogger != null) {
                this.osLogger.fatal("OsLogger.ConfigurationFailure", "103", configurationException.getLocalizedMessage());
            }
            throw new ConfigurationInitialisationException((Throwable)configurationException);
        }
    }

    protected void logConfigException(ConfigurationException configurationException) {
        this.logConfigException(configurationException, true);
    }

    @Generated
    public void setOsLogger(OperatingSystemEventLogger operatingSystemEventLogger) {
        this.osLogger = operatingSystemEventLogger;
    }
}

