/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.configurationmanagers;

import com.apcc.pcns.configservice.InvalidIniEntryException;
import com.apcc.pcns.configservice.configurationmanagers.AbstractConfigurationManager;
import com.apcc.pcns.configservice.logging.ConfigurationBuilderEventListener;
import com.apcc.pcns.configservice.logging.ConfigurationErrorEventListener;
import com.apcc.pcns.configservice.logging.LoggingConfigurationListener;
import com.apcc.pcns.configservice.logging.ReloadingEventListener;
import com.apcc.pcns.configservice.validation.ConfigurationEntryValidator;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.reloading.PeriodicReloadingTrigger;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupConfigurationManager
extends AbstractConfigurationManager {
    private static final Logger logger = LogManager.getLogger(BackupConfigurationManager.class);
    private ReloadingFileBasedConfigurationBuilder<INIConfiguration> builder;

    public BackupConfigurationManager() {
        this("pcnsconfig_backup.ini");
    }

    public BackupConfigurationManager(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("fileName is marked non-null but is null");
        }
        logger.debug("Attempting to load config from file: " + string);
        PropertiesBuilderParameters propertiesBuilderParameters = (PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setFileName(string)).setThrowExceptionOnMissing(false)).setSynchronizer((Synchronizer)new ReadWriteSynchronizer((ReadWriteLock)new ReentrantReadWriteLock()))).setReloadingRefreshDelay(Long.valueOf(0L));
        this.builder = new ReloadingFileBasedConfigurationBuilder(INIConfiguration.class).configure(new BuilderParameters[]{propertiesBuilderParameters});
        this.builder.setAutoSave(false);
        try {
            ((INIConfiguration)this.builder.getConfiguration()).addEventListener(ConfigurationErrorEvent.ANY, (EventListener)new ConfigurationErrorEventListener(false));
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException, false);
        }
        PeriodicReloadingTrigger periodicReloadingTrigger = new PeriodicReloadingTrigger(this.builder.getReloadingController(), (Object)"PeriodicReloadCheck", (long)RELOAD_REFRESH_DELAY.intValue(), RELOAD_REFRESH_UNIT);
        periodicReloadingTrigger.start();
        this.builder.addEventListener(ConfigurationBuilderEvent.CONFIGURATION_REQUEST, (EventListener)new ConfigurationBuilderEventListener(this.builder.getReloadingController(), false));
        this.builder.getReloadingController().addEventListener(ReloadingEvent.ANY, (EventListener)new ReloadingEventListener(false));
        this.addEventListener(ConfigurationEvent.ANY, LoggingConfigurationListener.createBackupConfigurationListener());
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Iterator iterator = ((INIConfiguration)this.builder.getConfiguration()).getKeys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = ((INIConfiguration)this.builder.getConfiguration()).getProperty(string);
                hashMap.put(string, object);
            }
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        return hashMap;
    }

    @Override
    public void addProperties(Map<String, Object> map) {
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string = entry.getKey();
                String[] stringArray = string.split("\\.");
                this.setProperty(stringArray[0], stringArray[1], entry.getValue());
            }
            if (this.isAutoSave()) {
                this.save();
            }
        }
    }

    @Override
    public String getString(String string, String string2, String string3) {
        String string4 = null;
        String string5 = BackupConfigurationManager.getKey(string, string2);
        try {
            string4 = ((INIConfiguration)this.builder.getConfiguration()).getString(string5, string3);
            if (string4 != null) {
                string4 = Normalizer.normalize(string4.trim(), Normalizer.Form.NFKC);
            }
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        return string4;
    }

    @Override
    public Integer getInt(String string, String string2, Integer n) {
        Integer n2 = null;
        String string3 = BackupConfigurationManager.getKey(string, string2);
        try {
            n2 = ((INIConfiguration)this.builder.getConfiguration()).getInteger(string3, n);
        }
        catch (ConversionException conversionException) {
            logger.error("Unable to convert " + string + "." + string2 + " = " + string3 + " to an Integer");
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("conversion.failure", new Object[]{string, string2});
            }
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        return n2;
    }

    @Override
    public Boolean getBoolean(String string, String string2, Boolean bl) {
        Boolean bl2 = null;
        String string3 = BackupConfigurationManager.getKey(string, string2);
        try {
            bl2 = ((INIConfiguration)this.builder.getConfiguration()).getBoolean(string3, bl);
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        return bl2;
    }

    @Override
    public Boolean isEnabled(String string, String string2) {
        Boolean bl = null;
        try {
            bl = this.getBoolean(string, string2);
        }
        catch (NoSuchElementException | ConversionException throwable) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    @Override
    public String getString(String string, String string2) throws ConversionException {
        String string3 = null;
        String string4 = BackupConfigurationManager.getKey(string, string2);
        try {
            string3 = ((INIConfiguration)this.builder.getConfiguration()).getString(string4);
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (string3 != null) {
            string3 = Normalizer.normalize(string3.trim(), Normalizer.Form.NFKC);
        }
        return string3;
    }

    @Override
    public String getString(String string, String string2, Pattern pattern) throws InvalidIniEntryException, ConversionException {
        String string3 = this.getString(string, string2);
        if (pattern != null && string3 != null && !pattern.matcher(string3).matches()) {
            String string4 = this.getApplicationErrorHandler().formatMessage("regex.failure", new Object[]{string, string2});
            throw new InvalidIniEntryException(string4);
        }
        return string3;
    }

    @Override
    public Integer getInt(String string, String string2) throws ConversionException {
        Integer n = null;
        String string3 = BackupConfigurationManager.getKey(string, string2);
        try {
            n = ((INIConfiguration)this.builder.getConfiguration()).getInt(string3);
        }
        catch (ConversionException conversionException) {
            logger.error("Unable to convert " + string + "." + string2 + " = " + string3 + " to an Integer");
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("conversion.failure", new Object[]{string, string2});
            }
            throw conversionException;
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        return n;
    }

    @Override
    public Boolean getBoolean(String string, String string2) throws ConversionException {
        Boolean bl = null;
        String string3 = BackupConfigurationManager.getKey(string, string2);
        try {
            bl = ((INIConfiguration)this.builder.getConfiguration()).getBoolean(string3);
        }
        catch (ConversionException conversionException) {
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("conversion.failure", new Object[]{string, string2});
            }
            throw conversionException;
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("values is marked non-null but is null");
        }
        ReloadingFileBasedConfigurationBuilder<INIConfiguration> reloadingFileBasedConfigurationBuilder = this.builder;
        synchronized (reloadingFileBasedConfigurationBuilder) {
            logger.debug("setProperties(Map<String,Object>)");
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object object = entry.getValue();
                if (object == null) {
                    object = "";
                }
                if (!this.isRestrictedKey(entry.getKey())) {
                    logger.debug("setProperties(Map<String,Object>) - " + entry.getKey() + BackupConfigurationManager.getDebugValue(object));
                }
                try {
                    if (((INIConfiguration)this.builder.getConfiguration()).containsKey(entry.getKey())) {
                        ((INIConfiguration)this.builder.getConfiguration()).clearProperty(entry.getKey());
                    }
                    ((INIConfiguration)this.builder.getConfiguration()).addProperty(entry.getKey(), object);
                }
                catch (ConfigurationException configurationException) {
                    this.logConfigException(configurationException);
                }
            }
            if (this.isAutoSave()) {
                this.save();
            }
        }
        if (this.hasDelegate()) {
            this.delegate.setProperties(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String string, String string2, Object object) {
        ReloadingFileBasedConfigurationBuilder<INIConfiguration> reloadingFileBasedConfigurationBuilder = this.builder;
        synchronized (reloadingFileBasedConfigurationBuilder) {
            if (!this.isRestrictedKey(string2)) {
                logger.debug("setProperty(String,String,Object) - " + BackupConfigurationManager.getDebugString(string, string2) + BackupConfigurationManager.getDebugValue(object));
            }
            String string3 = BackupConfigurationManager.getKey(string, string2);
            try {
                if (((INIConfiguration)this.builder.getConfiguration()).containsKey(string3)) {
                    ((INIConfiguration)this.builder.getConfiguration()).clearProperty(string3);
                }
                ((INIConfiguration)this.builder.getConfiguration()).addProperty(string3, object);
            }
            catch (ConfigurationException configurationException) {
                this.logConfigException(configurationException);
            }
            if (this.isAutoSave()) {
                this.save();
            }
        }
        if (this.hasDelegate()) {
            this.delegate.setProperty(string, string2, object);
        }
    }

    @Override
    public boolean containsKey(String string, String string2) {
        boolean bl = false;
        try {
            bl = ((INIConfiguration)this.builder.getConfiguration()).containsKey(BackupConfigurationManager.getKey(string, string2));
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (!bl && this.hasDelegate()) {
            bl = this.delegate.containsKey(string, string2);
        }
        if (!this.isRestrictedKey(string2)) {
            logger.debug("containsKey(String,String) - " + BackupConfigurationManager.getDebugString(string, string2) + BackupConfigurationManager.getDebugValue(bl));
        }
        return bl;
    }

    @Override
    public boolean containsSection(String string) {
        boolean bl = false;
        try {
            bl = ((INIConfiguration)this.builder.getConfiguration()).getSections().contains(string);
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (!bl && this.hasDelegate()) {
            bl = this.delegate.containsSection(string);
        }
        logger.debug("containsSection - " + BackupConfigurationManager.getDebugString(string, "") + BackupConfigurationManager.getDebugValue(bl));
        return bl;
    }

    @Override
    public void clearProperty(String string, String string2) {
        String string3 = BackupConfigurationManager.getKey(string, string2);
        logger.debug("Clearing property for: " + string3);
        try {
            ((INIConfiguration)this.builder.getConfiguration()).clearProperty(string3);
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (this.isAutoSave()) {
            this.save();
        }
        if (this.hasDelegate()) {
            this.delegate.clearProperty(string, string2);
        }
    }

    @Override
    public void clearSection(String string) {
        logger.debug("Clearing section: " + string);
        try {
            ((INIConfiguration)this.builder.getConfiguration()).clearTree(string);
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (this.isAutoSave()) {
            this.save();
        }
        if (this.hasDelegate()) {
            this.delegate.clearSection(string);
        }
    }

    @Override
    public void reload() {
        this.builder.getReloadingController().checkForReloading(null);
        if (this.hasDelegate()) {
            this.delegate.reload();
        }
    }

    @Override
    public Set<String> getSections() {
        HashSet<String> hashSet = new HashSet();
        try {
            hashSet = ((INIConfiguration)this.builder.getConfiguration()).getSections();
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (this.hasDelegate()) {
            hashSet.addAll(this.delegate.getSections());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        ReloadingFileBasedConfigurationBuilder<INIConfiguration> reloadingFileBasedConfigurationBuilder = this.builder;
        synchronized (reloadingFileBasedConfigurationBuilder) {
            logger.debug("Attempting save of config");
            try {
                this.builder.save();
                this.builder.getReloadingController().getDetector().reloadingPerformed();
            }
            catch (ConfigurationException configurationException) {
                logger.error((Object)configurationException);
            }
        }
        if (this.hasDelegate()) {
            this.delegate.save();
        }
    }

    @Override
    public void setAutoSave(boolean bl) {
        logger.debug("Setting AutoSave to " + bl);
        this.autoSave = bl;
        if (this.hasDelegate()) {
            this.delegate.setAutoSave(bl);
        }
    }

    @Override
    public boolean isAutoSave() {
        return this.autoSave;
    }

    @Override
    public Set<String> getSectionKeys(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.containsSection(string)) {
            try {
                Configuration configuration = ((INIConfiguration)this.builder.getConfiguration()).subset(string);
                Iterator iterator = configuration.getKeys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    hashSet.add(string2);
                }
            }
            catch (ConfigurationException configurationException) {
                this.logConfigException(configurationException);
            }
        }
        if (this.hasDelegate()) {
            hashSet.addAll(this.delegate.getSectionKeys(string));
        }
        return hashSet;
    }

    @Override
    public String getString(String string, String string2, ConfigurationEntryValidator<String> configurationEntryValidator) throws IllegalArgumentException {
        return null;
    }

    @Override
    public Integer getInt(String string, String string2, ConfigurationEntryValidator<Integer> configurationEntryValidator) throws IllegalArgumentException {
        return null;
    }

    @Override
    public <T extends Event> void addEventListener(EventType<T> eventType, EventListener<? super T> eventListener) {
        this.builder.addEventListener(eventType, eventListener);
    }

    @Override
    public <T extends Event> boolean removeEventListener(EventType<T> eventType, EventListener<? super T> eventListener) {
        return this.builder.removeEventListener(eventType, eventListener);
    }

    @Override
    public <T extends Event> void addReloadingEventListener(EventType<T> eventType, EventListener<? super T> eventListener) {
        this.builder.getReloadingController().addEventListener(eventType, eventListener);
    }

    @Override
    public <T extends Event> boolean removeReloadingEventListener(EventType<T> eventType, EventListener<? super T> eventListener) {
        return this.builder.getReloadingController().removeEventListener(eventType, eventListener);
    }
}

