/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.configurationmanagers;

import com.apcc.pcns.configservice.InvalidIniEntryException;
import com.apcc.pcns.configservice.validation.ConfigurationEntryValidator;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConversionException;

public interface ConfigurationManager {
    public static final String INI_KEY = "iniFile";
    public static final String DEFAULT_INI_FILE = "pcnsconfig.ini";
    public static final String BACKUP_INI_FILE = "pcnsconfig_backup.ini";
    public static final String DEFAULT_M11_FILE = "m11.cfg";
    public static final String BACKUP_M11_FILE = "m11.bak";
    public static final String JAVA_VERSION_FILE = "javaVersionFile.log";
    public static final String PERIODIC_RELOAD_CHECK = "PeriodicReloadCheck";
    public static final String ACCESS_RELOAD_CHECK = "AccessReloadCheck";

    public Map<String, Object> getProperties();

    public void addProperties(Map<String, Object> var1);

    public void setDelegate(ConfigurationManager var1);

    public void setAutoSave(boolean var1);

    public boolean isAutoSave();

    public void save();

    public String getString(String var1, String var2) throws ConversionException;

    public String getString(String var1, String var2, String var3);

    public String getString(String var1, String var2, Pattern var3) throws InvalidIniEntryException, ConversionException;

    public String getString(String var1, String var2, ConfigurationEntryValidator<String> var3) throws IllegalArgumentException, ConversionException;

    public void setProperty(String var1, String var2, Object var3);

    public void setProperties(@NonNull Map<String, Object> var1);

    public Integer getInt(String var1, String var2) throws ConversionException, NoSuchElementException;

    public Integer getInt(String var1, String var2, Integer var3);

    public Integer getInt(String var1, String var2, ConfigurationEntryValidator<Integer> var3) throws IllegalArgumentException, ConversionException;

    public Boolean getBoolean(String var1, String var2) throws ConversionException, NoSuchElementException;

    public Boolean getBoolean(String var1, String var2, Boolean var3);

    public Boolean isEnabled(String var1, String var2);

    public boolean containsSection(String var1);

    public boolean containsKey(String var1, String var2);

    public <T extends Event> void addEventListener(EventType<T> var1, EventListener<? super T> var2);

    public <T extends Event> boolean removeEventListener(EventType<T> var1, EventListener<? super T> var2);

    public <T extends Event> void addReloadingEventListener(EventType<T> var1, EventListener<? super T> var2);

    public <T extends Event> boolean removeReloadingEventListener(EventType<T> var1, EventListener<? super T> var2);

    public void clearProperty(String var1, String var2);

    public void clearSection(String var1);

    public ApplicationErrorHandler getApplicationErrorHandler();

    public void setApplicationErrorHandler(ApplicationErrorHandler var1);

    public void setAutoLog(boolean var1);

    public boolean isAutoLog();

    public void reload();

    public Set<String> getSections();

    public int keyCount(String var1, String var2);

    public Set<String> getSectionKeys(String var1);
}

