/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.configurationmanagers;

import com.apcc.pcns.configservice.InvalidIniEntryException;
import com.apcc.pcns.configservice.configurationmanagers.AbstractConfigurationManager;
import com.apcc.pcns.configservice.logging.ConfigurationBuilderEventListener;
import com.apcc.pcns.configservice.logging.ConfigurationErrorEventListener;
import com.apcc.pcns.configservice.logging.LoggingConfigurationListener;
import com.apcc.pcns.configservice.logging.ReloadingEventListener;
import com.apcc.pcns.configservice.validation.ConfigurationEntryValidator;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.reloading.PeriodicReloadingTrigger;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationManagerImpl
extends AbstractConfigurationManager {
    private static final Logger logger = LogManager.getLogger(ConfigurationManagerImpl.class);
    private ReloadingFileBasedConfigurationBuilder<INIConfiguration> builder;

    public ConfigurationManagerImpl() {
        this(System.getProperty("iniFile", "pcnsconfig.ini"));
    }

    public ConfigurationManagerImpl(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("fileName is marked non-null but is null");
        }
        logger.debug("Attempting to load config from file: " + string);
        PropertiesBuilderParameters propertiesBuilderParameters = (PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)new Parameters().properties().setFileName(string)).setThrowExceptionOnMissing(false)).setSynchronizer((Synchronizer)new ReadWriteSynchronizer((ReadWriteLock)new ReentrantReadWriteLock()))).setReloadingRefreshDelay(Long.valueOf(0L))).setPrefixLookups(null);
        this.builder = new ReloadingFileBasedConfigurationBuilder(INIConfiguration.class).configure(new BuilderParameters[]{propertiesBuilderParameters});
        this.builder.setAutoSave(false);
        this.builder.addEventListener(ConfigurationErrorEvent.ANY, (EventListener)new ConfigurationErrorEventListener(true));
        PeriodicReloadingTrigger periodicReloadingTrigger = new PeriodicReloadingTrigger(this.builder.getReloadingController(), (Object)"PeriodicReloadCheck", (long)RELOAD_REFRESH_DELAY.intValue(), RELOAD_REFRESH_UNIT);
        periodicReloadingTrigger.start();
        this.builder.addEventListener(ConfigurationBuilderEvent.CONFIGURATION_REQUEST, (EventListener)new ConfigurationBuilderEventListener(this.builder.getReloadingController(), true));
        this.builder.getReloadingController().addEventListener(ReloadingEvent.ANY, (EventListener)new ReloadingEventListener(true));
        this.addEventListener(ConfigurationEvent.ANY, LoggingConfigurationListener.createMainConfigurationListener());
    }

    @Override
    public <T extends Event> void addReloadingEventListener(EventType<T> eventType, EventListener<? super T> eventListener) {
        this.builder.getReloadingController().addEventListener(eventType, eventListener);
        logger.debug("addReloadingEventListener {} {}", eventType, eventListener);
    }

    @Override
    public <T extends Event> boolean removeReloadingEventListener(EventType<T> eventType, EventListener<? super T> eventListener) {
        logger.debug("removeReloadingEventListener {} {}", eventType, eventListener);
        return this.builder.getReloadingController().removeEventListener(eventType, eventListener);
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Iterator iterator = ((INIConfiguration)this.builder.getConfiguration()).getKeys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = ((INIConfiguration)this.builder.getConfiguration()).getProperty(string);
                hashMap.put(string, object);
            }
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        return hashMap;
    }

    @Override
    public void addProperties(Map<String, Object> map) {
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string = entry.getKey();
                String[] stringArray = string.split("\\.");
                this.setProperty(stringArray[0], stringArray[1], entry.getValue());
            }
            if (this.isAutoSave()) {
                this.save();
            }
        }
    }

    @Override
    public void setAutoSave(boolean bl) {
        logger.debug("Setting AutoSave to " + bl);
        this.autoSave = bl;
        if (this.hasDelegate()) {
            this.delegate.setAutoSave(bl);
        }
    }

    @Override
    public boolean isAutoSave() {
        return this.autoSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        ReloadingFileBasedConfigurationBuilder<INIConfiguration> reloadingFileBasedConfigurationBuilder = this.builder;
        synchronized (reloadingFileBasedConfigurationBuilder) {
            logger.debug("Attempting save of config");
            try {
                this.builder.save();
                this.builder.getReloadingController().getDetector().reloadingPerformed();
            }
            catch (ConfigurationException configurationException) {
                logger.error((Object)configurationException);
            }
        }
        if (this.hasDelegate()) {
            this.delegate.save();
        }
    }

    @Override
    public String getString(String string, String string2) throws ConversionException {
        boolean bl = false;
        String string3 = null;
        try {
            String string4 = ConfigurationManagerImpl.getKey(string, string2);
            string3 = ((INIConfiguration)this.builder.getConfiguration()).getString(string4);
            if (!this.isRestrictedKey(string2)) {
                logger.debug("getString(String,String) - " + ConfigurationManagerImpl.getDebugString(string, string2) + ConfigurationManagerImpl.getDebugValue(string3));
            }
            if (string3 == null) {
                bl = true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = true;
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (bl && this.hasDelegate() && (string3 = this.delegate.getString(string, string2)) != null) {
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("invalid.usingother", new Object[]{string, string2, string3});
            }
            this.setProperty(string, string2, string3);
        }
        if (string3 != null) {
            string3 = Normalizer.normalize(string3.trim(), Normalizer.Form.NFKC);
        }
        return string3;
    }

    @Override
    public String getString(String string, String string2, String string3) {
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            string4 = ((INIConfiguration)this.builder.getConfiguration()).getString(ConfigurationManagerImpl.getKey(string, string2));
            if (StringUtils.isBlank((CharSequence)string4)) {
                bl = true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = true;
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (bl) {
            if (this.hasDelegate()) {
                try {
                    string4 = this.delegate.getString(string, string2);
                }
                catch (ConversionException conversionException) {
                    bl2 = true;
                }
                if (StringUtils.isBlank((CharSequence)string4)) {
                    bl2 = true;
                } else {
                    bl3 = true;
                }
            } else {
                bl2 = true;
            }
        }
        if (bl2) {
            string4 = string3;
            bl3 = true;
        }
        if (string4 != null) {
            string4 = Normalizer.normalize(string4.trim(), Normalizer.Form.NFKC);
        }
        if (bl3) {
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("invalid.usingother", new Object[]{string, string2, string4});
            }
            this.setProperty(string, string2, string4);
        }
        if (!this.isRestrictedKey(string2)) {
            logger.debug("getString(String,String,String) - " + ConfigurationManagerImpl.getDebugString(string, string2) + ConfigurationManagerImpl.getDebugValue(string4));
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("values is marked non-null but is null");
        }
        logger.debug("setProperties(Map<String,Object>)");
        boolean bl = false;
        ReloadingFileBasedConfigurationBuilder<INIConfiguration> reloadingFileBasedConfigurationBuilder = this.builder;
        synchronized (reloadingFileBasedConfigurationBuilder) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object object = entry.getValue();
                if (object == null) {
                    object = "";
                }
                if (!this.isRestrictedKey(entry.getKey())) {
                    logger.debug("setProperties(Map<String,Object>) - " + entry.getKey() + ConfigurationManagerImpl.getDebugValue(object));
                }
                try {
                    if (((INIConfiguration)this.builder.getConfiguration()).containsKey(entry.getKey())) {
                        Object object2 = ((INIConfiguration)this.builder.getConfiguration()).getProperty(entry.getKey());
                        if (object2.toString().equals(object.toString())) continue;
                        ((INIConfiguration)this.builder.getConfiguration()).setProperty(entry.getKey(), object);
                        bl = true;
                        continue;
                    }
                    ((INIConfiguration)this.builder.getConfiguration()).addProperty(entry.getKey(), object);
                    bl = true;
                }
                catch (ConfigurationException configurationException) {
                    this.logConfigException(configurationException);
                }
            }
            if (bl && this.isAutoSave()) {
                this.save();
            }
        }
        if (this.hasDelegate()) {
            this.delegate.setProperties(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String string, String string2, Object object) {
        ReloadingFileBasedConfigurationBuilder<INIConfiguration> reloadingFileBasedConfigurationBuilder = this.builder;
        synchronized (reloadingFileBasedConfigurationBuilder) {
            if (!this.isRestrictedKey(string2)) {
                logger.debug("setProperty(String,String,Object) - {}{}", (Object)ConfigurationManagerImpl.getDebugString(string, string2), (Object)ConfigurationManagerImpl.getDebugValue(object));
            }
            String string3 = ConfigurationManagerImpl.getKey(string, string2);
            boolean bl = false;
            if (object == null) {
                object = "";
            }
            try {
                if (((INIConfiguration)this.builder.getConfiguration()).containsKey(string3)) {
                    Object object2 = ((INIConfiguration)this.builder.getConfiguration()).getProperty(string3);
                    if (object2 == null) {
                        object2 = "";
                    }
                    if (!StringUtils.equals((CharSequence)object2.toString(), (CharSequence)object.toString())) {
                        logger.debug("setProperty() - change ");
                        ((INIConfiguration)this.builder.getConfiguration()).setProperty(string3, object);
                        bl = true;
                    } else {
                        logger.debug("setProperty() - unchanged ");
                    }
                } else {
                    logger.debug("setProperty() - add ");
                    ((INIConfiguration)this.builder.getConfiguration()).addProperty(string3, object);
                    bl = true;
                }
            }
            catch (ConfigurationException configurationException) {
                this.logConfigException(configurationException);
            }
            catch (Exception exception) {
                logger.error("setProperty() - exception ", (Throwable)exception);
                throw exception;
            }
            if (bl && this.isAutoSave()) {
                this.save();
            }
        }
        if (this.hasDelegate()) {
            logger.debug("setProperty() - delegate {}", object);
            this.delegate.setProperty(string, string2, object);
        }
    }

    @Override
    public Integer getInt(String string, String string2) throws ConversionException {
        Integer n = null;
        boolean bl = false;
        String string3 = null;
        try {
            string3 = ConfigurationManagerImpl.getKey(string, string2);
            n = ((INIConfiguration)this.builder.getConfiguration()).getInt(string3);
            logger.debug("getInt(String,String) - " + ConfigurationManagerImpl.getDebugString(string, string2) + ConfigurationManagerImpl.getDebugValue(n));
        }
        catch (ConversionException conversionException) {
            if (this.hasDelegate()) {
                bl = true;
            }
            logger.error("Unable to convert " + string + "." + string2 + " = " + string3 + " to an Integer");
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("conversion.failure", new Object[]{string, string2});
            }
            throw conversionException;
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.hasDelegate()) {
                bl = true;
            }
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("key.missing", new Object[]{string, string2});
            }
            throw noSuchElementException;
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (bl && this.hasDelegate() && (n = this.delegate.getInt(string, string2)) != null) {
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("invalid.usingother", new Object[]{string, string2, n});
            }
            this.setProperty(string, string2, n);
        }
        return n;
    }

    @Override
    public Integer getInt(String string, String string2, Integer n) {
        Integer n2 = null;
        boolean bl = false;
        String string3 = null;
        try {
            string3 = ConfigurationManagerImpl.getKey(string, string2);
            n2 = ((INIConfiguration)this.builder.getConfiguration()).getInt(string3);
        }
        catch (ConversionException conversionException) {
            bl = true;
            logger.error("Unable to convert " + string + "." + string2 + " = " + string3 + " to an Integer");
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("conversion.failure", new Object[]{string, string2});
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.hasDelegate()) {
                bl = true;
            } else {
                if (this.isAutoLog()) {
                    this.getApplicationErrorHandler().put("key.missing", new Object[]{string, string2});
                }
                n2 = n;
            }
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (bl) {
            if (this.hasDelegate()) {
                try {
                    n2 = this.delegate.getInt(string, string2);
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    n2 = n;
                }
                if (n2 != null) {
                    this.setProperty(string, string2, n2);
                } else {
                    n2 = n;
                }
            } else {
                n2 = n;
                this.setProperty(string, string2, n2);
            }
        }
        logger.debug("getInt(String,String,Integer) - " + ConfigurationManagerImpl.getDebugString(string, string2) + ConfigurationManagerImpl.getDebugValue(n2));
        return n2;
    }

    @Override
    public boolean containsKey(String string, String string2) {
        boolean bl = false;
        try {
            bl = ((INIConfiguration)this.builder.getConfiguration()).containsKey(ConfigurationManagerImpl.getKey(string, string2));
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (!bl && this.hasDelegate()) {
            bl = this.delegate.containsKey(string, string2);
        }
        if (!this.isRestrictedKey(string2)) {
            logger.debug("containsKey(String,String) - " + ConfigurationManagerImpl.getDebugString(string, string2) + ConfigurationManagerImpl.getDebugValue(bl));
        }
        return bl;
    }

    @Override
    public boolean containsSection(String string) {
        boolean bl = false;
        try {
            bl = ((INIConfiguration)this.builder.getConfiguration()).getSections().contains(string);
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (!bl && this.hasDelegate()) {
            bl = this.delegate.containsSection(string);
        }
        logger.debug("containsSection - " + ConfigurationManagerImpl.getDebugString(string, "") + ConfigurationManagerImpl.getDebugValue(bl));
        return bl;
    }

    @Override
    public Boolean getBoolean(String string, String string2) throws ConversionException, NoSuchElementException {
        Boolean bl = null;
        boolean bl2 = false;
        try {
            String string3 = ConfigurationManagerImpl.getKey(string, string2);
            bl = ((INIConfiguration)this.builder.getConfiguration()).getBoolean(string3);
            logger.debug("getBoolean(String,String) - " + ConfigurationManagerImpl.getDebugString(string, string2) + ConfigurationManagerImpl.getDebugValue(bl));
        }
        catch (ConversionException conversionException) {
            if (this.hasDelegate()) {
                bl2 = true;
            }
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("conversion.failure", new Object[]{string, string2});
            }
            throw conversionException;
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.hasDelegate()) {
                bl2 = true;
            }
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("key.missing", new Object[]{string, string2});
            }
            throw noSuchElementException;
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (bl2 && this.hasDelegate() && (bl = this.delegate.getBoolean(string, string2)) != null) {
            this.setProperty(string, string2, bl);
        }
        return bl;
    }

    @Override
    public Boolean isEnabled(String string, String string2) {
        Boolean bl = null;
        try {
            bl = this.getBoolean(string, string2);
        }
        catch (NoSuchElementException | ConversionException throwable) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    @Override
    public Boolean getBoolean(String string, String string2, Boolean bl) {
        Boolean bl2 = null;
        boolean bl3 = false;
        try {
            String string3 = ConfigurationManagerImpl.getKey(string, string2);
            bl2 = ((INIConfiguration)this.builder.getConfiguration()).getBoolean(string3, bl);
            if (!((INIConfiguration)this.builder.getConfiguration()).containsKey(string3)) {
                bl3 = true;
            }
        }
        catch (ConversionException conversionException) {
            if (this.isAutoLog()) {
                this.getApplicationErrorHandler().put("conversion.failure", new Object[]{string, string2});
            }
            bl3 = true;
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.hasDelegate()) {
                bl3 = true;
            } else {
                if (this.isAutoLog()) {
                    this.getApplicationErrorHandler().put("key.missing", new Object[]{string, string2});
                }
                bl2 = bl;
            }
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (bl3) {
            if (this.hasDelegate()) {
                try {
                    bl2 = this.delegate.getBoolean(string, string2);
                }
                catch (ConversionException conversionException) {
                    bl2 = bl;
                }
                catch (NoSuchElementException noSuchElementException) {
                    bl2 = bl;
                }
                if (bl2 != null) {
                    this.setProperty(string, string2, bl2);
                } else {
                    bl2 = bl;
                }
            } else {
                bl2 = bl;
            }
        }
        logger.debug("getBoolean(String,String,boolean) - " + ConfigurationManagerImpl.getDebugString(string, string2) + ConfigurationManagerImpl.getDebugValue(bl2));
        return bl2;
    }

    @Override
    public void clearProperty(String string, String string2) {
        String string3 = ConfigurationManagerImpl.getKey(string, string2);
        logger.debug("Clearing property for: " + string3);
        try {
            ((INIConfiguration)this.builder.getConfiguration()).clearProperty(string3);
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (this.isAutoSave()) {
            this.save();
        }
        if (this.hasDelegate()) {
            this.delegate.clearProperty(string, string2);
        }
    }

    @Override
    public void clearSection(String string) {
        logger.debug("Clearing section: " + string);
        try {
            ((INIConfiguration)this.builder.getConfiguration()).clearTree(string);
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (this.isAutoSave()) {
            this.save();
        }
        if (this.hasDelegate()) {
            this.delegate.clearSection(string);
        }
    }

    @Override
    public String getString(String string, String string2, Pattern pattern) throws InvalidIniEntryException, ConversionException {
        String string3 = this.getString(string, string2);
        if (pattern != null && string3 != null && !pattern.matcher(string3).matches()) {
            String string4 = this.getApplicationErrorHandler().formatMessage("regex.failure", new Object[]{string, string2});
            throw new InvalidIniEntryException(string4);
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        return string3;
    }

    @Override
    public void reload() {
        this.builder.getReloadingController().checkForReloading(null);
        if (this.hasDelegate()) {
            this.delegate.reload();
        }
    }

    @Override
    public Set<String> getSections() {
        HashSet<String> hashSet = new HashSet();
        try {
            hashSet = ((INIConfiguration)this.builder.getConfiguration()).getSections();
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        if (this.hasDelegate()) {
            hashSet.addAll(this.delegate.getSections());
        }
        return hashSet;
    }

    @Override
    public int keyCount(String string, String string2) {
        int n = 0;
        try {
            Object object = ((INIConfiguration)this.builder.getConfiguration()).getProperty(ConfigurationManagerImpl.getKey(string, string2));
            if (object == null) {
                n = 0;
            } else if (object instanceof List) {
                List list = (List)object;
                n = list.size();
            } else {
                n = 1;
            }
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        return n;
    }

    @Override
    public Set<String> getSectionKeys(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.containsSection(string)) {
            try {
                Configuration configuration = ((INIConfiguration)this.builder.getConfiguration()).subset(string);
                Iterator iterator = configuration.getKeys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    hashSet.add(string2);
                }
            }
            catch (ConfigurationException configurationException) {
                this.logConfigException(configurationException);
            }
        }
        if (this.hasDelegate()) {
            hashSet.addAll(this.delegate.getSectionKeys(string));
        }
        return hashSet;
    }

    @Override
    public String getString(String string, String string2, ConfigurationEntryValidator<String> configurationEntryValidator) throws IllegalArgumentException, ConversionException {
        if (string == null || string2 == null || configurationEntryValidator == null) {
            logger.warn("Invalid argument passed.");
            throw new IllegalArgumentException("Invalid value passed.");
        }
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        string3 = this.getString(string, string2);
        logger.debug("INI contains (" + string3 + ") for " + string + ", " + string2);
        if (!configurationEntryValidator.isValid(string3)) {
            bl = true;
            bl3 = true;
        }
        if (bl) {
            if (this.hasDelegate()) {
                logger.debug("Main INI value is invalid.  Checking Backup.");
                string3 = this.delegate.getString(string, string2);
                logger.debug("Backup INI contains (" + string3 + ") for " + string + ", " + string2);
                if (configurationEntryValidator.isValid(string3)) {
                    logger.debug("Backup value is valid.  Using value of " + string3);
                    if (this.isAutoLog()) {
                        this.getApplicationErrorHandler().put("invalid.usingother", new Object[]{string, string2, string3});
                    }
                    bl3 = true;
                } else {
                    bl2 = true;
                    bl3 = true;
                }
            } else {
                bl2 = true;
                bl3 = true;
            }
        }
        if (bl2) {
            if (configurationEntryValidator.hasDefault()) {
                string3 = configurationEntryValidator.getDefault();
                logger.debug("Backup INI value is invalid.  Using default of " + string3);
                if (this.isAutoLog()) {
                    this.getApplicationErrorHandler().put("invalid.usingother", new Object[]{string, string2, string3});
                }
                bl3 = true;
            } else {
                string3 = null;
                logger.debug("Backup INI value is invalid. No default set. Using null");
                if (this.isAutoLog()) {
                    this.getApplicationErrorHandler().put("invalid.value", new Object[]{string, string2});
                }
                bl3 = true;
            }
        }
        if (string3 != null) {
            string3 = string3.trim();
        }
        if (bl3) {
            this.setProperty(string, string2, string3);
        }
        return string3;
    }

    @Override
    public Integer getInt(String string, String string2, ConfigurationEntryValidator<Integer> configurationEntryValidator) {
        if (string == null || string2 == null || configurationEntryValidator == null) {
            logger.warn("Invalid argument passed.");
            throw new IllegalArgumentException("Invalid value passed.");
        }
        Integer n = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            n = this.getInt(string, string2);
        }
        catch (NoSuchElementException | ConversionException throwable) {
            bl = true;
            bl3 = true;
        }
        logger.debug("INI contains (" + n + ") for " + string + ", " + string2);
        if (!configurationEntryValidator.isValid(n)) {
            bl = true;
            bl3 = true;
        }
        if (bl) {
            if (this.hasDelegate()) {
                logger.debug("Main INI value is invalid.  Checking Backup.");
                try {
                    n = this.delegate.getInt(string, string2);
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    n = null;
                }
                logger.debug("Backup INI contains (" + n + ") for " + string + ", " + string2);
                if (configurationEntryValidator.isValid(n)) {
                    logger.debug("Backup value is valid.  Using value of " + n);
                    if (this.isAutoLog()) {
                        this.getApplicationErrorHandler().put("invalid.usingother", new Object[]{string, string2, n});
                    }
                    bl3 = true;
                } else {
                    bl2 = true;
                    bl3 = true;
                }
            } else {
                bl2 = true;
                bl3 = true;
            }
        }
        if (bl2) {
            if (configurationEntryValidator.hasDefault()) {
                n = configurationEntryValidator.getDefault();
                logger.debug("Backup INI value is invalid.  Using default of " + n);
                if (this.isAutoLog()) {
                    this.getApplicationErrorHandler().put("invalid.usingother", new Object[]{string, string2, n});
                }
                bl3 = true;
            } else {
                n = null;
                logger.debug("Backup INI value is invalid. No default set. Using null");
                if (this.isAutoLog()) {
                    this.getApplicationErrorHandler().put("invalid.value", new Object[]{string, string2});
                }
                bl3 = false;
            }
        }
        if (bl3) {
            this.setProperty(string, string2, n);
        }
        return n;
    }

    @Override
    public <T extends Event> void addEventListener(EventType<T> eventType, EventListener<? super T> eventListener) {
        this.builder.addEventListener(eventType, eventListener);
        logger.info("addEventListener {} {}", eventType, eventListener);
    }

    @Override
    public <T extends Event> boolean removeEventListener(EventType<T> eventType, EventListener<? super T> eventListener) {
        boolean bl = false;
        try {
            bl = ((INIConfiguration)this.builder.getConfiguration()).removeEventListener(eventType, eventListener);
        }
        catch (ConfigurationException configurationException) {
            this.logConfigException(configurationException);
        }
        logger.info("removeEventListener {} {}", eventType, eventListener);
        return bl;
    }
}

