/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.configurationmanagers;

import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class M11ConfigurationManager
implements IPermanentStorage {
    private static final Logger logger = LogManager.getLogger(M11ConfigurationManager.class);
    private Hashtable<String, Object> config;

    public M11ConfigurationManager() {
        this.config = new Hashtable();
    }

    public M11ConfigurationManager(@NonNull File file) throws ClassNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        this.loadFromFile(file);
    }

    public boolean getObfuscate() {
        return false;
    }

    public Object readData(@NonNull ComponentID componentID, @NonNull String string) throws StorageEntryException {
        if (componentID == null) {
            throw new IllegalArgumentException("component is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("item is marked non-null but is null");
        }
        String string2 = componentID.getID() + "." + string;
        Object object = null;
        if (!this.config.containsKey(string2)) {
            throw new StorageEntryException("Value not found for key:: " + string2);
        }
        object = this.config.get(string2);
        return object;
    }

    public Object readData(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        return this.config.get(string);
    }

    public void removeData(@NonNull ComponentID componentID, @NonNull String string) throws StorageEntryException {
        if (componentID == null) {
            throw new IllegalArgumentException("component is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("item is marked non-null but is null");
        }
        String string2 = componentID.getID() + "." + string;
        this.config.remove(string2);
    }

    public void setObfuscate(boolean bl) throws StorageEntryException {
    }

    public void writeData(@NonNull ComponentID componentID, @NonNull String string, Object object) throws StorageEntryException {
        if (componentID == null) {
            throw new IllegalArgumentException("component is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("item is marked non-null but is null");
        }
        String string2 = componentID.getID() + "." + string;
        this.config.put(string2, object);
    }

    public void writeData(@NonNull String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        this.config.put(string, object);
    }

    public void loadFromFile(@NonNull File file) throws IOException, ClassNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("source is marked non-null but is null");
        }
        logger.debug("loadFromFile() - File: {}", (Object)file);
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Source M11 file doesn't exist, or can't be read");
        }
        try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));){
            this.config = (Hashtable)objectInputStream.readObject();
            logger.debug("loadFromFile() - Read contents of m11 file.");
        }
        catch (IOException | ClassNotFoundException exception) {
            logger.error("loadFromFile() - Exception: ", (Throwable)exception);
            throw exception;
        }
        logger.debug("loadFromFile() - end");
    }

    public void saveToFile(@NonNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("destination is marked non-null but is null");
        }
        logger.debug("saveToFile() - File: {}", (Object)file);
        if (file.exists() && !file.canWrite()) {
            throw new IllegalArgumentException("Destination m11 file can not be written to.");
        }
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));){
            objectOutputStream.writeObject(this.config);
        }
        catch (IOException iOException) {
            logger.error("saveToFile() - Exception: ", (Throwable)iOException);
            throw iOException;
        }
    }
}

