/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.logging;

import lombok.NonNull;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.reloading.ReloadingController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationBuilderEventListener
implements EventListener<ConfigurationBuilderEvent> {
    private static final Logger logger = LogManager.getLogger(ConfigurationBuilderEventListener.class);
    private boolean source;
    private ReloadingController controller;

    public ConfigurationBuilderEventListener(@NonNull ReloadingController reloadingController, boolean bl) {
        if (reloadingController == null) {
            throw new IllegalArgumentException("controller is marked non-null but is null");
        }
        this.source = bl;
        this.controller = reloadingController;
    }

    public void onEvent(ConfigurationBuilderEvent configurationBuilderEvent) {
        boolean bl = this.controller.checkForReloading((Object)"AccessReloadCheck");
        if (this.source) {
            logger.debug("INI reload needed: {}, {}", (Object)bl, (Object)configurationBuilderEvent);
        } else {
            logger.debug("Backup INI reload needed: {}, {}", (Object)bl, (Object)configurationBuilderEvent);
        }
    }
}

