/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.logging;

import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingConfigurationListener
implements EventListener<ConfigurationEvent> {
    private static final Logger logger = LogManager.getLogger(LoggingConfigurationListener.class);
    private static final String MAIN = "Main";
    private static final String BACKUP = "Backup";
    private String source;

    public static LoggingConfigurationListener createMainConfigurationListener() {
        return new LoggingConfigurationListener(MAIN);
    }

    public static LoggingConfigurationListener createBackupConfigurationListener() {
        return new LoggingConfigurationListener(BACKUP);
    }

    private LoggingConfigurationListener(String string) {
        this.source = string;
    }

    public void onEvent(ConfigurationEvent configurationEvent) {
        if (!configurationEvent.isBeforeUpdate()) {
            if (MAIN.equals(this.source)) {
                logger.info("{} INI Configuration Change.  Type: {}, {} : {}", (Object)this.source, (Object)configurationEvent.getEventType(), (Object)configurationEvent.getPropertyName(), configurationEvent.getPropertyValue());
            } else {
                logger.debug("{} INI Configuration Change.  Type: {}, {} : {}", (Object)this.source, (Object)configurationEvent.getEventType(), (Object)configurationEvent.getPropertyName(), configurationEvent.getPropertyValue());
            }
        }
    }
}

