/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.tasks;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.autoupdate.AutoUpdateComponent;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.components.webserver.util.virtualization.VMPrioritizationUtils;
import com.apcc.m11.ds.events.flexevents.EnvironmentalEvents;
import com.apcc.m11.ds.events.flexevents.EventLists;
import com.apcc.m11.ds.events.flexevents.RESTEvents;
import com.apcc.m11.ds.events.flexevents.RuntimeVerifierEvents;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.WebServerEvents;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import com.apcc.m11.ds.events.flexevents.powersource.Bypass;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.m11.ds.events.flexevents.powersource.LoadCapability;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.events.flexevents.powersource.Redundancy;
import com.apcc.m11.ds.events.flexevents.powersource.Temperature;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.licensing.ILicensingUtils;
import com.apcc.pcns.serviceaware.InitializationAdapter;
import com.apcc.pcns.threadpool.ThreadService;
import com.apcc.pcns.util.CountdownTimer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationValidationTask
extends InitializationAdapter
implements Runnable {
    private static final int MAX_SIMPLIVITY_OVCS = 20;
    private static final Logger logger = LogManager.getLogger(ConfigurationValidationTask.class);
    private List<String> sectionList = new ArrayList<String>();
    public static final Integer DEFAULT_HTTPS_PORT = 443;
    public static final Integer DEFAULT_HTTP_PORT = 80;
    public static final String MAXIMUM = "maixmum";
    public static final String MINIMUM = "minimum";
    private int errorCount = 0;
    @NonNull
    private VirtualConfigurationManager virtualConfigurationManager;
    @NonNull
    private AdvancedSetupHelper advancedSetupHelper;
    @NonNull
    private VMPrioritizationUtils vmPrioritizationUtils;
    @NonNull
    private UserFilePathValidator userFilePathValidator;
    @NonNull
    private ThreadService threadPool;
    @NonNull
    private ConfigurationManager config;
    @NonNull
    private ApplicationErrorHandler errorHandler;
    @NonNull
    private ILicensingUtils licensingUtils;

    public ConfigurationValidationTask() {
        this.userFilePathValidator = new UserFilePathValidator();
    }

    public ConfigurationValidationTask(@NonNull VirtualConfigurationManager virtualConfigurationManager, @NonNull AdvancedSetupHelper advancedSetupHelper, @NonNull VMPrioritizationUtils vMPrioritizationUtils, @NonNull ThreadService threadService, @NonNull ConfigurationManager configurationManager, @NonNull ApplicationErrorHandler applicationErrorHandler) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfig is marked non-null but is null");
        }
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        if (vMPrioritizationUtils == null) {
            throw new IllegalArgumentException("vmPrioritizationUtils is marked non-null but is null");
        }
        if (threadService == null) {
            throw new IllegalArgumentException("threadPool is marked non-null but is null");
        }
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("errorHandler is marked non-null but is null");
        }
        this.errorHandler = applicationErrorHandler;
        this.config = configurationManager;
        this.virtualConfigurationManager = virtualConfigurationManager;
        this.advancedSetupHelper = advancedSetupHelper;
        this.vmPrioritizationUtils = vMPrioritizationUtils;
        this.userFilePathValidator = new UserFilePathValidator();
        this.threadPool = threadService;
    }

    @Override
    public void start() {
        this.threadPool.schedule(this, 1, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        if (this.virtualConfigurationManager == null) {
            logger.error("Configuration Utils has not been set, creating a local copy");
            this.virtualConfigurationManager = new VirtualConfigurationManager();
        }
        logger.debug("run() - start");
        this.errorCount = 0;
        boolean bl = this.virtualConfigurationManager.isConfigWizardComplete();
        while (!bl) {
            logger.debug("waiting for cfg complete");
            new CountdownTimer(5L, TimeUnit.SECONDS).await(this);
            bl = this.virtualConfigurationManager.isConfigWizardComplete();
        }
        logger.debug("Running Configuration Validation task.");
        this.checkSections();
        this.checkNMCSection();
        this.checkEventLogSection();
        this.checkShutdownSection();
        this.checkNetworkingSection();
        this.checkEventSection();
        this.checkSoftwareUpdateSection();
        this.checkSNMPSection();
        this.checkVirtualisation();
        this.checkAdvancedConfiguration();
        this.checkSSHActions();
        this.checkSimplivity();
        this.checkHyperflex();
        this.checkVxRail();
        this.checkDeadlockDetector();
        this.checkCEIP();
        this.checkLicensing();
        if (this.errorCount > 5) {
            logger.error("Lots of config errors, making a backup of the config file");
            File file = new File("pcnsconfig.ini");
            try {
                logger.error(" full path:" + file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.error(" Exists:" + file.exists());
            logger.error(" Readable:" + file.canRead());
            logger.error(" Writeable:" + file.canWrite());
            Date date = new Date();
            File file2 = new File("pcnsconfig.ini." + date.getTime() + ".faulty");
            try {
                Files.copy(file.toPath(), file2.toPath(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                logger.error("unable to make a backup", (Throwable)iOException);
            }
        }
        logger.debug("run() - end");
    }

    private void checkAdvancedConfiguration() {
        if (this.advancedSetupHelper.isAdvancedShutdownMode()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add("setup_name");
            arrayList.add("ip_addresses");
            arrayList.add("ups_required_for_load");
            arrayList.add("shutdownCommandFileEnabled");
            arrayList.add("shutdownCommandFileDuration");
            arrayList.add("shutdownOnLostRedundancy");
            arrayList.add("turnOffUps");
            arrayList.add("turnOffSOG");
            arrayList2.add("delay_maintenance_mode");
            arrayList2.add("delay_maintenance_mode_timeout");
            arrayList2.add("shutdownCommandFile");
            arrayList2.add("force_VApp_shutdown");
            arrayList2.add("enable_guest_vm_migration");
            arrayList2.add("guest_vm_migration_duration");
            arrayList2.add("enable_custom_target_vm_migration");
            arrayList2.add("custom_target_hosts");
            arrayList2.add("executeCommandFileAfterHostShutdown");
            arrayList2.add("shutdownCommandFileDelay");
            arrayList2.add("enable_guest_vm_vapp_shutdown");
            arrayList2.add("guest_vm_vapp_shutdown_duration");
            arrayList2.add("enable_guest_vm_vapp_startup");
            arrayList2.add("guest_vm_vapp_startup_duration");
            arrayList2.add("hostlist");
            arrayList2.add("shutdownPowerchuteServer");
            arrayList2.add("ShutdownVirtualHosts");
            arrayList2.add("VCSA_shutdown_duration");
            arrayList2.add(ConfigurationKeys.ENABLE_PLUGIN);
            arrayList2.add("enable_host_maintenance");
            arrayList2.add("host_maintenance_duration");
            arrayList2.add("enable_host_shutdown");
            arrayList2.add("host_shutdown_duration");
            arrayList2.add("delay_before_vmstartup");
            arrayList2.add("vm_startup_delay_duration");
            arrayList2.add("vsan_sync_timeout");
            arrayList2.add("enable_vCLS_duration");
            arrayList2.add("disable_vCLS_duration");
            arrayList2.add("disable_ha_on_shutdown");
            arrayList2.add("disable_ha_delay");
            arrayList2.add("enable_ha_delay");
            arrayList2.add("autostart_delay");
            arrayList2.add("vsan_prepare");
            arrayList2.add("vsan_recovery");
            this.addNutanixVMSettingsToList(arrayList2);
            this.addSimplivitySettings(arrayList2);
            arrayList.addAll(this.getSSHActionConfigured());
            for (int i = 0; i < this.advancedSetupHelper.getGroupCount(); ++i) {
                String string = "advanced_ups_setup_" + i;
                this.processSection(string, arrayList, arrayList2);
                if (this.config.containsKey("advanced_ups_setup_" + i, "hostlist")) {
                    if (this.virtualConfigurationManager.isNutanixAHV()) {
                        this.validateNutanixAHVKeys("advanced_ups_setup_" + i);
                    } else if (this.virtualConfigurationManager.isNutanixESXi()) {
                        this.validateNutanixESXiKeys("advanced_ups_setup_" + i);
                    }
                }
                this.validateShutdownCommandPath(string);
                this.validateVCLSDuration();
                this.validateHADelays();
                this.validateVsanClusterDurations(i);
            }
        }
    }

    private void checkVirtualisation() {
        logger.debug("checkVirtualisation");
        String string = "";
        try {
            string = this.config.getString("Networking", "VirtualInstall");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((CharSequence)string)) {
            Object object;
            String string2 = "Unmanaged";
            if (this.config.containsKey("HostDetails", "ConfigurationMode")) {
                string2 = this.config.getString("HostDetails", "ConfigurationMode", "Unmanaged");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("ConfigurationMode");
            arrayList2.add("Server");
            arrayList2.add("vcenter_username");
            arrayList2.add("vcenter_password");
            arrayList2.add("pcns_host");
            arrayList2.add("pcns_vm");
            if (this.virtualConfigurationManager.isHyperV() || this.virtualConfigurationManager.isNutanixAHV()) {
                arrayList2.add("Skip_Cert_Check");
            } else {
                arrayList.add("Skip_Cert_Check");
            }
            if (string.equalsIgnoreCase("VMWare")) {
                arrayList.add("Server_Protocol");
                arrayList.add("Server_PORT");
                if ("Managed".equalsIgnoreCase(string2)) {
                    arrayList.add("is_VCSA");
                    arrayList2.add("Skip_Maintenance_Mode");
                    arrayList2.add("hyperconverged_support");
                }
            }
            if (this.config.containsSection("HostDetails")) {
                this.processSection("HostDetails", arrayList, arrayList2);
                this.checkServerProtocolValue();
                this.checkServerPortValue();
            }
            if (this.virtualConfigurationManager.isNutanixAHV() || this.virtualConfigurationManager.isNutanixESXi()) {
                object = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ((ArrayList)object).add("Cluster_Ip");
                ((ArrayList)object).add("Nutanix_Cluster_Username");
                ((ArrayList)object).add("AHV_Username");
                arrayList3.add("SSH_Key_Path");
                arrayList3.add("AFS_VMs");
                arrayList3.add("CVM_IPs");
                arrayList3.add("CVM_Names");
                if (this.config.containsSection("NutanixClusterDetails")) {
                    this.processSection("NutanixClusterDetails", (List<String>)object, arrayList3);
                    this.checkUsername("AHV_Username", "root");
                    this.checkUsername("Nutanix_Cluster_Username", "nutanix");
                    this.validateNutanixSSHKeyPaths("NutanixClusterDetails");
                }
            }
            arrayList = new ArrayList();
            arrayList2 = new ArrayList();
            arrayList2.add("isPCNSonVM");
            object = this.config.getString("Networking", "VirtualInstall", "none");
            if (this.advancedSetupHelper.isAdvancedShutdownMode()) {
                arrayList2.add("single_ups_groups_only");
                arrayList2.add("apply_vm_settings_to_all_nmcs");
            }
            if (((String)object).equalsIgnoreCase("Hyper-V")) {
                if ("Managed".equalsIgnoreCase(string2)) {
                    arrayList.add("enable_host_maintenance");
                    arrayList.add("host_maintenance_duration");
                    arrayList.add("enable_host_shutdown");
                    arrayList.add("host_shutdown_duration");
                    if (!this.advancedSetupHelper.isAdvancedShutdownMode()) {
                        arrayList2.add("hostlist");
                    }
                } else {
                    arrayList.add("enable_hvstopcluster");
                    arrayList.add("hvstopcluster_duration");
                    arrayList.add("hvstartcluster_duration");
                    arrayList.add("custom_target_hosts");
                    arrayList.add("enable_custom_target_vm_migration");
                    arrayList.add("enable_guest_vm_migration");
                    arrayList.add("guest_vm_migration_duration");
                    arrayList.add("enable_guest_vm_vapp_shutdown");
                    arrayList.add("guest_vm_vapp_shutdown_duration");
                    arrayList.add("enable_guest_vm_vapp_startup");
                    arrayList.add("guest_vm_vapp_startup_duration");
                    arrayList.add("vm_prioritization_enabled");
                    arrayList2.add("vm_startup_delay_duration");
                    this.checkVMPrioritizationSection(false);
                }
            } else if (((String)object).equalsIgnoreCase("VMWare")) {
                arrayList2.add("VMware_connect_timeout");
                arrayList2.add("VMware_read_timeout");
                arrayList2.add("api_task_wait_timeout");
                if ("Managed".equalsIgnoreCase(string2)) {
                    if (!this.advancedSetupHelper.isAdvancedShutdownMode()) {
                        arrayList2.add("hostlist");
                        arrayList.add("enable_custom_target_vm_migration");
                        arrayList.add("custom_target_hosts");
                    }
                    arrayList.add("enable_guest_vm_migration");
                    arrayList.add("guest_vm_migration_duration");
                    arrayList.add("enable_guest_vm_vapp_shutdown");
                    arrayList.add("guest_vm_vapp_shutdown_duration");
                    arrayList.add("enable_guest_vm_vapp_startup");
                    arrayList.add("guest_vm_vapp_startup_duration");
                    arrayList.add("force_VApp_shutdown");
                    arrayList.add("delay_maintenance_mode");
                    arrayList.add("delay_maintenance_mode_timeout");
                    arrayList2.add("vcls_detected_on_cluster");
                    arrayList2.add("enable_vCLS_duration");
                    arrayList2.add("disable_vCLS_duration");
                    arrayList2.add("disable_ha_on_shutdown");
                    arrayList2.add("disable_ha_delay");
                    arrayList2.add("enable_ha_delay");
                    arrayList2.add("autostart_delay");
                    arrayList2.add("vm_startup_delay_duration");
                    arrayList2.add("delay_after_exit_maintenance_mode");
                    arrayList2.add("delay_before_vmstartup");
                    arrayList.add(ConfigurationKeys.ENABLE_PLUGIN);
                    arrayList2.add(ConfigurationKeys.PLUGIN_TYPE);
                    arrayList2.add(ConfigurationKeys.PLUGIN_EXTENSION_KEY);
                    arrayList2.add("VCSA_shutdown_duration");
                    arrayList2.add("apply_vm_settings_to_all_nmcs");
                    arrayList2.add("single_ups_groups_only");
                    arrayList2.add("startup_waits_for_all_hosts_online");
                    arrayList2.add("delay_after_vcsa_powered_on_and_connected");
                    arrayList2.add("enable_vsan_ftt");
                    arrayList2.add("vsan_sync_timeout");
                    arrayList2.add("vsan_sync_retry_limit");
                    arrayList2.add("vm_startup_rescan_hba_duration");
                    arrayList2.add("shutdown_all_vsan_vms");
                    arrayList2.add("vsan_ftt_level");
                    arrayList2.add("check_vcsa_ip_address");
                    arrayList2.add("witness_vm_startup_duration");
                    arrayList2.add("vsan_prepare");
                    arrayList2.add("vsan_recovery");
                    arrayList2.add("Skip_Maintenance_Mode");
                    arrayList.add("vm_prioritization_enabled");
                    if (this.virtualConfigurationManager.isNutanixESXi()) {
                        this.addNutanixVMSettingsToList(arrayList);
                    }
                    if (this.virtualConfigurationManager.isSimplivity()) {
                        this.addSimplivitySettings(arrayList);
                    }
                    if (this.virtualConfigurationManager.isHyperflex()) {
                        arrayList.add("cvm_shutdown_duration");
                        arrayList.add("cvm_startup_duration");
                        arrayList.add("cvm_startup_enable");
                        arrayList.add("cvm_connect_timeout");
                        arrayList.add("cluster_shutdown_duration");
                        arrayList.add("cluster_startup_duration");
                    }
                    this.checkVMPrioritizationSection(false);
                    this.validateVCLSDuration();
                    this.validateHADelays();
                    this.validateVsanClusterDurations();
                }
            } else if (((String)object).equalsIgnoreCase("Nutanix")) {
                this.addNutanixVMSettingsToList(arrayList);
                arrayList.add("vm_prioritization_enabled");
                this.checkVMPrioritizationSection(true);
                if (!this.advancedSetupHelper.isAdvancedShutdownMode()) {
                    arrayList.add("hostlist");
                }
            } else if (((String)object).equalsIgnoreCase("simplivity")) {
                arrayList.add("ovc_shutdown_duration");
                arrayList.add("ovc_startup_duration");
                arrayList.add("ovc_startup_enable");
                arrayList.add("ovc_connect_timeout");
            }
            this.processSection("HostConfigSettings", arrayList, arrayList2);
            if (((String)object).equalsIgnoreCase("Nutanix")) {
                this.validateNutanixAHVKeys("HostConfigSettings");
            } else if (((String)object).equalsIgnoreCase("VMWare")) {
                this.validateNutanixESXiKeys("HostConfigSettings");
            }
        }
    }

    private void validateHADelays() {
        IntRangeSetValidator intRangeSetValidator;
        if (this.config.containsKey("HostConfigSettings", "enable_ha_delay")) {
            intRangeSetValidator = new IntRangeSetValidator(20);
            intRangeSetValidator.add(0, VMSettings.MAX_ENABLE_HA_DELAY);
            this.config.getInt("HostConfigSettings", "enable_ha_delay", intRangeSetValidator);
        }
        if (this.config.containsKey("HostConfigSettings", "disable_ha_delay")) {
            intRangeSetValidator = new IntRangeSetValidator(20);
            intRangeSetValidator.add(0, VMSettings.MAX_DISABLE_HA_DELAY);
            this.config.getInt("HostConfigSettings", "disable_ha_delay", intRangeSetValidator);
        }
    }

    private void validateVCLSDuration() {
        IntRangeSetValidator intRangeSetValidator;
        if (this.config.containsKey("HostConfigSettings", "enable_vCLS_duration")) {
            intRangeSetValidator = new IntRangeSetValidator(180);
            intRangeSetValidator.add(0, VMSettings.MAX_ENABLE_VCLS_DURATION);
            this.config.getInt("HostConfigSettings", "enable_vCLS_duration", intRangeSetValidator);
        }
        if (this.config.containsKey("HostConfigSettings", "disable_vCLS_duration")) {
            intRangeSetValidator = new IntRangeSetValidator(180);
            intRangeSetValidator.add(0, VMSettings.MAX_DISABLE_VCLS_DURATION);
            this.config.getInt("HostConfigSettings", "disable_vCLS_duration", intRangeSetValidator);
        }
    }

    private void validateVsanClusterDurations(int n) {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(120);
        intRangeSetValidator.add(0, VMSettings.MAX_VSAN_CLUSTER_DURATION);
        IntRangeSetValidator intRangeSetValidator2 = new IntRangeSetValidator(120);
        intRangeSetValidator2.add(0, VMSettings.MAX_VSAN_CLUSTER_DURATION);
        if (this.config.containsKey("advanced_ups_setup_" + n, "vsan_prepare")) {
            this.config.getInt("advanced_ups_setup_" + n, "vsan_prepare", intRangeSetValidator);
        }
        if (this.config.containsKey("advanced_ups_setup_" + n, "vsan_recovery")) {
            this.config.getInt("advanced_ups_setup_" + n, "vsan_recovery", intRangeSetValidator2);
        }
    }

    private void validateVsanClusterDurations() {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(120);
        intRangeSetValidator.add(0, VMSettings.MAX_VSAN_CLUSTER_DURATION);
        IntRangeSetValidator intRangeSetValidator2 = new IntRangeSetValidator(120);
        intRangeSetValidator2.add(0, VMSettings.MAX_VSAN_CLUSTER_DURATION);
        if (this.config.containsKey("HostConfigSettings", "vsan_prepare")) {
            this.config.getInt("HostConfigSettings", "vsan_prepare", intRangeSetValidator);
        }
        if (this.config.containsKey("HostConfigSettings", "vsan_recovery")) {
            this.config.getInt("HostConfigSettings", "vsan_recovery", intRangeSetValidator2);
        }
    }

    private void checkSoftwareUpdateSection() {
        if (AutoUpdateComponent.isJapanese()) {
            this.config.clearSection("SoftwareUpdate");
        } else {
            Set<String> set = this.config.getSectionKeys("SoftwareUpdate");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("enableUpdateCheck");
            arrayList.add("updateServerURL");
            arrayList.add("updateCheckInterval");
            for (String string : arrayList) {
                if (!this.config.containsKey("SoftwareUpdate", string)) {
                    this.errorHandler.put("key.missing", new Object[]{"SoftwareUpdate", string});
                } else if (this.config.keyCount("SoftwareUpdate", string) > 1) {
                    this.errorHandler.put("key.duplicate", new Object[]{"SoftwareUpdate", string});
                }
                set.remove(string);
            }
            set.remove("devBuild");
            set.remove("fakeProductVersion");
            set.remove("skuSearchKeyword");
            set.remove("username");
            set.remove("password");
            set.remove("updateProxy");
            set.remove("updateProxyPort");
            this.processUnwantedKeys(set, "SoftwareUpdate");
        }
    }

    private void checkSections() {
        Set<String> set = this.config.getSections();
        List<String> list = this.getSectionList();
        for (String string : list) {
            if (set.contains(string)) continue;
            ++this.errorCount;
            this.errorHandler.put("section.missing", new Object[]{string});
        }
        for (String string : set) {
            if (string == null) {
                ++this.errorCount;
                this.errorHandler.put("global.entries", new Object[0]);
                continue;
            }
            if (list.contains(string) || string.equalsIgnoreCase("HostDetails") || string.equalsIgnoreCase("HostConfigSettings") || string.equalsIgnoreCase("SNMP") || string.equalsIgnoreCase("CustomerExperienceImprovement") || string.equalsIgnoreCase("Deadlock")) continue;
            ++this.errorCount;
            this.errorHandler.put("section.extra", new Object[]{string});
        }
    }

    private List<String> getSectionList() {
        this.sectionList.add("NetworkManagementCard");
        this.sectionList.add("EventLog");
        this.sectionList.add("Shutdown");
        this.sectionList.add("Networking");
        this.sectionList.add("Events");
        this.sectionList.add("AdvancedConfig");
        logger.debug("getSectionList");
        String string = this.virtualConfigurationManager.getVirtualInstallValue();
        boolean bl = this.virtualConfigurationManager.isNutanixAHV();
        boolean bl2 = this.virtualConfigurationManager.isNutanixESXi();
        boolean bl3 = this.virtualConfigurationManager.isManagedESXiOrNutanixAHV();
        boolean bl4 = this.virtualConfigurationManager.isManagedHostOrNutanixAHV();
        boolean bl5 = this.virtualConfigurationManager.isSimplivity();
        boolean bl6 = this.virtualConfigurationManager.isHyperflex();
        boolean bl7 = this.virtualConfigurationManager.isVxRail();
        boolean bl8 = this.virtualConfigurationManager.isUnmanagedHyperV();
        if (!StringUtils.isBlank((CharSequence)string)) {
            if (bl) {
                this.sectionList.add("NutanixClusterDetails");
            } else if (bl2) {
                this.sectionList.add("NutanixClusterDetails");
                this.sectionList.add("HostDetails");
            } else if (bl5) {
                this.sectionList.add("SimplivityClusterDetails");
            } else if (bl6) {
                this.sectionList.add("HyperflexClusterDetails");
            } else if (bl7) {
                this.sectionList.add("VxRailClusterDetails");
            } else if (bl8) {
                this.sectionList.add("HostDetails");
                this.sectionList.add("VMPrioritization");
            } else {
                this.sectionList.add("HostDetails");
            }
            if (bl4) {
                this.sectionList.add("HostConfigSettings");
                if (bl3) {
                    this.sectionList.add("VMPrioritization");
                }
            }
        }
        if (this.advancedSetupHelper.isAdvancedShutdownMode()) {
            int n = this.advancedSetupHelper.getGroupCount();
            for (int i = 0; i < n; ++i) {
                this.sectionList.add("advanced_ups_setup_" + i);
            }
        }
        if (!AutoUpdateComponent.isJapanese()) {
            this.sectionList.add("SoftwareUpdate");
            this.sectionList.add("Licensing");
        }
        this.sectionList.addAll(this.getSSHActionConfigured());
        return this.sectionList;
    }

    private List<String> getSSHActionConfigured() {
        return this.config.getSections().stream().filter(string -> StringUtils.startsWith((CharSequence)string, (CharSequence)"SSHAction")).collect(Collectors.toList());
    }

    private void checkNMCSection() {
        String string;
        Set<String> set = this.config.getSectionKeys("NetworkManagementCard");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("mode");
        arrayList.add("port");
        arrayList.add("protocol");
        arrayList.add("enrolWithNMC");
        for (String string2 : arrayList) {
            if (!this.config.containsKey("NetworkManagementCard", string2)) {
                ++this.errorCount;
                this.errorHandler.put("key.missing", new Object[]{"NetworkManagementCard", string2});
            } else if (this.config.keyCount("NetworkManagementCard", string2) > 1) {
                ++this.errorCount;
                this.errorHandler.put("key.duplicate", new Object[]{"NetworkManagementCard", string2});
            }
            set.remove(string2);
        }
        arrayList.clear();
        Set<String> set2 = this.config.getSectionKeys("NetworkManagementCard");
        int n = 0;
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.startsWith("IP_") && !string.endsWith("_Outlet") && !string.endsWith("_Outlets")) {
                ++n;
            }
            if (this.config.keyCount("NetworkManagementCard", string) > 1) {
                ++this.errorCount;
                this.errorHandler.put("key.duplicate", new Object[]{"NetworkManagementCard", string});
            }
            set.remove(string);
        }
        if (n == 0) {
            ++this.errorCount;
            this.errorHandler.put("ip.missing", new Object[]{"NetworkManagementCard"});
        }
        arrayList.clear();
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (this.config.keyCount("NetworkManagementCard", string) > 1) {
                ++this.errorCount;
                this.errorHandler.put("key.duplicate", new Object[]{"NetworkManagementCard", string});
            }
            set.remove(string);
        }
        this.processUnwantedKeys(set, "NetworkManagementCard");
    }

    private void checkSNMPSection() {
        if (!this.config.containsSection("SNMP")) {
            logger.debug("Optional section SNMP not specified in the ini file");
            return;
        }
        Set<String> set = this.config.getSectionKeys("SNMP");
        Set<String> set2 = this.config.getSectionKeys("SNMP");
        for (String string : set2) {
            if (this.config.keyCount("SNMP", string) > 1) {
                ++this.errorCount;
                this.errorHandler.put("key.duplicate", new Object[]{"SNMP", string});
            }
            if (string.startsWith("SNMPv1_Name_Profile_") || string.startsWith("SNMPv1_AccessType_Profile_") || string.startsWith("SNMPv1_NMS_Profile_") || string.startsWith("SNMPv3_Name_Profile_") || string.startsWith("SNMPv3_AUTH_PROTOCOL_Profile_") || string.startsWith("SNMPv3_AUTH_PASSPHRASE_Profile_") || string.startsWith("SNMPv3_PRIV_PROTOCOL_Profile_") || string.startsWith("SNMPv3_PRIV_PASSPHRASE_Profile_") || string.startsWith("SNMPv3_ACCESS_TYPE_Profile_") || string.startsWith("TrapReceiver_") && string.endsWith("_Enabled") || string.startsWith("TrapReceiver_") && string.endsWith("_NMS") || string.startsWith("TrapReceiver_") && string.endsWith("_Port") || string.startsWith("TrapReceiver_") && string.endsWith("_Type") || string.startsWith("TrapReceiver_") && string.endsWith("_ProfileName")) {
                set.remove(string);
                continue;
            }
            for (String string2 : new String[]{"UPSCriticalEvents", "LostCommsEvents"}) {
                if (!string.equals(string2 + "_Enabled") && !string.equals(string2 + "_SendClearingTrap") && !string.equals(string2 + "_Delay") && !string.equals(string2 + "_RepeatInterval") && !string.equals(string2 + "_RepeatUntilCleared") && !string.equals(string2 + "_RepeatTimes")) continue;
                set.remove(string);
            }
        }
        set.remove("SNMP_DiscoveryPort");
        set.remove("SNMPv1_Enabled");
        set.remove("SNMPv3_Enabled");
        set.remove("UpdateAvailable_Enabled");
        set.remove("Logging_Level_Override");
        this.processUnwantedKeys(set, "SNMP");
    }

    private void checkEventLogSection() {
        Set<String> set = this.config.getSectionKeys("EventLog");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("logfile");
        arrayList.add("logsize");
        for (String string : arrayList) {
            if (!this.config.containsKey("EventLog", string)) {
                ++this.errorCount;
                this.errorHandler.put("key.missing", new Object[]{"EventLog", string});
            } else if (this.config.keyCount("EventLog", string) > 1) {
                ++this.errorCount;
                this.errorHandler.put("key.duplicate", new Object[]{"EventLog", string});
            }
            set.remove(string);
        }
        this.processUnwantedKeys(set, "EventLog");
    }

    private void processUnwantedKeys(Set<String> set, String string) {
        for (String string2 : set) {
            ++this.errorCount;
            this.errorHandler.put("key.deleted", new Object[]{string, string2});
        }
    }

    public void processSection(String string, List<String> list, List<String> list2) {
        Set<String> set = this.config.getSectionKeys(string);
        for (String string2 : list) {
            if (!this.config.containsKey(string, string2)) {
                ++this.errorCount;
                this.errorHandler.put("key.missing", new Object[]{string, string2});
            } else if (this.config.keyCount(string, string2) > 1) {
                ++this.errorCount;
                this.errorHandler.put("key.duplicate", new Object[]{string, string2});
            }
            set.remove(string2);
        }
        set.removeAll(list2);
        for (String string2 : set) {
            ++this.errorCount;
            this.errorHandler.put("key.deleted", new Object[]{string, string2});
        }
    }

    private void checkShutdownSection() {
        Object object;
        Set<String> set = this.config.getSectionKeys("Shutdown");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("shutdownCommand");
        arrayList.add("shutdownCommandDuration");
        arrayList.add("shutdownCommandFile");
        arrayList.add("shutdownCommandFileDuration");
        arrayList.add("runtimeRemainingThreshold");
        arrayList.add("runtimeRemainingCmdFileThreshold");
        arrayList.add("shutdownDelay");
        arrayList.add("turnOffUps");
        arrayList.add("turnOffSOG");
        if (!this.advancedSetupHelper.isAdvancedShutdownMode()) {
            try {
                object = this.config.getString("Networking", "VirtualInstall");
                if (object != null && !((String)object).trim().isEmpty()) {
                    Object object2 = "Managed";
                    if (this.config.containsKey("HostDetails", "ConfigurationMode")) {
                        object2 = this.config.getString("HostDetails", "ConfigurationMode");
                    }
                    if (this.virtualConfigurationManager.isManagedHostOrNutanixAHV()) {
                        arrayList.add("executeCommandFileAfterHostShutdown");
                    }
                }
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
        object = new ConfigurationKeys(ShutdownEvents.ShutdownStarting.name());
        arrayList.add(((ConfigurationKeys)object).getEnableLoggingKey());
        arrayList.add(((ConfigurationKeys)object).getEnableCommandFileKey());
        arrayList.add(((ConfigurationKeys)object).getCommandFilePathKey());
        arrayList.add(((ConfigurationKeys)object).getCommandFileDelayKey());
        arrayList.add(((ConfigurationKeys)object).getCommandFileDurationKey());
        for (String string : arrayList) {
            if (!this.config.containsKey("Shutdown", string)) {
                ++this.errorCount;
                this.errorHandler.put("key.missing", new Object[]{"Shutdown", string});
            } else if (this.config.keyCount("EventLog", string) > 1) {
                ++this.errorCount;
                this.errorHandler.put("key.duplicate", new Object[]{"Shutdown", string});
            }
            set.remove(string);
        }
        this.processUnwantedKeys(set, "Shutdown");
        this.validateShutdownCommandPath("Shutdown");
    }

    private void checkNetworkingSection() {
        Set<String> set = this.config.getSectionKeys("Networking");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("localHostAddress");
        arrayList.add("protocol");
        arrayList.add("httpPort");
        arrayList.add("httpsPort");
        arrayList.add("NetworkConfig");
        arrayList.add("IPv6NetworkConfig");
        arrayList.add("UnicastAddress");
        arrayList.add("MulticastAddress");
        arrayList.add("ConfigComplete");
        arrayList.add("LockoutFailCount");
        arrayList.add("LockoutDuration");
        for (String string : arrayList) {
            if (!this.config.containsKey("Networking", string)) {
                ++this.errorCount;
                this.errorHandler.put("key.missing", new Object[]{"Networking", string});
            } else if (this.config.keyCount("Networking", string) > 1) {
                ++this.errorCount;
                this.errorHandler.put("key.duplicate", new Object[]{"Networking", string});
            }
            set.remove(string);
        }
        set.remove("VirtualInstall");
        set.remove("SCVMMVersion");
        set.remove("isPCNSonVM");
        set.remove("javaModules");
        set.remove("tls1_support_os");
        this.processUnwantedKeys(set, "Networking");
        this.checkProtocolValue();
    }

    private void checkServerPortValue() {
        Integer n = DEFAULT_HTTPS_PORT;
        if (this.config.containsKey("HostDetails", "Server_PORT")) {
            Integer n2 = null;
            try {
                String string = this.config.getString("HostDetails", "Server_PORT");
                String string2 = this.config.getString("HostDetails", "Server_Protocol");
                n = "http".equalsIgnoreCase(string2) ? DEFAULT_HTTP_PORT : DEFAULT_HTTPS_PORT;
                n2 = Integer.valueOf(string);
                if (!(n2.equals(DEFAULT_HTTP_PORT) || n2.equals(DEFAULT_HTTPS_PORT) || n2 >= 0 && n2 <= 65535)) {
                    n2 = n;
                    ++this.errorCount;
                    this.errorHandler.put("invalid.usingother", new Object[]{"HostDetails", "Server_PORT", n2});
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)illegalArgumentException);
                n2 = n;
                ++this.errorCount;
                this.errorHandler.put("invalid.usingother", new Object[]{"HostDetails", "Server_PORT", n2});
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException);
                n2 = n;
                ++this.errorCount;
                this.errorHandler.put("invalid.usingother", new Object[]{"HostDetails", "Server_PORT", n2});
            }
        }
    }

    private void checkUsername(String string, String string2) {
        if (this.config.containsKey("NutanixClusterDetails", string)) {
            String string3 = null;
            try {
                string3 = this.config.getString("NutanixClusterDetails", string);
            }
            catch (ConversionException conversionException) {
                this.errorHandler.put("invalid.usingother", new Object[]{"NutanixClusterDetails", string, string2});
                this.config.setProperty("NutanixClusterDetails", string, string2);
            }
            if (StringUtils.isBlank((CharSequence)string3)) {
                this.errorHandler.put("key.missing", new Object[]{"NutanixClusterDetails", string, string2});
                this.config.setProperty("NutanixClusterDetails", string, string2);
            }
        } else {
            this.errorHandler.put("section.missing", new Object[]{"NutanixClusterDetails", string});
            this.config.setProperty("NutanixClusterDetails", string, string2);
        }
    }

    private void checkServerProtocolValue() {
        if (this.config.containsKey("HostDetails", "Server_Protocol")) {
            try {
                String string = this.config.getString("HostDetails", "Server_Protocol");
                if (!"http".equalsIgnoreCase(string) && !"https".equalsIgnoreCase(string)) {
                    ++this.errorCount;
                    this.errorHandler.put("invalid.usingother", new Object[]{"HostDetails", "Server_Protocol", "https"});
                }
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException);
            }
        }
    }

    private void checkProtocolValue() {
        if (this.config.containsKey("Networking", "protocol")) {
            try {
                String string = this.config.getString("Networking", "protocol");
                if (!"http".equalsIgnoreCase(string) && !"https".equalsIgnoreCase(string)) {
                    ++this.errorCount;
                    this.errorHandler.put("invalid.usingother", new Object[]{"Networking", "protocol", "https"});
                }
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException);
            }
        }
    }

    public static Map<String, String> getRequiredEventSectionKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<ObjectId> set = ConfigurationValidationTask.getINIEvents();
        Set<ObjectId> set2 = EventLists.getNonShutdownEvents();
        for (ObjectId objectId : set) {
            String string = EventLists.getEventNameForObjectId(objectId);
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
            if (!"Events".equalsIgnoreCase(configurationKeys.getSection())) continue;
            hashMap.put(configurationKeys.getEnableLoggingKey(), configurationKeys.getSection());
            hashMap.put(configurationKeys.getEnableCommandFileKey(), configurationKeys.getSection());
            hashMap.put(configurationKeys.getCommandFilePathKey(), configurationKeys.getSection());
            hashMap.put(configurationKeys.getCommandFileDelayKey(), configurationKeys.getSection());
            hashMap.put(configurationKeys.getCommandFileDurationKey(), configurationKeys.getSection());
            if (set2.contains(objectId)) continue;
            hashMap.put(configurationKeys.getEnableShutdownKey(), "Events");
            hashMap.put(configurationKeys.getShutdownDelayKey(), "Events");
        }
        return hashMap;
    }

    public static Set<String> getUnwantedEventSectionKeys() {
        HashSet<String> hashSet = new HashSet<String>();
        Set<ObjectId> set = ConfigurationValidationTask.getINIEvents();
        Set<ObjectId> set2 = EventLists.getNonShutdownEvents();
        for (ObjectId objectId : set) {
            String string = EventLists.getEventNameForObjectId(objectId);
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
            if (!"Events".equalsIgnoreCase(configurationKeys.getSection()) || !set2.contains(objectId)) continue;
            hashSet.add(configurationKeys.getEnableShutdownKey());
            hashSet.add(configurationKeys.getShutdownDelayKey());
        }
        return hashSet;
    }

    private void checkEventSection() {
        Set<String> set = this.config.getSectionKeys("Events");
        Map<String, String> map = ConfigurationValidationTask.getRequiredEventSectionKeys();
        Set<String> set2 = ConfigurationValidationTask.getUnwantedEventSectionKeys();
        for (Map.Entry<String, String> object : map.entrySet()) {
            if (!this.config.containsKey(object.getValue(), object.getKey())) {
                ++this.errorCount;
                this.errorHandler.put("key.missing", new Object[]{object.getValue(), object.getKey()});
            } else if (this.config.keyCount("Networking", object.getKey()) > 1) {
                ++this.errorCount;
                this.errorHandler.put("key.duplicate", new Object[]{object.getValue(), object.getKey()});
            }
            set.remove(object.getKey());
        }
        for (String string : set2) {
            if (this.config.containsKey("Events", string)) {
                ++this.errorCount;
                this.errorHandler.put("key.deleted", new Object[]{"Events", string});
            }
            set.remove(string);
        }
        this.processUnwantedKeys(set, "Events");
        this.checkCommandFileKeys();
    }

    private void checkCommandFileKeys() {
        Set<ObjectId> set = ConfigurationValidationTask.getINIEvents();
        for (ObjectId objectId : set) {
            Object object;
            String string = EventLists.getEventNameForObjectId(objectId);
            ConfigurationKeys configurationKeys = new ConfigurationKeys(string);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            try {
                bl = this.config.getBoolean(configurationKeys.getSection(), configurationKeys.getEnableCommandFileKey());
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            if (!bl) continue;
            try {
                object = this.config.getString(configurationKeys.getSection(), configurationKeys.getCommandFilePathKey());
                bl2 = !this.userFilePathValidator.isValid((String)object, true);
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            try {
                object = this.config.getInt(configurationKeys.getSection(), configurationKeys.getCommandFileDelayKey());
                if (object == null) {
                    bl3 = true;
                } else if ((Integer)object < 0 || (Integer)object > 172800) {
                    bl3 = true;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                bl3 = true;
            }
            catch (ConversionException conversionException) {
                bl3 = true;
            }
            try {
                object = this.config.getInt(configurationKeys.getSection(), configurationKeys.getCommandFileDurationKey());
                if (object == null) {
                    bl4 = true;
                } else if ((Integer)object < 0 || (Integer)object > 7200) {
                    bl4 = true;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                bl4 = true;
            }
            catch (ConversionException conversionException) {
                bl4 = true;
            }
            if (bl2) {
                ++this.errorCount;
                this.errorHandler.put("bad.command.params", new Object[]{string, configurationKeys.getCommandFilePathKey()});
            }
            if (bl3) {
                ++this.errorCount;
                this.errorHandler.put("bad.command.params", new Object[]{string, configurationKeys.getCommandFileDelayKey()});
            }
            if (bl4) {
                ++this.errorCount;
                this.errorHandler.put("bad.command.params", new Object[]{string, configurationKeys.getCommandFileDurationKey()});
            }
            if (!bl3 && !bl4 && !bl2) continue;
            ++this.errorCount;
            this.errorHandler.put("bad.command.reset", new Object[]{string});
            this.config.setProperty(configurationKeys.getSection(), configurationKeys.getEnableCommandFileKey(), false);
        }
    }

    private void validateNutanixAHVKeys(String string) {
        this.checkDurationLimits(string, "uvm_poweroff_duration", 5, 600, 15);
        this.checkDurationLimits(string, "uvm_poweroff_duration", 5, 600, 15);
        this.validateCommonNutanixKeys(string);
    }

    private void validateNutanixESXiKeys(String string) {
        this.validateCommonNutanixKeys(string);
    }

    private void validateCommonNutanixKeys(String string) {
        this.checkDurationLimits(string, "cvm_connect_timeout", 5, 600, 10);
    }

    private void checkDurationLimits(String string, String string2, Integer n, Integer n2, Integer n3) {
        if (this.config.containsKey(string, string2)) {
            try {
                Integer n4 = this.config.getInt(string, string2);
                if (n4 < n) {
                    this.errorHandler.put("out.of.bounds", new Object[]{string, string2, n, MINIMUM});
                    this.config.setProperty(string, string2, n);
                } else if (n4 > n2) {
                    this.errorHandler.put("out.of.bounds", new Object[]{string, string2, n2, MAXIMUM});
                    this.config.setProperty(string, string2, n2);
                }
            }
            catch (ConversionException conversionException) {
                this.errorHandler.put("conversion.failure", new Object[]{string, string2});
                ++this.errorCount;
            }
        }
    }

    private void addSimplivitySettings(List<String> list) {
        if (this.virtualConfigurationManager.isSimplivity()) {
            list.add("ovc_connect_timeout");
            list.add("ovc_startup_duration");
            list.add("ovc_startup_enable");
            list.add("ovc_shutdown_duration");
        }
    }

    private void addNutanixVMSettingsToList(List<String> list) {
        if (this.virtualConfigurationManager.isNutanixAHV()) {
            list.add("uvm_shutdown_duration");
            list.add("uvm_startup_enable");
            list.add("uvm_startup_duration");
            list.add("uvm_poweroff_duration");
            list.add("uvm_forceoff_duration");
        }
        list.add("cvm_shutdown_duration");
        list.add("cvm_startup_duration");
        list.add("cvm_startup_enable");
        list.add("cvm_connect_timeout");
        list.add("afs_shutdown_enable");
        list.add("afs_shutdown_duration");
        list.add("afs_startup_enable");
        list.add("afs_startup_duration");
        list.add("ongoing_replication_abort_delay_enable");
        list.add("ongoing_replication_abort_delay_duration");
        list.add("ongoing_replication_abort_command_duration");
        list.add("cluster_shutdown_duration");
        list.add("cluster_startup_duration");
        if (this.virtualConfigurationManager.isNutanixESXi()) {
            list.add("metro_availability_disable");
            list.add("metro_availability_re-enable");
        }
    }

    private void checkVMPrioritizationSection(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.vmPrioritizationUtils.isVMPrioritizationEnabled()) {
            arrayList.add("vm_list_high");
            arrayList.add("vm_list_medium");
            arrayList.add("vm_list_low");
            arrayList.add("vm_list_group_1");
            arrayList.add("vm_list_group_2");
            arrayList.add("vm_shutdown_duration_high");
            arrayList.add("vm_shutdown_duration_medium");
            arrayList.add("vm_shutdown_duration_low");
            arrayList.add("vm_shutdown_duration_group_1");
            arrayList.add("vm_shutdown_duration_group_2");
            arrayList.add("vm_shutdown_duration_none");
            if (!bl) {
                arrayList.add("vm_migration_duration_high");
                arrayList.add("vm_migration_duration_medium");
                arrayList.add("vm_migration_duration_low");
                arrayList.add("vm_migration_duration_group_1");
                arrayList.add("vm_migration_duration_group_2");
                arrayList.add("vm_migration_duration_none");
            }
            arrayList.add("vm_startup_duration_high");
            arrayList.add("vm_startup_duration_medium");
            arrayList.add("vm_startup_duration_low");
            arrayList.add("vm_startup_duration_group_1");
            arrayList.add("vm_startup_duration_group_2");
            arrayList.add("vm_startup_duration_none");
        } else {
            arrayList2.add("vm_list_high");
            arrayList2.add("vm_list_medium");
            arrayList2.add("vm_list_low");
            arrayList2.add("vm_list_group_1");
            arrayList2.add("vm_list_group_2");
            arrayList2.add("vm_shutdown_duration_high");
            arrayList2.add("vm_shutdown_duration_medium");
            arrayList2.add("vm_shutdown_duration_low");
            arrayList2.add("vm_shutdown_duration_group_1");
            arrayList2.add("vm_shutdown_duration_group_2");
            arrayList2.add("vm_shutdown_duration_none");
            if (!bl) {
                arrayList2.add("vm_migration_duration_high");
                arrayList2.add("vm_migration_duration_medium");
                arrayList2.add("vm_migration_duration_low");
                arrayList2.add("vm_migration_duration_group_1");
                arrayList2.add("vm_migration_duration_group_2");
                arrayList2.add("vm_migration_duration_none");
            }
            arrayList2.add("vm_startup_duration_high");
            arrayList2.add("vm_startup_duration_medium");
            arrayList2.add("vm_startup_duration_low");
            arrayList2.add("vm_startup_duration_group_1");
            arrayList2.add("vm_startup_duration_group_2");
            arrayList2.add("vm_startup_duration_none");
        }
        this.processSection("VMPrioritization", arrayList, arrayList2);
    }

    private void checkSimplivity() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.virtualConfigurationManager.isSimplivity()) {
            arrayList.add("ovc_username");
            arrayList.add("ovc_force_shutdown_delay");
            for (int i = 0; i < 20; ++i) {
                arrayList2.add(ConfigurationKeys.getOvcNameKey(i));
                arrayList2.add(ConfigurationKeys.getOvcIPKey(i));
                arrayList2.add(ConfigurationKeys.getOvcHostKey(i));
            }
            this.processSection("SimplivityClusterDetails", arrayList, arrayList2);
        }
    }

    private void checkDeadlockDetector() {
        if (this.config.containsSection("Deadlock")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add("detector_enabled");
            arrayList.add("period");
            this.processSection("Deadlock", arrayList, arrayList2);
        }
    }

    private void checkHyperflex() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.virtualConfigurationManager.isHyperflex()) {
            arrayList.add("username");
            arrayList.add("Cluster_Ip");
            arrayList2.add("client_id");
            arrayList2.add("client_secret");
            arrayList2.add("redirect_uri");
            arrayList2.add("job_query_wait");
            arrayList2.add("cluster_stop_retries");
            arrayList2.add("cluster_uuid");
            for (int i = 0; i < 20; ++i) {
                arrayList2.add(ConfigurationKeys.getCvmNameKey(i));
                arrayList2.add(ConfigurationKeys.getCvmHostKey(i));
            }
            this.processSection("HyperflexClusterDetails", arrayList, arrayList2);
        }
    }

    private void checkVxRail() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.virtualConfigurationManager.isVxRail()) {
            arrayList.add("Cluster_Ip");
            arrayList2.add("cluster_shutdown_delay");
            arrayList2.add("cluster_shutdown_duration");
            arrayList2.add("retry_limit");
            arrayList2.add("network_timeout");
            arrayList2.add("retry_interval");
            arrayList2.add("dry_run");
            arrayList2.add("scheduled_start_delay");
            this.processSection("VxRailClusterDetails", arrayList, arrayList2);
        }
    }

    public static Set<ObjectId> getINIEvents() {
        HashSet<ObjectId> hashSet = new HashSet<ObjectId>();
        hashSet.add(UtilityLineStatus.PowerFailed.getObjectId());
        hashSet.add(UtilityLineStatus.PowerRestored.getObjectId());
        hashSet.add(UtilityLineStatus.Overload.getObjectId());
        hashSet.add(UtilityLineStatus.OverloadSolved.getObjectId());
        hashSet.add(UtilityLineStatus.PowerOff.getObjectId());
        hashSet.add(UtilityLineStatus.OutletOff.getObjectId());
        hashSet.add(UtilityLineStatus.OutletOn.getObjectId());
        hashSet.add(RuntimeVerifierEvents.RunTimeExceeded.getObjectId());
        hashSet.add(RuntimeVerifierEvents.RunTimeWithinRange.getObjectId());
        hashSet.add(RuntimeVerifierEvents.RunTimeRemaining.getObjectId());
        hashSet.add(RuntimeVerifierEvents.RunTimeRemainingCleared.getObjectId());
        hashSet.add(RuntimeVerifierEvents.RunTimeRemainingCmdFile.getObjectId());
        hashSet.add(RuntimeVerifierEvents.RunTimeRemainingCmdFileCleared.getObjectId());
        hashSet.add(Battery.BatteryDischarged.getObjectId());
        hashSet.add(Battery.BatteryChargeInRange.getObjectId());
        hashSet.add(Battery.LowBattery.getObjectId());
        hashSet.add(Battery.ReturnFromLowBattery.getObjectId());
        hashSet.add(Bypass.FaultBypassEnabled.getObjectId());
        hashSet.add(Bypass.BypassEnabled.getObjectId());
        hashSet.add(Bypass.BypassManualEnabled.getObjectId());
        hashSet.add(Bypass.BypassDisabled.getObjectId());
        hashSet.add(Bypass.BypassContactorFailed.getObjectId());
        hashSet.add(Bypass.BypassContactorOk.getObjectId());
        hashSet.add(Communication.CommunicationLostOnBattery.getObjectId());
        hashSet.add(Communication.CommunicationLost.getObjectId());
        hashSet.add(Communication.NetCommunicationLost.getObjectId());
        hashSet.add(Communication.CommunicationEstablished.getObjectId());
        hashSet.add(Communication.CannotCommunicateResolved.getObjectId());
        hashSet.add(Communication.CannotCommunicate.getObjectId());
        hashSet.add(Communication.MonitoringStarted.getObjectId());
        hashSet.add(Redundancy.MinRedundancyLost.getObjectId());
        hashSet.add(Redundancy.MinRedundancyRegained.getObjectId());
        hashSet.add(Redundancy.ParallelRedundancyLost.getObjectId());
        hashSet.add(Redundancy.ParallelRedundancyRegained.getObjectId());
        hashSet.add(Temperature.MaxInternalTempExceeded.getObjectId());
        hashSet.add(Temperature.MaxInternalTempInRange.getObjectId());
        hashSet.add(LoadCapability.MinLoadCapabilityLost.getObjectId());
        hashSet.add(LoadCapability.MinLoadCapabilityRegained.getObjectId());
        hashSet.add(ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId());
        hashSet.add(ShutdownEvents.PowerSourceTurnOffCancelled.getObjectId());
        hashSet.add(ShutdownEvents.ShutdownStarting.getObjectId());
        hashSet.add(ShutdownEvents.TurnOffUpsStarting.getObjectId());
        hashSet.add(ShutdownEvents.ShutdownOnBattery.getObjectId());
        hashSet.add(ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId());
        hashSet.add(ShutdownEvents.UPSMainOutletTurnOffInitiated.getObjectId());
        hashSet.add(ShutdownEvents.UPSOutletTurnOffInitiatedCancelled.getObjectId());
        hashSet.add(WebServerEvents.AccountLockOut.getObjectId());
        hashSet.add(MultipleEvent.CriticalEvent.getObjectId());
        hashSet.add(MultipleEvent.CriticalEventResolved.getObjectId());
        hashSet.add(MultipleEvent.SinglePowerFailed.getObjectId());
        hashSet.add(MultipleEvent.SinglePowerRestored.getObjectId());
        hashSet.add(MultipleEvent.SingleOutletOff.getObjectId());
        hashSet.add(MultipleEvent.SingleOutletRestored.getObjectId());
        hashSet.add(MultipleEvent.MultipleCriticalEvent.getObjectId());
        hashSet.add(MultipleEvent.MultipleCriticalEventResolved.getObjectId());
        hashSet.add(EnvironmentalEvents.ContactFault1.getObjectId());
        hashSet.add(EnvironmentalEvents.ContactFault2.getObjectId());
        hashSet.add(EnvironmentalEvents.ContactFault3.getObjectId());
        hashSet.add(EnvironmentalEvents.ContactFault4.getObjectId());
        hashSet.add(EnvironmentalEvents.ContactNormal1.getObjectId());
        hashSet.add(EnvironmentalEvents.ContactNormal2.getObjectId());
        hashSet.add(EnvironmentalEvents.ContactNormal3.getObjectId());
        hashSet.add(EnvironmentalEvents.ContactNormal4.getObjectId());
        hashSet.add(EnvironmentalEvents.HumidityInRangeProbe1.getObjectId());
        hashSet.add(EnvironmentalEvents.HumidityInRangeProbe2.getObjectId());
        hashSet.add(EnvironmentalEvents.HumidityOutOfRangeProbe1.getObjectId());
        hashSet.add(EnvironmentalEvents.HumidityOutOfRangeProbe2.getObjectId());
        hashSet.add(EnvironmentalEvents.TempInRangeProbe1.getObjectId());
        hashSet.add(EnvironmentalEvents.TempInRangeProbe2.getObjectId());
        hashSet.add(EnvironmentalEvents.TempOutOfRangeProbe1.getObjectId());
        hashSet.add(EnvironmentalEvents.TempOutOfRangeProbe2.getObjectId());
        hashSet.add(EnvironmentalEvents.EnvironmentCommunicationEstablished.getObjectId());
        hashSet.add(EnvironmentalEvents.EnvironmentCommunicationLost.getObjectId());
        hashSet.add(EnvironmentalEvents.EnvironmentNoCommunicationSinceLastReboot.getObjectId());
        hashSet.add(EnvironmentalEvents.IntegratedEnvCommunicationEstablished.getObjectId());
        hashSet.add(Communication.ParallelSilconNotSupported.getObjectId());
        hashSet.add(Communication.ParallelSilconSupported.getObjectId());
        hashSet.add(RESTEvents.RemoteShutdownEvent.getObjectId());
        hashSet.add(RESTEvents.RemoteShutdownEventResolved.getObjectId());
        return hashSet;
    }

    public void checkSSHActions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add("ssh_action_name");
        arrayList.add("ssh_target");
        arrayList.add("ssh_command_path");
        arrayList.add("ssh_action_enabled");
        arrayList.add("action_duration");
        arrayList.add("action_delay");
        arrayList.add("ssh_port");
        arrayList.add("ssh_action_sequence");
        arrayList2.add("ssh_keyfile_path");
        arrayList2.add("ssh_prompt_regex");
        this.getSSHActionConfigured().stream().forEach(string -> this.processSection((String)string, (List<String>)arrayList, (List<String>)arrayList2));
        this.getSSHActionConfigured().stream().forEach(string -> this.validateSSHActionPaths((String)string));
    }

    private void checkCEIP() {
        if (this.config.containsSection("CustomerExperienceImprovement")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("CEIPKey");
            arrayList2.add("CEIPURL");
            arrayList2.add("CEIPStartDelay");
            arrayList2.add("CEIPRepeatInterval");
            arrayList2.add("CEIPRandomID");
            arrayList2.add("CEIPEnabled");
            this.processSection("CustomerExperienceImprovement", arrayList, arrayList2);
        }
    }

    private void checkLicensing() {
        if (this.config.containsSection("Licensing")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add("cloudLicensingServerAddress");
            arrayList.add("licensingPortalAddress");
            arrayList2.add("licensingProxyAddress");
            arrayList2.add("licensingProxyPort");
            arrayList2.add("licensingActivationMethod");
            arrayList2.add("licensingActivationId");
            arrayList2.add("licensedNodeCount");
            this.validateLicensingValues();
            this.processSection("Licensing", arrayList, arrayList2);
        }
    }

    private void validateLicensingValues() {
        ServiceManager.getInstance().getLicensingUtils().getQuantityFromIni();
        if (this.config.containsKey("Licensing", "licensingActivationId")) {
            logger.debug("validateLicensingValues() - activation id found in INI.");
            String string = this.config.getString("Licensing", "licensingActivationId");
            if (!this.licensingUtils.getActivationIdValidator().isValid(string)) {
                logger.error("validateLicensingValues() - removing invalid activation id from INI");
                this.config.clearProperty("Licensing", "licensingActivationId");
            }
        }
    }

    private void validateNutanixSSHKeyPaths(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        String string2 = this.config.getString(string, "SSH_Key_Path");
        if (StringUtils.isNotBlank((CharSequence)string2) && !this.userFilePathValidator.isValid(string2)) {
            this.errorHandler.put("invalid.value", new Object[]{string, "SSH_Key_Path"});
        }
    }

    private void validateSSHActionPaths(@NonNull String string) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        String string3 = this.config.getString(string, "ssh_command_path");
        if (StringUtils.isNotBlank((CharSequence)string3) && !this.userFilePathValidator.isValid(string3)) {
            this.errorHandler.put("invalid.value", new Object[]{string, "ssh_command_path"});
        }
        if (StringUtils.isNotBlank((CharSequence)(string2 = this.config.getString(string, "ssh_keyfile_path"))) && !this.userFilePathValidator.isValid(string2)) {
            this.errorHandler.put("invalid.value", new Object[]{string, "ssh_keyfile_path"});
        }
    }

    private void validateShutdownCommandPath(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("section is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            return;
        }
        String string2 = this.config.getString(string, "shutdownCommandFile");
        if (StringUtils.isNotBlank((CharSequence)string2) && !this.userFilePathValidator.isValid(string2, true)) {
            this.errorHandler.put("invalid.value", new Object[]{string, "shutdownCommandFile"});
        }
    }

    @Generated
    public void setVirtualConfigurationManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
    }

    @Generated
    public void setAdvancedSetupHelper(@NonNull AdvancedSetupHelper advancedSetupHelper) {
        if (advancedSetupHelper == null) {
            throw new IllegalArgumentException("advancedSetupHelper is marked non-null but is null");
        }
        this.advancedSetupHelper = advancedSetupHelper;
    }

    @Generated
    public void setVmPrioritizationUtils(@NonNull VMPrioritizationUtils vMPrioritizationUtils) {
        if (vMPrioritizationUtils == null) {
            throw new IllegalArgumentException("vmPrioritizationUtils is marked non-null but is null");
        }
        this.vmPrioritizationUtils = vMPrioritizationUtils;
    }

    @Generated
    public void setUserFilePathValidator(@NonNull UserFilePathValidator userFilePathValidator) {
        if (userFilePathValidator == null) {
            throw new IllegalArgumentException("userFilePathValidator is marked non-null but is null");
        }
        this.userFilePathValidator = userFilePathValidator;
    }

    @Generated
    public void setThreadPool(@NonNull ThreadService threadService) {
        if (threadService == null) {
            throw new IllegalArgumentException("threadPool is marked non-null but is null");
        }
        this.threadPool = threadService;
    }

    @Generated
    public void setConfig(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Generated
    public void setErrorHandler(@NonNull ApplicationErrorHandler applicationErrorHandler) {
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("errorHandler is marked non-null but is null");
        }
        this.errorHandler = applicationErrorHandler;
    }

    @Generated
    public void setLicensingUtils(@NonNull ILicensingUtils iLicensingUtils) {
        if (iLicensingUtils == null) {
            throw new IllegalArgumentException("licensingUtils is marked non-null but is null");
        }
        this.licensingUtils = iLicensingUtils;
    }
}

