/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.tasks;

import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.serviceaware.InitializationAdapter;
import com.apcc.pcns.threadpool.ThreadService;
import com.apcc.pcns.util.CountdownTimer;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CredentialMigrationTask
extends InitializationAdapter
implements Runnable {
    private static final Logger logger = LogManager.getLogger(CredentialMigrationTask.class);
    private VirtualConfigurationManager virtualConfigurationManager;
    private AuthHelper authHelper;
    private ThreadService threadPool;

    public CredentialMigrationTask(@NonNull VirtualConfigurationManager virtualConfigurationManager, @NonNull AuthHelper authHelper, @NonNull ThreadService threadService) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        if (authHelper == null) {
            throw new IllegalArgumentException("authHelper is marked non-null but is null");
        }
        if (threadService == null) {
            throw new IllegalArgumentException("threadPool is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
        this.authHelper = authHelper;
        this.threadPool = threadService;
    }

    @Override
    public void start() {
        this.threadPool.schedule(this, 0, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        try {
            logger.debug("run() - start");
            while (!this.authHelper.isReady()) {
                new CountdownTimer(1L, TimeUnit.SECONDS).interruptableSleep();
            }
            logger.debug("run() - AuthHelper ready.  Migrating credentials...");
            this.virtualConfigurationManager.getVCenterUsername();
            this.virtualConfigurationManager.getVCenterPassword();
            logger.debug("run() - end");
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.debug("run() - Aborting credential migration due to interruption.");
        }
    }
}

