/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.validation;

import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.oslogger.OperatingSystemEventLogger;
import com.apcc.pcns.util.FileUtils;
import java.io.File;
import java.io.IOException;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationFileReplacementService {
    private static final int EXIT_CONFIG_MISSING = 25;
    private static final Logger logger = LogManager.getLogger(ConfigurationFileReplacementService.class);
    private ApplicationErrorHandler eventLogger;
    private OperatingSystemEventLogger osLogger;

    public ConfigurationFileReplacementService(@NonNull ApplicationErrorHandler applicationErrorHandler, @NonNull OperatingSystemEventLogger operatingSystemEventLogger) {
        if (applicationErrorHandler == null) {
            throw new IllegalArgumentException("eventLogger is marked non-null but is null");
        }
        if (operatingSystemEventLogger == null) {
            throw new IllegalArgumentException("osLogger is marked non-null but is null");
        }
        this.eventLogger = applicationErrorHandler;
        this.osLogger = operatingSystemEventLogger;
        String string = System.getProperty("iniFile", "pcnsconfig.ini");
        this.verifyConfigurationFiles(string, "pcnsconfig_backup.ini");
        this.verifyConfigurationFiles("m11.cfg", "m11.bak");
    }

    private void restoreConfigFile(@NonNull File file, @NonNull File file2) {
        if (file == null) {
            throw new IllegalArgumentException("absentFile is marked non-null but is null");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("presentFile is marked non-null but is null");
        }
        try {
            new FileUtils().copyFile(file2, file);
        }
        catch (IOException iOException) {
            logger.error("restoreConfigFile() - ", (Throwable)iOException);
        }
        String string = this.eventLogger.formatMessage("ini.replaced", new Object[]{file.getAbsoluteFile(), file2.getAbsoluteFile()});
        logger.warn(string);
        this.eventLogger.put(string);
    }

    private void verifyConfigurationFiles(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("backupConfig is marked non-null but is null");
        }
        File file = new File(string);
        File file2 = new File(string2);
        boolean bl = file.canRead();
        boolean bl2 = file2.canRead();
        if (bl) {
            if (!bl2) {
                this.restoreConfigFile(file2, file);
            }
        } else if (bl2) {
            this.restoreConfigFile(file, file2);
        } else {
            String string3 = this.eventLogger.formatMessage("ini.missing", new Object[]{file.getAbsoluteFile(), file2.getAbsoluteFile()});
            this.eventLogger.put(string3);
            logger.fatal(string3);
            this.osLogger.fatal(string3, "102");
            System.exit(25);
        }
    }
}

