/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.validation;

import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.components.omaha.LogUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.ValidationSettings;
import com.apcc.pcns.configservice.validation.ValidationUtil;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import lombok.NonNull;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class EncryptUtils {
    private static final Logger logger = LogManager.getLogger(EncryptUtils.class);
    private static ReentrantLock lock = new ReentrantLock();
    private ValidationSettings theEncryptor = null;
    private static ValidationUtil val = new ValidationUtil();
    public static String kRandomNumberId = "JRNThreshold";
    public static final ComponentID kComponentId = new ComponentID("PCNSOmaha");
    private IPermanentStorage storage;

    public EncryptUtils(@NonNull IPermanentStorage iPermanentStorage) {
        if (iPermanentStorage == null) {
            throw new IllegalArgumentException("Storage reference can't be null.");
        }
        this.storage = iPermanentStorage;
    }

    public static ReentrantLock getReentrantLock() {
        return lock;
    }

    public ValidationSettings getEncryptor() {
        String string;
        if (this.theEncryptor == null && (string = this.retrieveRandomNumberinM11()) != null) {
            this.theEncryptor = new ValidationSettings(string);
        }
        return this.theEncryptor;
    }

    public boolean setValue(String string, String string2, String string3) {
        boolean bl = false;
        try {
            if (StringUtils.isNotEmpty((CharSequence)string3)) {
                if (!string3.equals(this.readEncValueFromPermanentStorage(string, string2))) {
                    String string4 = this.getEncryptor().encrypt(string3);
                    this.storage.writeData(kComponentId, EncryptUtils.getPermStorageKey(string, string2), (Object)string4);
                    bl = true;
                }
            } else {
                this.clearValue(string, string2);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.error((Object)storageEntryException);
        }
        return bl;
    }

    public void clearValue(String string, String string2) {
        try {
            this.storage.removeData(kComponentId, EncryptUtils.getPermStorageKey(string, string2));
        }
        catch (StorageEntryException storageEntryException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String string, String string2) {
        try {
            lock.lock();
            String string3 = null;
            String string4 = StringUtils.trim((String)this.readEncValueFromPermanentStorage(string, string2));
            ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
            if (configurationManager.containsKey(string, string2)) {
                logger.debug("Encrypted Value key contained in INI.");
                try {
                    string3 = StringUtils.trim((String)configurationManager.getString(string, string2));
                    if (string4 != null && !string4.trim().isEmpty() && !string4.equals(string3)) {
                        LogUtils.logMessage("PasswordChangedIni");
                    }
                    if (string4 == null || !string4.equals(string3)) {
                        this.setValue(string, string2, string3);
                    }
                }
                catch (ConversionException conversionException) {
                    logger.error((Object)conversionException);
                }
                finally {
                    configurationManager.clearProperty(string, string2);
                }
            }
            if (StringUtils.isEmpty(string3)) {
                logger.debug("Failed to find Encrypt Value in INI, looking in m11.cfg");
                string3 = string4;
            }
            String string5 = string3;
            return string5;
        }
        finally {
            lock.unlock();
        }
    }

    public String readEncValueFromPermanentStorage(String string, String string2) {
        String string3 = null;
        try {
            Object object = this.storage.readData(kComponentId, EncryptUtils.getPermStorageKey(string, string2));
            if (object instanceof String) {
                string3 = this.getEncryptor().decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.debug((Object)storageEntryException);
        }
        return string3;
    }

    public static String getPermStorageKey(String string, String string2) {
        return Integer.toString((string + string2).hashCode());
    }

    @Deprecated
    public static String getRandomNumber() {
        String string = "";
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("DES");
            keyGenerator.init(new SecureRandom());
            SecretKey secretKey = keyGenerator.generateKey();
            string = Hex.encodeHexString((byte[])secretKey.getEncoded());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error((Object)noSuchAlgorithmException);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveRandomNumberinM11() {
        String string = null;
        try {
            lock.lock();
            if (this.storage != null) {
                Object object = this.storage.readData(kComponentId, kRandomNumberId);
                string = val.decrypt((String)object);
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.debug((Object)storageEntryException);
            string = EncryptUtils.getRandomNumber();
            try {
                String string2 = val.encrypt(string);
                this.storage.writeData(kComponentId, kRandomNumberId, (Object)string2);
            }
            catch (StorageEntryException storageEntryException2) {
                logger.debug((Object)storageEntryException);
            }
        }
        finally {
            lock.unlock();
        }
        return string;
    }
}

