/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.validation;

import com.apcc.pcns.configservice.validation.AbstractConfigurationEntryValidator;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringSetValidator
extends AbstractConfigurationEntryValidator<String> {
    private static final Logger logger = LogManager.getLogger(StringSetValidator.class);
    private Set<String> validValues;

    public StringSetValidator() {
        this.validValues = new HashSet<String>();
    }

    public StringSetValidator(String string) {
        super(string);
        logger.debug("New StringSetValidator with default: " + string);
        this.validValues = new HashSet<String>();
        if (string != null) {
            this.validValues.add(string.toUpperCase());
        } else {
            this.validValues.add(null);
        }
    }

    @Override
    public boolean isValid(String string) {
        boolean bl = false;
        bl = string == null ? this.validValues.contains(null) : this.validValues.contains(string.toUpperCase());
        return bl;
    }

    public boolean add(String string) {
        logger.debug("Adding valid value: " + string);
        return this.validValues.add(string.toUpperCase());
    }
}

