/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.validation;

import com.apcc.pcns.configservice.validation.AbstractConfigurationEntryValidator;
import com.apcc.pcns.util.FileUtils;
import java.io.File;
import java.text.Normalizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserFilePathValidator
extends AbstractConfigurationEntryValidator<String> {
    private static final Logger logger = LogManager.getLogger(UserFilePathValidator.class);
    private String applicationDir;
    private String safeDir = "user_files";
    private String safeDirWildcard;
    private FileUtils fileUtils;

    public UserFilePathValidator() {
        super(null);
        String string = System.getProperty("user.dir") + File.separator;
        this.applicationDir = FilenameUtils.normalize((String)(string + ".." + File.separator + this.safeDir));
        this.safeDirWildcard = this.applicationDir + File.separator + "*";
        logger.trace("UserFilePathValidator() - Application Directory: {}, File Selector: {}", (Object)this.applicationDir, (Object)this.safeDirWildcard);
        this.fileUtils = new FileUtils();
    }

    @Override
    public boolean isValid(String string) {
        return this.isValid(string, false);
    }

    public boolean isValid(String string, boolean bl) {
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.debug("isValid() - File path is blank");
            return false;
        }
        String string2 = FilenameUtils.normalize((String)(string = Normalizer.normalize(string.trim(), Normalizer.Form.NFKC)));
        if (!FilenameUtils.wildcardMatchOnSystem((String)string2, (String)this.safeDirWildcard)) {
            logger.error("isValid() - File path {} is not in in user_files folder", (Object)string2);
            return false;
        }
        if (bl && !this.fileUtils.isExecutable(string2)) {
            logger.error("isValid() - file {} is not executable", (Object)string2);
            return false;
        }
        if (!bl && !this.fileUtils.isReadable(string2)) {
            logger.error("isValid() - file {} is not readable", (Object)string2);
            return false;
        }
        logger.trace("isValid() - file path {} is valid", (Object)string2);
        return true;
    }
}

