/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.configservice.validation;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.RandomIvGenerator;

public class ValidationSettings {
    private StandardPBEStringEncryptor encryptor;
    private static final Logger logger = LogManager.getLogger(ValidationSettings.class);
    public static final int KEY_ITERATIONS = 10000;

    public ValidationSettings(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't use a blank key.");
        }
        this.encryptor = new StandardPBEStringEncryptor();
        this.encryptor.setAlgorithm("PBEWithHMACSHA512AndAES_256");
        this.encryptor.setIvGenerator((IvGenerator)new RandomIvGenerator());
        this.encryptor.setKeyObtentionIterations(10000);
        this.encryptor.setPassword(string);
    }

    public String encrypt(String string) {
        logger.debug("encrypt() - start");
        String string2 = null;
        try {
            string2 = this.encryptor.encrypt(string);
        }
        catch (EncryptionInitializationException | EncryptionOperationNotPossibleException throwable) {
            logger.error("encrypt() - Failure: ", throwable);
        }
        logger.debug("encrypt() - end");
        return string2;
    }

    public String decrypt(String string) {
        logger.debug("decrypt() - start");
        String string2 = null;
        try {
            string2 = this.encryptor.decrypt(string);
        }
        catch (EncryptionInitializationException | EncryptionOperationNotPossibleException throwable) {
            logger.error("decrypt() - Failure: ", throwable);
        }
        logger.debug("decrypt() - end");
        return string2;
    }
}

