/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.datagramservice;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.datagramservice.DatagramListener;
import com.apcc.pcns.datagramservice.DatagramManager;
import com.apcc.pcns.datagramservice.DatagramTask;
import com.apcc.pcns.datagramservice.UpdaterTask;
import com.apcc.pcns.util.CountdownTimer;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatagramManagerImpl
implements DatagramManager {
    private static final Logger logger = LogManager.getLogger(DatagramManagerImpl.class);
    private Map<Integer, ArrayList<DatagramListener>> listeners = new HashMap<Integer, ArrayList<DatagramListener>>();
    private Map<Integer, DatagramTask> tasks = new HashMap<Integer, DatagramTask>();
    private Map<Integer, Future<?>> futures = new HashMap();

    @Override
    public void addDatagramListener(DatagramListener datagramListener, int n) throws IllegalArgumentException, SocketException {
        logger.debug("AddingListener on:" + n);
        if (datagramListener == null) {
            throw new IllegalArgumentException("Listener can't be null.");
        }
        if (!DatagramManagerImpl.isPortValid(n)) {
            throw new IllegalArgumentException("Port number out of range.");
        }
        this.addTask(n);
        ArrayList<DatagramListener> arrayList = this.listeners.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(datagramListener);
            this.listeners.put(n, arrayList);
        } else if (!arrayList.contains(datagramListener)) {
            arrayList.add(datagramListener);
        }
    }

    @Override
    public boolean removeDatagramListener(DatagramListener datagramListener, int n) throws IllegalArgumentException {
        if (datagramListener == null) {
            throw new IllegalArgumentException("Listener can't be null.");
        }
        if (!DatagramManagerImpl.isPortValid(n)) {
            throw new IllegalArgumentException("Port number out of range.");
        }
        ArrayList<DatagramListener> arrayList = this.listeners.get(n);
        if (arrayList == null) {
            return true;
        }
        boolean bl = arrayList.remove(datagramListener);
        this.removeTask(n);
        return bl;
    }

    public synchronized void processData(int n, byte[] byArray) throws IllegalArgumentException {
        if (!DatagramManagerImpl.isPortValid(n)) {
            throw new IllegalArgumentException("Port number out of range.");
        }
        logger.trace("processData(): Packet recieved on port {}, data: {}", (Object)n, (Object)StringUtils.toEncodedString((byte[])byArray, null));
        ArrayList<DatagramListener> arrayList = this.listeners.get(n);
        if (arrayList == null || arrayList.size() == 0) {
            logger.debug("processData(): Nothing listening on: " + n);
        } else {
            for (DatagramListener datagramListener : arrayList) {
                UpdaterTask updaterTask = new UpdaterTask(datagramListener, byArray);
                ServiceManager.getInstance().getThreadService().submit(updaterTask);
            }
        }
    }

    @Override
    public boolean removeDatagramListener(DatagramListener datagramListener) {
        if (datagramListener == null) {
            return true;
        }
        logger.debug("removeDatagramListner:" + datagramListener.getClass().toString());
        for (Integer n : this.listeners.keySet()) {
            ArrayList<DatagramListener> arrayList = this.listeners.get(n);
            if (!arrayList.contains(datagramListener)) continue;
            arrayList.remove(datagramListener);
            this.removeTask(n);
        }
        return true;
    }

    private synchronized void addTask(int n) throws SocketException {
        Object object;
        logger.debug("AddDatagramTask on:" + n);
        DatagramTask datagramTask = this.tasks.get(n);
        if (datagramTask != null) {
            logger.debug("Found Task");
            object = this.futures.get(n);
            if (object != null && object.isDone()) {
                logger.debug("Completed Remove it");
                this.futures.remove(n);
                this.tasks.remove(n);
                datagramTask = null;
            }
        }
        if (datagramTask == null) {
            try {
                logger.debug("Add new DatagramTask on:" + n);
                object = new DatagramTask(this, n);
                this.tasks.put(n, (DatagramTask)object);
                Future<?> future = ServiceManager.getInstance().getThreadService().submit((Runnable)object);
                this.futures.put(n, future);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)illegalArgumentException);
            }
            catch (SocketException socketException) {
                logger.error((Object)socketException);
                throw socketException;
            }
        }
    }

    private synchronized void removeTask(int n) {
        logger.debug("Removing listener from port:" + n);
        ArrayList<DatagramListener> arrayList = this.listeners.get(n);
        if (arrayList == null || arrayList.size() == 0) {
            logger.debug("no listeners, remove the task:" + n);
            DatagramTask datagramTask = this.tasks.get(n);
            Future<?> future = this.futures.get(n);
            if (datagramTask != null) {
                datagramTask.setEnabled(false);
                this.tasks.remove(n);
            }
            if (future != null) {
                future.cancel(false);
                while (!future.isDone()) {
                    new CountdownTimer(500L, TimeUnit.MILLISECONDS).await(this);
                }
                this.futures.remove(n);
            }
        } else {
            logger.debug("someone is still listening on:" + n);
        }
    }

    @Override
    public Collection<DatagramListener> getDatagramListeners(int n) throws IllegalArgumentException {
        if (!DatagramManagerImpl.isPortValid(n)) {
            throw new IllegalArgumentException("Port number out of range.");
        }
        ArrayList<DatagramListener> arrayList = new ArrayList<DatagramListener>();
        ArrayList<DatagramListener> arrayList2 = this.listeners.get(n);
        if (arrayList2 != null) {
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public static boolean isPortValid(int n) {
        return n >= 0 && n <= 65535;
    }

    @Override
    public boolean hasDatagramTask(int n) throws IllegalArgumentException {
        if (!DatagramManagerImpl.isPortValid(n)) {
            throw new IllegalArgumentException("Port out of bounds.");
        }
        DatagramTask datagramTask = this.tasks.get(n);
        return datagramTask != null && datagramTask.isSocketBound() && !datagramTask.isSocketClosed();
    }

    @Override
    public void clearAllTasks() {
        for (Integer n : this.listeners.keySet()) {
            Future<?> future;
            this.listeners.get(n).clear();
            DatagramTask datagramTask = this.tasks.get(n);
            if (datagramTask != null) {
                datagramTask.setEnabled(false);
            }
            if ((future = this.futures.get(n)) == null) continue;
            while (!future.isDone()) {
                Thread.yield();
            }
        }
    }
}

