/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.datagramservice;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.datagramservice.DatagramManagerImpl;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatagramTask
implements Runnable {
    private static final Logger logger = LogManager.getLogger(DatagramTask.class);
    private static final int SOCKET_TIMEOUT = 30000;
    private static final long TWO_MINUTES = TimeUnit.SECONDS.convert(2L, TimeUnit.MINUTES);
    private static final int MAX_PACKET_SIZE = 4096;
    private static final String UDP = "UDP";
    private DatagramManagerImpl manager;
    private int port;
    private boolean enabled;
    private DatagramSocket socket;
    private MulticastSocket multicastSocket;
    private byte[] inputBuffer;
    private ConfigurationManager config;
    private VirtualConfigurationManager virtualConfig;

    public DatagramTask(DatagramManagerImpl datagramManagerImpl, int n) throws SocketException {
        logger.debug("DatagramTask constructor port={}", (Object)n);
        if (datagramManagerImpl == null) {
            throw new IllegalArgumentException("Manager can't be null.");
        }
        if (!DatagramManagerImpl.isPortValid(n)) {
            throw new IllegalArgumentException("Port is out of range.");
        }
        this.enabled = true;
        this.manager = datagramManagerImpl;
        this.port = n;
        logger.debug("Attempting to bind to port: {}", (Object)n);
        this.config = ServiceManager.getInstance().getConfigurationManager();
        this.virtualConfig = ServiceManager.getInstance().getVirtualConfigurationManager();
        logger.debug("DatagramTask ctor - end");
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        logger.debug("Setting enabled to: {} for port: {}", (Object)bl, (Object)this.port);
        this.enabled = bl;
        if (!bl) {
            this.closeMulticastSocket();
            this.closeSocket();
        }
    }

    @Override
    public void run() {
        logger.debug("run() - started");
        while (this.isEnabled()) {
            try {
                try {
                    if (this.virtualConfig.isIPv6() && this.virtualConfig.isIPv6Multicast()) {
                        this.handleIPv6Multicast();
                    } else {
                        this.handleUnicast();
                    }
                }
                catch (ConversionException conversionException) {
                    logger.error((Object)conversionException);
                }
                catch (BindException bindException) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(UDP);
                    arrayList.add(Integer.toString(this.port));
                    this.logCommunicationStatusError("RegStatus.PowerChuteError", arrayList);
                    logger.error((Object)bindException);
                    CountdownTimer.minutes(2L).sleep();
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException);
                    CountdownTimer.minutes(2L).sleep();
                }
                if (this.socket != null) {
                    this.unicastListen();
                } else if (this.multicastSocket != null) {
                    this.multicastListen();
                }
            }
            catch (Exception exception) {
                logger.error("run() - Error in packet Receiver", (Throwable)exception);
            }
            logger.trace("run() - completed");
        }
        this.closeMulticastSocket();
        this.closeSocket();
        logger.debug("run() - ended");
    }

    private void handleUnicast() throws SocketException {
        this.closeMulticastSocket();
        if (this.socket == null) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(UDP);
            vector.add(Integer.toString(this.port));
            this.logCommunicationStatusError("RegStatus.PowerChuteTry", vector);
            this.socket = new DatagramSocket(this.port);
            this.socket.setSoTimeout(30000);
            this.inputBuffer = new byte[4096];
            logger.trace("handleUnicast() - DatagramTask constructed");
            this.logCommunicationStatusError("RegStatus.PowerChuteSuccess", vector);
        }
    }

    private void handleIPv6Multicast() throws IOException {
        this.closeSocket();
        if (this.multicastSocket == null) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(UDP);
            vector.add(Integer.toString(this.port));
            this.logCommunicationStatusError("RegStatus.PowerChuteTry", vector);
            this.multicastSocket = new MulticastSocket(this.port);
            String string = this.config.getString("Networking", "MulticastAddress");
            this.multicastSocket.joinGroup(InetAddress.getByName(string));
            this.multicastSocket.setSoTimeout(30000);
            this.inputBuffer = new byte[4096];
            logger.trace("handleIPv6Multicast() - MulticastSocket constructed");
            this.logCommunicationStatusError("RegStatus.PowerChuteSuccess", vector);
        }
    }

    private void unicastListen() {
        try {
            logger.debug("unicastListen() - DatagramTask packetlisten");
            this.inputBuffer = new byte[4096];
            DatagramPacket datagramPacket = new DatagramPacket(this.inputBuffer, 4096);
            this.socket.receive(datagramPacket);
            this.manager.processData(this.port, datagramPacket.getData());
        }
        catch (SocketTimeoutException socketTimeoutException) {
            logger.trace("unicastListen() - No packet at this time: ", (Throwable)socketTimeoutException);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }

    private void multicastListen() {
        try {
            logger.debug("DatagramTask multicast packetlisten");
            this.inputBuffer = new byte[4096];
            DatagramPacket datagramPacket = new DatagramPacket(this.inputBuffer, 4096);
            this.multicastSocket.receive(datagramPacket);
            this.manager.processData(this.port, datagramPacket.getData());
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }

    private synchronized void closeMulticastSocket() {
        if (this.multicastSocket != null && !this.multicastSocket.isClosed()) {
            logger.debug("Closing socket on port:" + this.port);
            this.multicastSocket.close();
            this.multicastSocket = null;
        }
    }

    public synchronized boolean isSocketBound() {
        if (this.socket != null) {
            return this.socket.isBound();
        }
        if (this.multicastSocket != null) {
            return this.multicastSocket.isBound();
        }
        return false;
    }

    public synchronized boolean isSocketClosed() {
        if (this.socket != null) {
            return this.socket.isClosed();
        }
        if (this.multicastSocket != null) {
            return this.multicastSocket.isClosed();
        }
        return false;
    }

    public synchronized void closeSocket() {
        if (this.socket != null && !this.socket.isClosed()) {
            logger.debug("Closing socket on port:" + this.port);
            this.socket.close();
            this.socket = null;
        }
    }

    private void logCommunicationStatusError(String string, List<Object> list) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
        String string2 = Utils.getResourceString(resourceBundleWrapper, string);
        if (list != null) {
            string2 = MessageFormat.format(string2, list.toArray());
        }
        ServiceManager.getInstance().getApplicationErrorHandler().put(string2);
    }
}

