/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.deadlock;

import com.apcc.pcns.deadlock.DeadlockHandler;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeadlockCheckRunnable
implements Runnable {
    private static final Logger logger = LogManager.getLogger(DeadlockCheckRunnable.class);
    private ThreadMXBean threadMxBean;
    private DeadlockHandler deadlockHandler;

    public DeadlockCheckRunnable(@NonNull ThreadMXBean threadMXBean, @NonNull DeadlockHandler deadlockHandler) {
        if (threadMXBean == null) {
            throw new IllegalArgumentException("threadMxBean is marked non-null but is null");
        }
        if (deadlockHandler == null) {
            throw new IllegalArgumentException("deadlockHandler is marked non-null but is null");
        }
        this.threadMxBean = threadMXBean;
        this.deadlockHandler = deadlockHandler;
    }

    @Override
    public void run() {
        logger.debug("Running Deadlock Detection ...");
        long[] lArray = this.threadMxBean.findDeadlockedThreads();
        if (lArray != null) {
            ThreadInfo[] threadInfoArray = this.threadMxBean.getThreadInfo(lArray);
            this.deadlockHandler.handleDeadlock(threadInfoArray);
        }
    }
}

