/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.deadlock;

import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.deadlock.DeadlockDetector;
import com.apcc.pcns.deadlock.DeadlockLogHandler;
import com.apcc.pcns.serviceaware.InitializationAdapter;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeadlockDetectionService
extends InitializationAdapter {
    private static final Logger logger = LogManager.getLogger(DeadlockDetectionService.class);
    private static final boolean DEFAULT_ENABLED = true;
    private static final int DEFAULT_PERIOD = 180;
    private DeadlockDetector detector;
    private ConfigurationManager config;

    public DeadlockDetectionService(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Override
    public synchronized void start() {
        if (this.detector == null && this.isEnabled()) {
            this.detector = new DeadlockDetector(new DeadlockLogHandler(), this.getPeriod(), TimeUnit.SECONDS);
            this.detector.start();
        }
    }

    public void stop() {
        logger.info("stop() - Request to stop the deadlock detector");
        if (this.detector != null) {
            this.detector.stop();
            this.detector = null;
        }
        logger.debug("stop() - complete");
    }

    private int getPeriod() {
        int n = 180;
        if (this.config.containsKey("Deadlock", "period")) {
            IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(180);
            intRangeSetValidator.add(0, Integer.MAX_VALUE);
            n = this.config.getInt("Deadlock", "period", intRangeSetValidator);
        }
        logger.debug("Deadlock Detection Service running with period: {} seconds", (Object)n);
        return n;
    }

    private boolean isEnabled() {
        boolean bl = true;
        if (this.config.containsKey("Deadlock", "detector_enabled")) {
            bl = this.config.getBoolean("Deadlock", "detector_enabled");
        }
        logger.debug("Deadlock Detection Service is enabled: {}", (Object)bl);
        return bl;
    }
}

