/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.deadlock;

import com.apcc.pcns.deadlock.DeadlockCheckRunnable;
import com.apcc.pcns.deadlock.DeadlockHandler;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeadlockDetector {
    private static final Logger logger = LogManager.getLogger(DeadlockDetector.class);
    private final long period;
    private final TimeUnit unit;
    private final ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final DeadlockCheckRunnable deadlockCheck;

    public DeadlockDetector(@NonNull DeadlockHandler deadlockHandler, long l, TimeUnit timeUnit) {
        if (deadlockHandler == null) {
            throw new IllegalArgumentException("deadlockHandler is marked non-null but is null");
        }
        this.period = l;
        this.unit = timeUnit;
        this.deadlockCheck = new DeadlockCheckRunnable(this.mbean, deadlockHandler);
    }

    public void start() {
        this.scheduler.scheduleAtFixedRate(this.deadlockCheck, this.period, this.period, this.unit);
    }

    public void stop() {
        logger.info("stop() - Request to stop deadlock detection.");
        if (!this.scheduler.isShutdown()) {
            logger.debug("stop() - Shutdown deadlock detector scheduler.");
            this.scheduler.shutdownNow();
        }
        logger.debug("stop() - Complete");
    }
}

