/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.deadlock;

import com.apcc.pcns.deadlock.DeadlockHandler;
import java.lang.management.ThreadInfo;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeadlockLogHandler
implements DeadlockHandler {
    private static final Logger logger = LogManager.getLogger(DeadlockLogHandler.class);

    @Override
    public void handleDeadlock(ThreadInfo[] threadInfoArray) {
        if (threadInfoArray != null) {
            logger.error("Deadlock Detected!");
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            for (ThreadInfo threadInfo : threadInfoArray) {
                this.logDeadlockedThread(map, threadInfo);
            }
        }
    }

    private void logDeadlockedThread(Map<Thread, StackTraceElement[]> map, ThreadInfo threadInfo) {
        if (threadInfo != null) {
            for (Thread thread : map.keySet()) {
                if (thread.getId() != threadInfo.getThreadId()) continue;
                StringBuilder stringBuilder = new StringBuilder(threadInfo.toString().trim() + "\n");
                for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                    stringBuilder.append(stackTraceElement.toString().trim() + "\n");
                }
                logger.error(stringBuilder.toString());
            }
        }
    }
}

