/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.errorservice;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.eventlogginggroup.EventLoggingGroup;
import com.apcc.pcns.errorservice.ApplicationErrorEvent;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.threadpool.ThreadService;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationErrorHandlerImpl
implements ApplicationErrorHandler,
Runnable,
IDataConsumer {
    private static final Logger logger = LogManager.getLogger(ApplicationErrorHandlerImpl.class);
    private boolean paused = true;
    private IDataSource m11DataSource;
    private BlockingQueue<ApplicationErrorEvent> queue;
    private boolean stopped = false;
    private ResourceBundleWrapper bundle;
    private boolean suspended = false;

    public ApplicationErrorHandlerImpl(@NonNull ThreadService threadService) {
        if (threadService == null) {
            throw new IllegalArgumentException("threadService is marked non-null but is null");
        }
        this.queue = new LinkedBlockingQueue<ApplicationErrorEvent>();
        this.bundle = Utils.getUTF8ResourceBundle("com.apcc.pcns.configservice.i18n.configuration", Locale.getDefault());
        threadService.schedule(this, 0, TimeUnit.SECONDS);
    }

    @Override
    public void put(String string) {
        logger.debug("Adding error to application error handler. String: " + string);
        if (this.suspended) {
            return;
        }
        ApplicationErrorEvent applicationErrorEvent = new ApplicationErrorEvent(string);
        this.put(applicationErrorEvent);
    }

    @Override
    public synchronized void setPaused(boolean bl) {
        logger.debug("Setting application Error handler paused to: " + bl);
        this.paused = bl;
        this.notifyAll();
    }

    @Override
    public synchronized void stop() {
        this.setStopped(true);
    }

    @Override
    public synchronized void waitOnReady() {
        while ((this.isPaused() || this.getDataSource() == null) && !this.isStopped()) {
            try {
                logger.debug("application Error handler waiting");
                logger.debug("Paused: " + this.paused);
                logger.debug("Datasource: " + String.valueOf(this.getDataSource()));
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                logger.error("application error handler interrupted.  Checking conditions again.");
            }
        }
        logger.debug("Conditions are good, Proceed to process application errors.");
    }

    @Override
    public void run() {
        while (!this.isStopped()) {
            this.waitOnReady();
            try {
                ApplicationErrorEvent applicationErrorEvent = this.queue.take();
                this.getDataSource().set(EventLoggingGroup.LogApplicationError.getObjectId(), (Object)applicationErrorEvent);
            }
            catch (InterruptedException interruptedException) {
                logger.error((Object)interruptedException);
                Thread.currentThread().interrupt();
            }
            catch (CommunicationException | InvalidObjectIdException | InvalidValueException throwable) {
                logger.error((Object)throwable);
            }
        }
    }

    public synchronized void setDataSource(IDataSource iDataSource) {
        logger.debug("Setting data source on Configuration Service.");
        if (iDataSource != null) {
            this.m11DataSource = iDataSource;
            this.notifyAll();
        }
    }

    public synchronized IDataSource getDataSource() {
        return this.m11DataSource;
    }

    @Override
    public void clearLog() {
        logger.debug("Clearing the application log");
        this.queue.clear();
    }

    @Override
    public boolean isLogEmpty() {
        logger.debug("application Errors Pending log is empty: " + this.queue.isEmpty());
        return this.queue.isEmpty();
    }

    @Override
    public synchronized boolean isPaused() {
        logger.debug("application errors pending processor is paused: " + this.paused);
        return this.paused;
    }

    public synchronized void setStopped(boolean bl) {
        logger.debug("setStopped() : {}", (Object)bl);
        this.stopped = bl;
        this.notifyAll();
    }

    public synchronized boolean isStopped() {
        logger.debug("isStopped() - {}", (Object)this.stopped);
        return this.stopped;
    }

    private Object[] convertValueToString(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i] instanceof Integer ? String.valueOf(objectArray[i]) : objectArray[i];
        }
        return objectArray2;
    }

    @Override
    public String formatMessage(String string, Object[] objectArray) {
        String string2 = null;
        String string3 = Utils.getResourceString(this.bundle, string);
        if (objectArray == null) {
            string2 = string3;
        } else {
            Object[] objectArray2 = this.convertValueToString(objectArray);
            try {
                string2 = MessageFormat.format(string3, objectArray2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.debug((Object)illegalArgumentException);
            }
        }
        string2 = StringEscapeUtils.escapeHtml4((String)string2);
        return string2;
    }

    @Override
    public void put(ApplicationErrorEvent applicationErrorEvent) {
        if (this.suspended) {
            return;
        }
        try {
            this.queue.put(applicationErrorEvent);
        }
        catch (InterruptedException interruptedException) {
            logger.debug("application error handler interrupted.");
            try {
                logger.debug("offer it again");
                if (!this.queue.offer(applicationErrorEvent, 1L, TimeUnit.SECONDS)) {
                    try {
                        logger.error("Message not logged:" + applicationErrorEvent.getFormatter().format((Object)applicationErrorEvent));
                    }
                    catch (FormatterException | UnsupportedLocaleException throwable) {
                        logger.error("Message not logged");
                    }
                } else {
                    logger.debug("Message logged anyway");
                }
                Thread.currentThread().interrupt();
            }
            catch (InterruptedException interruptedException2) {
                Thread.currentThread().interrupt();
                try {
                    logger.error("application error handler interrupted.  Message not logged:" + applicationErrorEvent.getFormatter().format((Object)applicationErrorEvent));
                }
                catch (FormatterException | UnsupportedLocaleException throwable) {
                    logger.error("application error handler interrupted.  Message not logged");
                }
            }
        }
    }

    @Override
    public void suspend(boolean bl) {
        logger.debug("set suspended to " + bl);
        this.suspended = bl;
    }

    @Override
    public void put(String string, Object[] objectArray) {
        this.put(this.formatMessage(string, objectArray));
    }
}

