/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.hyperflex;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.hyperflex.HyperflexConnection;
import com.apcc.pcns.hyperflex.HyperflexDetails;
import com.apcc.pcns.hyperflex.HyperflexRestClient;
import com.apcc.pcns.hyperflex.HyperflexRestConnection;
import com.apcc.pcns.restservice.RestService;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class HyperflexConnectionManager {
    private RestService restService;

    public HyperflexConnectionManager(@NonNull RestService restService) {
        if (restService == null) {
            throw new IllegalArgumentException("restService is marked non-null but is null");
        }
        this.restService = restService;
    }

    public HyperflexConnection getConnection(@NonNull HyperflexDetails hyperflexDetails) throws IllegalArgumentException {
        if (hyperflexDetails == null) {
            throw new IllegalArgumentException("hyperflexConfig is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)hyperflexDetails.getHost())) {
            throw new IllegalArgumentException("Host cannot be blank");
        }
        HyperflexRestClient hyperflexRestClient = new HyperflexRestClient(this.restService, false);
        return new HyperflexRestConnection(hyperflexRestClient, hyperflexDetails, ServiceManager.getInstance());
    }
}

